/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import water.DKV;
import water.Futures;
import water.Job;
import water.Key;
import water.Keyed;
import water.TAtomic;
import water.Value;
import water.util.Log;

public abstract class Lockable<T extends Lockable<T>>
extends Keyed<T> {
    public transient Key<Job>[] _lockers;

    public Lockable(Key<T> key) {
        super(key);
    }

    public Lockable write_lock() {
        return this.write_lock((Key<Job>)null);
    }

    public Lockable write_lock(Job job) {
        return this.write_lock(job._key);
    }

    public Lockable write_lock(Key<Job> job_key) {
        Log.debug("write-lock " + this._key + " by job " + job_key);
        return ((PriorWriteLock)new PriorWriteLock(job_key).invoke(this._key))._old;
    }

    public T delete_and_lock() {
        return this.delete_and_lock((Key<Job>)null);
    }

    public T delete_and_lock(Job job) {
        return this.delete_and_lock(job._key);
    }

    public T delete_and_lock(Key<Job> job_key) {
        Lockable old = this.write_lock(job_key);
        if (old != null) {
            Log.debug("lock-then-clear " + this._key + " by job " + job_key);
            old.remove_impl(new Futures(), false).blockForPending();
        }
        return (T)this;
    }

    public static void delete(Key key) {
        Value val = DKV.get(key);
        if (val == null) {
            return;
        }
        ((Lockable)val.get()).delete();
    }

    public final void delete() {
        this.delete(true);
    }

    public final void delete(boolean cascade) {
        this.delete(null, new Futures(), cascade).blockForPending();
    }

    public final Futures delete(Key<Job> job_key, Futures fs, boolean cascade) {
        if (this._key != null) {
            Log.debug("lock-then-delete " + this._key + " by job " + job_key);
            new PriorWriteLock(job_key).invoke(this._key);
        }
        return this.remove(fs, cascade);
    }

    public static void read_lock(Key k, Job job) {
        Lockable.read_lock(k, job._key);
    }

    public static void read_lock(Key k, Key<Job> job_key) {
        Value val = DKV.get(k);
        if (val.isLockable()) {
            ((Lockable)val.get()).read_lock(job_key);
        }
    }

    public void read_lock(Key<Job> job_key) {
        if (this._key != null) {
            Log.debug("shared-read-lock " + this._key + " by job " + job_key);
            new ReadLock(job_key).invoke(this._key);
        }
    }

    public T update() {
        return this.update((Key<Job>)null);
    }

    public T update(Job job) {
        return this.update(job._key);
    }

    public T update(Key<Job> job_key) {
        Log.debug("update write-locked " + this._key + " by job " + job_key);
        new Update(job_key).invoke(this._key);
        return (T)this;
    }

    public T unlock() {
        return this.unlock(null, true);
    }

    public T unlock(Job job) {
        return this.unlock(job._key, true);
    }

    public T unlock(Key<Job> job_key) {
        return this.unlock(job_key, true);
    }

    public T unlock(Key<Job> job_key, boolean exact) {
        if (this._key != null) {
            Log.debug("unlock " + this._key + " by job " + job_key);
            new Unlock(job_key, exact).invoke(this._key);
        }
        return (T)this;
    }

    private boolean is_locked(Key<Job> job_key) {
        int i;
        if (this._lockers == null) {
            return false;
        }
        int n = i = this._lockers.length == 1 ? 0 : 1;
        while (i < this._lockers.length) {
            Key<Job> k = this._lockers[i];
            if (job_key == k || job_key != null && k != null && job_key.equals(k)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean is_wlocked() {
        return this._lockers != null && this._lockers.length == 1;
    }

    private boolean is_wlocked(Key<Job> job_key) {
        return this.is_wlocked() && (this._lockers[0] == job_key || this._lockers[0] != null && this._lockers[0].equals(job_key));
    }

    private boolean is_unlocked() {
        return this._lockers == null;
    }

    private void set_write_lock(Key<Job> job_key) {
        this._lockers = new Key[]{job_key};
        assert (this.is_locked(job_key));
    }

    private void set_read_lock(Key<Job> job_key) {
        assert (!this.is_wlocked());
        this._lockers = this._lockers == null ? new Key[2] : Arrays.copyOf(this._lockers, this._lockers.length + 1);
        this._lockers[this._lockers.length - 1] = job_key;
        assert (this.is_locked(job_key));
    }

    private void set_unlocked(Key[] lks, Key<Job> job_key) {
        if (lks.length == 1) {
            assert (job_key == lks[0] || job_key.equals(lks[0]));
            this._lockers = null;
        } else if (lks.length == 2) {
            assert (lks[0] == null);
            assert (lks[1] == job_key || job_key != null && job_key.equals(lks[1]));
            this._lockers = null;
        } else {
            assert (lks.length > 2);
            this._lockers = Arrays.copyOf(lks, lks.length - 1);
            for (int i = 1; i < lks.length; ++i) {
                if ((job_key == null || !job_key.equals(lks[i])) && (job_key != null || lks[i] != null)) continue;
                if (i >= this._lockers.length) break;
                this._lockers[i] = lks[lks.length - 1];
                break;
            }
        }
    }

    public void unlock_all() {
        if (this._key != null) {
            for (Key<Job> k : this._lockers) {
                new UnlockSafe(k).invoke(this._key);
            }
        }
    }

    private class UnlockSafe
    extends TAtomic<Lockable> {
        final Key<Job> _job_key;

        UnlockSafe(Key job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            if (old.is_locked(this._job_key)) {
                Lockable.this.set_unlocked(old._lockers, this._job_key);
            }
            return Lockable.this;
        }
    }

    private class Unlock
    extends TAtomic<Lockable> {
        final Key<Job> _job_key;
        final boolean _exact;

        Unlock(Key<Job> job_key, boolean exact) {
            this._job_key = job_key;
            this._exact = exact;
        }

        @Override
        public Lockable atomic(Lockable old) {
            assert (!this._exact || old != null) : "Trying to unlock null!";
            assert (!this._exact || old.is_locked(this._job_key)) : "Can't unlock: Not locked!";
            if (this._exact || old.is_locked(this._job_key)) {
                Lockable.this.set_unlocked(old._lockers, this._job_key);
            }
            return Lockable.this;
        }
    }

    private class Update
    extends TAtomic<Lockable> {
        final Key<Job> _job_key;

        Update(Key<Job> job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            assert (old != null) : "Cannot update - Lockable is null!";
            assert (old.is_wlocked()) : "Cannot update - Lockable is not write-locked!";
            Lockable.this._lockers = old._lockers;
            return Lockable.this;
        }
    }

    private static class ReadLock
    extends TAtomic<Lockable> {
        final Key<Job> _job_key;

        ReadLock(Key<Job> job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            if (old == null) {
                throw new IllegalArgumentException("Nothing to lock!");
            }
            if (old.is_wlocked()) {
                throw new IllegalArgumentException(old.getClass() + " " + this._key + " is being created;  Unable to read it now.");
            }
            old.set_read_lock(this._job_key);
            return old;
        }
    }

    private final class PriorWriteLock
    extends TAtomic<Lockable> {
        private final Key<Job> _job_key;
        private Lockable _old;

        private PriorWriteLock(Key<Job> job_key) {
            this._job_key = job_key;
        }

        @Override
        public Lockable atomic(Lockable old) {
            this._old = old;
            if (old != null) {
                assert (!old.is_wlocked(this._job_key)) : "Key " + this._key + " already locked (or deleted); lks=" + Arrays.toString(old._lockers);
                if (old.is_locked(this._job_key)) {
                    old.set_unlocked(old._lockers, this._job_key);
                }
                if (!old.is_unlocked()) {
                    throw new IllegalArgumentException(old.getClass() + " " + this._key + " is already in use.  Unable to use it now.  Consider using a different destination name.");
                }
            }
            Lockable.this.set_write_lock(this._job_key);
            return Lockable.this;
        }
    }
}

