/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.AutoBuffer;
import water.H2O;
import water.H2ONode;
import water.HeartBeat;
import water.Iced;
import water.UDP;
import water.util.Log;

public class UDPClientEvent
extends UDP {
    @Override
    AutoBuffer call(AutoBuffer ab) {
        ClientEvent ce = (ClientEvent)new ClientEvent().read(ab);
        if (!H2O.ARGS.allow_clients) {
            return ab;
        }
        if (ce.senderHeartBeat._cloud_name_hash != H2O.SELF._heartbeat._cloud_name_hash) {
            return ab;
        }
        if (!H2O.ARGS.client) {
            switch (ce.type) {
                case CONNECT: {
                    if (!H2O.isFlatfileEnabled()) break;
                    Log.info("Client reported via broadcast message " + ce.clientNode + " from " + ab._h2o);
                    ce.clientNode.setHeartBeat(ce.clientHeartBeat);
                    H2O.addNodeToFlatfile(ce.clientNode);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported Client event: " + (Object)((Object)ce.type));
                }
            }
        }
        return ab;
    }

    public static class ClientEvent
    extends Iced<ClientEvent> {
        public Type type;
        public H2ONode clientNode;
        public HeartBeat senderHeartBeat;
        public HeartBeat clientHeartBeat;

        public ClientEvent() {
        }

        public ClientEvent(Type type, HeartBeat senderHeartBeat, H2ONode clientNode) {
            this.type = type;
            this.senderHeartBeat = senderHeartBeat;
            this.clientNode = clientNode;
            this.clientHeartBeat = clientNode._heartbeat;
        }

        public static enum Type {
            CONNECT;


            public void broadcast(H2ONode clientNode) {
                ClientEvent ce = new ClientEvent(this, H2O.SELF._heartbeat, clientNode);
                ce.write(new AutoBuffer(H2O.SELF, UDP.udp.client_event._prior).putUdp(UDP.udp.client_event)).close();
            }
        }
    }
}

