/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.util.ArrayUtils;
import water.util.IcedHashMap;
import water.util.IcedLong;

public class InteractionWrappedVec
extends WrappedVec {
    private final Key<Vec> _masterVecKey1;
    private final Key<Vec> _masterVecKey2;
    private transient Vec _masterVec1;
    private transient Vec _masterVec2;
    private String[] _v1Domain;
    private String[] _v2Domain;
    public boolean _useAllFactorLevels;
    public boolean _skipMissing;
    public boolean _standardize;
    private long[] _bins;
    private String[] _missingDomains;
    public transient GetMeanTask t;
    private String[] _v1Enums;
    private String[] _v2Enums;

    public InteractionWrappedVec(Key<Vec> key, int rowLayout, String[] vec1DomainLimit, String[] vec2DomainLimit, boolean useAllFactorLevels, boolean skipMissing, boolean standardize, Key<Vec> masterVecKey1, Key<Vec> masterVecKey2) {
        super(key, rowLayout, (Key<Vec>)null);
        this._masterVecKey1 = masterVecKey1;
        this._masterVecKey2 = masterVecKey2;
        this._v1Enums = vec1DomainLimit;
        this._v2Enums = vec2DomainLimit;
        this._masterVec1 = this._masterVecKey1.get();
        this._masterVec2 = this._masterVecKey2.get();
        this._useAllFactorLevels = useAllFactorLevels;
        this._skipMissing = skipMissing;
        this._standardize = standardize;
        this.setupDomain(this._standardize);
        DKV.put(this);
        if (this.t != null) {
            this.t.doAll(this);
        }
    }

    public String[] v1Domain() {
        return this._v1Enums == null ? this._v1Domain : this._v1Enums;
    }

    public String[] v2Domain() {
        return this._v2Enums == null ? this._v2Domain : this._v2Enums;
    }

    @Override
    public String[] domain() {
        String[] res1 = this.v1Domain();
        String[] res2 = this.v2Domain();
        return res1 == null ? res2 : (res2 == null ? res1 : super.domain());
    }

    public Vec v1() {
        return this._masterVec1 == null ? (this._masterVec1 = this._masterVecKey1.get()) : this._masterVec1;
    }

    public Vec v2() {
        return this._masterVec2 == null ? (this._masterVec2 = this._masterVecKey2.get()) : this._masterVec2;
    }

    public int expandedLength() {
        if (this.isNumericInteraction()) {
            return 1;
        }
        if (this.isCategorical()) {
            return this.domain().length;
        }
        if (this._v1Domain != null) {
            return this._v1Enums == null ? this._v1Domain.length - (this._useAllFactorLevels ? 0 : 1) : this._v1Enums.length - (this._useAllFactorLevels ? 0 : 1);
        }
        return this._v2Enums == null ? this._v2Domain.length - (this._useAllFactorLevels ? 0 : 1) : this._v2Enums.length - (this._useAllFactorLevels ? 0 : 1);
    }

    public double[] getMeans() {
        if (null != this._v1Domain && null != this._v2Domain) {
            double[] res = new double[this.domain().length];
            Arrays.fill(res, Double.NaN);
            return res;
        }
        if (null == this._v1Domain && null == this._v2Domain) {
            return new double[]{super.mean()};
        }
        return ((GetMeanTask)new GetMeanTask(this.v1Domain() == null ? this.v2Domain().length : this.v1Domain().length).doAll(this))._d;
    }

    public double getSub(int i) {
        if (this.t == null) {
            return this.mean();
        }
        return this.t._d[i];
    }

    public double getMul(int i) {
        double sigma = this.t == null ? this.sigma() : this.t._sigma[i];
        return sigma == 0.0 ? 1.0 : 1.0 / sigma;
    }

    public boolean isNumericInteraction() {
        return null == this.v1Domain() && null == this.v2Domain();
    }

    @Override
    public double mean() {
        if (null == this.t && this.isNumericInteraction()) {
            return super.mean();
        }
        return 0.0;
    }

    @Override
    public double sigma() {
        if (null == this.t && this.isNumericInteraction()) {
            return super.sigma();
        }
        return 1.0;
    }

    @Override
    public int mode() {
        if (!this.isCategorical()) {
            if (this.v1Domain() != null) {
                assert (this.v2Domain() == null);
                return this._masterVec1.mode();
            }
            if (this.v2Domain() != null) {
                assert (this.v1Domain() == null);
                return this._masterVec2.mode();
            }
            throw H2O.unimpl();
        }
        return ArrayUtils.maxIndex(this._bins);
    }

    public long[] getBins() {
        return this._bins;
    }

    public String[] missingDomains() {
        return this._missingDomains;
    }

    private void setupDomain(boolean standardize) {
        if (this._masterVec1.isCategorical() || this._masterVec2.isCategorical()) {
            this._v1Domain = this._masterVec1.domain();
            this._v2Domain = this._masterVec2.domain();
            if (this._v1Domain != null && this._v2Domain != null) {
                CombineDomainTask t = (CombineDomainTask)new CombineDomainTask(this._v1Domain, this._v2Domain, this._v1Enums, this._v2Enums, this._useAllFactorLevels, this._skipMissing).doAll(this._masterVec1, this._masterVec2);
                this.setDomain(t._dom);
                this._bins = t._bins;
                this._type = (byte)4;
                this._missingDomains = t._missingDom;
            } else {
                GetMeanTask getMeanTask = standardize ? new GetMeanTask(this.v1Domain() == null ? this.v2Domain().length : this.v1Domain().length) : (this.t = null);
            }
        }
        if (null == this._v1Domain && null == this._v2Domain) {
            this._useAllFactorLevels = true;
        }
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        Chunk[] cs = new Chunk[]{(this._masterVec1 != null ? this._masterVec1 : (this._masterVec1 = this._masterVecKey1.get())).chunkForChunkIdx(cidx), (this._masterVec2 != null ? this._masterVec2 : (this._masterVec2 = this._masterVecKey2.get())).chunkForChunkIdx(cidx)};
        return new InteractionWrappedChunk(this, cs);
    }

    @Override
    public Vec doCopy() {
        InteractionWrappedVec v = new InteractionWrappedVec(this.group().addVec(), this._rowLayout, this._v1Enums, this._v2Enums, this._useAllFactorLevels, this._skipMissing, this._standardize, this._masterVecKey1, this._masterVecKey2);
        if (null != this.domain()) {
            v.setDomain(this.domain());
        }
        if (null != this._v1Domain) {
            v._v1Domain = (String[])this._v1Domain.clone();
        }
        if (null != this._v2Domain) {
            v._v2Domain = (String[])this._v2Domain.clone();
        }
        return v;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        ab.putAStr(this._v1Domain);
        ab.putAStr(this._v2Domain);
        ab.putZ(this._useAllFactorLevels);
        ab.putZ(this._skipMissing);
        ab.putZ(this._standardize);
        ab.putAStr(this._missingDomains);
        ab.putAStr(this._v1Enums);
        ab.putAStr(this._v2Enums);
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        this._v1Domain = ab.getAStr();
        this._v2Domain = ab.getAStr();
        this._useAllFactorLevels = ab.getZ();
        this._skipMissing = ab.getZ();
        this._standardize = ab.getZ();
        this._missingDomains = ab.getAStr();
        this._v1Enums = ab.getAStr();
        this._v2Enums = ab.getAStr();
        return super.readAll_impl(ab, fs);
    }

    public static class InteractionWrappedChunk
    extends Chunk {
        public final transient Chunk[] _c;
        public final boolean _c1IsCat;
        public final boolean _c2IsCat;
        public final boolean _isCat;

        InteractionWrappedChunk(InteractionWrappedVec transformWrappedVec, Chunk[] c) {
            this._c = c;
            this.set_len(this._c[0]._len);
            this._start = this._c[0]._start;
            this._vec = transformWrappedVec;
            this._cidx = this._c[0]._cidx;
            this._c1IsCat = this._c[0]._vec.isCategorical();
            this._c2IsCat = this._c[1]._vec.isCategorical();
            this._isCat = this._vec.isCategorical();
        }

        @Override
        public double atd_impl(int idx) {
            if (this._isCat && this.isNA_impl(idx)) {
                return Double.NaN;
            }
            return this._isCat ? (double)Arrays.binarySearch(this._vec.domain(), this.getKey(idx)) : (this._c1IsCat ? 1.0 : this._c[0].atd(idx)) * (this._c2IsCat ? 1.0 : this._c[1].atd(idx));
        }

        @Override
        public long at8_impl(int idx) {
            return this._isCat ? (long)Arrays.binarySearch(this._vec.domain(), this.getKey(idx)) : (this._c1IsCat ? 1L : this._c[0].at8(idx)) * (this._c2IsCat ? 1L : this._c[1].at8(idx));
        }

        private String getKey(int idx) {
            return this._c[0]._vec.domain()[(int)this._c[0].at8(idx)] + "_" + this._c[1]._vec.domain()[(int)this._c[1].at8(idx)];
        }

        @Override
        public boolean isNA_impl(int idx) {
            return this._c[0].isNA(idx) || this._c[1].isNA(idx);
        }

        @Override
        public boolean set_impl(int idx, long l) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, double d) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, float f) {
            return false;
        }

        @Override
        public boolean setNA_impl(int idx) {
            return false;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            for (int i = from; i < to; ++i) {
                nc.addValue(this.atd(i));
            }
            return nc;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            for (int i : rows) {
                nc.addValue(this.atd(i));
            }
            return nc;
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }
    }

    private static class CombineDomainTask
    extends MRTask<CombineDomainTask> {
        private String[] _dom;
        private long[] _bins;
        private String[] _missingDom;
        private final String[] _left;
        private final String[] _rite;
        private final String[] _leftLimit;
        private final String[] _riteLimit;
        private final boolean _useAllLvls;
        private final boolean _skipMissing;
        private IcedHashMap<String, IcedLong> _perChkMap;
        private IcedHashMap<String, String> _perChkMapMissing;

        CombineDomainTask(String[] left, String[] rite, String[] leftLimit, String[] riteLimit, boolean useAllLvls, boolean skipMissing) {
            this._left = left;
            this._rite = rite;
            this._leftLimit = leftLimit;
            this._riteLimit = riteLimit;
            this._useAllLvls = useAllLvls;
            this._skipMissing = skipMissing;
        }

        @Override
        public void map(Chunk[] c) {
            HashSet B;
            this._perChkMap = new IcedHashMap();
            if (!this._useAllLvls) {
                this._perChkMapMissing = new IcedHashMap();
            }
            Chunk left = c[0];
            Chunk rite = c[1];
            HashSet A = this._leftLimit == null ? null : new HashSet();
            HashSet hashSet = B = this._riteLimit == null ? null : new HashSet();
            if (A != null) {
                Collections.addAll(A, this._leftLimit);
            }
            if (B != null) {
                Collections.addAll(B, this._riteLimit);
            }
            for (int i = 0; i < left._len; ++i) {
                String k;
                String r;
                String l;
                int rval;
                int lval;
                boolean riteIsNA;
                boolean leftIsNA = left.isNA(i);
                if (!(leftIsNA | (riteIsNA = rite.isNA(i)))) {
                    lval = (int)left.at8(i);
                    rval = (int)rite.at8(i);
                    if (!(this._useAllLvls || 0 != lval && 0 != rval)) {
                        this._perChkMapMissing.putIfAbsent(this._left[lval] + "_" + this._rite[rval], "");
                        continue;
                    }
                    l = this._left[lval];
                    r = this._rite[rval];
                    if (A != null && !A.contains(l) || B != null && !B.contains(r) || null == this._perChkMap.putIfAbsent(k = l + "_" + r, new IcedLong(1L))) continue;
                    ++((IcedLong)this._perChkMap.get((Object)k))._val;
                    continue;
                }
                if (this._skipMissing || leftIsNA && riteIsNA) continue;
                if (leftIsNA) {
                    rval = (int)rite.at8(i);
                    r = this._rite[rval];
                    if (!this._useAllLvls && 0 == rval) {
                        this._perChkMapMissing.putIfAbsent("NA_" + this._rite[rval], "");
                        continue;
                    }
                    if (B != null && !B.contains(r) || null == this._perChkMap.putIfAbsent(k = "NA_" + r, new IcedLong(1L))) continue;
                    ++((IcedLong)this._perChkMap.get((Object)k))._val;
                    continue;
                }
                lval = (int)left.at8(i);
                l = this._left[lval];
                if (!this._useAllLvls && 0 == lval) {
                    this._perChkMapMissing.putIfAbsent(this._left[lval] + "_NA", "");
                    continue;
                }
                if (null != A && !A.contains(l) || null == this._perChkMap.putIfAbsent(k = l + "_NA", new IcedLong(1L))) continue;
                ++((IcedLong)this._perChkMap.get((Object)k))._val;
            }
        }

        @Override
        public void reduce(CombineDomainTask t) {
            for (Map.Entry e : t._perChkMap.entrySet()) {
                IcedLong i = (IcedLong)this._perChkMap.get(e.getKey());
                if (i != null) {
                    i._val += ((IcedLong)e.getValue())._val;
                    continue;
                }
                this._perChkMap.put((String)e.getKey(), (IcedLong)e.getValue());
            }
            t._perChkMap = null;
            if (this._perChkMapMissing == null && t._perChkMapMissing != null) {
                this._perChkMapMissing = new IcedHashMap();
                this._perChkMapMissing.putAll(t._perChkMapMissing);
            } else if (this._perChkMapMissing != null && t._perChkMapMissing != null) {
                for (String s : t._perChkMapMissing.keySet()) {
                    this._perChkMapMissing.putIfAbsent(s, "");
                }
            }
            t._perChkMapMissing = null;
        }

        @Override
        public void postGlobal() {
            this._dom = this._perChkMap.keySet().toArray(new String[this._perChkMap.size()]);
            Arrays.sort(this._dom);
            int idx = 0;
            this._bins = new long[this._perChkMap.size()];
            for (String s : this._dom) {
                this._bins[idx++] = ((IcedLong)this._perChkMap.get((Object)s))._val;
            }
            if (this._missingDom != null) {
                this._missingDom = this._perChkMapMissing.keySet().toArray(new String[this._perChkMapMissing.size()]);
                Arrays.sort(this._missingDom);
            }
        }
    }

    private static class GetMeanTask
    extends MRTask<GetMeanTask> {
        private double[] _d;
        private double[] _sigma;
        private long _rows;
        private final int _len;

        GetMeanTask(int len) {
            this._len = len;
        }

        @Override
        public void map(Chunk c) {
            this._d = new double[this._len];
            this._sigma = new double[this._len];
            InteractionWrappedChunk cc = (InteractionWrappedChunk)c;
            Chunk lC = cc._c[0];
            Chunk rC = cc._c[1];
            if (cc._c2IsCat) {
                lC = rC;
                rC = cc._c[0];
            }
            long rows = 0L;
            for (int rid = 0; rid < c._len; ++rid) {
                if (lC.isNA(rid) || rC.isNA(rid)) continue;
                int idx = (int)lC.at8(rid);
                ++rows;
                for (int i = 0; i < this._d.length; ++i) {
                    double x = i == idx ? rC.atd(rid) : 0.0;
                    double delta = x - this._d[i];
                    int n = i;
                    this._d[n] = this._d[n] + delta / (double)rows;
                    int n2 = i;
                    this._sigma[n2] = this._sigma[n2] + delta * (x - this._d[i]);
                }
            }
            this._rows = rows;
        }

        @Override
        public void reduce(GetMeanTask t) {
            if (this._rows == 0L) {
                this._d = t._d;
                this._sigma = t._sigma;
            } else if (t._rows != 0L) {
                for (int i = 0; i < this._d.length; ++i) {
                    double delta = this._d[i] - t._d[i];
                    this._d[i] = (this._d[i] * (double)this._rows + t._d[i] * (double)t._rows) / (double)(this._rows + t._rows);
                    int n = i;
                    this._sigma[n] = this._sigma[n] + (t._sigma[i] + delta * delta * (double)this._rows * (double)t._rows / (double)(this._rows + t._rows));
                }
            }
            this._rows += t._rows;
        }

        @Override
        public void postGlobal() {
            for (int i = 0; i < this._sigma.length; ++i) {
                this._sigma[i] = Math.sqrt(this._sigma[i] / (double)(this._rows - 1L));
            }
        }
    }
}

