/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import water.DKV;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.ChunkVisitor;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.fvec.WrappedVec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNum;

public class TransformWrappedVec
extends WrappedVec {
    private final Key<Vec>[] _masterVecKeys;
    private transient Vec[] _masterVecs;
    private final TransformFactory<?> _tf;

    public TransformWrappedVec(Key<Vec> key, int rowLayout, TransformFactory<?> fact, Key<Vec>[] masterVecKeys) {
        super(key, rowLayout, (Key<Vec>)null);
        this._tf = fact;
        this._masterVecKeys = masterVecKeys;
        DKV.put(this);
    }

    public TransformWrappedVec(Vec v, AstPrimitive fun) {
        this(v.group().addVec(), v._rowLayout, fun, new Key[]{v._key});
    }

    public TransformWrappedVec(Vec[] vecs, TransformFactory<?> fact) {
        this(vecs[0].group().addVec(), vecs[0]._rowLayout, fact, TransformWrappedVec.keys(vecs));
    }

    private static Key<Vec>[] keys(Vec[] vecs) {
        Key[] keys = new Key[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            keys[i] = vecs[i]._key;
        }
        return keys;
    }

    public TransformWrappedVec(Key<Vec> key, int rowLayout, AstPrimitive fun, Key<Vec>[] masterVecKeys) {
        this(key, rowLayout, new AstTransformFactory(fun), masterVecKeys);
    }

    public Vec makeVec() {
        Vec v = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk c, NewChunk nc) {
                c.extractRows(nc, 0, c._len);
            }
        }.doAll((byte)3, this)).outputFrame().anyVec();
        this.remove();
        return v;
    }

    @Override
    public Chunk chunkForChunkIdx(int cidx) {
        Chunk[] cs = new Chunk[this._masterVecKeys.length];
        if (this._masterVecs == null) {
            this._masterVecs = new Vec[this._masterVecKeys.length];
        }
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = (this._masterVecs[i] != null ? this._masterVecs[i] : this._masterVecKeys[i].get()).chunkForChunkIdx(cidx);
        }
        return new TransformWrappedChunk(this._tf, this, cs);
    }

    @Override
    public Vec doCopy() {
        TransformWrappedVec v = new TransformWrappedVec(this.group().addVec(), this._rowLayout, this._tf, this._masterVecKeys);
        v.setDomain(this.domain() == null ? null : (String[])this.domain().clone());
        return v;
    }

    private static class AstTransform
    implements Transform {
        private final AstPrimitive _fun;
        private final AstRoot[] _asts;
        private final Env _env;

        AstTransform(AstPrimitive fun, int n) {
            this._fun = fun;
            this._asts = new AstRoot[1 + n];
            this._asts[0] = this._fun;
            for (int i = 1; i < this._asts.length; ++i) {
                this._asts[i] = new AstNum(0.0);
            }
            this._env = new Env(null);
        }

        @Override
        public void setInput(int i, double value) {
            ((AstNum)this._asts[i + 1]).setNum(value);
        }

        @Override
        public double apply() {
            return this._fun.apply(this._env, this._env.stk(), this._asts).getNum();
        }

        @Override
        public void reset() {
        }
    }

    private static class AstTransformFactory
    extends Iced<AstTransformFactory>
    implements TransformFactory<AstTransformFactory> {
        private final AstPrimitive _fun;

        AstTransformFactory(AstPrimitive fun) {
            this._fun = fun;
        }

        public AstTransformFactory() {
            this(null);
        }

        @Override
        public Transform create(int n_inputs) {
            return new AstTransform(this._fun, n_inputs);
        }
    }

    public static interface TransformFactory<T extends Freezable>
    extends Freezable<T> {
        public Transform create(int var1);
    }

    public static interface Transform {
        public void reset();

        public void setInput(int var1, double var2);

        public double apply();
    }

    public static class TransformWrappedChunk
    extends Chunk {
        public final transient Chunk[] _c;
        public final transient Transform _t;
        public final TransformFactory<?> _fact;

        TransformWrappedChunk(TransformFactory<?> fact, Vec transformWrappedVec, Chunk ... c) {
            this._c = c;
            this.set_len(this._c[0]._len);
            this._start = this._c[0]._start;
            this._vec = transformWrappedVec;
            this._cidx = this._c[0]._cidx;
            this._fact = fact;
            this._t = fact != null ? fact.create(c.length) : null;
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int from, int to) {
            throw H2O.unimpl();
        }

        public ChunkVisitor processRows(ChunkVisitor nc, int ... rows) {
            throw H2O.unimpl();
        }

        @Override
        public double atd_impl(int idx) {
            if (null == this._fact) {
                return this._c[0].atd(idx);
            }
            this._t.reset();
            for (int i = 0; i < this._c.length; ++i) {
                this._t.setInput(i, this._c[i].atd(idx));
            }
            return this._t.apply();
        }

        @Override
        public long at8_impl(int idx) {
            throw H2O.unimpl();
        }

        @Override
        public boolean isNA_impl(int idx) {
            return Double.isNaN(this.atd_impl(idx));
        }

        @Override
        public boolean set_impl(int idx, long l) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, double d) {
            return false;
        }

        @Override
        public boolean set_impl(int idx, float f) {
            return false;
        }

        @Override
        public boolean setNA_impl(int idx) {
            return false;
        }

        @Override
        protected final void initFromBytes() {
            throw H2O.fail();
        }

        @Override
        public Chunk deepCopy() {
            return this.extractRows(new NewChunk(this), 0, this._len).compress();
        }
    }
}

