/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import water.H2O;
import water.H2ONode;
import water.TimeLine;
import water.UDP;
import water.Value;
import water.util.Log;

public final class TimelineSnapshot
implements Iterable<Event>,
Iterator<Event> {
    final long[][] _snapshot;
    final Event[] _events;
    final HashMap<Event, Event> _edges;
    public final HashMap<Event, ArrayList<Event>> _sends;
    final H2O _cloud;
    boolean _processed;

    public TimelineSnapshot(H2O cloud, long[][] snapshot) {
        this._cloud = cloud;
        this._snapshot = snapshot;
        this._edges = new HashMap();
        this._sends = new HashMap();
        this._events = new Event[snapshot.length];
        for (int i = 0; i < this._events.length; ++i) {
            this._events[i] = new Event(i, 0);
            if (this._events[i].isEmpty() && !this._events[i].next()) {
                this._events[i] = null;
            }
            if (this._events[i] != null) {
                this.processEvent(this._events[i]);
            }
            assert (this._events[i] == null || this._events[i]._eventIdx < 2048);
        }
        for (Event event : this) {
        }
        this._processed = true;
        for (int i = 0; i < this._events.length; ++i) {
            this._events[i] = new Event(i, 0);
            if (this._events[i].isEmpty() && !this._events[i].next()) {
                this._events[i] = null;
            }
            assert (this._events[i] == null || this._events[i]._eventIdx < 2048);
        }
    }

    private boolean isSenderRecvPair(Event senderCnd, Event recvCnd) {
        ArrayList<Event> recvs;
        if (senderCnd.isSend() && recvCnd.isRecv() && senderCnd.match(recvCnd) && ((recvs = this._sends.get(senderCnd)).isEmpty() || senderCnd.packH2O() == null)) {
            for (Event e : recvs) {
                if (e._nodeId != recvCnd._nodeId) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    void processEvent(Event e) {
        assert (!this._processed);
        if (e.isSend()) {
            this._sends.put(e, new ArrayList());
            for (Event otherE : this._events) {
                if (otherE == null || otherE == e || otherE.equals(e) || !otherE._blocked || !otherE.match(e)) continue;
                this._edges.put(otherE, e);
                this._sends.get(e).add(otherE);
                otherE._blocked = false;
            }
        } else {
            assert (!this._edges.containsKey(e));
            int senderIdx = e.packH2O().index();
            if (senderIdx < 0) {
                Log.warn("no sender found! port = " + e.portPack() + ", ip = " + e.addrPack().toString());
                return;
            }
            Event senderCnd = this._events[senderIdx];
            if (senderCnd != null) {
                if (this.isSenderRecvPair(senderCnd, e)) {
                    this._edges.put(e, senderCnd.clone());
                    this._sends.get(senderCnd).add(e);
                    return;
                }
                senderCnd = senderCnd.clone();
                while (senderCnd.prev()) {
                    if (!this.isSenderRecvPair(senderCnd, e)) continue;
                    this._edges.put(e, senderCnd);
                    this._sends.get(senderCnd).add(e);
                    return;
                }
            }
            e._blocked = true;
        }
        assert (e == null || e._eventIdx < 2048);
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        for (int i = 0; i < this._events.length; ++i) {
            if (this._events[i] != null && (!this._events[i].isEmpty() || this._events[i].next())) {
                assert (this._events[i] == null || this._events[i]._eventIdx < 2048 && !this._events[i].isEmpty());
                return true;
            }
            assert (this._events[i] == null || this._events[i]._eventIdx < 2048 && !this._events[i].isEmpty());
            this._events[i] = null;
        }
        return false;
    }

    public Event getDependency(Event e) {
        return this._edges.get(e);
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        int selectedIdx = -1;
        for (int i = 0; i < this._events.length; ++i) {
            Event send;
            if (this._events[i] == null || this._events[i]._blocked || this._events[i].isRecv() && (send = this._edges.get(this._events[i])) != null && this._events[send._nodeId] != null && send._eventIdx >= this._events[send._nodeId]._eventIdx) continue;
            selectedIdx = selectedIdx == -1 || this._events[i].compareTo(this._events[selectedIdx]) < 0 ? i : selectedIdx;
        }
        if (selectedIdx == -1) {
            selectedIdx = 0;
            long selectedNs = this._events[selectedIdx] != null ? this._events[selectedIdx].ns() : Long.MAX_VALUE;
            long selectedMs = this._events[selectedIdx] != null ? this._events[selectedIdx].ms() : Long.MAX_VALUE;
            for (int i = 1; i < this._events.length; ++i) {
                if (this._events[i] == null || this._events[i].ms() >= selectedMs || this._events[i].ns() >= selectedNs) continue;
                selectedIdx = i;
                selectedNs = this._events[i].ns();
                selectedMs = this._events[i].ms();
            }
        }
        assert (selectedIdx != -1);
        assert (this._events[selectedIdx] != null && this._events[selectedIdx]._eventIdx < 2048 && !this._events[selectedIdx].isEmpty());
        Event res = this._events[selectedIdx];
        this._events[selectedIdx] = this._events[selectedIdx].nextEvent();
        if (this._events[selectedIdx] != null && !this._processed) {
            this.processEvent(this._events[selectedIdx]);
        }
        return res;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public class Event {
        public final int _nodeId;
        final long[] _val;
        int _eventIdx;
        H2ONode _packh2o;
        boolean _blocked;

        public UDP.udp udpType() {
            return UDP.getUdp((int)(this.dataLo() & 0xFFL));
        }

        public Event(int nodeId, int eventIdx) {
            this._nodeId = nodeId;
            this._eventIdx = eventIdx;
            this._val = TimelineSnapshot.this._snapshot[nodeId];
            this.computeH2O(false);
        }

        public final int hashCode() {
            return this._nodeId << 10 ^ this._eventIdx;
        }

        public final boolean equals(Object o) {
            Event e = (Event)o;
            return this._nodeId == e._nodeId && this._eventIdx == e._eventIdx;
        }

        private boolean computeH2O(boolean b) {
            InetAddress inet;
            H2ONode h2o = null;
            if (this.dataLo() != 0L && !(inet = this.addrPack()).isMulticastAddress()) {
                h2o = H2ONode.intern(inet, this.portPack());
                if (this.isSend() && h2o == this.recoH2O()) {
                    h2o = null;
                }
            }
            this._packh2o = h2o;
            return b;
        }

        public final int send_recv() {
            return TimeLine.send_recv(this._val, this._eventIdx);
        }

        public final int dropped() {
            return TimeLine.dropped(this._val, this._eventIdx);
        }

        public final boolean isSend() {
            return this.send_recv() == 0;
        }

        public final boolean isRecv() {
            return this.send_recv() == 1;
        }

        public final boolean isDropped() {
            return this.dropped() != 0;
        }

        public final InetAddress addrPack() {
            return TimeLine.inet(this._val, this._eventIdx);
        }

        public final long dataLo() {
            return TimeLine.l0(this._val, this._eventIdx);
        }

        public final long dataHi() {
            return TimeLine.l8(this._val, this._eventIdx);
        }

        public final long ns() {
            return TimeLine.ns(this._val, this._eventIdx);
        }

        public final boolean isTCP() {
            return (this.ns() & 4L) != 0L;
        }

        public final long ms() {
            return TimeLine.ms(this._val, this._eventIdx) + this.recoH2O()._heartbeat.jvmBootTimeMsec();
        }

        public H2ONode packH2O() {
            return this._packh2o;
        }

        public H2ONode recoH2O() {
            return TimelineSnapshot.this._cloud.members()[this._nodeId];
        }

        public final int portPack() {
            int i = (int)this.dataLo();
            return 0xFFFF & i >> 8;
        }

        public final String addrString() {
            return this._packh2o == null ? "multicast" : this._packh2o.toString();
        }

        public final String ioflavor() {
            int flavor = this.is_io();
            return flavor == -1 ? (this.isTCP() ? "TCP" : "UDP") : Value.nameOfPersist(flavor);
        }

        public final int is_io() {
            int udp_type = (int)(this.dataLo() & 0xFFL);
            return UDP.udp.i_o.ordinal() == udp_type ? (int)(this.dataLo() >> 24 & 0xFFL) : -1;
        }

        public final int ms_io() {
            return (int)(this.dataLo() >> 32);
        }

        public final int size_io() {
            return (int)this.dataHi();
        }

        public String toString() {
            int udp_type = (int)(this.dataLo() & 0xFFL);
            UDP.udp udpType = UDP.getUdp(udp_type);
            String operation = this.isSend() ? " SEND " : " RECV ";
            String host1 = this.addrString();
            String host2 = this.recoH2O().toString();
            String networkPart = this.isSend() ? host2 + " -> " + host1 : host1 + " -> " + host2;
            return "Node(" + this._nodeId + ": " + this.ns() + ") " + udpType.toString() + operation + networkPart + (this.isDropped() ? " DROPPED " : "") + ", data = '" + Long.toHexString(this.dataLo()) + ',' + Long.toHexString(this.dataHi()) + "'";
        }

        final boolean match(Event ev) {
            long evl0;
            int ev_udp_type;
            if (this.send_recv() == ev.send_recv()) {
                return false;
            }
            long myl0 = this.dataLo();
            int my_udp_type = (int)(myl0 & 0xFFL);
            if (my_udp_type != (ev_udp_type = (int)((evl0 = ev.dataLo()) & 0xFFL))) {
                return false;
            }
            UDP.udp e = UDP.getUdp(my_udp_type);
            switch (e) {
                case rebooted: 
                case timeline: {
                    break;
                }
                case ack: 
                case nack: 
                case fetchack: 
                case ackack: 
                case exec: 
                case heartbeat: {
                    if ((int)(myl0 >> 24) == (int)(evl0 >> 24)) break;
                    return false;
                }
                case i_o: {
                    return false;
                }
                default: {
                    throw new RuntimeException("unexpected packet type " + e.toString());
                }
            }
            if (this._packh2o != null && this._packh2o.index() != ev._nodeId) {
                return false;
            }
            return ev._packh2o == null || ev._packh2o.index() == this._nodeId;
        }

        public final boolean isEmpty() {
            return this._eventIdx < TimeLine.length() ? TimeLine.isEmpty(this._val, this._eventIdx) : false;
        }

        public final Event clone() {
            return new Event(this._nodeId, this._eventIdx);
        }

        boolean prev(int minIdx) {
            int min = Math.max(minIdx, -1);
            if (this._eventIdx <= minIdx) {
                return false;
            }
            while (--this._eventIdx > min) {
                if (this.isEmpty()) continue;
                return this.computeH2O(true);
            }
            return this.computeH2O(false);
        }

        boolean prev() {
            return this.prev(-1);
        }

        Event previousEvent(int minIdx) {
            Event res = new Event(this._nodeId, this._eventIdx);
            return res.prev(minIdx) ? res : null;
        }

        Event previousEvent() {
            return this.previousEvent(-1);
        }

        boolean next(int maxIdx) {
            int max = Math.min(maxIdx, TimeLine.length());
            if (this._eventIdx >= max) {
                return false;
            }
            while (++this._eventIdx < max) {
                if (this.isEmpty()) continue;
                return this.computeH2O(true);
            }
            return this.computeH2O(false);
        }

        boolean next() {
            return this.next(TimeLine.length());
        }

        Event nextEvent(int maxIdx) {
            Event res = new Event(this._nodeId, this._eventIdx);
            return res.next(maxIdx) ? res : null;
        }

        Event nextEvent() {
            return this.nextEvent(TimeLine.length());
        }

        public final int compareTo(Event ev) {
            if (ev == null) {
                return -1;
            }
            if (ev == this) {
                return 0;
            }
            if (ev.equals(this)) {
                return 0;
            }
            int res = ev.send_recv() - this.send_recv();
            if (res != 0) {
                return res;
            }
            if (this.isSend()) {
                long myMinMs = Long.MAX_VALUE;
                long evMinMs = Long.MAX_VALUE;
                ArrayList<Event> myRecvs = TimelineSnapshot.this._sends.get(this);
                ArrayList<Event> evRecvs = TimelineSnapshot.this._sends.get(ev);
                for (Event e : myRecvs) {
                    if (e.ms() >= myMinMs) continue;
                    myMinMs = e.ms();
                }
                for (Event e : evRecvs) {
                    if (e.ms() >= evMinMs) continue;
                    evMinMs = e.ms();
                }
                res = (int)(myMinMs - evMinMs);
                if (myMinMs == Long.MAX_VALUE && evMinMs != Long.MAX_VALUE) {
                    res = -1;
                }
                if (myMinMs != Long.MAX_VALUE && evMinMs == Long.MAX_VALUE) {
                    res = 1;
                }
            }
            if (res == 0) {
                res = (int)(this.ms() - ev.ms());
            }
            if (res == 0) {
                res = (int)(this.ns() - ev.ns());
            }
            return res;
        }
    }
}

