/*
 * Decompiled with CFR 0.152.
 */
package water.parser;

import java.util.Arrays;
import java.util.UUID;
import water.Futures;
import water.Iced;
import water.fvec.AppendableVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.Categorical;
import water.parser.ParseDataset;
import water.parser.ParseTime;
import water.parser.ParseUUID;
import water.parser.ParseWriter;
import water.parser.StreamParseWriter;
import water.util.ArrayUtils;

public class FVecParseWriter
extends Iced
implements StreamParseWriter {
    protected AppendableVec[] _vecs;
    protected transient NewChunk[] _nvs;
    protected final transient Categorical[] _categoricals;
    protected final transient byte[] _ctypes;
    long _nLines;
    int _nCols;
    int _col = -1;
    final int _cidx;
    final int _chunkSize;
    ParseWriter.ParseErr[] _errs = new ParseWriter.ParseErr[0];
    private final Vec.VectorGroup _vg;
    private long _errCnt;
    int[] _parse_columns_indices;

    public FVecParseWriter(Vec.VectorGroup vg, int cidx, Categorical[] categoricals, byte[] ctypes, int chunkSize, AppendableVec[] avs) {
        this(vg, cidx, categoricals, ctypes, chunkSize, avs, null);
    }

    public FVecParseWriter(Vec.VectorGroup vg, int cidx, Categorical[] categoricals, byte[] ctypes, int chunkSize, AppendableVec[] avs, int[] parse_columns_indices) {
        boolean ctypesShrunk = false;
        if (parse_columns_indices != null && categoricals != null && parse_columns_indices.length == categoricals.length) {
            this._ctypes = ctypes;
            this._categoricals = categoricals;
            this._vecs = avs;
            this._parse_columns_indices = parse_columns_indices;
            int num_parse_columns = parse_columns_indices.length;
            this._nvs = new NewChunk[num_parse_columns];
            for (int i = 0; i < num_parse_columns; ++i) {
                this._nvs[i] = avs[i].chunkForChunkIdx(cidx);
            }
        } else {
            if (parse_columns_indices == null) {
                parse_columns_indices = new int[avs.length];
                this._ctypes = ctypes;
                this._categoricals = categoricals;
                this._vecs = avs;
                for (int index = 0; index < avs.length; ++index) {
                    parse_columns_indices[index] = index;
                }
            } else {
                int parseColNum = parse_columns_indices.length;
                this._ctypes = ctypes == null ? null : new byte[parseColNum];
                Categorical[] categoricalArray = this._categoricals = categoricals == null ? null : new Categorical[parseColNum];
                ctypesShrunk = categoricals == null ? avs.length <= parse_columns_indices.length : avs.length < categoricals.length;
                this._vecs = new AppendableVec[parseColNum];
                for (int index = 0; index < parse_columns_indices.length; ++index) {
                    if (ctypes != null) {
                        this._ctypes[index] = ctypes[parse_columns_indices[index]];
                    }
                    if (categoricals != null) {
                        this._categoricals[index] = categoricals[parse_columns_indices[index]];
                    }
                    this._vecs[index] = ctypesShrunk ? avs[index] : avs[parse_columns_indices[index]];
                }
            }
            this._parse_columns_indices = parse_columns_indices;
            int num_parse_columns = parse_columns_indices.length;
            this._nvs = new NewChunk[num_parse_columns];
            for (int i = 0; i < num_parse_columns; ++i) {
                this._nvs[i] = ctypesShrunk ? avs[i].chunkForChunkIdx(cidx) : avs[parse_columns_indices[i]].chunkForChunkIdx(cidx);
            }
        }
        this._nCols = this._nvs.length;
        this._cidx = cidx;
        this._vg = vg;
        this._chunkSize = chunkSize;
    }

    @Override
    public FVecParseWriter reduce(StreamParseWriter sdout) {
        FVecParseWriter dout = (FVecParseWriter)sdout;
        this._nCols = Math.max(this._nCols, dout._nCols);
        if (this._vecs != dout._vecs) {
            if (dout._vecs.length > this._vecs.length) {
                AppendableVec[] tmpv = this._vecs;
                this._vecs = dout._vecs;
                dout._vecs = tmpv;
            }
            for (int i = 0; i < dout._vecs.length; ++i) {
                this._vecs[i].reduce(dout._vecs[i]);
            }
        }
        this._errCnt += ((FVecParseWriter)sdout)._errCnt;
        if (this._errs.length < 20 && ((FVecParseWriter)sdout)._errs.length > 0) {
            this._errs = ArrayUtils.append(this._errs, ((FVecParseWriter)sdout)._errs);
            if (this._errs.length > 20) {
                this._errs = Arrays.copyOf(this._errs, 20);
            }
        }
        return this;
    }

    @Override
    public FVecParseWriter close() {
        Futures fs = new Futures();
        this.close(fs);
        fs.blockForPending();
        return this;
    }

    @Override
    public FVecParseWriter close(Futures fs) {
        if (this._nvs == null) {
            return this;
        }
        for (int i = 0; i < this._nvs.length; ++i) {
            this._nvs[i].close(this._cidx, fs);
            this._nvs[i] = null;
        }
        this._nvs = null;
        return this;
    }

    @Override
    public FVecParseWriter nextChunk() {
        return new FVecParseWriter(this._vg, this._cidx + 1, this._categoricals, this._ctypes, this._chunkSize, this._vecs, this._parse_columns_indices);
    }

    @Override
    public void newLine() {
        if (this._col >= 0) {
            ++this._nLines;
            for (int i = this._col + 1; i < this._nCols; ++i) {
                this.addInvalidCol(i);
            }
        }
        this._col = -1;
    }

    @Override
    public void addNumCol(int colIdx, long number, int exp) {
        if (colIdx < this._nCols) {
            this._col = colIdx;
            this._nvs[this._col].addNum(number, exp);
            if (this._ctypes != null && this._ctypes[colIdx] == 0) {
                this._ctypes[colIdx] = 3;
            }
        }
    }

    @Override
    public final void addInvalidCol(int colIdx) {
        if (colIdx < this._nCols) {
            this._col = colIdx;
            this._nvs[this._col].addNA();
        }
    }

    @Override
    public void addNAs(int colIdx, int nrows) {
        this._nvs[colIdx] = this._vecs[colIdx].chunkForChunkIdx(this._cidx);
        this._nvs[colIdx].addNAs(nrows);
    }

    @Override
    public boolean isString(int colIdx) {
        return colIdx < this._nCols && (this._ctypes[colIdx] == 4 || this._ctypes[colIdx] == 2);
    }

    @Override
    public void addStrCol(int colIdx, BufferedString str) {
        if (colIdx < this._nvs.length) {
            if (this._ctypes[colIdx] == 3) {
                this.addInvalidCol(colIdx);
                return;
            }
            if (this._ctypes[colIdx] == 0 && ParseTime.isTime(str)) {
                this._ctypes[colIdx] = 5;
            }
            if (this._ctypes[colIdx] == 0 && ParseUUID.isUUID(str)) {
                this._ctypes[colIdx] = 1;
            }
            if (this._ctypes[colIdx] == 5) {
                long l = ParseTime.attemptTimeParse(str);
                if (l == Long.MIN_VALUE) {
                    this.addInvalidCol(colIdx);
                } else {
                    this.addNumCol(colIdx, l, 0);
                    ++this._nvs[this._col]._timCnt;
                }
            } else if (this._ctypes[colIdx] == 1) {
                UUID uuid = ParseUUID.attemptUUIDParse(str);
                if (colIdx < this._nCols) {
                    this._col = colIdx;
                    this._nvs[this._col].addUUID(uuid);
                }
            } else if (this._ctypes[colIdx] == 2) {
                this._col = colIdx;
                this._nvs[this._col].addStr(str);
            } else if (!this._categoricals[colIdx].isMapFull()) {
                this._col = colIdx;
                int id = this._categoricals[this._col].addKey(str);
                if (this._ctypes[colIdx] == 0 && id > 1) {
                    this._ctypes[colIdx] = 4;
                }
                if (this._ctypes[colIdx] == 4) {
                    this._nvs[colIdx].addNum(id, 0);
                } else {
                    this._nvs[colIdx].addCategorical(id);
                }
            } else {
                throw new ParseDataset.H2OParseException("Exceeded categorical limit on column #" + (colIdx + 1) + " (using 1-based indexing).  Consider reparsing this column as a string.");
            }
        }
    }

    @Override
    public void addNumCol(int colIdx, double value) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.addInvalidCol(colIdx);
        } else if (colIdx < this._nCols) {
            this._col = colIdx;
            this._nvs[this._col].addNumDecompose(value);
            if (this._ctypes != null && this._ctypes[colIdx] == 0) {
                this._ctypes[colIdx] = 3;
            }
        }
    }

    @Override
    public void setColumnNames(String[] names) {
    }

    @Override
    public final void rollbackLine() {
    }

    @Override
    public void invalidLine(ParseWriter.ParseErr err) {
        this.addErr(err);
        this.newLine();
    }

    @Override
    public void addError(ParseWriter.ParseErr err) {
        if (this._errs == null) {
            this._errs = new ParseWriter.ParseErr[]{err};
        } else if (this._errs.length < 20) {
            this._errs = ArrayUtils.append(this._errs, err);
        }
        ++this._errCnt;
    }

    @Override
    public void setIsAllASCII(int colIdx, boolean b) {
        if (colIdx < this._nvs.length) {
            this._nvs[colIdx]._isAllASCII = b;
        }
    }

    @Override
    public boolean hasErrors() {
        return this._errs != null && this._errs.length > 0;
    }

    @Override
    public ParseWriter.ParseErr[] removeErrors() {
        ParseWriter.ParseErr[] res = this._errs;
        this._errs = null;
        return res;
    }

    @Override
    public long lineNum() {
        return this._nLines;
    }

    public void addErr(ParseWriter.ParseErr err) {
        if (this._errs.length < 20) {
            this._errs = ArrayUtils.append(this._errs, err);
        }
        ++this._errCnt;
    }
}

