/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public abstract class LogArchiveWriter
implements Closeable {
    final OutputStream _os;

    LogArchiveWriter(OutputStream os) {
        this._os = os;
    }

    public abstract void putNextEntry(ArchiveEntry var1) throws IOException;

    public abstract void closeEntry() throws IOException;

    public void write(byte[] b, int off, int len) throws IOException {
        this._os.write(b, off, len);
    }

    public final void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void close() throws IOException {
        this._os.close();
    }

    public static class ArchiveEntry {
        final String _name;
        final long _time;

        public ArchiveEntry(String name, Date date) {
            this(name, date.getTime());
        }

        ArchiveEntry(String name, long time) {
            this._name = name;
            this._time = time;
        }

        public String toString() {
            return this._name + " (" + new Date(this._time) + ")";
        }
    }
}

