/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import water.parser.BufferedString;
import water.util.ArrayUtils;
import water.util.CollectionUtils;

public class StringUtils {
    private static Map<Character, Integer> hexCode = CollectionUtils.createMap(StringUtils.toCharacterArray("0123456789abcdefABCDEF"), new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 10, 11, 12, 13, 14, 15});
    public static String PADDING_SYMBOL = "</s>";

    public static String toString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static boolean isNullOrEmpty(BufferedString s) {
        return s == null || s.length() == 0;
    }

    public static String expandPath(String path) {
        return path.replaceFirst("^~", System.getProperty("user.home"));
    }

    public static String cleanString(String s) {
        String string = s;
        string = string.replaceAll("[^A-Za-z0-9(),!?\\'\\`]", " ");
        string = string.replaceAll("'s", " 's");
        string = string.replaceAll("'ve", " 've");
        string = string.replaceAll("n't", " n't");
        string = string.replaceAll("'re", " 're");
        string = string.replaceAll("'d", " 'd");
        string = string.replaceAll("'ll", " 'll");
        string = string.replaceAll(",", " , ");
        string = string.replaceAll("!", " ! ");
        string = string.replaceAll("\\(", " ( ");
        string = string.replaceAll("\\)", " ) ");
        string = string.replaceAll("\\?", " ? ");
        string = string.replaceAll("\\s{2,}", " ");
        return string.trim().toLowerCase();
    }

    public static String[] tokenize(String text) {
        return StringUtils.cleanString(text).split(" ");
    }

    public static int[] tokensToArray(String[] tokens, int padToLength, Map<String, Integer> dict) {
        assert (dict != null);
        int len = tokens.length;
        int pad = padToLength - len;
        int[] data = new int[padToLength];
        int ix = 0;
        for (String t : tokens) {
            int index;
            Integer val = dict.get(t);
            if (val == null) {
                index = dict.size();
                dict.put(t, index);
            } else {
                index = val;
            }
            data[ix] = index;
            ++ix;
        }
        for (int i = 0; i < pad; ++i) {
            int index;
            data[ix] = index = dict.get(PADDING_SYMBOL).intValue();
            ++ix;
        }
        return data;
    }

    public static ArrayList<int[]> texts2array(List<String> texts) {
        int maxlen = 0;
        int index = 0;
        HashMap<String, Integer> dict = new HashMap<String, Integer>();
        dict.put(PADDING_SYMBOL, index);
        ++index;
        for (String text : texts) {
            String[] tokens;
            for (String token : tokens = StringUtils.tokenize(text)) {
                if (dict.containsKey(token)) continue;
                dict.put(token, index);
                ++index;
            }
            int len = tokens.length;
            if (len <= maxlen) continue;
            maxlen = len;
        }
        ArrayList<int[]> array = new ArrayList<int[]>();
        for (String text : texts) {
            int[] data = StringUtils.tokensToArray(StringUtils.tokenize(text), maxlen, dict);
            array.add(data);
        }
        return array;
    }

    public static String join(String delimiter, String[] arr) {
        return StringUtils.join(delimiter, Arrays.asList(arr));
    }

    public static String join(String delimiter, Iterable<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String item : strings) {
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public static HashSet<Character> toCharacterSet(String src) {
        int n = src.length();
        HashSet<Character> res = new HashSet<Character>(n);
        for (int i = 0; i < n; ++i) {
            res.add(Character.valueOf(src.charAt(i)));
        }
        return res;
    }

    public static Character[] toCharacterArray(String src) {
        return ArrayUtils.box(src.toCharArray());
    }

    public static int unhex(String str) {
        int res = 0;
        for (char c : str.toCharArray()) {
            if (!hexCode.containsKey(Character.valueOf(c))) {
                throw new NumberFormatException("Not a hexademical character " + c);
            }
            res = (res << 4) + hexCode.get(Character.valueOf(c));
        }
        return res;
    }

    public static byte[] bytesOf(CharSequence str) {
        return str.toString().getBytes(Charset.forName("UTF-8"));
    }

    public static byte[] toBytes(Object value) {
        return StringUtils.bytesOf(String.valueOf(value));
    }

    public static String toString(byte[] bytes, int from, int length) {
        return new String(bytes, from, length, Charset.forName("UTF-8"));
    }
}

