/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ConfusionMatrix;
import hex.Model;
import hex.ModelBuilderListener;
import hex.ModelCategory;
import hex.ModelMetrics;
import hex.ScoreKeeper;
import hex.ToEigenVec;
import hex.genmodel.utils.DistributionFamily;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import jsr166y.CountedCompleter;
import water.AutoBuffer;
import water.DKV;
import water.ExtensionManager;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.MRTask;
import water.Scope;
import water.api.FSIOException;
import water.api.HDFSIOException;
import water.exceptions.H2OIllegalArgumentException;
import water.exceptions.H2OModelBuilderIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.FileVec;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.rapids.ast.prims.advmath.AstKFold;
import water.udf.CFuncRef;
import water.util.ArrayUtils;
import water.util.Countdown;
import water.util.FrameUtils;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MRUtils;
import water.util.MathUtils;
import water.util.StringUtils;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class ModelBuilder<M extends Model<M, P, O>, P extends Model.Parameters, O extends Model.Output>
extends Iced {
    private ModelBuilderListener _modelBuilderListener;
    private transient IcedHashMap<Key, String> _toDelete = new IcedHashMap();
    public Job<M> _job;
    protected Key<M> _result;
    private Countdown _build_model_countdown;
    private Countdown _build_step_countdown;
    private static String[] ALGOBASES = new String[0];
    private static String[] SCHEMAS = new String[0];
    private static ModelBuilder[] BUILDERS = new ModelBuilder[0];
    protected boolean _startUpOnceModelBuilder = false;
    public P _parms;
    protected transient Frame _train;
    protected transient Frame _valid;
    private static final Map<String, Class<? extends ModelBuilder>> _builders = new HashMap<String, Class<? extends ModelBuilder>>();
    private static final Map<Class<? extends Model>, String> _model_class_to_algo = new HashMap<Class<? extends Model>, String>();
    private static final Map<String, String> _algo_to_algo_full_name = new HashMap<String, String>();
    private static final Map<String, Class<? extends Model>> _algo_to_model_class = new HashMap<String, Class<? extends Model>>();
    protected transient Vec _response;
    protected transient Vec _vresponse;
    protected transient Vec _offset;
    protected transient Vec _weights;
    protected transient Vec _fold;
    protected transient String[] _origNames;
    protected transient String[][] _origDomains;
    protected int _nclass;
    transient double[] _distribution;
    protected transient double[] _priorClassDist;
    public ValidationMessage[] _messages = new ValidationMessage[0];
    private int _error_count = -1;
    public transient HashSet<String> _removedCols = new HashSet();

    public void setModelBuilderListener(ModelBuilderListener modelBuilderListener) {
        this._modelBuilderListener = modelBuilderListener;
    }

    public ToEigenVec getToEigenVec() {
        return null;
    }

    public boolean shouldReorder(Vec v) {
        return ((Model.Parameters)this._parms)._categorical_encoding.needsResponse() && this.isSupervised();
    }

    void cleanUp() {
        FrameUtils.cleanUp(this._toDelete);
    }

    public final M get() {
        assert (this._job._result == this._result);
        return (M)((Model)this._job.get());
    }

    public final boolean isStopped() {
        return this._job.isStopped();
    }

    public final Key<M> dest() {
        return this._result;
    }

    private void startClock() {
        this._build_model_countdown = Countdown.fromSeconds(((Model.Parameters)this._parms)._max_runtime_secs);
        this._build_model_countdown.start();
    }

    protected boolean timeout() {
        return this._build_step_countdown != null ? this._build_step_countdown.timedOut() : this._build_model_countdown.timedOut();
    }

    protected boolean stop_requested() {
        return this._job.stop_requested() || this.timeout();
    }

    public static <S extends Model> Key<S> defaultKey(String algoName) {
        return Key.make(H2O.calcNextUniqueModelId(algoName));
    }

    protected ModelBuilder(P parms) {
        this(parms, ModelBuilder.defaultKey(((Model.Parameters)parms).algoName()));
    }

    protected ModelBuilder(P parms, Key<M> key) {
        this._result = key;
        this._job = new Job<M>(this._result, ((Model.Parameters)parms).javaName(), ((Model.Parameters)parms).algoName());
        this._parms = parms;
    }

    protected ModelBuilder(P parms, Job<M> job) {
        this._job = job;
        this._result = ModelBuilder.defaultKey(((Model.Parameters)parms).algoName());
        this._parms = parms;
    }

    public static String[] algos() {
        return ALGOBASES;
    }

    protected ModelBuilder(P parms, boolean startup_once) {
        this(parms, startup_once, "hex.schemas.");
    }

    protected ModelBuilder(P parms, boolean startup_once, String externalSchemaDirectory) {
        String base = this.getName();
        if (!startup_once) {
            throw H2O.fail("Algorithm " + base + " registration issue. It can only be called at startup.");
        }
        this._startUpOnceModelBuilder = true;
        this._job = null;
        this._result = null;
        this._parms = parms;
        this.init(false);
        if (ArrayUtils.find(ALGOBASES, base) != -1) {
            throw H2O.fail("Only called once at startup per ModelBuilder, and " + base + " has already been called");
        }
        ALGOBASES = Arrays.copyOf(ALGOBASES, ALGOBASES.length + 1);
        BUILDERS = Arrays.copyOf(BUILDERS, BUILDERS.length + 1);
        SCHEMAS = Arrays.copyOf(SCHEMAS, SCHEMAS.length + 1);
        ModelBuilder.ALGOBASES[ModelBuilder.ALGOBASES.length - 1] = base;
        ModelBuilder.BUILDERS[ModelBuilder.BUILDERS.length - 1] = this;
        ModelBuilder.SCHEMAS[ModelBuilder.SCHEMAS.length - 1] = externalSchemaDirectory;
    }

    public static String algoName(String urlName) {
        return ((Model.Parameters)ModelBuilder.BUILDERS[ArrayUtils.find(ModelBuilder.ALGOBASES, urlName)]._parms).algoName();
    }

    public static String javaName(String urlName) {
        return ((Model.Parameters)ModelBuilder.BUILDERS[ArrayUtils.find(ModelBuilder.ALGOBASES, urlName)]._parms).javaName();
    }

    public static String paramName(String urlName) {
        return ModelBuilder.algoName(urlName) + "Parameters";
    }

    public static String schemaDirectory(String urlName) {
        return SCHEMAS[ArrayUtils.find(ALGOBASES, urlName)];
    }

    public static boolean havePojo(String urlName) {
        return BUILDERS[ModelBuilder.ensureBuilderIndex(urlName)].havePojo();
    }

    public static boolean haveMojo(String urlName) {
        return BUILDERS[ModelBuilder.ensureBuilderIndex(urlName)].haveMojo();
    }

    private static int ensureBuilderIndex(String urlName) {
        String formattedName = urlName.toLowerCase();
        int index = ArrayUtils.find(ALGOBASES, formattedName);
        if (index < 0) {
            throw new IllegalArgumentException(String.format("Cannot find Builder for algo url name %s", formattedName));
        }
        return index;
    }

    public static <B extends ModelBuilder> B make(String algo, Job job, Key<Model> result) {
        int idx = ArrayUtils.find(ALGOBASES, algo.toLowerCase());
        if (idx < 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unknown algo: '").append(algo).append("'; Extension report: ");
            Log.err(ExtensionManager.getInstance().makeExtensionReport(sb));
            throw new IllegalStateException("Algorithm '" + algo + "' is not registered. Available algos: [" + StringUtils.join(",", ALGOBASES) + "]");
        }
        ModelBuilder mb = (ModelBuilder)BUILDERS[idx].clone();
        mb._job = job;
        mb._result = result;
        mb._parms = (Model.Parameters)((Iced)ModelBuilder.BUILDERS[idx]._parms).clone();
        return (B)mb;
    }

    public static <B extends ModelBuilder, MP extends Model.Parameters> B make(MP parms) {
        Key<Model> mKey = ModelBuilder.defaultKey(parms.algoName());
        Job mJob = new Job(mKey, parms.javaName(), parms.algoName());
        B newMB = ModelBuilder.make(parms.algoName(), mJob, mKey);
        ((ModelBuilder)newMB)._parms = (Model.Parameters)parms.clone();
        return newMB;
    }

    public final Frame train() {
        return this._train;
    }

    public void setTrain(Frame train) {
        this._train = train;
    }

    protected final Frame valid() {
        return this._valid;
    }

    public Vec response() {
        return this._response;
    }

    public Vec vresponse() {
        return this._vresponse == null ? this._response : this._vresponse;
    }

    private void setFinalState() {
        Key<M> reskey = this.dest();
        if (reskey == null) {
            return;
        }
        Model res = (Model)reskey.get();
        if (res != null && res._output != null) {
            ((Model.Output)res._output)._job = this._job;
            ((Model.Output)res._output).stopClock();
        }
        Log.info("Completing model " + reskey);
    }

    private void saveModelCheckpointIfConfigured() {
        Model model = (Model)this._result.get();
        if (model != null && !StringUtils.isNullOrEmpty(((Model.Parameters)model._parms)._export_checkpoints_dir)) {
            try {
                model.exportBinaryModel(((Model.Parameters)model._parms)._export_checkpoints_dir + "/" + model._key.toString(), true);
            }
            catch (IOException | FSIOException | HDFSIOException e) {
                throw new H2OIllegalArgumentException("export_checkpoints_dir", "saveModelIfConfigured", e);
            }
        }
    }

    public Job<M> trainModelOnH2ONode() {
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        TrainModelRunnable trainModel = new TrainModelRunnable(this);
        H2O.runOnH2ONode(trainModel);
        return this._job;
    }

    public final Job<M> trainModel() {
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        this.startClock();
        if (!this.nFoldCV()) {
            return this._job.start(this.trainModelImpl(), ((Model.Parameters)this._parms).progressUnits(), ((Model.Parameters)this._parms)._max_runtime_secs);
        }
        return this._job.start(new H2O.H2OCountedCompleter(){

            @Override
            public void compute2() {
                ModelBuilder.this.computeCrossValidation();
                this.tryComplete();
                if (ModelBuilder.this._modelBuilderListener != null) {
                    ModelBuilder.this._modelBuilderListener.onModelSuccess((Model)ModelBuilder.this._job.get());
                }
            }

            @Override
            public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                Log.warn("Model training job " + ModelBuilder.this._job._description + " completed with exception: " + ex);
                try {
                    Keyed.remove(ModelBuilder.this._job._result);
                }
                catch (Exception logged) {
                    Log.warn("Exception thrown when removing result from job " + ModelBuilder.this._job._description, logged);
                }
                if (ModelBuilder.this._modelBuilderListener != null) {
                    ModelBuilder.this._modelBuilderListener.onModelFailure(ex, (Model.Parameters)ModelBuilder.this._parms);
                }
                return true;
            }
        }, (long)(this.nFoldWork() + 1) * ((Model.Parameters)this._parms).progressUnits(), ((Model.Parameters)this._parms)._max_runtime_secs);
    }

    public final M trainModelNested(Frame fr) {
        if (fr != null) {
            this.setTrain(fr);
        }
        if (this.error_count() > 0) {
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        this.startClock();
        if (!this.nFoldCV()) {
            this.trainModelImpl().compute2();
        } else {
            this.computeCrossValidation();
        }
        return (M)((Model)this._result.get());
    }

    public static <MP extends Model.Parameters> Model trainModelNested(Job<?> job, Key<Model> result, MP params, Frame fr) {
        H2O.runOnH2ONode(new TrainModelNestedRunnable(job, result, params, fr));
        return result.get();
    }

    protected abstract Driver trainModelImpl();

    @Deprecated
    protected int nModelsInParallel() {
        return 0;
    }

    protected int nModelsInParallel(int folds) {
        int n = this.nModelsInParallel();
        if (n > 0) {
            return n;
        }
        return this.nModelsInParallel(folds, 1);
    }

    protected int nModelsInParallel(int folds, int defaultParallelization) {
        if (!((Model.Parameters)this._parms)._parallelize_cross_validation) {
            return 1;
        }
        int parallelization = defaultParallelization;
        if ((double)this._train.byteSize() < 1000000.0) {
            parallelization = folds;
        }
        return Math.min(parallelization, H2O.getCloudSize() * H2O.ARGS.nthreads);
    }

    private double maxRuntimeSecsPerModel(int cvModelsCount, int parallelization) {
        return cvModelsCount > 0 ? ((Model.Parameters)this._parms)._max_runtime_secs / Math.ceil((double)cvModelsCount / (double)parallelization + 1.0) : ((Model.Parameters)this._parms)._max_runtime_secs;
    }

    protected int nFoldWork() {
        if (((Model.Parameters)this._parms)._fold_column == null) {
            return ((Model.Parameters)this._parms)._nfolds;
        }
        Vec f = ((Model.Parameters)this._parms)._train.get().vec(((Model.Parameters)this._parms)._fold_column);
        Vec fc = VecUtils.toCategoricalVec(f);
        int N = fc.domain().length;
        fc.remove();
        return N;
    }

    public void computeCrossValidation() {
        assert (this._job.isRunning());
        this._job.setReadyForView(false);
        int N = this.nFoldWork();
        this.init(false);
        ModelBuilder<M, P, O>[] cvModelBuilders = null;
        try {
            Scope.enter();
            ModelBuilder<M, P, O>[] foldAssignment = this.cv_AssignFold(N);
            Vec[] weights = this.cv_makeWeights(N, (Vec)foldAssignment);
            cvModelBuilders = this.cv_makeFramesAndBuilders(N, weights);
            this.cv_buildModels(N, cvModelBuilders);
            ModelMetrics.MetricBuilder[] mbs = this.cv_scoreCVModels(N, weights, cvModelBuilders);
            long time_allocated_to_main_model = (long)(this.maxRuntimeSecsPerModel(N, this.nModelsInParallel(N)) * 1000.0);
            this.buildMainModel(time_allocated_to_main_model);
            this.cv_mainModelScores(N, mbs, cvModelBuilders);
            this._job.setReadyForView(true);
            DKV.put(this._job);
        }
        catch (Exception e) {
            if (cvModelBuilders != null) {
                Futures fs = new Futures();
                for (ModelBuilder<M, P, O> mb : cvModelBuilders) {
                    DKV.remove(((Model.Parameters)mb._parms)._train, fs);
                    DKV.remove(((Model.Parameters)mb._parms)._valid, fs);
                    DKV.remove(Key.make(super.getPredictionKey()), fs);
                    Keyed.remove(mb._result, fs, true);
                }
                fs.blockForPending();
            }
            throw e;
        }
        finally {
            if (cvModelBuilders != null) {
                for (ModelBuilder<M, P, O> mb : cvModelBuilders) {
                    mb.cleanUp();
                }
            }
            this.cleanUp();
            Scope.exit(new Key[0]);
        }
    }

    public Vec cv_AssignFold(int N) {
        assert (N >= 2);
        Vec fold = this.train().vec(((Model.Parameters)this._parms)._fold_column);
        if (fold != null) {
            if (!(fold.isInt() && (fold.min() == 0.0 && fold.max() == (double)(N - 1) || fold.min() == 1.0 && fold.max() == (double)N))) {
                throw new H2OIllegalArgumentException("Fold column must be either categorical or contiguous integers from 0..N-1 or 1..N");
            }
            return fold;
        }
        long seed = ((Model.Parameters)this._parms).getOrMakeRealSeed();
        Log.info("Creating " + N + " cross-validation splits with random number seed: " + seed);
        switch (((Model.Parameters)this._parms)._fold_assignment) {
            case AUTO: 
            case Random: {
                return AstKFold.kfoldColumn(this.train().anyVec().makeZero(), N, seed);
            }
            case Modulo: {
                return AstKFold.moduloKfoldColumn(this.train().anyVec().makeZero(), N);
            }
            case Stratified: {
                return AstKFold.stratifiedKFoldColumn(this.response(), N, seed);
            }
        }
        throw H2O.unimpl();
    }

    public Vec[] cv_makeWeights(final int N, Vec foldAssignment) {
        String origWeightsName = ((Model.Parameters)this._parms)._weights_column;
        Vec origWeight = origWeightsName != null ? this.train().vec(origWeightsName) : this.train().anyVec().makeCon(1.0);
        Frame folds_and_weights = new Frame(foldAssignment, origWeight);
        Vec[] weights = ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] chks, NewChunk[] nchks) {
                Chunk fold = chks[0];
                Chunk orig = chks[1];
                for (int row = 0; row < orig._len; ++row) {
                    int foldIdx = (int)fold.at8(row) % N;
                    double w = orig.atd(row);
                    for (int f = 0; f < N; ++f) {
                        boolean holdout = foldIdx == f;
                        nchks[2 * f].addNum(holdout ? 0.0 : w);
                        nchks[2 * f + 1].addNum(holdout ? w : 0.0);
                    }
                }
            }
        }.doAll(2 * N, (byte)3, folds_and_weights)).outputFrame().vecs();
        if (((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment) {
            DKV.put(new Frame(Key.make("cv_fold_assignment_" + this._result.toString()), new String[]{"fold_assignment"}, new Vec[]{foldAssignment}));
        }
        if (((Model.Parameters)this._parms)._fold_column == null && !((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment) {
            foldAssignment.remove();
        }
        if (origWeightsName == null) {
            origWeight.remove();
        }
        for (Vec weight : weights) {
            if (!weight.isConst()) continue;
            throw new H2OIllegalArgumentException("Not enough data to create " + N + " random cross-validation splits. Either reduce nfolds, specify a larger dataset (or specify another random number seed, if applicable).");
        }
        return weights;
    }

    public ModelBuilder<M, P, O>[] cv_makeFramesAndBuilders(int N, Vec[] weights) {
        long old_cs = ((Model.Parameters)this._parms).checksum();
        String origDest = this._result.toString();
        String weightName = "__internal_cv_weights__";
        if (this.train().find("__internal_cv_weights__") != -1) {
            throw new H2OIllegalArgumentException("Frame cannot contain a Vec called '__internal_cv_weights__'.");
        }
        Frame cv_fr = new Frame(this.train().names(), this.train().vecs());
        if (((Model.Parameters)this._parms)._weights_column != null) {
            cv_fr.remove(((Model.Parameters)this._parms)._weights_column);
        }
        ModelBuilder[] cvModelBuilders = new ModelBuilder[N];
        ArrayList<Frame> cvFramesForFailedModels = new ArrayList<Frame>();
        double cv_max_runtime_secs = this.maxRuntimeSecsPerModel(N, this.nModelsInParallel(N));
        for (int i = 0; i < N; ++i) {
            String identifier = origDest + "_cv_" + (i + 1);
            Frame cvTrain = new Frame(Key.make(identifier + "_train"), cv_fr.names(), cv_fr.vecs());
            cvTrain.add("__internal_cv_weights__", weights[2 * i]);
            DKV.put(cvTrain);
            Frame cvValid = new Frame(Key.make(identifier + "_valid"), cv_fr.names(), cv_fr.vecs());
            cvValid.add("__internal_cv_weights__", weights[2 * i + 1]);
            DKV.put(cvValid);
            ModelBuilder cv_mb = (ModelBuilder)this.clone();
            cv_mb.setTrain(cvTrain);
            cv_mb._result = Key.make(identifier);
            cv_mb._parms = (Model.Parameters)((Iced)this._parms).clone();
            ((Model.Parameters)cv_mb._parms)._is_cv_model = true;
            ((Model.Parameters)cv_mb._parms)._weights_column = "__internal_cv_weights__";
            ((Model.Parameters)cv_mb._parms).setTrain(cvTrain._key);
            ((Model.Parameters)cv_mb._parms)._valid = cvValid._key;
            ((Model.Parameters)cv_mb._parms)._fold_assignment = Model.Parameters.FoldAssignmentScheme.AUTO;
            ((Model.Parameters)cv_mb._parms)._nfolds = 0;
            ((Model.Parameters)cv_mb._parms)._max_runtime_secs = cv_max_runtime_secs;
            cv_mb.clearValidationErrors();
            cv_mb.init(false);
            if (cv_mb.error_count() > 0) {
                Log.info("Marking frame for failed cv model for removal: " + cvTrain._key);
                cvFramesForFailedModels.add(cvTrain);
                Log.info("Marking frame for failed cv model for removal: " + cvValid._key);
                cvFramesForFailedModels.add(cvValid);
                for (ValidationMessage vm : cv_mb._messages) {
                    this.message(vm._log_level, vm._field_name, vm._message);
                }
            }
            cvModelBuilders[i] = cv_mb;
        }
        if (this.error_count() > 0) {
            Futures fs = new Futures();
            for (Frame cvf : cvFramesForFailedModels) {
                cvf.vec("__internal_cv_weights__").remove(fs);
                DKV.remove(cvf._key, fs);
                Log.info("Removing frame for failed cv model: " + cvf._key);
            }
            fs.blockForPending();
            throw H2OModelBuilderIllegalArgumentException.makeFromBuilder(this);
        }
        assert (old_cs == ((Model.Parameters)this._parms).checksum());
        return cvModelBuilders;
    }

    public void cv_buildModels(int N, ModelBuilder<M, P, O>[] cvModelBuilders) {
        ModelBuilder.bulkBuildModels("cross-validation", this._job, cvModelBuilders, this.nModelsInParallel(N), 0);
        this.cv_computeAndSetOptimalParameters(cvModelBuilders);
    }

    public static void bulkBuildModels(String modelType, Job job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization, int updateInc) {
        int i;
        int N = modelBuilders.length;
        H2O.H2OCountedCompleter[] submodel_tasks = new H2O.H2OCountedCompleter[N];
        int nRunning = 0;
        RuntimeException rt = null;
        for (i = 0; i < N; ++i) {
            if (job.stop_requested()) {
                Log.info("Skipping build of last " + (N - i) + " out of " + N + " " + modelType + " CV models");
                ModelBuilder.stopAll(submodel_tasks);
                throw new Job.JobCancelledException();
            }
            Log.info("Building " + modelType + " model " + (i + 1) + " / " + N + ".");
            super.startClock();
            submodel_tasks[i] = H2O.submitTask(modelBuilders[i].trainModelImpl());
            if (++nRunning != parallelization) continue;
            while (nRunning > 0) {
                try {
                    submodel_tasks[i + 1 - nRunning--].join();
                    if (updateInc <= 0) continue;
                    job.update(updateInc);
                }
                catch (RuntimeException t) {
                    if (rt != null) continue;
                    rt = t;
                }
            }
            if (rt == null) continue;
            throw rt;
        }
        for (i = 0; i < N; ++i) {
            try {
                H2O.H2OCountedCompleter task = submodel_tasks[i];
                assert (task != null);
                task.join();
                continue;
            }
            catch (RuntimeException t) {
                if (rt != null) continue;
                rt = t;
            }
        }
        if (rt != null) {
            throw rt;
        }
    }

    private static void stopAll(H2O.H2OCountedCompleter[] tasks) {
        for (H2O.H2OCountedCompleter task : tasks) {
            if (task == null) continue;
            task.cancel(true);
        }
    }

    public ModelMetrics.MetricBuilder[] cv_scoreCVModels(int N, Vec[] weights, ModelBuilder<M, P, O>[] cvModelBuilders) {
        if (this._job.stop_requested()) {
            Log.info("Skipping scoring of CV models");
            throw new Job.JobCancelledException();
        }
        assert (weights.length == 2 * N);
        assert (cvModelBuilders.length == N);
        Log.info("Scoring the " + N + " CV models");
        ModelMetrics.MetricBuilder[] mbs = new ModelMetrics.MetricBuilder[N];
        Futures fs = new Futures();
        for (int i = 0; i < N; ++i) {
            if (this._job.stop_requested()) {
                Log.info("Skipping scoring for last " + (N - i) + " out of " + N + " CV models");
                throw new Job.JobCancelledException();
            }
            Frame cvValid = cvModelBuilders[i].valid();
            Frame adaptFr = new Frame(cvValid);
            Model cvModel = (Model)cvModelBuilders[i].dest().get();
            cvModel.adaptTestForTrain(adaptFr, true, !this.isSupervised());
            mbs[i] = cvModel.scoreMetrics(adaptFr);
            if (this.nclasses() == 2 || ((Model.Parameters)this._parms)._keep_cross_validation_predictions || ((Model.Parameters)this._parms)._distribution == DistributionFamily.huber) {
                String predName = super.getPredictionKey();
                cvModel.predictScoreImpl(cvValid, adaptFr, predName, this._job, true, CFuncRef.NOP);
                DKV.put(cvModel);
            }
            if (adaptFr != null) {
                Frame.deleteTempFrameAndItsNonSharedVecs(adaptFr, cvValid);
                DKV.remove(adaptFr._key, fs);
            }
            DKV.remove(((Model.Parameters)cvModelBuilders[i]._parms)._train, fs);
            DKV.remove(((Model.Parameters)cvModelBuilders[i]._parms)._valid, fs);
            weights[2 * i].remove(fs);
            weights[2 * i + 1].remove(fs);
        }
        fs.blockForPending();
        return mbs;
    }

    private void buildMainModel(long max_runtime_millis) {
        if (this._job.stop_requested()) {
            Log.info("Skipping main model");
            throw new Job.JobCancelledException();
        }
        assert (this._job.isRunning());
        Log.info("Building main model.");
        Log.info("Remaining time for main model (ms): " + max_runtime_millis);
        this._build_step_countdown = new Countdown(max_runtime_millis, true);
        Driver mm = H2O.submitTask(this.trainModelImpl());
        mm.join();
        this._build_step_countdown = null;
    }

    public void cv_mainModelScores(int N, ModelMetrics.MetricBuilder[] mbs, ModelBuilder<M, P, O>[] cvModelBuilders) {
        Model mainModel = (Model)this._result.get();
        Log.info("Computing " + N + "-fold cross-validation metrics.");
        Key[] cvModKeys = new Key[N];
        ((Model.Output)mainModel._output)._cross_validation_models = ((Model.Parameters)this._parms)._keep_cross_validation_models ? cvModKeys : null;
        Key[] predKeys = new Key[N];
        ((Model.Output)mainModel._output)._cross_validation_predictions = ((Model.Parameters)this._parms)._keep_cross_validation_predictions ? predKeys : null;
        for (int i = 0; i < N; ++i) {
            if (i > 0) {
                mbs[0].reduce(mbs[i]);
            }
            cvModKeys[i] = cvModelBuilders[i]._result;
            predKeys[i] = Key.make(super.getPredictionKey());
        }
        Frame holdoutPreds = null;
        if (((Model.Parameters)this._parms)._keep_cross_validation_predictions || this.nclasses() == 2 || ((Model.Parameters)this._parms)._distribution == DistributionFamily.huber) {
            Key cvhp = Key.make("cv_holdout_prediction_" + mainModel._key.toString());
            if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
                ((Model.Output)mainModel._output)._cross_validation_holdout_predictions_frame_id = cvhp;
            }
            holdoutPreds = ModelBuilder.combineHoldoutPredictions(predKeys, cvhp);
        }
        if (((Model.Parameters)this._parms)._keep_cross_validation_fold_assignment) {
            ((Model.Output)mainModel._output)._cross_validation_fold_assignment_frame_id = Key.make("cv_fold_assignment_" + this._result.toString());
            Frame xvalidation_fold_assignment_frame = ((Model.Output)mainModel._output)._cross_validation_fold_assignment_frame_id.get();
            if (xvalidation_fold_assignment_frame != null) {
                Scope.untrack(xvalidation_fold_assignment_frame.keysList());
            }
        }
        if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
            for (Key k : predKeys) {
                Frame fr = (Frame)DKV.getGet(k);
                if (fr == null) continue;
                Scope.untrack(fr.keysList());
            }
        } else {
            int count = Model.deleteAll(predKeys);
            Log.info(count + " CV predictions were removed");
        }
        ((Model.Output)mainModel._output)._cross_validation_metrics = mbs[0].makeModelMetrics(mainModel, ((Model.Parameters)this._parms).train(), null, holdoutPreds);
        if (holdoutPreds != null) {
            if (((Model.Parameters)this._parms)._keep_cross_validation_predictions) {
                Scope.untrack(holdoutPreds.keysList());
            } else {
                holdoutPreds.remove();
            }
        }
        ((Model.Output)mainModel._output)._cross_validation_metrics._description = N + "-fold cross-validation on training data (Metrics computed for combined holdout predictions)";
        Log.info(((Model.Output)mainModel._output)._cross_validation_metrics.toString());
        ((Model.Output)mainModel._output)._cross_validation_metrics_summary = this.makeCrossValidationSummaryTable(cvModKeys);
        if (!((Model.Parameters)this._parms)._keep_cross_validation_models) {
            int count = Model.deleteAll(cvModKeys);
            Log.info(count + " CV models were removed");
        }
        ((Model.Output)mainModel._output)._total_run_time = this._build_model_countdown.elapsedTime();
        DKV.put(mainModel);
    }

    private String getPredictionKey() {
        return "prediction_" + this._result.toString();
    }

    public void cv_computeAndSetOptimalParameters(ModelBuilder<M, P, O>[] cvModelBuilders) {
    }

    public boolean nFoldCV() {
        return ((Model.Parameters)this._parms)._fold_column != null || ((Model.Parameters)this._parms)._nfolds != 0;
    }

    public abstract ModelCategory[] can_build();

    public BuilderVisibility builderVisibility() {
        return BuilderVisibility.Stable;
    }

    public void clearInitState() {
        this.clearValidationErrors();
    }

    protected boolean logMe() {
        return true;
    }

    public abstract boolean isSupervised();

    public boolean hasOffsetCol() {
        return ((Model.Parameters)this._parms)._offset_column != null;
    }

    public boolean hasWeightCol() {
        return ((Model.Parameters)this._parms)._weights_column != null;
    }

    public boolean hasFoldCol() {
        return ((Model.Parameters)this._parms)._fold_column != null;
    }

    public int numSpecialCols() {
        return (this.hasOffsetCol() ? 1 : 0) + (this.hasWeightCol() ? 1 : 0) + (this.hasFoldCol() ? 1 : 0);
    }

    public String[] specialColNames() {
        String[] n = new String[this.numSpecialCols()];
        int i = 0;
        if (this.hasOffsetCol()) {
            n[i++] = ((Model.Parameters)this._parms)._offset_column;
        }
        if (this.hasWeightCol()) {
            n[i++] = ((Model.Parameters)this._parms)._weights_column;
        }
        if (this.hasFoldCol()) {
            n[i++] = ((Model.Parameters)this._parms)._fold_column;
        }
        return n;
    }

    public boolean havePojo() {
        return false;
    }

    public boolean haveMojo() {
        return false;
    }

    public int nclasses() {
        return this._nclass;
    }

    public final boolean isClassifier() {
        return this.nclasses() > 1;
    }

    public int separateFeatureVecs() {
        int res = 0;
        if (((Model.Parameters)this._parms)._weights_column != null) {
            Vec w = this._train.remove(((Model.Parameters)this._parms)._weights_column);
            if (w == null) {
                this.error("_weights_column", "Weights column '" + ((Model.Parameters)this._parms)._weights_column + "' not found in the training frame");
            } else {
                if (!w.isNumeric()) {
                    this.error("_weights_column", "Invalid weights column '" + ((Model.Parameters)this._parms)._weights_column + "', weights must be numeric");
                }
                this._weights = w;
                if (w.naCnt() > 0L) {
                    this.error("_weights_columns", "Weights cannot have missing values.");
                }
                if (w.min() < 0.0) {
                    this.error("_weights_columns", "Weights must be >= 0");
                }
                if (w.max() == 0.0) {
                    this.error("_weights_columns", "Max. weight must be > 0");
                }
                this._train.add(((Model.Parameters)this._parms)._weights_column, w);
                ++res;
            }
        } else {
            this._weights = null;
            assert (!this.hasWeightCol());
        }
        if (((Model.Parameters)this._parms)._offset_column != null) {
            Vec o = this._train.remove(((Model.Parameters)this._parms)._offset_column);
            if (o == null) {
                this.error("_offset_column", "Offset column '" + ((Model.Parameters)this._parms)._offset_column + "' not found in the training frame");
            } else {
                if (!o.isNumeric()) {
                    this.error("_offset_column", "Invalid offset column '" + ((Model.Parameters)this._parms)._offset_column + "', offset must be numeric");
                }
                this._offset = o;
                if (o.naCnt() > 0L) {
                    this.error("_offset_column", "Offset cannot have missing values.");
                }
                if (this._weights == this._offset) {
                    this.error("_offset_column", "Offset must be different from weights");
                }
                this._train.add(((Model.Parameters)this._parms)._offset_column, o);
                ++res;
            }
        } else {
            this._offset = null;
            assert (!this.hasOffsetCol());
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            Vec f = this._train.remove(((Model.Parameters)this._parms)._fold_column);
            if (f == null) {
                this.error("_fold_column", "Fold column '" + ((Model.Parameters)this._parms)._fold_column + "' not found in the training frame");
            } else {
                if (!f.isInt() && !f.isCategorical()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be integer or categorical");
                }
                if (f.min() < 0.0) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold must be non-negative");
                }
                if (f.isConst()) {
                    this.error("_fold_column", "Invalid fold column '" + ((Model.Parameters)this._parms)._fold_column + "', fold cannot be constant");
                }
                this._fold = f;
                if (f.naCnt() > 0L) {
                    this.error("_fold_column", "Fold cannot have missing values.");
                }
                if (this._fold == this._weights) {
                    this.error("_fold_column", "Fold must be different from weights");
                }
                if (this._fold == this._offset) {
                    this.error("_fold_column", "Fold must be different from offset");
                }
                this._train.add(((Model.Parameters)this._parms)._fold_column, f);
                ++res;
            }
        } else {
            this._fold = null;
            assert (!this.hasFoldCol());
        }
        if (this.isSupervised() && ((Model.Parameters)this._parms)._response_column != null) {
            this._response = this._train.remove(((Model.Parameters)this._parms)._response_column);
            if (this._response == null) {
                if (this.isSupervised()) {
                    this.error("_response_column", "Response column '" + ((Model.Parameters)this._parms)._response_column + "' not found in the training frame");
                }
            } else {
                if (this._response == this._offset) {
                    this.error("_response_column", "Response column must be different from offset_column");
                }
                if (this._response == this._weights) {
                    this.error("_response_column", "Response column must be different from weights_column");
                }
                if (this._response == this._fold) {
                    this.error("_response_column", "Response column must be different from fold_column");
                }
                this._train.add(((Model.Parameters)this._parms)._response_column, this._response);
                ++res;
            }
        } else {
            this._response = null;
        }
        return res;
    }

    protected boolean ignoreStringColumns() {
        return true;
    }

    protected boolean ignoreConstColumns() {
        return ((Model.Parameters)this._parms)._ignore_const_cols;
    }

    protected boolean ignoreUuidColumns() {
        return true;
    }

    protected void ignoreBadColumns(int npredictors, boolean expensive) {
        if (((Model.Parameters)this._parms)._ignore_const_cols) {
            new FilterCols(npredictors){

                @Override
                protected boolean filter(Vec v) {
                    boolean isBad = v.isBad();
                    boolean skipConst = ModelBuilder.this.ignoreConstColumns() && v.isConst();
                    boolean skipString = ModelBuilder.this.ignoreStringColumns() && v.isString();
                    boolean skipUuid = ModelBuilder.this.ignoreUuidColumns() && v.isUUID();
                    boolean skip = isBad || skipConst || skipString || skipUuid;
                    return skip;
                }
            }.doIt(this._train, "Dropping bad and constant columns: ", expensive);
        }
    }

    protected void checkResponseVariable() {
        if (!(this._response == null || this._response.isNumeric() || this._response.isCategorical() || this._response.isTime())) {
            this.error("_response_column", "Use numerical, categorical or time variable. Currently used " + this._response.get_type_str());
        }
    }

    protected void ignoreInvalidColumns(int npredictors, boolean expensive) {
    }

    protected void checkMemoryFootPrint() {
        if (Boolean.getBoolean("sys.ai.h2o.debug.noMemoryCheck")) {
            return;
        }
        this.checkMemoryFootPrint_impl();
    }

    protected void checkMemoryFootPrint_impl() {
    }

    protected boolean computePriorClassDistribution() {
        return this.isClassifier();
    }

    public int error_count() {
        assert (this._error_count >= 0) : "init() not run yet";
        return this._error_count;
    }

    public void hide(String field_name, String message) {
        this.message((byte)5, field_name, message);
    }

    public void info(String field_name, String message) {
        this.message((byte)3, field_name, message);
    }

    public void warn(String field_name, String message) {
        this.message((byte)2, field_name, message);
    }

    public void error(String field_name, String message) {
        this.message((byte)1, field_name, message);
        ++this._error_count;
    }

    public void clearValidationErrors() {
        this._messages = new ValidationMessage[0];
        this._error_count = 0;
    }

    public void message(byte log_level, String field_name, String message) {
        this._messages = Arrays.copyOf(this._messages, this._messages.length + 1);
        this._messages[this._messages.length - 1] = new ValidationMessage(log_level, field_name, message);
        if (log_level == 1) {
            ++this._error_count;
        }
    }

    public String validationErrors() {
        StringBuilder sb = new StringBuilder();
        for (ValidationMessage vm : this._messages) {
            if (vm._log_level != 1) continue;
            sb.append(vm.toString()).append("\n");
        }
        return sb.toString();
    }

    public void init(boolean expensive) {
        boolean names_differ;
        Frame va;
        Frame tr;
        if (expensive && this.logMe()) {
            Log.info("Building H2O " + this.getClass().getSimpleName() + " model with these parameters:");
            Log.info(new String(((Iced)this._parms).writeJSON(new AutoBuffer()).buf()));
        }
        this.clearInitState();
        assert (this._parms != null);
        if (((Model.Parameters)this._parms)._train == null) {
            if (expensive) {
                this.error("_train", "Missing training frame");
            }
            return;
        }
        Frame frame = tr = this._train != null ? this._train : ((Model.Parameters)this._parms).train();
        if (tr == null) {
            this.error("_train", "Missing training frame: " + ((Model.Parameters)this._parms)._train);
            return;
        }
        this.setTrain(new Frame(null, (String[])tr._names.clone(), (Vec[])tr.vecs().clone()));
        if (expensive) {
            ((Model.Parameters)this._parms).getOrMakeRealSeed();
        }
        if (((Model.Parameters)this._parms)._categorical_encoding.needsResponse() && !this.isSupervised()) {
            this.error("_categorical_encoding", "Categorical encoding scheme cannot be " + ((Model.Parameters)this._parms)._categorical_encoding.toString() + " - no response column available.");
        }
        if (((Model.Parameters)this._parms)._nfolds < 0 || ((Model.Parameters)this._parms)._nfolds == 1) {
            this.error("_nfolds", "nfolds must be either 0 or >1.");
        }
        if (((Model.Parameters)this._parms)._nfolds > 1 && (long)((Model.Parameters)this._parms)._nfolds > this.train().numRows()) {
            this.error("_nfolds", "nfolds cannot be larger than the number of rows (" + this.train().numRows() + ").");
        }
        if (((Model.Parameters)this._parms)._fold_column != null) {
            this.hide("_fold_assignment", "Fold assignment is ignored when a fold column is specified.");
            if (((Model.Parameters)this._parms)._nfolds > 1) {
                this.error("_nfolds", "nfolds cannot be specified at the same time as a fold column.");
            } else {
                this.hide("_nfolds", "nfolds is ignored when a fold column is specified.");
            }
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO) {
                this.error("_fold_assignment", "Fold assignment is not allowed in conjunction with a fold column.");
            }
        }
        if (((Model.Parameters)this._parms)._nfolds > 1) {
            this.hide("_fold_column", "Fold column is ignored when nfolds > 1.");
        }
        if (!this.nFoldCV()) {
            this.hide("_keep_cross_validation_models", "Only for cross-validation.");
            this.hide("_keep_cross_validation_predictions", "Only for cross-validation.");
            this.hide("_keep_cross_validation_fold_assignment", "Only for cross-validation.");
            this.hide("_fold_assignment", "Only for cross-validation.");
            if (((Model.Parameters)this._parms)._fold_assignment != Model.Parameters.FoldAssignmentScheme.AUTO) {
                this.error("_fold_assignment", "Fold assignment is only allowed for cross-validation.");
            }
        }
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.modified_huber) {
            this.error("_distribution", "Modified Huber distribution is not supported yet.");
        }
        if (((Model.Parameters)this._parms)._distribution != DistributionFamily.tweedie) {
            this.hide("_tweedie_power", "Only for Tweedie Distribution.");
        }
        if (((Model.Parameters)this._parms)._tweedie_power <= 1.0 || ((Model.Parameters)this._parms)._tweedie_power >= 2.0) {
            this.error("_tweedie_power", "Tweedie power must be between 1 and 2 (exclusive).");
        }
        if (((Model.Parameters)this._parms)._ignored_columns != null) {
            this._train.remove(((Model.Parameters)this._parms)._ignored_columns);
            if (expensive) {
                Log.info("Dropping ignored columns: " + Arrays.toString(((Model.Parameters)this._parms)._ignored_columns));
            }
        }
        if (((Model.Parameters)this._parms)._checkpoint != null) {
            String[] warnings;
            if (DKV.get(((Model.Parameters)this._parms)._checkpoint) == null) {
                this.error("_checkpoint", "Checkpoint has to point to existing model!");
            }
            Model checkpointedModel = ((Model.Parameters)this._parms)._checkpoint.get();
            for (String warning : warnings = checkpointedModel.adaptTestForTrain(this._train, expensive, false)) {
                this.warn("_checkpoint", warning);
            }
            this.separateFeatureVecs();
        } else {
            this.ignoreBadColumns(this.separateFeatureVecs(), expensive);
            this.ignoreInvalidColumns(this.separateFeatureVecs(), expensive);
            this.checkResponseVariable();
        }
        if (expensive && this.error_count() == 0 && ((Model.Parameters)this._parms)._auto_rebalance) {
            this.setTrain(this.rebalance(this._train, false, this._result + ".temporary.train"));
            this.separateFeatureVecs();
            this._valid = this.rebalance(this._valid, false, this._result + ".temporary.valid");
        }
        if (this._train.numCols() == 0) {
            this.error("_train", "There are no usable columns to generate model");
        }
        if (this.isSupervised()) {
            if (this._response != null) {
                if (((Model.Parameters)this._parms)._distribution != DistributionFamily.tweedie) {
                    this.hide("_tweedie_power", "Tweedie power is only used for Tweedie distribution.");
                }
                if (((Model.Parameters)this._parms)._distribution != DistributionFamily.quantile) {
                    this.hide("_quantile_alpha", "Quantile (alpha) is only used for Quantile regression.");
                }
                if (expensive) {
                    this.checkDistributions();
                }
                this._nclass = this.init_getNClass();
                if (((Model.Parameters)this._parms)._check_constant_response && this._response.isConst()) {
                    this.error("_response", "Response cannot be constant.");
                }
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Balance classes is false, hide max_after_balance_size");
            } else if (((Model.Parameters)this._parms)._weights_column != null && this._weights != null && !this._weights.isBinary()) {
                this.error("_balance_classes", "Balance classes and observation weights are not currently supported together.");
            }
            if ((double)((Model.Parameters)this._parms)._max_after_balance_size <= 0.0) {
                this.error("_max_after_balance_size", "Max size after balancing needs to be positive, suggest 1.0f");
            }
            if (this._train != null) {
                if (this._train.numCols() <= 1) {
                    this.error("_train", "Training data must have at least 2 features (incl. response).");
                }
                if (null == ((Model.Parameters)this._parms)._response_column) {
                    this.error("_response_column", "Response column parameter not set.");
                    return;
                }
                if (this._response != null && this.computePriorClassDistribution()) {
                    if (this.isClassifier() && this.isSupervised() && ((Model.Parameters)this._parms)._distribution != DistributionFamily.quasibinomial) {
                        MRUtils.ClassDist cdmt = this._weights != null ? (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response, this._weights) : (MRUtils.ClassDist)new MRUtils.ClassDist(this.nclasses()).doAll(this._response);
                        this._distribution = cdmt.dist();
                        this._priorClassDist = cdmt.rel_dist();
                    } else {
                        this._distribution = new double[]{(this._weights != null ? this._weights.mean() : 1.0) * (double)this.train().numRows()};
                        this._priorClassDist = new double[]{1.0};
                    }
                }
            }
            if (!this.isClassifier()) {
                this.hide("_balance_classes", "Balance classes is only applicable to classification problems.");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable to classification problems.");
                this.hide("_max_after_balance_size", "Max after balance size is only applicable to classification problems.");
                this.hide("_max_confusion_matrix_size", "Max confusion matrix size is only applicable to classification problems.");
            }
            if (this._nclass <= 2) {
                this.hide("_max_hit_ratio_k", "Max K-value for hit ratio is only applicable to multi-class classification problems.");
                this.hide("_max_confusion_matrix_size", "Only for multi-class classification problems.");
            }
            if (!((Model.Parameters)this._parms)._balance_classes) {
                this.hide("_max_after_balance_size", "Only used with balanced classes");
                this.hide("_class_sampling_factors", "Class sampling factors is only applicable if balancing classes.");
            }
        } else {
            this.hide("_response_column", "Ignored for unsupervised methods.");
            this.hide("_balance_classes", "Ignored for unsupervised methods.");
            this.hide("_class_sampling_factors", "Ignored for unsupervised methods.");
            this.hide("_max_after_balance_size", "Ignored for unsupervised methods.");
            this.hide("_max_confusion_matrix_size", "Ignored for unsupervised methods.");
            this._response = null;
            this._vresponse = null;
            this._nclass = 1;
        }
        if (this._nclass > 0x100000) {
            this.error("_nclass", "Too many levels in response column: " + this._nclass + ", maximum supported number of classes is " + 0x100000 + ".");
        }
        if ((va = ((Model.Parameters)this._parms).valid()) != null) {
            this._valid = this.adaptFrameToTrain(va, "Validation Frame", "_validation_frame", expensive);
            this._vresponse = this._valid.vec(((Model.Parameters)this._parms)._response_column);
        } else {
            this._valid = null;
            this._vresponse = null;
        }
        if (expensive) {
            Frame newtrain = this.encodeFrameCategoricals(this._train, !((Model.Parameters)this._parms)._is_cv_model);
            if (newtrain != this._train) {
                this._origNames = this._train.names();
                this._origDomains = this._train.domains();
                this.setTrain(newtrain);
                this.separateFeatureVecs();
            }
            if (this._valid != null) {
                this._valid = this.encodeFrameCategoricals(this._valid, !((Model.Parameters)this._parms)._is_cv_model);
                this._vresponse = this._valid.vec(((Model.Parameters)this._parms)._response_column);
            }
            boolean restructured = false;
            Vec[] vecs = this._train.vecs();
            for (int j = 0; j < vecs.length; ++j) {
                Vec v = vecs[j];
                if (v == this._response || v == this._fold || !v.isCategorical() || !this.shouldReorder(v)) continue;
                int len = v.domain().length;
                Log.info("Reordering categorical column " + this._train.name(j) + " (" + len + " levels) based on the mean (weighted) response per level.");
                VecUtils.MeanResponsePerLevelTask mrplt = (VecUtils.MeanResponsePerLevelTask)new VecUtils.MeanResponsePerLevelTask(len).doAll(v, ((Model.Parameters)this._parms)._weights_column != null ? this._train.vec(((Model.Parameters)this._parms)._weights_column) : v.makeCon(1.0), this._train.vec(((Model.Parameters)this._parms)._response_column));
                double[] meanWeightedResponse = mrplt.meanWeightedResponse;
                int[] idx = new int[len];
                for (int i = 0; i < len; ++i) {
                    idx[i] = i;
                }
                ArrayUtils.sort(idx, meanWeightedResponse);
                int[] invIdx = new int[len];
                for (int i = 0; i < len; ++i) {
                    invIdx[idx[i]] = i;
                }
                Vec vNew = ((VecUtils.ReorderTask)new VecUtils.ReorderTask(invIdx).doAll(1, (byte)3, new Frame(v))).outputFrame().anyVec();
                String[] newDomain = new String[len];
                for (int i = 0; i < len; ++i) {
                    newDomain[i] = v.domain()[idx[i]];
                }
                vNew.setDomain(newDomain);
                vecs[j] = vNew;
                restructured = true;
            }
            if (restructured) {
                this._train.restructure(this._train.names(), vecs);
            }
        }
        boolean names_may_differ = ((Model.Parameters)this._parms)._categorical_encoding == Model.Parameters.CategoricalEncodingScheme.Binary;
        boolean bl = names_differ = this._valid != null && !Arrays.equals(this._train._names, this._valid._names);
        assert (!expensive || names_may_differ || !names_differ);
        if (names_differ && names_may_differ) {
            for (String name : this._train._names) {
                assert (ArrayUtils.contains(this._valid._names, name)) : "Internal error during categorical encoding: training column " + name + " not in validation frame with columns " + Arrays.toString(this._valid._names);
            }
        }
        if (((Model.Parameters)this._parms)._stopping_tolerance < 0.0) {
            this.error("_stopping_tolerance", "Stopping tolerance must be >= 0.");
        }
        if (((Model.Parameters)this._parms)._stopping_tolerance >= 1.0) {
            this.error("_stopping_tolerance", "Stopping tolerance must be < 1.");
        }
        if (((Model.Parameters)this._parms)._stopping_rounds == 0) {
            if (((Model.Parameters)this._parms)._stopping_metric != ScoreKeeper.StoppingMetric.AUTO) {
                this.warn("_stopping_metric", "Stopping metric is ignored for _stopping_rounds=0.");
            }
            if (((Model.Parameters)this._parms)._stopping_tolerance != ((Model.Parameters)this._parms).defaultStoppingTolerance()) {
                this.warn("_stopping_tolerance", "Stopping tolerance is ignored for _stopping_rounds=0.");
            }
        } else if (((Model.Parameters)this._parms)._stopping_rounds < 0) {
            this.error("_stopping_rounds", "Stopping rounds must be >= 0.");
        } else if (this.isClassifier()) {
            if (((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.deviance && !this.getClass().getSimpleName().contains("GLM")) {
                this.error("_stopping_metric", "Stopping metric cannot be deviance for classification.");
            }
            if (this.nclasses() != 2 && (((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.AUC || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.AUCPR)) {
                this.error("_stopping_metric", "Stopping metric cannot be AUC or AUCPR for multinomial classification.");
            }
        } else if (((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.misclassification || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.AUC || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.logloss || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.AUCPR) {
            this.error("_stopping_metric", "Stopping metric cannot be " + ((Model.Parameters)this._parms)._stopping_metric.toString() + " for regression.");
        }
        if ((((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.custom || ((Model.Parameters)this._parms)._stopping_metric == ScoreKeeper.StoppingMetric.custom_increasing) && ((Model.Parameters)this._parms)._custom_metric_func == null) {
            this.error("_stopping_metric", "Custom metric function needs to be defined in order to use it for early stopping.");
        }
        if (((Model.Parameters)this._parms)._max_runtime_secs < 0.0) {
            this.error("_max_runtime_secs", "Max runtime (in seconds) must be greater than 0 (or 0 for unlimited).");
        }
        if (!(StringUtils.isNullOrEmpty(((Model.Parameters)this._parms)._export_checkpoints_dir) || ((Model.Parameters)this._parms)._is_cv_model || H2O.getPM().isWritableDirectory(((Model.Parameters)this._parms)._export_checkpoints_dir))) {
            this.error("_export_checkpoints_dir", "Checkpoints directory path must point to a writable path.");
        }
    }

    public Frame init_adaptFrameToTrain(Frame fr, String frDesc, String field, boolean expensive) {
        Frame adapted = this.adaptFrameToTrain(fr, frDesc, field, expensive);
        if (expensive) {
            adapted = this.encodeFrameCategoricals(adapted, true);
        }
        return adapted;
    }

    private Frame adaptFrameToTrain(Frame fr, String frDesc, String field, boolean expensive) {
        if (fr.numRows() == 0L) {
            this.error(field, frDesc + " must have > 0 rows.");
        }
        Frame adapted = new Frame(null, (String[])fr._names.clone(), (Vec[])fr.vecs().clone());
        try {
            String[] msgs = Model.adaptTestForTrain(adapted, null, null, this._train._names, this._train.domains(), this._parms, expensive, true, null, this.getToEigenVec(), this._toDelete, false);
            Vec response = adapted.vec(((Model.Parameters)this._parms)._response_column);
            if (response == null && ((Model.Parameters)this._parms)._response_column != null) {
                this.error(field, frDesc + " must have a response column '" + ((Model.Parameters)this._parms)._response_column + "'.");
            }
            if (expensive) {
                for (String s : msgs) {
                    Log.info(s);
                    this.warn(field, s);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            this.error(field, iae.getMessage());
        }
        return adapted;
    }

    private Frame encodeFrameCategoricals(Frame fr, boolean scopeTrack) {
        String[] skipCols = new String[]{((Model.Parameters)this._parms)._weights_column, ((Model.Parameters)this._parms)._offset_column, ((Model.Parameters)this._parms)._fold_column, ((Model.Parameters)this._parms)._response_column};
        Frame encoded = FrameUtils.categoricalEncoder(fr, skipCols, ((Model.Parameters)this._parms)._categorical_encoding, this.getToEigenVec(), ((Model.Parameters)this._parms)._max_categorical_levels);
        if (encoded != fr) {
            assert (encoded._key != null);
            if (scopeTrack) {
                Scope.track(encoded);
            } else {
                this._toDelete.put(encoded._key, Arrays.toString(Thread.currentThread().getStackTrace()));
            }
        }
        return encoded;
    }

    protected Frame rebalance(Frame original_fr, boolean local, String name) {
        if (original_fr == null) {
            return null;
        }
        int chunks = this.desiredChunks(original_fr, local);
        double rebalanceRatio = this.rebalanceRatio();
        int nonEmptyChunks = original_fr.anyVec().nonEmptyChunks();
        if ((double)nonEmptyChunks >= (double)chunks * rebalanceRatio) {
            if (chunks > 1) {
                Log.info(name.substring(name.length() - 5) + " dataset already contains " + nonEmptyChunks + " (non-empty)  chunks. No need to rebalance. [desiredChunks=" + chunks, ", rebalanceRatio=" + rebalanceRatio + "]");
            }
            return original_fr;
        }
        Log.info("Rebalancing " + name.substring(name.length() - 5) + " dataset into " + chunks + " chunks.");
        Key newKey = Key.makeUserHidden(name + ".chunks" + chunks);
        RebalanceDataSet rb = new RebalanceDataSet(original_fr, newKey, chunks);
        H2O.submitTask(rb).join();
        Frame rebalanced_fr = (Frame)DKV.get(newKey).get();
        Scope.track(rebalanced_fr);
        return rebalanced_fr;
    }

    private double rebalanceRatio() {
        String mode = H2O.getCloudSize() == 1 ? "single" : "multi";
        String ratioStr = this.getSysProperty("rebalance.ratio." + mode, "1.0");
        return Double.parseDouble(ratioStr);
    }

    protected int desiredChunks(Frame original_fr, boolean local) {
        if (H2O.getCloudSize() > 1 && Boolean.parseBoolean(this.getSysProperty("rebalance.enableMulti", "false"))) {
            return this.desiredChunkMulti(original_fr);
        }
        return this.desiredChunkSingle(original_fr);
    }

    private int desiredChunkSingle(Frame originalFr) {
        return Math.min((int)Math.ceil((double)originalFr.numRows() / 1000.0), H2O.NUMCPUS);
    }

    private int desiredChunkMulti(Frame fr) {
        for (byte by : fr.types()) {
            if (by == 3 || by == 4) continue;
            Log.warn("Training frame contains columns non-numeric/categorical columns. Using old rebalance logic.");
            return this.desiredChunkSingle(fr);
        }
        long itemCnt = 0L;
        for (Vec v : fr.vecs()) {
            itemCnt += v.length() - v.naCnt();
        }
        int itemSize = 4;
        long l = Math.max(itemCnt * 4L, fr.byteSize());
        int desiredChunkSize = FileVec.calcOptimalChunkSize(l, fr.numCols(), fr.numCols() * 4, H2O.NUMCPUS, H2O.getCloudSize(), false, true);
        int desiredChunks = (int)(l / (long)desiredChunkSize + (long)(l % (long)desiredChunkSize > 0L ? 1 : 0));
        Log.info("Calculated optimal number of chunks = " + desiredChunks);
        return desiredChunks;
    }

    protected String getSysProperty(String name, String def) {
        return System.getProperty("sys.ai.h2o." + name, def);
    }

    protected int init_getNClass() {
        int nclass;
        int n = nclass = this._response.isCategorical() ? this._response.cardinality() : 1;
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            nclass = 2;
        }
        return nclass;
    }

    public void checkDistributions() {
        if (((Model.Parameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            if (this._response.min() != 0.0) {
                this.error("_response", "For quasibinomial distribution, response must have a low value of 0 (negative class), but instead has min value of " + this._response.min() + ".");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.poisson) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Poisson distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.gamma) {
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Gamma distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.tweedie) {
            if (((Model.Parameters)this._parms)._tweedie_power >= 2.0 || ((Model.Parameters)this._parms)._tweedie_power <= 1.0) {
                this.error("_tweedie_power", "Tweedie power must be between 1 and 2.");
            }
            if (this._response.min() < 0.0) {
                this.error("_response", "Response must be non-negative for Tweedie distribution.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.quantile) {
            if (((Model.Parameters)this._parms)._quantile_alpha > 1.0 || ((Model.Parameters)this._parms)._quantile_alpha < 0.0) {
                this.error("_quantile_alpha", "Quantile alpha must be between 0 and 1.");
            }
        } else if (((Model.Parameters)this._parms)._distribution == DistributionFamily.huber && (((Model.Parameters)this._parms)._huber_alpha < 0.0 || ((Model.Parameters)this._parms)._huber_alpha > 1.0)) {
            this.error("_huber_alpha", "Huber alpha must be between 0 and 1.");
        }
    }

    private static Frame combineHoldoutPredictions(Key<Frame>[] predKeys, Key key) {
        int N = predKeys.length;
        Frame template = predKeys[0].get();
        Vec[] vecs = new Vec[N * template.numCols()];
        int idx = 0;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < predKeys[i].get().numCols(); ++j) {
                vecs[idx++] = predKeys[i].get().vec(j);
            }
        }
        return ((HoldoutPredictionCombiner)new HoldoutPredictionCombiner(N, template.numCols()).doAll(template.types(), new Frame(vecs))).outputFrame(key, template.names(), template.domains());
    }

    private TwoDimTable makeCrossValidationSummaryTable(Key[] cvmodels) {
        if (cvmodels == null || cvmodels.length == 0) {
            return null;
        }
        int N = cvmodels.length;
        int extra_length = 2;
        Object[] colTypes = new String[N + extra_length];
        Arrays.fill(colTypes, "string");
        Object[] colFormats = new String[N + extra_length];
        Arrays.fill(colFormats, "%s");
        String[] colNames = new String[N + extra_length];
        colNames[0] = "mean";
        colNames[1] = "sd";
        for (int i = 0; i < N; ++i) {
            colNames[i + extra_length] = "cv_" + (i + 1) + "_valid";
        }
        HashSet<String> excluded = new HashSet<String>();
        excluded.add("total_rows");
        excluded.add("makeSchema");
        excluded.add("hr");
        excluded.add("frame");
        excluded.add("model");
        excluded.add("remove");
        excluded.add("cm");
        excluded.add("auc_obj");
        ArrayList<Method> methods = new ArrayList<Method>();
        Model m = (Model)DKV.getGet(cvmodels[0]);
        ModelMetrics mm = ((Model.Output)m._output)._validation_metrics;
        if (mm != null) {
            for (Method meth : mm.getClass().getMethods()) {
                if (excluded.contains(meth.getName())) continue;
                try {
                    double c = (Double)meth.invoke((Object)mm, new Object[0]);
                    methods.add(meth);
                }
                catch (Exception c) {
                    // empty catch block
                }
            }
            ConfusionMatrix confusionMatrix = mm.cm();
            if (confusionMatrix != null) {
                for (Method meth : confusionMatrix.getClass().getMethods()) {
                    if (excluded.contains(meth.getName())) continue;
                    try {
                        double c = (Double)meth.invoke((Object)confusionMatrix, new Object[0]);
                        methods.add(meth);
                    }
                    catch (Exception c) {
                        // empty catch block
                    }
                }
            }
        }
        TreeSet<String> rowNames = new TreeSet<String>();
        for (Method method : methods) {
            rowNames.add(method.getName());
        }
        ArrayList<Method> meths = new ArrayList<Method>();
        block12: for (String n : rowNames) {
            for (Method m3 : methods) {
                if (!m3.getName().equals(n)) continue;
                meths.add(m3);
                continue block12;
            }
        }
        int n = rowNames.size();
        TwoDimTable table = new TwoDimTable("Cross-Validation Metrics Summary", null, rowNames.toArray(new String[0]), colNames, (String[])colTypes, (String[])colFormats, "");
        MathUtils.BasicStats stats = new MathUtils.BasicStats(n);
        double[][] vals = new double[N][n];
        int i = 0;
        for (Key km : cvmodels) {
            Model m4 = (Model)DKV.getGet(km);
            if (m4 == null) continue;
            ModelMetrics mm2 = ((Model.Output)m4._output)._validation_metrics;
            int j = 0;
            for (Method meth : meths) {
                if (excluded.contains(meth.getName())) continue;
                try {
                    double val;
                    vals[i][j] = val = ((Double)meth.invoke((Object)mm2, new Object[0])).doubleValue();
                    table.set(j++, i + extra_length, Float.valueOf((float)val));
                }
                catch (Throwable val) {
                    // empty catch block
                }
                if (mm2.cm() == null) continue;
                try {
                    vals[i][j] = val = ((Double)meth.invoke((Object)mm2.cm(), new Object[0])).doubleValue();
                    table.set(j++, i + extra_length, Float.valueOf((float)val));
                }
                catch (Throwable throwable) {}
            }
            ++i;
        }
        MathUtils.SimpleStats simpleStats = new MathUtils.SimpleStats(n);
        for (i = 0; i < N; ++i) {
            simpleStats.add(vals[i], 1.0);
        }
        for (i = 0; i < n; ++i) {
            table.set(i, 0, Float.valueOf((float)simpleStats.mean()[i]));
            table.set(i, 1, Float.valueOf((float)simpleStats.sigma()[i]));
        }
        Log.info(table);
        return table;
    }

    public String getName() {
        return this.getClass().getSimpleName().toLowerCase();
    }

    private static class HoldoutPredictionCombiner
    extends MRTask<HoldoutPredictionCombiner> {
        int _folds;
        int _cols;

        public HoldoutPredictionCombiner(int folds, int cols) {
            this._folds = folds;
            this._cols = cols;
        }

        @Override
        public void map(Chunk[] cs, NewChunk[] nc) {
            for (int c = 0; c < this._cols; ++c) {
                double[] vals = new double[cs[0].len()];
                for (int f = 0; f < this._folds; ++f) {
                    for (int row = 0; row < cs[0].len(); ++row) {
                        int n = row;
                        vals[n] = vals[n] + cs[f * this._cols + c].atd(row);
                    }
                }
                nc[c].setDoubles(vals);
            }
        }
    }

    public abstract class FilterCols {
        final int _specialVecs;

        public FilterCols(int n) {
            this._specialVecs = n;
        }

        protected abstract boolean filter(Vec var1);

        public void doIt(Frame f, String msg, boolean expensive) {
            ArrayList<Integer> rmcolsList = new ArrayList<Integer>();
            for (int i = 0; i < f.vecs().length - this._specialVecs; ++i) {
                if (!this.filter(f.vec(i))) continue;
                rmcolsList.add(i);
            }
            if (!rmcolsList.isEmpty()) {
                ModelBuilder.this._removedCols = new HashSet(rmcolsList.size());
                int[] rmcols = new int[rmcolsList.size()];
                for (int i = 0; i < rmcols.length; ++i) {
                    rmcols[i] = (Integer)rmcolsList.get(i);
                    ModelBuilder.this._removedCols.add(f._names[rmcols[i]]);
                }
                f.remove(rmcols);
                msg = msg + ModelBuilder.this._removedCols.toString();
                ModelBuilder.this.warn("_train", msg);
                if (expensive) {
                    Log.info(msg);
                }
            }
        }
    }

    public static final class ValidationMessage
    extends Iced {
        final byte _log_level;
        final String _field_name;
        final String _message;

        public ValidationMessage(byte log_level, String field_name, String message) {
            this._log_level = log_level;
            this._field_name = field_name;
            this._message = message;
            Log.log(log_level, field_name + ": " + message);
        }

        public int log_level() {
            return this._log_level;
        }

        public String toString() {
            return Log.LVLS[this._log_level] + " on field: " + this._field_name + ": " + this._message;
        }
    }

    public static enum BuilderVisibility {
        Experimental,
        Beta,
        Stable;


        public static BuilderVisibility valueOfIgnoreCase(String value) throws IllegalArgumentException {
            BuilderVisibility[] values = BuilderVisibility.values();
            for (int i = 0; i < values.length; ++i) {
                if (!values[i].name().equalsIgnoreCase(value)) continue;
                return values[i];
            }
            throw new IllegalArgumentException(String.format("Algorithm availability level of '%s' is not known. Available levels: %s", value, Arrays.toString((Object[])values)));
        }
    }

    private static class TrainModelNestedRunnable
    extends H2O.RemoteRunnable<TrainModelNestedRunnable> {
        private Job<?> _job;
        private Key<Model> _key;
        private Model.Parameters _parms;
        private Frame _fr;

        private TrainModelNestedRunnable(Job<?> job, Key<Model> key, Model.Parameters parms, Frame fr) {
            this._job = job;
            this._key = key;
            this._parms = parms;
            this._fr = fr;
        }

        @Override
        public void run() {
            Object mb = ModelBuilder.make(this._parms.algoName(), this._job, this._key);
            ((ModelBuilder)mb)._parms = this._parms;
            ((ModelBuilder)mb).trainModelNested(this._fr);
        }
    }

    private static class TrainModelRunnable
    extends H2O.RemoteRunnable<TrainModelRunnable> {
        private transient ModelBuilder _mb;
        private Job<Model> _job;
        private Key<Model> _key;
        private Model.Parameters _parms;

        private TrainModelRunnable(ModelBuilder mb) {
            this._mb = mb;
            this._job = this._mb._job;
            this._key = this._job._result;
            this._parms = this._mb._parms;
        }

        @Override
        public void setupOnRemote() {
            this._mb = ModelBuilder.make(this._parms.algoName(), this._job, this._key);
            this._mb._parms = this._parms;
            this._mb.init(false);
        }

        @Override
        public void run() {
            this._mb.trainModel();
        }
    }

    protected abstract class Driver
    extends H2O.H2OCountedCompleter<Driver> {
        protected Driver() {
        }

        protected Driver(H2O.H2OCountedCompleter completer) {
            super(completer);
        }

        @Override
        public void compute2() {
            try {
                Scope.enter();
                ((Model.Parameters)ModelBuilder.this._parms).read_lock_frames(ModelBuilder.this._job);
                this.computeImpl();
                ModelBuilder.this.saveModelCheckpointIfConfigured();
            }
            finally {
                ModelBuilder.this.setFinalState();
                ((Model.Parameters)ModelBuilder.this._parms).read_unlock_frames(ModelBuilder.this._job);
                if (!((Model.Parameters)ModelBuilder.this._parms)._is_cv_model) {
                    ModelBuilder.this.cleanUp();
                }
                Scope.exit(new Key[0]);
            }
            this.tryComplete();
            if (ModelBuilder.this._modelBuilderListener != null) {
                ModelBuilder.this._modelBuilderListener.onModelSuccess((Model)ModelBuilder.this._result.get());
            }
        }

        @Override
        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
            if (ModelBuilder.this._modelBuilderListener != null) {
                ModelBuilder.this._modelBuilderListener.onModelFailure(ex, (Model.Parameters)ModelBuilder.this._parms);
            }
            return true;
        }

        public abstract void computeImpl();
    }
}

