/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogExpUtil;
import hex.LogitFunction;
import hex.genmodel.utils.DistributionFamily;

class QuasibinomialDistribution
extends Distribution {
    public QuasibinomialDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogitFunction());
    }

    @Override
    public double deviance(double w, double y, double f) {
        if (y == f) {
            return 0.0;
        }
        if (f > 1.0) {
            return -2.0 * w * y * LogExpUtil.log(f);
        }
        if (f < 0.0) {
            return -2.0 * w * (1.0 - y) * LogExpUtil.log(1.0 - f);
        }
        return -2.0 * w * (y * LogExpUtil.log(f) + (1.0 - y) * LogExpUtil.log(1.0 - f));
    }

    @Override
    public double negHalfGradient(double y, double f) {
        double ff = this.linkInv(f);
        if (ff == y) {
            return 0.0;
        }
        if (ff > 1.0) {
            return y / ff;
        }
        if (ff < 0.0) {
            return (1.0 - y) / (ff - 1.0);
        }
        return y - ff;
    }

    @Override
    public double initFNum(double w, double o, double y) {
        return w * (y - o);
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        return w;
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        return w * z;
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        double ff = y - z;
        return w * ff * (1.0 - ff);
    }
}

