/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.grid.HyperSpaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import water.exceptions.H2OIllegalArgumentException;
import water.util.PojoUtils;

public interface HyperSpaceWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
    public C search_criteria();

    public boolean stopEarly(Model var1, ScoringInfo[] var2);

    public HyperSpaceIterator<MP> iterator();

    public String[] getHyperParamNames();

    public long getMaxHyperSpaceSize();

    public MP getParams();

    public ModelParametersBuilderFactory<MP> getParametersBuilderFactory();

    public static class RandomDiscreteValueWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria> {
        Random random;
        private List<int[]> _visitedPermutations = new ArrayList<int[]>();
        private Set<Integer> _visitedPermutationHashes = new LinkedHashSet<Integer>();

        public RandomDiscreteValueWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
            this.random = -1L == search_criteria.seed() ? new Random() : new Random(search_criteria.seed());
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return ScoreKeeper.stopEarly(ScoringInfo.scoreKeepers(sk), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_rounds(), ScoreKeeper.ProblemType.forSupervised(((Model.Output)model._output).isClassifier()), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_metric(), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_tolerance(), "grid's best", true);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private int[] _currentHyperparamIndices = null;
                private int _currentPermutationNum = 0;
                private long _start_time = System.currentTimeMillis();

                @Override
                public MP nextModelParameters(Model previousModel) {
                    this._currentHyperparamIndices = this.nextModelIndices();
                    if (this._currentHyperparamIndices != null) {
                        _visitedPermutations.add(this._currentHyperparamIndices);
                        _visitedPermutationHashes.add(this.integerHash(this._currentHyperparamIndices));
                        ++this._currentPermutationNum;
                        Object[] hypers = this.hypers(this._currentHyperparamIndices, new Object[_hyperParamNames.length]);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers);
                        if (_search_criteria != null && ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).strategy() == HyperSpaceSearchCriteria.Strategy.RandomDiscrete) {
                            double timeleft;
                            if (_set_model_seed_from_search_seed) {
                                params._seed = ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).seed() + model_number++;
                            }
                            if ((timeleft = this.time_remaining_secs()) > 0.0) {
                                params._max_runtime_secs = params._max_runtime_secs > 0.0 ? StrictMath.min(params._max_runtime_secs, timeleft) : timeleft;
                            }
                        }
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext(Model previousModel) {
                    return (long)_visitedPermutationHashes.size() < _maxHyperSpaceSize && (((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models() == 0 || this._currentPermutationNum < ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models());
                }

                @Override
                public void reset() {
                    this._start_time = System.currentTimeMillis();
                    this._currentPermutationNum = 0;
                    this._currentHyperparamIndices = null;
                    _visitedPermutations.clear();
                    _visitedPermutationHashes.clear();
                }

                @Override
                public double max_runtime_secs() {
                    return ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_runtime_secs();
                }

                @Override
                public int max_models() {
                    return ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models();
                }

                @Override
                public double time_remaining_secs() {
                    return ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_runtime_secs() - (double)(System.currentTimeMillis() - this._start_time) / 1000.0;
                }

                @Override
                public void modelFailed(Model failedModel) {
                    --this._currentPermutationNum;
                }

                @Override
                public Object[] getCurrentRawParameters() {
                    Object[] hyperValues = new Object[_hyperParamNames.length];
                    return this.hypers(this._currentHyperparamIndices, hyperValues);
                }
            };
        }

        private int[] nextModelIndices() {
            int[] hyperparamIndices = new int[this._hyperParamNames.length];
            do {
                for (int i = 0; i < this._hyperParamNames.length; ++i) {
                    hyperparamIndices[i] = this.random.nextInt(((Object[])this._hyperParams.get(this._hyperParamNames[i])).length);
                }
            } while (this._visitedPermutationHashes.contains(this.integerHash(hyperparamIndices)));
            return hyperparamIndices;
        }
    }

    public static class CartesianWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.CartesianSearchCriteria> {
        public CartesianWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.CartesianSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private int[] _currentHyperparamIndices = null;

                @Override
                public MP nextModelParameters(Model previousModel) {
                    int[] nArray = this._currentHyperparamIndices = this._currentHyperparamIndices != null ? this.nextModelIndices(this._currentHyperparamIndices) : new int[_hyperParamNames.length];
                    if (this._currentHyperparamIndices != null) {
                        Object[] hypers = this.hypers(this._currentHyperparamIndices, new Object[_hyperParamNames.length]);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers);
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext(Model previousModel) {
                    if (this._currentHyperparamIndices == null) {
                        return true;
                    }
                    int[] hyperparamIndices = this._currentHyperparamIndices;
                    for (int i = 0; i < hyperparamIndices.length; ++i) {
                        if (hyperparamIndices[i] + 1 >= ((Object[])_hyperParams.get(_hyperParamNames[i])).length) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void reset() {
                    this._currentHyperparamIndices = null;
                }

                @Override
                public double time_remaining_secs() {
                    return Double.MAX_VALUE;
                }

                @Override
                public double max_runtime_secs() {
                    return Double.MAX_VALUE;
                }

                @Override
                public int max_models() {
                    return _maxHyperSpaceSize > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)_maxHyperSpaceSize;
                }

                @Override
                public void modelFailed(Model failedModel) {
                }

                @Override
                public Object[] getCurrentRawParameters() {
                    Object[] hyperValues = new Object[_hyperParamNames.length];
                    return this.hypers(this._currentHyperparamIndices, hyperValues);
                }
            };
        }

        private int[] nextModelIndices(int[] hyperparamIndices) {
            int i;
            for (i = 0; i < hyperparamIndices.length && hyperparamIndices[i] + 1 >= ((Object[])this._hyperParams.get(this._hyperParamNames[i])).length; ++i) {
            }
            if (i == hyperparamIndices.length) {
                return null;
            }
            for (int j = 0; j < i; ++j) {
                hyperparamIndices[j] = 0;
            }
            int n = i;
            hyperparamIndices[n] = hyperparamIndices[n] + 1;
            return hyperparamIndices;
        }
    }

    public static abstract class BaseWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria>
    implements HyperSpaceWalker<MP, C> {
        protected final C _search_criteria;
        final transient ModelParametersBuilderFactory<MP> _paramsBuilderFactory;
        final MP _params;
        protected final Map<String, Object[]> _hyperParams;
        protected boolean _set_model_seed_from_search_seed = false;
        long model_number = 0L;
        protected final String[] _hyperParamNames;
        protected final long _maxHyperSpaceSize;

        @Override
        public C search_criteria() {
            return this._search_criteria;
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return false;
        }

        public BaseWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
            this._params = params;
            this._hyperParams = hyperParams;
            this._paramsBuilderFactory = paramsBuilderFactory;
            this._hyperParamNames = hyperParams.keySet().toArray(new String[0]);
            this._maxHyperSpaceSize = this.computeMaxSizeOfHyperSpace();
            this._search_criteria = search_criteria;
            Model.Parameters defaults = null;
            try {
                defaults = (Model.Parameters)params.getClass().newInstance();
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Failed to instantiate a new Model.Parameters object to get the default values.");
            }
            for (String key : hyperParams.keySet()) {
                Object[] values = hyperParams.get(key);
                if (0 == values.length) {
                    throw new H2OIllegalArgumentException("Grid search hyperparameter value list is empty for hyperparameter: " + key);
                }
                if ("seed".equals(key) || "_seed".equals(key)) continue;
                String prefix = key.startsWith("_") ? "" : "_";
                Object defaultVal = PojoUtils.getFieldValue(defaults, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
                Object actualVal = PojoUtils.getFieldValue(params, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
                if (defaultVal != null && actualVal != null) {
                    if (defaultVal.getClass().isArray() && !PojoUtils.arraysEquals(defaultVal, actualVal)) {
                        throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                    }
                    if (!defaultVal.getClass().isArray() && !defaultVal.equals(actualVal)) {
                        throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                    }
                }
                if (defaultVal != null || actualVal == null) continue;
                throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
            }
            if (search_criteria != null && ((HyperSpaceSearchCriteria)search_criteria).strategy() == HyperSpaceSearchCriteria.Strategy.RandomDiscrete) {
                Object defaultSeedVal = PojoUtils.getFieldValue(defaults, "_seed", PojoUtils.FieldNaming.CONSISTENT);
                Object actualSeedVal = PojoUtils.getFieldValue(params, "_seed", PojoUtils.FieldNaming.CONSISTENT);
                long gridSeed = ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)search_criteria).seed();
                if (defaultSeedVal != null && actualSeedVal != null && defaultSeedVal.equals(actualSeedVal) && !defaultSeedVal.equals(gridSeed)) {
                    this._set_model_seed_from_search_seed = true;
                }
            }
        }

        @Override
        public String[] getHyperParamNames() {
            return this._hyperParamNames;
        }

        @Override
        public long getMaxHyperSpaceSize() {
            return this._maxHyperSpaceSize;
        }

        @Override
        public MP getParams() {
            return this._params;
        }

        @Override
        public ModelParametersBuilderFactory<MP> getParametersBuilderFactory() {
            return this._paramsBuilderFactory;
        }

        protected MP getModelParams(MP params, Object[] hyperParams) {
            ModelParametersBuilderFactory.ModelParametersBuilder<MP> paramsBuilder = this._paramsBuilderFactory.get(params);
            for (int i = 0; i < this._hyperParamNames.length; ++i) {
                String paramName = this._hyperParamNames[i];
                Object paramValue = hyperParams[i];
                if (paramName.equals("valid")) {
                    paramName = "validation_frame";
                }
                paramsBuilder.set(paramName, paramValue);
            }
            return paramsBuilder.build();
        }

        protected long computeMaxSizeOfHyperSpace() {
            long work = 1L;
            for (Map.Entry<String, Object[]> p : this._hyperParams.entrySet()) {
                if (p.getValue() == null) continue;
                work *= (long)p.getValue().length;
            }
            return work;
        }

        protected Object[] hypers(int[] hidx, Object[] hypers) {
            for (int i = 0; i < hidx.length; ++i) {
                hypers[i] = this._hyperParams.get(this._hyperParamNames[i])[hidx[i]];
            }
            return hypers;
        }

        protected int integerHash(int[] ar) {
            Object[] hashMe = new Integer[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                hashMe[i] = ar[i] * this._hyperParams.get(this._hyperParamNames[i]).length;
            }
            return Arrays.deepHashCode(hashMe);
        }

        public static class WalkerFactory<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
            public static <MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> HyperSpaceWalker<MP, ? extends HyperSpaceSearchCriteria> create(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
                HyperSpaceSearchCriteria.Strategy strategy = search_criteria.strategy();
                if (strategy == HyperSpaceSearchCriteria.Strategy.Cartesian) {
                    return new CartesianWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.CartesianSearchCriteria)search_criteria);
                }
                if (strategy == HyperSpaceSearchCriteria.Strategy.RandomDiscrete) {
                    return new RandomDiscreteValueWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)search_criteria);
                }
                throw new H2OIllegalArgumentException("strategy", "GridSearch", (Object)strategy);
            }
        }
    }

    public static interface HyperSpaceIterator<MP extends Model.Parameters> {
        public MP nextModelParameters(Model var1);

        public boolean hasNext(Model var1);

        public void reset();

        public double max_runtime_secs();

        public int max_models();

        public double time_remaining_secs();

        public void modelFailed(Model var1);

        public Object[] getCurrentRawParameters();
    }
}

