/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.io.IOException;
import java.nio.channels.ByteChannel;
import java.sql.Timestamp;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import water.AutoBuffer;
import water.ExternalBackendRequestType;
import water.ExternalFrameConfirmationCheck;
import water.ExternalFrameConfirmationException;
import water.ExternalFrameUtils;

public final class ExternalFrameWriterClient {
    private final AutoBuffer ab = new AutoBuffer();
    private final ByteChannel channel;
    private byte[] expectedTypes;
    private int currentColIdx = 0;
    private int currentRowIdx = 0;
    private final int timeout;
    private int numRows;
    private int numCols;
    private final long blockSize;

    public ExternalFrameWriterClient(ByteChannel channel, int timeout, long blockSize) {
        this.channel = channel;
        this.timeout = timeout;
        this.blockSize = blockSize;
    }

    public static ExternalFrameWriterClient create(String ip, int port, short timestamp, int timeout, long blockSize) throws IOException {
        ByteChannel channel = ExternalFrameUtils.getConnection(ip, port, timestamp);
        return new ExternalFrameWriterClient(channel, timeout, blockSize);
    }

    public void initFrame(String keyName, String[] names) throws IOException, ExternalFrameConfirmationException {
        byte requestType = ExternalBackendRequestType.INIT_FRAME.getByte();
        this.ab.put1(42);
        this.ab.put1(requestType);
        this.ab.putStr(keyName);
        this.ab.putAStr(names);
        ExternalFrameUtils.writeToChannel(this.ab, this.channel);
        this.waitForRequestToFinish(this.timeout, requestType);
    }

    public void createChunk(String frameKey, byte[] expectedTypes, int chunkId, int totalNumRows, int[] maxVecSizes) throws IOException {
        this.ab.put1(42);
        this.ab.put1(ExternalBackendRequestType.WRITE_TO_CHUNK.getByte());
        this.ab.putStr(frameKey);
        this.expectedTypes = expectedTypes;
        this.numCols = expectedTypes.length;
        this.numRows = totalNumRows;
        this.ab.putA1(expectedTypes);
        this.ab.putA4(maxVecSizes);
        this.ab.putInt(totalNumRows);
        this.ab.putInt(chunkId);
        ExternalFrameUtils.writeToChannel(this.ab, this.channel);
    }

    public void finalizeFrame(String keyName, long[] rowsPerChunk, byte[] colTypes, String[][] domains) throws IOException, ExternalFrameConfirmationException {
        byte requestType = ExternalBackendRequestType.FINALIZE_FRAME.getByte();
        this.ab.put1(42);
        this.ab.put1(requestType);
        this.ab.putStr(keyName);
        this.ab.putA8(rowsPerChunk);
        this.ab.putA1(colTypes);
        this.ab.putAAStr(domains);
        ExternalFrameUtils.writeToChannel(this.ab, this.channel);
        this.waitForRequestToFinish(this.timeout, requestType);
    }

    public void close() throws IOException, ExternalFrameConfirmationException {
        try {
            ExternalFrameUtils.writeToChannel(this.ab, this.channel);
            this.waitForRequestToFinish(this.timeout, ExternalBackendRequestType.WRITE_TO_CHUNK.getByte());
        }
        finally {
            this.channel.close();
        }
    }

    public void sendBoolean(boolean data) throws IOException {
        ExternalFrameUtils.sendBoolean(this.ab, data);
        this.increaseAndSend();
    }

    public void sendByte(byte data) throws IOException {
        ExternalFrameUtils.sendByte(this.ab, data);
        this.increaseAndSend();
    }

    public void sendChar(char data) throws IOException {
        ExternalFrameUtils.sendChar(this.ab, data);
        this.increaseAndSend();
    }

    public void sendShort(short data) throws IOException {
        ExternalFrameUtils.sendShort(this.ab, data);
        this.increaseAndSend();
    }

    public void sendInt(int data) throws IOException {
        ExternalFrameUtils.sendInt(this.ab, data);
        this.increaseAndSend();
    }

    public void sendLong(long data) throws IOException {
        ExternalFrameUtils.sendLong(this.ab, data);
        this.increaseAndSend();
    }

    public void sendFloat(float data) throws IOException {
        ExternalFrameUtils.sendFloat(this.ab, data);
        this.increaseAndSend();
    }

    public void sendDouble(double data) throws IOException {
        ExternalFrameUtils.sendDouble(this.ab, data);
        this.increaseAndSend();
    }

    public void sendString(String data) throws IOException {
        ExternalFrameUtils.sendString(this.ab, data);
        this.increaseAndSend();
    }

    public void sendTimestamp(Timestamp timestamp) throws IOException {
        ExternalFrameUtils.sendTimestamp(this.ab, timestamp);
        this.increaseAndSend();
    }

    public void sendNA() throws IOException {
        ExternalFrameUtils.sendNA(this.ab, this.expectedTypes[this.currentColIdx]);
        this.increaseAndSend();
    }

    public void sendSparseVector(int[] indices, double[] values) throws IOException {
        ExternalFrameUtils.sendBoolean(this.ab, true);
        ExternalFrameUtils.sendIntArray(this.ab, indices);
        ExternalFrameUtils.sendDoubleArray(this.ab, values);
        this.increaseAndSend();
    }

    public void sendDenseVector(double[] values) throws IOException {
        ExternalFrameUtils.sendBoolean(this.ab, false);
        ExternalFrameUtils.sendDoubleArray(this.ab, values);
        this.increaseAndSend();
    }

    public int getNumberOfWrittenRows() {
        return this.currentRowIdx;
    }

    private void waitForRequestToFinish(int timeout, byte confirmation) throws ExternalFrameConfirmationException {
        AutoBuffer confirmAb = new AutoBuffer(this.channel);
        try {
            byte flag = ExternalFrameConfirmationCheck.getConfirmation(confirmAb, timeout);
            assert (flag == confirmation);
        }
        catch (TimeoutException ex) {
            throw new ExternalFrameConfirmationException("Timeout for confirmation exceeded!");
        }
        catch (InterruptedException e) {
            throw new ExternalFrameConfirmationException("Confirmation thread interrupted!");
        }
        catch (ExecutionException e) {
            throw new ExternalFrameConfirmationException("Confirmation failed!");
        }
    }

    private void increaseAndSend() throws IOException {
        ++this.currentColIdx;
        if (this.currentColIdx == this.numCols) {
            ++this.currentRowIdx;
            this.currentColIdx = 0;
        }
        if ((long)this.ab.position() > this.blockSize) {
            ExternalFrameUtils.writeToChannel(this.ab, this.channel);
        }
    }
}

