/*
 * Decompiled with CFR 0.152.
 */
package water;

import java.util.Arrays;
import water.H2O;
import water.H2ONode;
import water.ListenerService;
import water.UDPRebooted;
import water.init.JarHash;
import water.nbhm.NonBlockingHashMap;
import water.util.Log;

public abstract class Paxos {
    public static volatile boolean _commonKnowledge = false;
    public static volatile boolean _cloudLocked = false;
    public static final NonBlockingHashMap<H2ONode.H2Okey, H2ONode> PROPOSED = new NonBlockingHashMap();

    static synchronized int doHeartbeat(H2ONode h2o) {
        if (!H2O.ARGS.client && !h2o._heartbeat._client) {
            if (!h2o._heartbeat.check_jar_md5()) {
                System.out.println("Jar check fails; my hash=" + Arrays.toString(JarHash.JARHASH));
                System.out.println("Jar check fails; received hash=" + Arrays.toString(h2o._heartbeat._jar_md5));
                if (H2O.CLOUD.size() > 1) {
                    Log.warn("Killing " + h2o + " because of H2O version mismatch (md5 differs).");
                    UDPRebooted.T.mismatch.send(h2o);
                } else {
                    H2O.die("Attempting to join " + h2o + " with an H2O version mismatch (md5 differs).  (Is H2O already running?)  Exiting.");
                }
                return 0;
            }
        } else if (!h2o._heartbeat.check_jar_md5()) {
            ListenerService.getInstance().report("client_wrong_md5", new Object[]{h2o._heartbeat._jar_md5});
        }
        if (!H2O.ARGS.allow_clients && h2o.isClient()) {
            ListenerService.getInstance().report("clients_disabled", h2o);
            h2o.removeClient();
            return 0;
        }
        if (h2o._heartbeat._cloud_name_hash != H2O.SELF._heartbeat._cloud_name_hash) {
            ListenerService.getInstance().report("different_cloud", h2o);
            return 0;
        }
        if (H2O.isFlatfileEnabled() && !H2O.ARGS.client && h2o._heartbeat._client && !H2O.isNodeInFlatfile(h2o)) {
            H2O.addNodeToFlatfile(h2o);
        }
        if (!PROPOSED.contains(h2o) && !h2o._heartbeat._client) {
            if (_cloudLocked) {
                Log.warn("Killing " + h2o + " because the cloud is no longer accepting new H2O nodes.");
                UDPRebooted.T.locked.send(h2o);
                return 0;
            }
            if (_commonKnowledge) {
                _commonKnowledge = false;
                H2O.SELF._heartbeat._common_knowledge = false;
                Log.debug("Cloud voting in progress");
            }
            H2ONode res = PROPOSED.putIfAbsent(h2o._key, h2o);
            assert (res == null);
            H2O.SELF._heartbeat._cloud_hash += h2o.hashCode();
        } else if (_commonKnowledge) {
            return 0;
        }
        int chash = H2O.SELF._heartbeat._cloud_hash;
        assert (chash == Paxos.doHash()) : "mismatched hash4, HB=" + chash + " full=" + Paxos.doHash();
        assert (!_commonKnowledge);
        H2ONode[] h2os = PROPOSED.values().toArray(new H2ONode[PROPOSED.size()]);
        if (H2O.ARGS.client && h2os.length == 0) {
            return 0;
        }
        for (H2ONode h2o2 : h2os) {
            if (chash == h2o2._heartbeat._cloud_hash) continue;
            return Paxos.print("Heartbeat hashes differ, self=0x" + Integer.toHexString(chash) + " " + h2o2 + "=0x" + Integer.toHexString(h2o2._heartbeat._cloud_hash) + " ", PROPOSED);
        }
        H2O.CLOUD.set_next_Cloud(h2os, chash);
        boolean same_size = true;
        for (H2ONode h2o2 : h2os) {
            same_size &= h2o2._heartbeat._cloud_size == H2O.CLOUD.size();
        }
        if (!same_size) {
            return 0;
        }
        H2O.SELF._heartbeat._common_knowledge = true;
        for (H2ONode h2o2 : h2os) {
            if (h2o2._heartbeat._common_knowledge) continue;
            return Paxos.print("Missing common knowledge from all nodes!", PROPOSED);
        }
        _commonKnowledge = true;
        Paxos.class.notifyAll();
        Paxos.print("Announcing new Cloud Membership: ", H2O.CLOUD._memary);
        Log.info("Cloud of size ", H2O.CLOUD.size(), " formed ", H2O.CLOUD.toString());
        H2ONode.H2Okey leader = H2O.CLOUD.leader()._key;
        H2O.notifyAboutCloudSize(H2O.SELF_ADDRESS, H2O.API_PORT, leader.getAddress(), leader.getApiPort(), H2O.CLOUD.size());
        return 0;
    }

    private static int doHash() {
        int hash = 0;
        for (H2ONode h2o : PROPOSED.values()) {
            hash += h2o.hashCode();
        }
        assert (hash != 0 || H2O.ARGS.client);
        return hash;
    }

    public static void lockCloud(Object reason) {
        if (_cloudLocked) {
            return;
        }
        Paxos.lockCloud_impl(reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void lockCloud_impl(Object reason) {
        Log.info("Locking cloud to new members, because " + reason.toString());
        Class<Paxos> clazz = Paxos.class;
        synchronized (Paxos.class) {
            while (!_commonKnowledge) {
                try {
                    Paxos.class.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            _cloudLocked = true;
            if (H2O.isFlatfileEnabled()) {
                for (H2ONode n : H2O.getFlatfile()) {
                    if (n._heartbeat._client || PROPOSED.containsKey(n._key)) continue;
                    Log.warn("Flatfile entry ignored: Node " + n._key.getIpPortString() + " not active in this cloud. Removing it from the list.");
                    n.removeFromCloud();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static int print(String msg, NonBlockingHashMap<H2ONode.H2Okey, H2ONode> p) {
        return Paxos.print(msg, p.values().toArray(new H2ONode[p.size()]));
    }

    static int print(String msg, H2ONode[] h2os) {
        return Paxos.print(msg, h2os, "");
    }

    static int print(String msg, H2ONode[] h2os, String msg2) {
        Log.debug(msg, Arrays.toString(h2os), msg2);
        return 0;
    }
}

