/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.Collection;
import water.AbstractH2OExtension;
import water.ExtensionManager;
import water.Job;
import water.api.Handler;
import water.api.schemas3.ImportHiveTableV3;
import water.api.schemas3.JobV3;
import water.fvec.Frame;

public class ImportHiveTableHandler
extends Handler {
    private HiveTableImporter getImporter() {
        Collection<AbstractH2OExtension> extensions = ExtensionManager.getInstance().getCoreExtensions();
        for (AbstractH2OExtension e : extensions) {
            if (!(e instanceof HiveTableImporter)) continue;
            return (HiveTableImporter)((Object)e);
        }
        return null;
    }

    public JobV3 importHiveTable(int version, ImportHiveTableV3 request) throws Exception {
        HiveTableImporter importer = this.getImporter();
        if (importer != null) {
            try {
                Job<Frame> job = importer.loadHiveTable(request.database, request.table, request.partitions, request.allow_multi_format);
                return new JobV3(job);
            }
            catch (NoClassDefFoundError e) {
                throw new IllegalStateException("Hive Metastore client classes not available on classpath.", e);
            }
        }
        throw new IllegalStateException("HiveTableImporter extension not enabled.");
    }

    public static interface HiveTableImporter {
        public static final String DEFAULT_DATABASE = "default";

        public Job<Frame> loadHiveTable(String var1, String var2, String[][] var3, boolean var4) throws Exception;
    }
}

