/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import water.Key;
import water.Value;
import water.util.Log;

public abstract class Persist {
    public abstract void store(Value var1) throws IOException;

    public abstract byte[] load(Value var1) throws IOException;

    public abstract void delete(Value var1);

    public long getUsableSpace() {
        return -1L;
    }

    public long getTotalSpace() {
        return -1L;
    }

    public abstract Key uriToKey(URI var1) throws IOException;

    public abstract void cleanUp();

    public abstract List<String> calcTypeaheadMatches(String var1, int var2);

    public abstract void importFiles(String var1, String var2, ArrayList<String> var3, ArrayList<String> var4, ArrayList<String> var5, ArrayList<String> var6);

    static String getIceName(Value v) {
        return Persist.getIceName(v._key);
    }

    static String getIceName(Key k) {
        return Persist.getIceDirectory(k) + File.separator + Persist.key2Str(k);
    }

    static String getIceDirectory(Key key) {
        if (!key.isChunkKey()) {
            return "not_a_Chunk";
        }
        return Persist.key2Str(key.getVecKey());
    }

    protected static String key2Str(Key k) {
        Key x;
        String s = Persist.key2Str_impl(k);
        assert ((x = Persist.str2Key_impl(s)).equals(k)) : "bijection fail " + k + " <-> " + s + " <-> " + x;
        return s;
    }

    static Key str2Key(String s) {
        Key k = Persist.str2Key_impl(s);
        assert (Persist.key2Str_impl(k).equals(s)) : "bijection fail " + s + " <-> " + k;
        return k;
    }

    private static String key2Str_impl(Key k) {
        StringBuilder sb = new StringBuilder(k._kb.length / 2 + 4);
        int i = 0;
        if (k._kb[0] < 32) {
            int j;
            sb.append('%');
            for (j = k._kb.length - 1; j >= 0 && k._kb[j] >= 32 && k._kb[j] < 128; --j) {
            }
            while (i <= j) {
                int nib1;
                byte b = k._kb[i];
                int nib0 = (b >>> 4 & 0xF) + 48;
                if (nib0 > 57) {
                    nib0 += 7;
                }
                if ((nib1 = (b >>> 0 & 0xF) + 48) > 57) {
                    nib1 += 7;
                }
                sb.append((char)nib0).append((char)nib1);
                ++i;
            }
            sb.append('%');
        }
        return Persist.escapeBytes(k._kb, i, sb).toString();
    }

    private static StringBuilder escapeBytes(byte[] bytes, int i, StringBuilder sb) {
        while (i < bytes.length) {
            char b = (char)bytes[i];
            char c = '\u0000';
            switch (b) {
                case '%': {
                    c = '%';
                    break;
                }
                case '.': {
                    c = 'd';
                    break;
                }
                case '/': {
                    c = 's';
                    break;
                }
                case ':': {
                    c = 'c';
                    break;
                }
                case '\"': {
                    c = 'q';
                    break;
                }
                case '>': {
                    c = 'g';
                    break;
                }
                case '<': {
                    c = 'l';
                    break;
                }
                case '\\': {
                    c = 'b';
                    break;
                }
                case '\u0000': {
                    c = 'z';
                }
            }
            if (c != '\u0000') {
                sb.append('%').append(c);
            } else {
                sb.append(b);
            }
            ++i;
        }
        return sb;
    }

    private static Key str2Key_impl(String s) {
        String key = s;
        byte[] kb = new byte[(key.length() - 1) / 2];
        int i = 0;
        int j = 0;
        if (key.length() > 2 && key.charAt(0) == '%' && key.charAt(1) >= '0' && key.charAt(1) <= '9') {
            for (i = 1; i < key.length() && key.charAt(i) != '%'; i += 2) {
                char b1;
                char b0 = (char)(key.charAt(i) - 48);
                if (b0 > '\t') {
                    b0 = (char)(b0 - 7);
                }
                if ((b1 = (char)(key.charAt(i + 1) - 48)) > '\t') {
                    b1 = (char)(b1 - 7);
                }
                kb[j++] = (byte)(b0 << 4 | b1);
            }
            ++i;
        }
        while (i < key.length()) {
            int b = key.charAt(i);
            if (b == 37) {
                switch (key.charAt(++i)) {
                    case '%': {
                        b = 37;
                        break;
                    }
                    case 'c': {
                        b = 58;
                        break;
                    }
                    case 'd': {
                        b = 46;
                        break;
                    }
                    case 'g': {
                        b = 62;
                        break;
                    }
                    case 'l': {
                        b = 60;
                        break;
                    }
                    case 'q': {
                        b = 34;
                        break;
                    }
                    case 's': {
                        b = 47;
                        break;
                    }
                    case 'b': {
                        b = 92;
                        break;
                    }
                    case 'z': {
                        b = 0;
                        break;
                    }
                    default: {
                        Log.warn("Invalid format of filename " + s + " at index " + i);
                    }
                }
            }
            if (j >= kb.length) {
                kb = Arrays.copyOf(kb, Math.max(2, j * 2));
            }
            kb[j++] = b;
            ++i;
        }
        return Key.make(Arrays.copyOf(kb, j));
    }

    public String getHomeDirectory() {
        throw new RuntimeException("Not implemented");
    }

    public PersistEntry[] list(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean exists(String path) {
        throw new RuntimeException("Not implemented");
    }

    public String getParent(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean isDirectory(String path) {
        throw new RuntimeException("Not implemented");
    }

    public long length(String path) {
        throw new RuntimeException("Not implemented");
    }

    public InputStream open(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean mkdirs(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean rename(String fromPath, String toPath) {
        throw new RuntimeException("Not implemented");
    }

    public OutputStream create(String path, boolean overwrite) {
        throw new RuntimeException("Not implemented");
    }

    public boolean delete(String path) {
        throw new RuntimeException("Not implemented");
    }

    public boolean canHandle(String path) {
        throw new RuntimeException("Not implemented");
    }

    public static class PersistEntry {
        public final String _name;
        public final long _size;
        public final long _timestamp_millis;

        public PersistEntry(String name, long size, long timestamp) {
            this._name = name;
            this._size = size;
            this._timestamp_millis = timestamp;
        }
    }
}

