/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.grid.HyperSpaceSearchCriteria;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import water.exceptions.H2OIllegalArgumentException;
import water.util.PojoUtils;

public interface HyperSpaceWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
    public C search_criteria();

    public boolean stopEarly(Model var1, ScoringInfo[] var2);

    public HyperSpaceIterator<MP> iterator();

    public String[] getHyperParamNames();

    public long getMaxHyperSpaceSize();

    public MP getParams();

    public ModelParametersBuilderFactory<MP> getParametersBuilderFactory();

    public static class RandomDiscreteValueWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria> {
        private Random _random;
        private boolean _set_model_seed_from_search_seed;

        public RandomDiscreteValueWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
            long defaultSeed = this._defaultParams._seed;
            long actualSeed = this._params._seed;
            long gridSeed = search_criteria.seed();
            this._set_model_seed_from_search_seed = defaultSeed == actualSeed && defaultSeed != gridSeed;
            this._random = gridSeed == defaultSeed ? new Random() : new Random(gridSeed);
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return ScoreKeeper.stopEarly(ScoringInfo.scoreKeepers(sk), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_rounds(), ScoreKeeper.ProblemType.forSupervised(((Model.Output)model._output).isClassifier()), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_metric(), ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).stopping_tolerance(), "grid's best", true);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private final List<int[]> _visitedPermutations = new ArrayList<int[]>();
                private final Set<Integer> _visitedPermutationHashes = new LinkedHashSet<Integer>();
                private int[] _currentHyperparamIndices = null;
                private int _currentPermutationNum = 0;

                @Override
                public MP nextModelParameters(Model previousModel) {
                    this._currentHyperparamIndices = this.nextModelIndices();
                    if (this._currentHyperparamIndices != null) {
                        this._visitedPermutations.add(this._currentHyperparamIndices);
                        this._visitedPermutationHashes.add(this.integerHash(this._currentHyperparamIndices));
                        ++this._currentPermutationNum;
                        Object[] hypers = this.hypers(this._currentHyperparamIndices);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers);
                        if (_search_criteria != null && ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).strategy() == HyperSpaceSearchCriteria.Strategy.RandomDiscrete && _set_model_seed_from_search_seed) {
                            params._seed = ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)_search_criteria).seed() + model_number++;
                        }
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext(Model previousModel) {
                    return (long)this._visitedPermutationHashes.size() < _maxHyperSpaceSize && (((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models() == 0 || this._currentPermutationNum < ((HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)this.search_criteria()).max_models());
                }

                @Override
                public void onModelFailure(Model failedModel, Consumer<Object[]> withFailedModelHyperParams) {
                    --this._currentPermutationNum;
                    withFailedModelHyperParams.accept(this.hypers(this._currentHyperparamIndices));
                }

                private int[] nextModelIndices() {
                    int[] hyperparamIndices = new int[_hyperParamNames.length];
                    do {
                        for (int i = 0; i < _hyperParamNames.length; ++i) {
                            hyperparamIndices[i] = _random.nextInt(((Object[])_hyperParams.get(_hyperParamNames[i])).length);
                        }
                    } while (this._visitedPermutationHashes.contains(this.integerHash(hyperparamIndices)));
                    return hyperparamIndices;
                }
            };
        }
    }

    public static class CartesianWalker<MP extends Model.Parameters>
    extends BaseWalker<MP, HyperSpaceSearchCriteria.CartesianSearchCriteria> {
        public CartesianWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.CartesianSearchCriteria search_criteria) {
            super(params, hyperParams, paramsBuilderFactory, search_criteria);
        }

        @Override
        public HyperSpaceIterator<MP> iterator() {
            return new HyperSpaceIterator<MP>(){
                private int[] _currentHyperparamIndices = null;

                @Override
                public MP nextModelParameters(Model previousModel) {
                    int[] nArray = this._currentHyperparamIndices = this._currentHyperparamIndices != null ? this.nextModelIndices(this._currentHyperparamIndices) : new int[_hyperParamNames.length];
                    if (this._currentHyperparamIndices != null) {
                        Object[] hypers = this.hypers(this._currentHyperparamIndices);
                        Model.Parameters commonModelParams = (Model.Parameters)_params.clone();
                        Model.Parameters params = this.getModelParams(commonModelParams, hypers);
                        return params;
                    }
                    throw new NoSuchElementException("No more elements to explore in hyper-space!");
                }

                @Override
                public boolean hasNext(Model previousModel) {
                    if (this._currentHyperparamIndices == null) {
                        return true;
                    }
                    int[] hyperparamIndices = this._currentHyperparamIndices;
                    for (int i = 0; i < hyperparamIndices.length; ++i) {
                        if (hyperparamIndices[i] + 1 >= ((Object[])_hyperParams.get(_hyperParamNames[i])).length) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public void onModelFailure(Model failedModel, Consumer<Object[]> withFailedModelHyperParams) {
                    withFailedModelHyperParams.accept(this.hypers(this._currentHyperparamIndices));
                }

                private int[] nextModelIndices(int[] hyperparamIndices) {
                    int i;
                    for (i = 0; i < hyperparamIndices.length && hyperparamIndices[i] + 1 >= ((Object[])_hyperParams.get(_hyperParamNames[i])).length; ++i) {
                    }
                    if (i == hyperparamIndices.length) {
                        return null;
                    }
                    for (int j = 0; j < i; ++j) {
                        hyperparamIndices[j] = 0;
                    }
                    int n = i;
                    hyperparamIndices[n] = hyperparamIndices[n] + 1;
                    return hyperparamIndices;
                }
            };
        }
    }

    public static abstract class BaseWalker<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria>
    implements HyperSpaceWalker<MP, C> {
        protected final C _search_criteria;
        final transient ModelParametersBuilderFactory<MP> _paramsBuilderFactory;
        final MP _params;
        final MP _defaultParams;
        protected final Map<String, Object[]> _hyperParams;
        long model_number = 0L;
        protected final String[] _hyperParamNames;
        protected final long _maxHyperSpaceSize;

        @Override
        public C search_criteria() {
            return this._search_criteria;
        }

        @Override
        public boolean stopEarly(Model model, ScoringInfo[] sk) {
            return false;
        }

        public BaseWalker(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
            this._params = params;
            this._hyperParams = hyperParams;
            this._paramsBuilderFactory = paramsBuilderFactory;
            this._hyperParamNames = hyperParams.keySet().toArray(new String[0]);
            this._maxHyperSpaceSize = this.computeMaxSizeOfHyperSpace();
            this._search_criteria = search_criteria;
            try {
                this._defaultParams = (Model.Parameters)params.getClass().newInstance();
            }
            catch (Exception e) {
                throw new H2OIllegalArgumentException("Failed to instantiate a new Model.Parameters object to get the default values.");
            }
            this.validateParams();
        }

        @Override
        public String[] getHyperParamNames() {
            return this._hyperParamNames;
        }

        @Override
        public long getMaxHyperSpaceSize() {
            return this._maxHyperSpaceSize;
        }

        @Override
        public MP getParams() {
            return this._params;
        }

        @Override
        public ModelParametersBuilderFactory<MP> getParametersBuilderFactory() {
            return this._paramsBuilderFactory;
        }

        protected MP getModelParams(MP params, Object[] hyperParams) {
            ModelParametersBuilderFactory.ModelParametersBuilder<MP> paramsBuilder = this._paramsBuilderFactory.get(params);
            for (int i = 0; i < this._hyperParamNames.length; ++i) {
                String paramName = this._hyperParamNames[i];
                Object paramValue = hyperParams[i];
                if (paramName.equals("valid")) {
                    paramName = "validation_frame";
                }
                paramsBuilder.set(paramName, paramValue);
            }
            return paramsBuilder.build();
        }

        protected long computeMaxSizeOfHyperSpace() {
            long work = 1L;
            for (Map.Entry<String, Object[]> p : this._hyperParams.entrySet()) {
                if (p.getValue() == null) continue;
                work *= (long)p.getValue().length;
            }
            return work;
        }

        protected Object[] hypers(int[] hidx) {
            Object[] hypers = new Object[this._hyperParamNames.length];
            for (int i = 0; i < hidx.length; ++i) {
                hypers[i] = this._hyperParams.get(this._hyperParamNames[i])[hidx[i]];
            }
            return hypers;
        }

        protected int integerHash(int[] ar) {
            Object[] hashMe = new Integer[ar.length];
            for (int i = 0; i < ar.length; ++i) {
                hashMe[i] = ar[i] * this._hyperParams.get(this._hyperParamNames[i]).length;
            }
            return Arrays.deepHashCode(hashMe);
        }

        private void validateParams() {
            for (String key : this._hyperParams.keySet()) {
                Object[] values = this._hyperParams.get(key);
                if (0 == values.length) {
                    throw new H2OIllegalArgumentException("Grid search hyperparameter value list is empty for hyperparameter: " + key);
                }
                if ("seed".equals(key) || "_seed".equals(key)) continue;
                String prefix = key.startsWith("_") ? "" : "_";
                Object defaultVal = PojoUtils.getFieldValue(this._defaultParams, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
                Object actualVal = PojoUtils.getFieldValue(this._params, prefix + key, PojoUtils.FieldNaming.CONSISTENT);
                if (defaultVal != null && actualVal != null) {
                    if (defaultVal.getClass().isArray() && !PojoUtils.arraysEquals(defaultVal, actualVal)) {
                        throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                    }
                    if (!defaultVal.getClass().isArray() && !defaultVal.equals(actualVal)) {
                        throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
                    }
                }
                if (defaultVal != null || actualVal == null) continue;
                throw new H2OIllegalArgumentException("Grid search model parameter '" + key + "' is set in both the model parameters and in the hyperparameters map.  This is ambiguous; set it in one place or the other, not both.");
            }
        }

        public static class WalkerFactory<MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> {
            public static <MP extends Model.Parameters, C extends HyperSpaceSearchCriteria> HyperSpaceWalker<MP, ? extends HyperSpaceSearchCriteria> create(MP params, Map<String, Object[]> hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, C search_criteria) {
                HyperSpaceSearchCriteria.Strategy strategy = search_criteria.strategy();
                switch (strategy) {
                    case Cartesian: {
                        return new CartesianWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.CartesianSearchCriteria)search_criteria);
                    }
                    case RandomDiscrete: {
                        return new RandomDiscreteValueWalker<MP>(params, hyperParams, paramsBuilderFactory, (HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria)search_criteria);
                    }
                }
                throw new H2OIllegalArgumentException("strategy", "GridSearch", (Object)strategy);
            }
        }
    }

    public static interface HyperSpaceIterator<MP extends Model.Parameters> {
        public MP nextModelParameters(Model var1);

        public boolean hasNext(Model var1);

        public void onModelFailure(Model var1, Consumer<Object[]> var2);
    }
}

