/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.LinkFunction;
import hex.LogExpUtil;
import hex.genmodel.utils.LinkFunctionType;

class LogitFunction
extends LinkFunction {
    public LogitFunction() {
        this.linkFunctionType = LinkFunctionType.logit;
    }

    @Override
    public double link(double f) {
        return LogExpUtil.log(f / (1.0 - f));
    }

    @Override
    public double linkInv(double f) {
        return 1.0 / (1.0 + LogExpUtil.exp(-f));
    }

    @Override
    public String linkInvString(String f) {
        return "1./(1. + " + LogitFunction.expString("-(" + f + ")") + ")";
    }
}

