/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import hex.Model;
import hex.ModelParametersBuilderFactory;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.grid.HyperSpaceSearchCriteria;
import hex.grid.HyperSpaceWalker;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import water.Iced;

public class SequentialWalker<MP extends Model.Parameters>
implements HyperSpaceWalker<MP, HyperSpaceSearchCriteria.SequentialSearchCriteria> {
    private final MP _params;
    private final Object[][] _hyperParams;
    private final String[] _hyperParamNames;
    private final ModelParametersBuilderFactory _paramsBuilderFactory;
    private final HyperSpaceSearchCriteria.SequentialSearchCriteria _searchCriteria;

    public SequentialWalker(MP params, Object[][] hyperParams, ModelParametersBuilderFactory<MP> paramsBuilderFactory, HyperSpaceSearchCriteria.SequentialSearchCriteria searchCriteria) {
        assert (hyperParams.length > 1);
        assert (Stream.of(hyperParams[0]).allMatch(c -> c instanceof String)) : "first row of hyperParams must contains hyper-parameter names";
        this._params = params;
        this._hyperParamNames = new String[hyperParams[0].length];
        System.arraycopy(hyperParams[0], 0, this._hyperParamNames, 0, this._hyperParamNames.length);
        this._hyperParams = (Object[][])Arrays.copyOfRange(hyperParams, 1, hyperParams.length);
        this._paramsBuilderFactory = paramsBuilderFactory;
        this._searchCriteria = searchCriteria;
    }

    @Override
    public HyperSpaceSearchCriteria.SequentialSearchCriteria search_criteria() {
        return this._searchCriteria;
    }

    @Override
    public String[] getHyperParamNames() {
        return this._hyperParamNames;
    }

    @Override
    public String[] getAllHyperParamNamesInSubspaces() {
        return null;
    }

    @Override
    public long getMaxHyperSpaceSize() {
        return this._hyperParams.length;
    }

    @Override
    public MP getParams() {
        return this._params;
    }

    @Override
    public ModelParametersBuilderFactory<MP> getParametersBuilderFactory() {
        return this._paramsBuilderFactory;
    }

    @Override
    public boolean stopEarly(Model model, ScoringInfo[] sk) {
        HyperSpaceSearchCriteria.StoppingCriteria stoppingCriteria = this.search_criteria().stoppingCriteria();
        return ScoreKeeper.stopEarly(ScoringInfo.scoreKeepers(sk), stoppingCriteria.getStoppingRounds(), ScoreKeeper.ProblemType.forSupervised(((Model.Output)model._output).isClassifier()), stoppingCriteria.getStoppingMetric(), stoppingCriteria.getStoppingTolerance(), "grid's best", true);
    }

    private MP getModelParams(MP params, Object[] hyperParams) {
        ModelParametersBuilderFactory.ModelParametersBuilder<Model.Parameters> paramsBuilder = this._paramsBuilderFactory.get((Model.Parameters)((Iced)params).clone());
        for (int i = 0; i < this._hyperParamNames.length; ++i) {
            String paramName = this._hyperParamNames[i];
            Object paramValue = hyperParams[i];
            if (paramValue == null) continue;
            paramsBuilder.set(paramName, paramValue);
        }
        return (MP)paramsBuilder.build();
    }

    @Override
    public HyperSpaceWalker.HyperSpaceIterator<MP> iterator() {
        return new HyperSpaceWalker.HyperSpaceIterator<MP>(){
            private int _index = -1;

            @Override
            public MP nextModelParameters(Model previousModel) {
                return SequentialWalker.this.getModelParams(SequentialWalker.this._params, SequentialWalker.this._hyperParams[++this._index]);
            }

            @Override
            public boolean hasNext(Model previousModel) {
                return (long)(this._index + 1) < SequentialWalker.this.getMaxHyperSpaceSize();
            }

            @Override
            public void onModelFailure(Model failedModel, Consumer<Object[]> withFailedModelHyperParams) {
                withFailedModelHyperParams.accept(SequentialWalker.this._hyperParams[this._index]);
            }
        };
    }
}

