/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import hex.Model;
import hex.ModelBuilder;
import hex.schemas.ModelBuilderSchema;
import java.util.Properties;
import water.H2O;
import water.Job;
import water.Key;
import water.api.Handler;
import water.api.ModelBuilderHandlerUtils;
import water.api.Route;
import water.api.schemas3.ModelParametersSchemaV3;
import water.util.HttpResponseStatus;
import water.util.Log;
import water.util.PojoUtils;

public class ModelBuilderHandler<B extends ModelBuilder, S extends ModelBuilderSchema<B, S, P>, P extends ModelParametersSchemaV3>
extends Handler {
    public S handle(int version, Route route, Properties parms, String postBody) throws Exception {
        Key<Model> key;
        String handlerName = route._handler_method.getName();
        boolean doTrain = handlerName.equals("train");
        assert (doTrain || handlerName.equals("validate_parameters"));
        String model_id = parms.getProperty("model_id");
        String warningStr = null;
        if (model_id != null && model_id.contains("/")) {
            String tempName = model_id;
            model_id = model_id.replaceAll("/", "_");
            warningStr = "Bad model_id: slash (/) found and replaced with _.  Original model_id " + tempName + " is now " + model_id + ".";
            Log.warn("model_id", warningStr);
        }
        String algoURLName = ModelBuilderHandlerUtils.parseAlgoURLName(route);
        String algoName = ModelBuilder.algoName(algoURLName);
        Key key2 = doTrain ? (model_id == null ? ModelBuilder.defaultKey(algoName) : Key.make(model_id)) : (key = null);
        Job<Model> job = doTrain ? (warningStr != null ? new Job<Model>(key, ModelBuilder.javaName(algoURLName), algoName, warningStr) : new Job<Model>(key, ModelBuilder.javaName(algoURLName), algoName)) : null;
        Object builder = ModelBuilder.make(algoURLName, job, key);
        Object schema = ModelBuilderHandlerUtils.makeBuilderSchema(version, algoURLName, parms, builder);
        ((ModelBuilder)builder).init(false);
        ((ModelBuilderSchema)schema).fillFromImpl(builder);
        PojoUtils.copyProperties(((ModelBuilderSchema)schema).parameters, ((ModelBuilder)builder)._parms, PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES, null, new String[]{"error_count", "messages"});
        ((ModelBuilderSchema)schema).setHttpStatus(HttpResponseStatus.OK.getCode());
        if (doTrain) {
            ((ModelBuilderSchema)schema).job.fillFromImpl(((ModelBuilder)builder).trainModelOnH2ONode());
        }
        return schema;
    }

    public S train(int version, S schema) {
        throw H2O.fail();
    }

    public S validate_parameters(int version, S schema) {
        throw H2O.fail();
    }
}

