/*
 * Decompiled with CFR 0.152.
 */
package water.fvec;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.Scope;
import water.Value;
import water.api.FramesHandler;
import water.api.schemas3.KeyV3;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.NewChunk;
import water.fvec.RebalanceDataSet;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.rapids.Merge;
import water.util.ArrayUtils;
import water.util.CompressionFactory;
import water.util.FrameUtils;
import water.util.Log;
import water.util.PrettyPrint;
import water.util.StringUtils;
import water.util.TwoDimTable;

public class Frame
extends Lockable<Frame> {
    public String[] _names;
    private boolean _lastNameBig;
    private Key<Vec>[] _keys;
    private transient Vec[] _vecs;
    private transient Vec _col0;
    private long _naCnt = -1L;
    static final int MAX_EQ2_COLS = 100000;

    public static void deleteTempFrameAndItsNonSharedVecs(Frame tempFrame, Frame baseFrame) {
        Key<Vec>[] keys = tempFrame.keys();
        for (int i = 0; i < keys.length; ++i) {
            if (baseFrame.find(keys[i]) != -1) continue;
            Keyed.remove(keys[i]);
        }
        DKV.remove(tempFrame._key);
    }

    public static Frame[] fetchAll() {
        Key[] frameKeys = KeySnapshot.globalKeysOfClass(Frame.class);
        ArrayList<Frame> frames = new ArrayList<Frame>(frameKeys.length);
        for (Key key : frameKeys) {
            Frame frame = FramesHandler.getFromDKV("(none)", key);
            boolean skip = false;
            for (Vec vec : frame.vecs()) {
                if (vec != null && DKV.get(vec._key) != null) continue;
                Log.warn("Leaked frame: Frame " + frame._key + " points to one or more deleted vecs.");
                skip = true;
                break;
            }
            if (skip) continue;
            frames.add(frame);
        }
        return frames.toArray(new Frame[frames.size()]);
    }

    public boolean hasNAs() {
        for (Vec v : this.bulkRollups()) {
            if (v.naCnt() <= 0L) continue;
            return true;
        }
        return false;
    }

    public boolean hasInfs() {
        for (Vec v : this.bulkRollups()) {
            if (v.pinfs() <= 0L && v.ninfs() <= 0L) continue;
            return true;
        }
        return false;
    }

    public synchronized long naCount() {
        if (this._naCnt != -1L) {
            return this._naCnt;
        }
        this._naCnt = 0L;
        for (Vec v : this.vecs()) {
            this._naCnt += v.naCnt();
        }
        return this._naCnt;
    }

    public double naFraction() {
        return this.naCount() / ((long)this.numCols() * this.numRows());
    }

    public Frame(Vec ... vecs) {
        this((String[])null, vecs);
    }

    public Frame(String[] names, Vec[] vecs) {
        this(null, names, vecs);
    }

    public Frame(Key<Frame> key) {
        this(key, null, new Vec[0]);
    }

    public Frame(Key<Frame> key, Vec[] vecs, boolean noChecks) {
        super(key);
        assert (noChecks);
        this._vecs = vecs;
        String[] names = new String[vecs.length];
        this._keys = this.makeVecKeys(vecs.length);
        for (int i = 0; i < vecs.length; ++i) {
            names[i] = Frame.defaultColName(i);
            this._keys[i] = vecs[i]._key;
        }
        this.setNames(names);
    }

    public Frame(Key<Frame> key, String[] names, Vec[] vecs) {
        super(key);
        int i;
        for (Vec vec : vecs) {
            DKV.prefetch(vec._key);
        }
        for (i = 0; i < vecs.length; ++i) {
            assert (DKV.get(vecs[i]._key) != null) : " null vec: " + vecs[i]._key + "; " + (names != null ? "name: " + names[i] : "index: " + i);
        }
        if (names == null) {
            this.setNames(new String[vecs.length]);
            this._keys = this.makeVecKeys(vecs.length);
            this._vecs = vecs;
            for (i = 0; i < vecs.length; ++i) {
                this._names[i] = Frame.defaultColName(i);
            }
            for (i = 0; i < vecs.length; ++i) {
                this._keys[i] = vecs[i]._key;
            }
            for (i = 0; i < vecs.length; ++i) {
                this.checkCompatibility(this._names[i], vecs[i]);
            }
            this._lastNameBig = true;
        } else {
            this._names = new String[0];
            this._keys = this.makeVecKeys(0);
            this._vecs = new Vec[0];
            this.add(names, vecs);
        }
        assert (this._names.length == vecs.length);
    }

    void setNamesNoCheck(String[] columns) {
        this._names = columns;
    }

    public final void setNames(String[] columns) {
        if (this._vecs != null && columns.length != this._vecs.length) {
            throw new IllegalArgumentException("Number of column names=" + columns.length + " must be the number of vecs=" + this._vecs.length);
        }
        this._names = columns;
    }

    public Frame(Frame fr) {
        super(Key.make());
        this.setNames((String[])fr._names.clone());
        this._keys = (Key[])fr._keys.clone();
        this._vecs = (Vec[])fr.vecs().clone();
        this._lastNameBig = fr._lastNameBig;
    }

    public static String defaultColName(int col) {
        return "C" + (1 + col);
    }

    private Key<Vec>[] makeVecKeys(int size) {
        return new Key[size];
    }

    private int pint(String name) {
        try {
            return Integer.valueOf(name.substring(1));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String uniquify(String name) {
        int again;
        String last;
        String n = name;
        int lastName = 0;
        if (name.length() > 0 && name.charAt(0) == 'C') {
            lastName = this.pint(name);
        }
        if (this._lastNameBig && this._names.length > 0 && !(last = this._names[this._names.length - 1]).equals("") && last.charAt(0) == 'C' && lastName == this.pint(last) + 1) {
            return name;
        }
        int cnt = 0;
        int max = 0;
        do {
            again = cnt;
            for (String s : this._names) {
                if (lastName > 0 && s.charAt(0) == 'C') {
                    max = Math.max(max, this.pint(s));
                }
                if (!n.equals(s)) continue;
                n = name + cnt++;
            }
        } while (again != cnt);
        if (lastName == max + 1) {
            this._lastNameBig = true;
        }
        return n;
    }

    private void checkCompatibility(String name, Vec vec) {
        if (vec instanceof AppendableVec) {
            return;
        }
        Vec v0 = this.anyVec();
        if (v0 == null) {
            return;
        }
        if (!v0.isCompatibleWith(vec)) {
            if (!Vec.VectorGroup.sameGroup(v0, vec)) {
                Log.err("Unexpected incompatible vector group, " + v0.group() + " != " + vec.group());
            }
            if (!Arrays.equals(v0.espc(), vec.espc())) {
                Log.err("Unexpected incompatible espc, " + Arrays.toString(v0.espc()) + " != " + Arrays.toString(vec.espc()));
            }
            throw new IllegalArgumentException("Vec " + name + " is not compatible with the rest of the frame");
        }
    }

    public boolean isCompatible(Frame fr) {
        if (this.numRows() != fr.numRows()) {
            return false;
        }
        for (int i = 0; i < this.vecs().length; ++i) {
            if (this.vecs()[i].isCompatibleWith(fr.vecs()[i])) continue;
            return false;
        }
        return true;
    }

    public int numCols() {
        return this._keys == null ? 0 : this._keys.length;
    }

    public long numRows() {
        Vec v = this.anyVec();
        return v == null ? 0L : v.length();
    }

    public final Vec anyVec() {
        Vec c0 = this._col0;
        if (c0 != null) {
            return c0;
        }
        for (Vec v : this.vecs()) {
            if (!v.readable()) continue;
            this._col0 = v;
            return this._col0;
        }
        return null;
    }

    public String[] names() {
        return this._names;
    }

    public String name(int i) {
        return this._names[i];
    }

    public Key<Vec>[] keys() {
        return this._keys;
    }

    public Iterable<Key<Vec>> keysList() {
        return Arrays.asList(this._keys);
    }

    public final Vec[] vecs() {
        Vec[] vecArray;
        Vec[] tvecs = this._vecs;
        if (tvecs == null) {
            this._vecs = this.vecs_impl();
            vecArray = this._vecs;
        } else {
            vecArray = tvecs;
        }
        return vecArray;
    }

    public final Vec[] vecs(int[] idxs) {
        Vec[] all = this.vecs();
        Vec[] res = new Vec[idxs.length];
        for (int i = 0; i < idxs.length; ++i) {
            res[i] = all[idxs[i]];
        }
        return res;
    }

    public Vec[] vecs(String[] names) {
        Vec[] res = new Vec[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = this.vec(names[i]);
        }
        return res;
    }

    private Vec[] vecs_impl() {
        for (Key<Vec> key : this._keys) {
            DKV.prefetch(key);
        }
        Vec[] vecs = new Vec[this._keys.length];
        for (int i = 0; i < this._keys.length; ++i) {
            vecs[i] = this._keys[i].get();
        }
        return vecs;
    }

    public Vec lastVec() {
        this.vecs();
        return this._vecs[this._vecs.length - 1];
    }

    public String lastVecName() {
        return this._names[this._names.length - 1];
    }

    public final Vec[] reloadVecs() {
        this._vecs = null;
        return this.vecs();
    }

    public final Vec vec(int idx) {
        return this.vecs()[idx];
    }

    public Vec vec(String name) {
        int idx = this.find(name);
        return idx == -1 ? null : this.vecs()[idx];
    }

    public int find(String name) {
        if (name == null) {
            return -1;
        }
        assert (this._names != null);
        for (int i = 0; i < this._names.length; ++i) {
            if (!name.equals(this._names[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public int find(Vec vec) {
        Vec[] vecs = this.vecs();
        if (vec == null) {
            return -1;
        }
        for (int i = 0; i < vecs.length; ++i) {
            if (!vec.equals(vecs[i])) continue;
            return i;
        }
        return -1;
    }

    @Deprecated
    public int find(Key key) {
        for (int i = 0; i < this._keys.length; ++i) {
            if (!key.equals(this._keys[i])) continue;
            return i;
        }
        return -1;
    }

    public int[] find(String[] names) {
        if (names == null) {
            return null;
        }
        int[] res = new int[names.length];
        for (int i = 0; i < names.length; ++i) {
            res[i] = this.find(names[i]);
        }
        return res;
    }

    public void insertVec(int i, String name, Vec vec) {
        String[] names = new String[this._names.length + 1];
        Vec[] vecs = new Vec[this._vecs.length + 1];
        Key<Vec>[] keys = this.makeVecKeys(this._keys.length + 1);
        System.arraycopy(this._names, 0, names, 0, i);
        System.arraycopy(this._vecs, 0, vecs, 0, i);
        System.arraycopy(this._keys, 0, keys, 0, i);
        names[i] = name;
        vecs[i] = vec;
        keys[i] = vec._key;
        System.arraycopy(this._names, i, names, i + 1, this._names.length - i);
        System.arraycopy(this._vecs, i, vecs, i + 1, this._vecs.length - i);
        System.arraycopy(this._keys, i, keys, i + 1, this._keys.length - i);
        this._vecs = vecs;
        this.setNames(names);
        this._keys = keys;
    }

    public byte[] types() {
        Vec[] vecs = this.vecs();
        byte[] bs = new byte[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            bs[i] = vecs[i]._type;
        }
        return bs;
    }

    public String[] typesStr() {
        Vec[] vecs = this.vecs();
        String[] s = new String[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            s[i] = vecs[i].get_type_str();
        }
        return s;
    }

    public String[][] domains() {
        Vec[] vecs = this.vecs();
        String[][] ds = new String[vecs.length][];
        for (int i = 0; i < vecs.length; ++i) {
            ds[i] = vecs[i].domain();
        }
        return ds;
    }

    public int[] cardinality() {
        Vec[] vecs = this.vecs();
        int[] card = new int[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            card[i] = vecs[i].cardinality();
        }
        return card;
    }

    public Vec[] bulkRollups() {
        Vec[] vecs;
        Futures fs = new Futures();
        for (Vec v : vecs = this.vecs()) {
            v.startRollupStats(fs);
        }
        fs.blockForPending();
        return vecs;
    }

    public int[] modes() {
        Vec[] vecs = this.bulkRollups();
        int[] modes = new int[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            modes[i] = vecs[i].isCategorical() ? vecs[i].mode() : -1;
        }
        return modes;
    }

    public double[] means() {
        Vec[] vecs = this.bulkRollups();
        double[] means = new double[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            means[i] = vecs[i].mean();
        }
        return means;
    }

    public double[] mults() {
        Vec[] vecs = this.bulkRollups();
        double[] mults = new double[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            double sigma = vecs[i].sigma();
            mults[i] = Frame.standardize(sigma) ? 1.0 / sigma : 1.0;
        }
        return mults;
    }

    private static boolean standardize(double sigma) {
        return sigma > 1.0E-6;
    }

    public long byteSize() {
        try {
            Vec[] vecs = this.bulkRollups();
            long sum = 0L;
            for (Vec vec : vecs) {
                sum += vec.byteSize();
            }
            return sum;
        }
        catch (RuntimeException ex) {
            Log.debug("Failure to obtain byteSize() - missing chunks?");
            return -1L;
        }
    }

    @Override
    protected long checksum_impl() {
        Vec[] vecs = this.vecs();
        long _checksum = 0L;
        for (int i = 0; i < this._names.length; ++i) {
            long vec_checksum = vecs[i].checksum();
            _checksum ^= vec_checksum;
            long tmp = Integer.MAX_VALUE * (long)i;
            _checksum ^= tmp;
        }
        return _checksum *= (long)(47806 + Arrays.hashCode(this._names));
    }

    public void add(String[] names, Vec[] vecs) {
        this.bulkAdd(names, vecs);
    }

    public void add(String[] names, Vec[] vecs, int cols) {
        if (null == vecs || null == names) {
            return;
        }
        if (cols == names.length && cols == vecs.length) {
            this.bulkAdd(names, vecs);
        } else {
            for (int i = 0; i < cols; ++i) {
                this.add(names[i], vecs[i]);
            }
        }
    }

    private void bulkAdd(String[] names, Vec[] vecs) {
        String[] tmpnames = (String[])names.clone();
        int N = names.length;
        assert (names.length == vecs.length) : "names = " + Arrays.toString(names) + ", vecs len = " + vecs.length;
        for (int i = 0; i < N; ++i) {
            vecs[i] = vecs[i] != null ? this.makeCompatible(new Frame(vecs[i]))[0] : null;
            tmpnames[i] = this.uniquify(tmpnames[i]);
            this.checkCompatibility(tmpnames[i], vecs[i]);
        }
        int ncols = this._keys.length;
        String[] tmpnam = Arrays.copyOf(this._names, ncols + N);
        Key<Vec>[] tmpkeys = Arrays.copyOf(this._keys, ncols + N);
        Vec[] tmpvecs = Arrays.copyOf(this._vecs, ncols + N);
        for (int i = 0; i < N; ++i) {
            tmpnam[ncols + i] = tmpnames[i];
            tmpkeys[ncols + i] = vecs[i]._key;
            tmpvecs[ncols + i] = vecs[i];
        }
        this._keys = tmpkeys;
        this._vecs = tmpvecs;
        this.setNames(tmpnam);
    }

    public Vec add(String name, Vec vec) {
        vec = this.makeCompatible(new Frame(vec))[0];
        name = this.uniquify(name);
        this.checkCompatibility(name, vec);
        int ncols = this._keys.length;
        String[] names = Arrays.copyOf(this._names, ncols + 1);
        names[ncols] = name;
        Key<Vec>[] keys = Arrays.copyOf(this._keys, ncols + 1);
        keys[ncols] = vec._key;
        Vec[] vecs = Arrays.copyOf(this._vecs, ncols + 1);
        vecs[ncols] = vec;
        this._keys = keys;
        this._vecs = vecs;
        this.setNames(names);
        return vec;
    }

    public Frame add(Frame fr) {
        this.add(fr._names, (Vec[])fr.vecs().clone(), fr.numCols());
        return this;
    }

    public Frame prepend(String name, Vec vec) {
        if (this.find(name) != -1) {
            throw new IllegalArgumentException("Duplicate name '" + name + "' in Frame");
        }
        if (this._vecs.length != 0) {
            if (!this.anyVec().group().equals(vec.group()) && !Arrays.equals(this.anyVec().espc(), vec.espc())) {
                throw new IllegalArgumentException("Vector groups differs - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
            if (this.numRows() != vec.length()) {
                throw new IllegalArgumentException("Vector lengths differ - adding vec '" + name + "' into the frame " + Arrays.toString(this._names));
            }
        }
        int len = this._names != null ? this._names.length : 0;
        String[] _names2 = new String[len + 1];
        Vec[] _vecs2 = new Vec[len + 1];
        Key<Vec>[] _keys2 = this.makeVecKeys(len + 1);
        _names2[0] = name;
        _vecs2[0] = vec;
        _keys2[0] = vec._key;
        if (this._names != null) {
            System.arraycopy(this._names, 0, _names2, 1, len);
            System.arraycopy(this._vecs, 0, _vecs2, 1, len);
            System.arraycopy(this._keys, 0, _keys2, 1, len);
        }
        this._vecs = _vecs2;
        this._keys = _keys2;
        this.setNames(_names2);
        return this;
    }

    public void swap(int lo, int hi) {
        assert (0 <= lo && lo < this._keys.length);
        assert (0 <= hi && hi < this._keys.length);
        if (lo == hi) {
            return;
        }
        Vec[] vecs = this.vecs();
        Vec v = vecs[lo];
        vecs[lo] = vecs[hi];
        vecs[hi] = v;
        Key<Vec> k = this._keys[lo];
        this._keys[lo] = this._keys[hi];
        this._keys[hi] = k;
        String n = this._names[lo];
        this._names[lo] = this._names[hi];
        this._names[hi] = n;
    }

    public void reOrder(int[] newOrder) {
        int colIndex;
        assert (newOrder.length == this._keys.length);
        int numCols = this._keys.length;
        Vec[] tmpvecs = (Vec[])this.vecs().clone();
        Key[] tmpkeys = (Key[])this._keys.clone();
        String[] tmpnames = (String[])this._names.clone();
        for (colIndex = 0; colIndex < numCols; ++colIndex) {
            tmpvecs[colIndex] = this._vecs[newOrder[colIndex]];
            tmpkeys[colIndex] = this._keys[newOrder[colIndex]];
            tmpnames[colIndex] = this._names[newOrder[colIndex]];
        }
        for (colIndex = 0; colIndex < numCols; ++colIndex) {
            this._vecs[colIndex] = tmpvecs[colIndex];
            this._keys[colIndex] = tmpkeys[colIndex];
            this._names[colIndex] = tmpnames[colIndex];
        }
    }

    public void moveFirst(int[] cols) {
        int i;
        boolean[] colsMoved = new boolean[this._keys.length];
        Vec[] tmpvecs = (Vec[])this.vecs().clone();
        Key[] tmpkeys = (Key[])this._keys.clone();
        String[] tmpnames = (String[])this._names.clone();
        for (int i2 = 0; i2 < cols.length; ++i2) {
            int w = cols[i2];
            if (colsMoved[w]) {
                throw new IllegalArgumentException("Duplicates in column numbers passed in");
            }
            if (w < 0 || w >= this._keys.length) {
                throw new IllegalArgumentException("column number out of 0-based range");
            }
            colsMoved[w] = true;
            tmpvecs[i2] = this._vecs[w];
            tmpkeys[i2] = this._keys[w];
            tmpnames[i2] = this._names[w];
        }
        int w = cols.length;
        for (i = 0; i < this._keys.length; ++i) {
            if (colsMoved[i]) continue;
            tmpvecs[w] = this._vecs[i];
            tmpkeys[w] = this._keys[i];
            tmpnames[w] = this._names[i];
            ++w;
        }
        for (i = 0; i < this._keys.length; ++i) {
            this._vecs[i] = tmpvecs[i];
            this._keys[i] = tmpkeys[i];
            this._names[i] = tmpnames[i];
        }
    }

    public Frame subframe(String[] names) {
        Vec[] vecs = new Vec[names.length];
        this.vecs();
        HashMap<String, Integer> map = new HashMap<String, Integer>((int)((float)names.length / 0.75f + 1.0f));
        for (int i = 0; i < this._names.length; ++i) {
            map.put(this._names[i], i);
        }
        int missingCnt = 0;
        for (int i = 0; i < names.length; ++i) {
            if (map.containsKey(names[i])) {
                vecs[i] = this._vecs[(Integer)map.get(names[i])];
                continue;
            }
            ++missingCnt;
        }
        if (missingCnt > 0) {
            StringBuilder sb = new StringBuilder();
            int maxReported = missingCnt <= 5 ? missingCnt : 5;
            int reported = 0;
            for (int i = 0; i < names.length && reported < maxReported; ++i) {
                if (vecs[i] != null) continue;
                sb.append('\'').append(names[i]).append('\'');
                if (++reported >= maxReported) continue;
                sb.append(", ");
            }
            if (reported < missingCnt) {
                sb.append(" (and other ").append(missingCnt - reported).append(")");
            }
            throw new IllegalArgumentException("Frame `" + this._key + "` doesn't contain columns: " + sb.toString() + ".");
        }
        return new Frame(Key.make("subframe" + Key.make().toString()), names, vecs);
    }

    public Futures postWrite(Futures fs) {
        for (Vec v : this.vecs()) {
            v.postWrite(fs);
        }
        return fs;
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        int n;
        Vec[] vecs;
        Key[] keys = this._keys;
        if (keys.length == 0) {
            return fs;
        }
        Vec v = this._col0;
        if (v == null && (vecs = this._vecs) != null) {
            Vec vec;
            Vec[] vecArray = vecs;
            n = vecArray.length;
            for (int i = 0; i < n && (v = (vec = vecArray[i])) == null; ++i) {
            }
        }
        if (v == null) {
            Key<Vec> _key1;
            Key<Vec>[] keyArray = this._keys;
            int n2 = keyArray.length;
            for (n = 0; n < n2 && (v = (_key1 = keyArray[n]).get()) == null; ++n) {
            }
        }
        if (v == null) {
            return fs;
        }
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this._keys = this.makeVecKeys(0);
        Vec.bulk_remove(keys, v.nChunks());
        return fs;
    }

    public final Futures retain(Futures futures, Set<Key> retainedKeys) {
        int n;
        Iced[] vecs;
        Key<Vec>[] delCandidateKeys;
        if (this._key != null) {
            DKV.remove(this._key);
        }
        if ((delCandidateKeys = this._keys).length == 0) {
            return futures;
        }
        Iced v = this._col0;
        if (v == null && (vecs = this._vecs) != null) {
            Iced vec;
            Iced[] icedArray = vecs;
            n = icedArray.length;
            for (int i = 0; i < n && (v = (vec = icedArray[i])) == null; ++i) {
            }
        }
        if (v == null) {
            Iced _key1;
            vecs = this._keys;
            int n2 = vecs.length;
            for (n = 0; n < n2 && (v = (Vec)((Key)(_key1 = vecs[n])).get()) == null; ++n) {
            }
        }
        if (v == null) {
            return futures;
        }
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this._keys = this.makeVecKeys(0);
        ArrayList<Key<Vec>> deletedKeys = new ArrayList<Key<Vec>>();
        for (int i = 0; i < delCandidateKeys.length; ++i) {
            if (retainedKeys.contains(delCandidateKeys[i])) continue;
            deletedKeys.add(delCandidateKeys[i]);
        }
        Vec.bulk_remove(deletedKeys.toArray(new Key[0]), ((Vec)v).nChunks());
        return futures;
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        for (Key<Vec> k : this._keys) {
            ab.putKey(k);
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        for (Key<Vec> k : this._keys) {
            ab.getKey(k, fs);
        }
        return super.readAll_impl(ab, fs);
    }

    public Vec replace(int col, Vec nv) {
        Vec rv = this.vecs()[col];
        nv = new Frame(rv).makeCompatible(new Frame(nv))[0];
        DKV.put(nv);
        assert (DKV.get(nv._key) != null);
        assert (rv.isCompatibleWith(nv));
        this._vecs[col] = nv;
        this._keys[col] = nv._key;
        return rv;
    }

    public Frame subframe(int startIdx, int endIdx) {
        return new Frame(Arrays.copyOfRange(this._names, startIdx, endIdx), Arrays.copyOfRange(this.vecs(), startIdx, endIdx));
    }

    public Frame extractFrame(int startIdx, int endIdx) {
        Frame f = this.subframe(startIdx, endIdx);
        this.remove(startIdx, endIdx);
        return f;
    }

    public Vec remove(String name) {
        return this.remove(this.find(name));
    }

    public Frame remove(String[] names) {
        for (String name : names) {
            this.remove(this.find(name));
        }
        return this;
    }

    public Vec[] remove(int[] idxs) {
        for (int i : idxs) {
            if (i >= 0 && i < this.vecs().length) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        Arrays.sort(idxs);
        Vec[] res = new Vec[idxs.length];
        Vec[] rem = new Vec[this._vecs.length - idxs.length];
        String[] names = new String[rem.length];
        Key<Vec>[] keys = this.makeVecKeys(rem.length);
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i = 0; i < this._vecs.length; ++i) {
            if (j < idxs.length && i == idxs[j]) {
                ++j;
                res[k++] = this._vecs[i];
                continue;
            }
            rem[l] = this._vecs[i];
            names[l] = this._names[i];
            keys[l] = this._keys[i];
            ++l;
        }
        this._vecs = rem;
        this.setNames(names);
        this._keys = keys;
        assert (l == rem.length && k == idxs.length);
        return res;
    }

    public final Vec remove(int idx) {
        int len = this._names.length;
        if (idx < 0 || idx >= len) {
            return null;
        }
        Vec v = this.vecs()[idx];
        if (v == this._col0) {
            this._col0 = null;
        }
        this._vecs = ArrayUtils.remove(this._vecs, idx);
        this.setNames(ArrayUtils.remove(this._names, idx));
        this._keys = ArrayUtils.remove(this._keys, idx);
        return v;
    }

    public Vec[] removeAll() {
        return this.remove(0, this._names.length);
    }

    Vec[] remove(int startIdx, int endIdx) {
        int len = this._names.length;
        int nlen = len - (endIdx - startIdx);
        String[] names = new String[nlen];
        Key<Vec>[] keys = this.makeVecKeys(nlen);
        Vec[] vecs = new Vec[nlen];
        this.vecs();
        if (startIdx > 0) {
            System.arraycopy(this._names, 0, names, 0, startIdx);
            System.arraycopy(this._vecs, 0, vecs, 0, startIdx);
            System.arraycopy(this._keys, 0, keys, 0, startIdx);
        }
        nlen -= startIdx;
        if (endIdx < this._names.length + 1) {
            System.arraycopy(this._names, endIdx, names, startIdx, nlen);
            System.arraycopy(this._vecs, endIdx, vecs, startIdx, nlen);
            System.arraycopy(this._keys, endIdx, keys, startIdx, nlen);
        }
        Vec[] vecX = Arrays.copyOfRange(this._vecs, startIdx, endIdx);
        this._vecs = vecs;
        this._keys = keys;
        this.setNames(names);
        this._col0 = null;
        return vecX;
    }

    public void restructure(String[] names, Vec[] vecs) {
        this.restructure(names, vecs, vecs.length);
    }

    public void restructure(String[] names, Vec[] vecs, int cols) {
        this._keys = this.makeVecKeys(0);
        this._vecs = new Vec[0];
        this.setNames(new String[0]);
        this.add(names, vecs, cols);
    }

    void preparePartialFrame(String[] names) {
        if (this._keys != null) {
            this.delete_and_lock();
        } else {
            this.write_lock();
        }
        this._keys = new Vec.VectorGroup().addVecs(names.length);
        this.setNamesNoCheck(names);
    }

    static NewChunk[] createNewChunks(String name, byte[] type, int cidx) {
        boolean[] sparse = new boolean[type.length];
        Arrays.fill(sparse, false);
        return Frame.createNewChunks(name, type, cidx, sparse);
    }

    static NewChunk[] createNewChunks(String name, byte[] type, int cidx, boolean[] sparse) {
        Frame fr = (Frame)Key.make(name).get();
        NewChunk[] nchks = new NewChunk[fr.numCols()];
        for (int i = 0; i < nchks.length; ++i) {
            nchks[i] = new NewChunk((Vec)new AppendableVec(fr._keys[i], type[i]), cidx, sparse[i]);
        }
        return nchks;
    }

    static void closeNewChunks(NewChunk[] nchks) {
        Futures fs = new Futures();
        for (NewChunk nchk : nchks) {
            nchk.close(fs);
        }
        fs.blockForPending();
    }

    void finalizePartialFrame(long[] espc, String[][] domains, byte[] types) {
        int nchunk;
        for (nchunk = espc.length; nchunk > 1 && espc[nchunk - 1] == 0L; --nchunk) {
        }
        long[] espc2 = new long[nchunk + 1];
        long x = 0L;
        for (int i = 0; i < nchunk; ++i) {
            espc2[i] = x;
            x += espc[i];
        }
        espc2[nchunk] = x;
        Futures fs = new Futures();
        this._vecs = new Vec[this._keys.length];
        for (int i = 0; i < this._keys.length; ++i) {
            for (int j = nchunk; j < espc.length; ++j) {
                DKV.remove(Vec.chunkKey(this._keys[i], j), fs);
            }
            Vec vec = this._vecs[i] = new Vec(this._keys[i], Vec.ESPC.rowLayout(this._keys[i], espc2), domains != null ? domains[i] : null, types[i]);
            DKV.put(this._keys[i], vec, fs);
        }
        fs.blockForPending();
        this.unlock();
    }

    public Frame deepSlice(Object orows, Object ocols) {
        int[] c2;
        long[] cols;
        if (ocols == null) {
            cols = null;
        } else if (ocols instanceof long[]) {
            cols = (long[])ocols;
        } else if (ocols instanceof Frame) {
            Frame fr = (Frame)ocols;
            if (fr.numCols() != 1) {
                throw new IllegalArgumentException("Columns Frame must have only one column (actually has " + fr.numCols() + " columns)");
            }
            long n = fr.anyVec().length();
            if (n > 100000L) {
                throw new IllegalArgumentException("Too many requested columns (requested " + n + ", max " + 100000 + ")");
            }
            cols = new long[(int)n];
            Vec.Reader v = new Vec.Reader(fr.anyVec());
            for (long i = 0L; i < v.length(); ++i) {
                cols[(int)i] = v.at8(i);
            }
        } else {
            throw new IllegalArgumentException("Columns is specified by an unsupported data type (" + ocols.getClass().getName() + ")");
        }
        if (cols == null) {
            c2 = new int[this.numCols()];
            for (int i = 0; i < c2.length; ++i) {
                c2[i] = i;
            }
        } else if (cols.length == 0) {
            c2 = new int[]{};
        } else if (cols[0] >= 0L) {
            c2 = new int[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                c2[i] = (int)cols[i];
            }
        } else {
            c2 = new int[this.numCols() - cols.length];
            int j = 0;
            for (int i = 0; i < this.numCols(); ++i) {
                if (j >= cols.length || (long)i < -(1L + cols[j])) {
                    c2[i - j] = i;
                    continue;
                }
                ++j;
            }
        }
        for (int aC2 : c2) {
            if (aC2 < this.numCols()) continue;
            throw new IllegalArgumentException("Trying to select column " + (aC2 + 1) + " but only " + this.numCols() + " present.");
        }
        if (c2.length == 0) {
            throw new IllegalArgumentException("No columns selected (did you try to select column 0 instead of column 1?)");
        }
        if (this.numRows() == 0L) {
            return ((MRTask)new MRTask(){

                @Override
                public void map(Chunk[] chks, NewChunk[] nchks) {
                    for (NewChunk nc : nchks) {
                        nc.addNA();
                    }
                }
            }.doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows == null) {
            return ((DeepSlice)new DeepSlice(null, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
        }
        if (orows instanceof long[]) {
            long CHK_ROWS = 1000000L;
            final long[] rows = (long[])orows;
            if (this.numRows() == 0L) {
                return this;
            }
            if (rows.length == 0 || rows[0] < 0L) {
                if (rows.length != 0 && rows[0] < 0L) {
                    Vec v0 = this.anyVec().makeZero();
                    Vec v = ((MRTask)((MRTask)new MRTask(){

                        @Override
                        public void map(Chunk cs) {
                            for (long er : rows) {
                                if (er >= 0L || (er = Math.abs(er)) < cs._start || er > (long)cs._len + cs._start - 1L) continue;
                                cs.set((int)(er - cs._start), 1L);
                            }
                        }
                    }.doAll((Vec[])new Vec[]{v0})).getResult())._fr.anyVec();
                    Keyed.remove(v0._key);
                    Frame slicedFrame = ((DeepSlice)new DeepSlice(rows, c2, this.vecs()).doAll(this.types(c2), this.add("select_vec", v))).outputFrame(this.names(c2), this.domains(c2));
                    Keyed.remove(v._key);
                    Keyed.remove(this.remove((int)(this.numCols() - 1))._key);
                    return slicedFrame;
                }
                return ((DeepSlice)new DeepSlice(rows.length == 0 ? null : rows, c2, this.vecs()).doAll(this.types(c2), this)).outputFrame(this.names(c2), this.domains(c2));
            }
            Futures fs = new Futures();
            AppendableVec av = new AppendableVec(Vec.newKey(), 3);
            int r = 0;
            int c = 0;
            while (r < rows.length) {
                NewChunk nc = new NewChunk(av, c);
                long end = Math.min((long)r + 1000000L, (long)rows.length);
                while ((long)r < end) {
                    nc.addNum(rows[r]);
                    ++r;
                }
                nc.close(c++, fs);
            }
            Vec c0 = av.layout_and_close(fs);
            fs.blockForPending();
            Frame ff = new Frame(new String[]{"rownames"}, new Vec[]{c0});
            Frame fr2 = ((Slice)new Slice(c2, this).doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
            Keyed.remove(c0._key);
            Keyed.remove(av._key);
            ff.delete();
            return fr2;
        }
        Frame frows = (Frame)orows;
        Vec[] vecs = new Vec[c2.length];
        String[] names = new String[c2.length];
        for (int i = 0; i < c2.length; ++i) {
            vecs[i] = this._vecs[c2[i]];
            names[i] = this._names[c2[i]];
        }
        Frame ff = new Frame(names, vecs);
        ff.add("predicate", frows.anyVec());
        return ((DeepSelect)new DeepSelect().doAll(this.types(c2), ff)).outputFrame(this.names(c2), this.domains(c2));
    }

    public String toString() {
        return "Frame key: " + this._key + "\n" + "   cols: " + this.numCols() + "\n   rows: " + this.numRows() + "\n chunks: " + (this.anyVec() == null ? "N/A" : Integer.valueOf(this.anyVec().nChunks())) + "\n   size: " + this.byteSize() + "\n";
    }

    public String toString(long off, int len) {
        return this.toTwoDimTable(off, len).toString();
    }

    public String toString(long off, int len, boolean rollups) {
        return this.toTwoDimTable(off, len, rollups).toString();
    }

    public TwoDimTable toTwoDimTable() {
        return this.toTwoDimTable(0L, 10);
    }

    public TwoDimTable toTwoDimTable(long off, int len) {
        return this.toTwoDimTable(off, len, true);
    }

    public TwoDimTable toTwoDimTable(long off, int len, boolean rollups) {
        if (off > this.numRows()) {
            off = this.numRows();
        }
        if (off + (long)len > this.numRows()) {
            len = (int)(this.numRows() - off);
        }
        String[] rowHeaders = new String[len];
        int H = 0;
        if (rollups) {
            H = 5;
            rowHeaders = new String[len + H];
            rowHeaders[0] = "min";
            rowHeaders[1] = "mean";
            rowHeaders[2] = "stddev";
            rowHeaders[3] = "max";
            rowHeaders[4] = "missing";
            for (int i = 0; i < len; ++i) {
                rowHeaders[i + H] = "" + (off + (long)i);
            }
        }
        int ncols = this.numCols();
        Vec[] vecs = this.vecs();
        String[] coltypes = new String[ncols];
        String[][] strCells = new String[len + H][ncols];
        double[][] dblCells = new double[len + H][ncols];
        BufferedString tmpStr = new BufferedString();
        block9: for (int i = 0; i < ncols; ++i) {
            if (DKV.get(this._keys[i]) == null) {
                int j;
                coltypes[i] = "string";
                for (j = 0; j < len + H; ++j) {
                    dblCells[j][i] = 9.9E-324;
                }
                for (j = 0; j < len; ++j) {
                    strCells[j + H][i] = "NO_VEC";
                }
                continue;
            }
            Vec vec = vecs[i];
            if (rollups) {
                dblCells[0][i] = vec.min();
                dblCells[1][i] = vec.mean();
                dblCells[2][i] = vec.sigma();
                dblCells[3][i] = vec.max();
                dblCells[4][i] = vec.naCnt();
            }
            switch (vec.get_type()) {
                case 0: {
                    coltypes[i] = "string";
                    for (int j = 0; j < len; ++j) {
                        strCells[j + H][i] = null;
                        dblCells[j + H][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 2: {
                    coltypes[i] = "string";
                    for (int j = 0; j < len; ++j) {
                        strCells[j + H][i] = vec.isNA(off + (long)j) ? "" : vec.atStr(tmpStr, off + (long)j).toString();
                        dblCells[j + H][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 4: {
                    coltypes[i] = "string";
                    for (int j = 0; j < len; ++j) {
                        strCells[j + H][i] = vec.isNA(off + (long)j) ? "" : vec.factor(vec.at8(off + (long)j));
                        dblCells[j + H][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 5: {
                    int j;
                    coltypes[i] = "string";
                    DateTimeFormatter fmt = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
                    for (j = 0; j < len; ++j) {
                        strCells[j + H][i] = vec.isNA(off + (long)j) ? "" : fmt.print(vec.at8(off + (long)j));
                        dblCells[j + H][i] = 9.9E-324;
                    }
                    continue block9;
                }
                case 3: {
                    int j;
                    coltypes[i] = vec.isInt() ? "long" : "double";
                    for (j = 0; j < len; ++j) {
                        dblCells[j + H][i] = vec.isNA(off + (long)j) ? 9.9E-324 : vec.at(off + (long)j);
                        strCells[j + H][i] = null;
                    }
                    continue block9;
                }
                case 1: {
                    throw H2O.unimpl();
                }
                default: {
                    System.err.println("bad vector type during debug print: " + vec.get_type());
                    throw H2O.fail();
                }
            }
        }
        return new TwoDimTable("Frame " + this._key, this.numRows() + " rows and " + this.numCols() + " cols", rowHeaders, (String[])this._names.clone(), coltypes, null, "", strCells, dblCells);
    }

    public Frame deepCopy(String keyName) {
        final Vec[] vecs = (Vec[])this.vecs().clone();
        Key<Vec>[] ks = this.anyVec().group().addVecs(vecs.length);
        Futures fs = new Futures();
        for (int i = 0; i < vecs.length; ++i) {
            vecs[i] = new Vec(ks[i], this.anyVec()._rowLayout, vecs[i].domain(), this.vecs()[i]._type);
            DKV.put(vecs[i], fs);
        }
        new MRTask(){

            @Override
            public void map(Chunk[] cs) {
                int cidx = cs[0].cidx();
                for (int i = 0; i < cs.length; ++i) {
                    DKV.put(vecs[i].chunkKey(cidx), cs[i].deepCopy(), this._fs);
                }
            }
        }.doAll(this);
        fs.blockForPending();
        return new Frame(keyName == null ? null : Key.make(keyName), this.names(), vecs);
    }

    private String[][] domains(int[] cols) {
        Vec[] vecs = this.vecs();
        String[][] res = new String[cols.length][];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = vecs[cols[i]].domain();
        }
        return res;
    }

    private String[] names(int[] cols) {
        if (this._names == null) {
            return null;
        }
        String[] res = new String[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = this._names[cols[i]];
        }
        return res;
    }

    private byte[] types(int[] cols) {
        Vec[] vecs = this.vecs();
        byte[] res = new byte[cols.length];
        for (int i = 0; i < cols.length; ++i) {
            res[i] = vecs[cols[i]]._type;
        }
        return res;
    }

    public Vec[] makeCompatible(Frame f) {
        return this.makeCompatible(f, false);
    }

    public Vec[] makeCompatible(Frame f, boolean force) {
        if (this.anyVec() == null) {
            return f.vecs();
        }
        Vec v1 = this.anyVec();
        Vec v2 = f.anyVec();
        if (v1 != null && v2 != null && v1.length() != v2.length()) {
            throw new IllegalArgumentException("Can not make vectors of different length compatible!");
        }
        if (v1 == null || v2 == null || !force && v1.isCompatibleWith(v2)) {
            return f.vecs();
        }
        Key k = Key.make();
        H2O.submitTask(new RebalanceDataSet(this, f, k)).join();
        Frame f2 = (Frame)k.get();
        DKV.remove(k);
        for (Vec v : f2.vecs()) {
            Scope.track(v);
        }
        return f2.vecs();
    }

    public static Job export(Frame fr, String path, String frameName, boolean overwrite, int nParts) {
        return Frame.export(fr, path, frameName, overwrite, nParts, null, new CSVStreamParams());
    }

    public static Job export(Frame fr, String path, String frameName, boolean overwrite, int nParts, String compression, CSVStreamParams csvParms) {
        boolean forceSingle;
        boolean bl = forceSingle = nParts == 1;
        if (forceSingle) {
            boolean fileExists = H2O.getPM().exists(path);
            if (overwrite && fileExists) {
                Log.warn("File " + path + " exists, but will be overwritten!");
            } else if (!overwrite && fileExists) {
                throw new H2OIllegalArgumentException(path, "exportFrame", "File " + path + " already exists!");
            }
        } else if (!H2O.getPM().isEmptyDirectoryAllNodes(path)) {
            throw new H2OIllegalArgumentException(path, "exportFrame", "Cannot use path " + path + " to store part files! The target needs to be either an existing empty directory or not exist yet.");
        }
        CompressionFactory compressionFactory = compression != null ? CompressionFactory.make(compression) : null;
        Job job = new Job(fr._key, "water.fvec.Frame", "Export dataset");
        FrameUtils.ExportTaskDriver t = new FrameUtils.ExportTaskDriver(fr, path, frameName, overwrite, job, nParts, compressionFactory, csvParms);
        return job.start(t, fr.anyVec().nChunks());
    }

    public InputStream toCSV(CSVStreamParams parms) {
        return new CSVStream(this, parms);
    }

    @Override
    public Class<KeyV3.FrameKeyV3> makeSchema() {
        return KeyV3.FrameKeyV3.class;
    }

    public Frame sort(int[] cols) {
        return Merge.sort(this, cols);
    }

    public Frame sort(int[] cols, int[] ascending) {
        return Merge.sort(this, cols, ascending);
    }

    public FrameVecRegistry frameVecRegistry() {
        return new FrameVecRegistry();
    }

    public Frame toCategoricalCol(int columIdx) {
        this.write_lock();
        this.replace(columIdx, this.vec(columIdx).toCategoricalVec()).remove();
        this.update();
        this.unlock();
        return this;
    }

    public Frame toCategoricalCol(String column) {
        return this.toCategoricalCol(this.find(column));
    }

    public class FrameVecRegistry {
        private LinkedHashMap<String, Vec> vecMap;

        private FrameVecRegistry() {
            this.vecMap = new LinkedHashMap(Frame.this._vecs.length);
            for (int i = 0; i < Frame.this._vecs.length; ++i) {
                this.vecMap.put(Frame.this._names[i], Frame.this._vecs[i]);
            }
        }

        public Vec findByColName(String colName) {
            return this.vecMap.get(colName);
        }
    }

    public static class CSVStream
    extends InputStream {
        private static final Pattern DOUBLE_QUOTE_PATTERN = Pattern.compile("\"");
        private static final Set<Character> SPECIAL_CHARS = Collections.unmodifiableSet(new HashSet<Character>(Arrays.asList(Character.valueOf('\\'), Character.valueOf('|'), Character.valueOf('('), Character.valueOf(')'))));
        private final CSVStreamParams _parms;
        private final Pattern escapingPattern;
        private final String escapeReplacement;
        byte[] _line;
        int _position;
        int _chkRow;
        Chunk[] _curChks;
        int _lastChkIdx;
        public volatile int _curChkIdx;
        private final transient String[][] _escapedCategoricalVecDomains;

        public CSVStream(Frame fr, CSVStreamParams parms) {
            this(CSVStream.firstChunks(fr), parms._headers ? fr.names() : null, fr.anyVec().nChunks(), parms);
        }

        public CSVStream(Chunk[] chks, String[] names, int nChunks, CSVStreamParams parms) {
            if (chks == null) {
                nChunks = 0;
            }
            this._lastChkIdx = chks != null ? chks[0].cidx() + nChunks - 1 : -1;
            this._parms = Objects.requireNonNull(parms);
            if (this._parms._escapeCharacter != '\"') {
                String escapeCharacterEscaped = (SPECIAL_CHARS.contains(Character.valueOf(this._parms._escapeCharacter)) ? "\\" : "") + this._parms._escapeCharacter;
                this.escapingPattern = Pattern.compile("(\"|" + escapeCharacterEscaped + ")");
                this.escapeReplacement = escapeCharacterEscaped + "$1";
            } else {
                this.escapingPattern = DOUBLE_QUOTE_PATTERN;
                this.escapeReplacement = "\"\"";
            }
            StringBuilder sb = new StringBuilder();
            if (names != null) {
                sb.append('\"').append(names[0]).append('\"');
                for (int i = 1; i < names.length; ++i) {
                    sb.append(this._parms._separator).append('\"').append(names[i]).append('\"');
                }
                sb.append('\n');
            }
            this._line = StringUtils.bytesOf(sb);
            this._chkRow = -1;
            this._curChks = chks;
            this._escapedCategoricalVecDomains = this.escapeCategoricalVecDomains(this._curChks);
        }

        private static Chunk[] firstChunks(Frame fr) {
            Vec anyvec = fr.anyVec();
            if (anyvec == null || anyvec.nChunks() == 0 || anyvec.length() == 0L) {
                return null;
            }
            Chunk[] chks = new Chunk[fr.vecs().length];
            for (int i = 0; i < fr.vecs().length; ++i) {
                chks[i] = fr.vec(i).chunkForRow(0L);
            }
            return chks;
        }

        private String[][] escapeCategoricalVecDomains(Chunk[] chunks) {
            if (chunks == null) {
                return null;
            }
            String[][] localEscapedCategoricalVecDomains = new String[chunks.length][];
            for (int i = 0; i < chunks.length; ++i) {
                Vec vec = chunks[i].vec();
                if (!vec.isCategorical()) continue;
                String[] originalDomain = vec.domain();
                String[] escapedDomain = new String[originalDomain.length];
                boolean escapingRequired = false;
                for (int level = 0; level < originalDomain.length; ++level) {
                    escapedDomain[level] = this.escapeQuotesForCsv(originalDomain[level]);
                    escapingRequired = escapingRequired || !escapedDomain[level].equals(originalDomain[level]);
                }
                localEscapedCategoricalVecDomains[i] = escapingRequired ? escapedDomain : originalDomain;
            }
            return localEscapedCategoricalVecDomains;
        }

        public int getCurrentRowSize() {
            int av = this.available();
            assert (av > 0);
            return this._line.length;
        }

        byte[] getBytesForRow() {
            StringBuilder sb = new StringBuilder();
            BufferedString tmpStr = new BufferedString();
            for (int i = 0; i < this._curChks.length; ++i) {
                Vec v = this._curChks[i]._vec;
                if (i > 0) {
                    sb.append(this._parms._separator);
                }
                if (this._curChks[i].isNA(this._chkRow)) continue;
                if (v.isCategorical()) {
                    String escapedString = this._escapedCategoricalVecDomains[i][(int)this._curChks[i].at8(this._chkRow)];
                    sb.append('\"').append(escapedString).append('\"');
                    continue;
                }
                if (v.isUUID()) {
                    sb.append(PrettyPrint.UUID(this._curChks[i].at16l(this._chkRow), this._curChks[i].at16h(this._chkRow)));
                    continue;
                }
                if (v.isInt()) {
                    sb.append(this._curChks[i].at8(this._chkRow));
                    continue;
                }
                if (v.isString()) {
                    String escapedString = this.escapeQuotesForCsv(this._curChks[i].atStr(tmpStr, this._chkRow).toString());
                    sb.append('\"').append(escapedString).append('\"');
                    continue;
                }
                double d = this._curChks[i].atd(this._chkRow);
                String s = this._parms._hexString ? Double.toHexString(d) : Double.toString(d);
                sb.append(s);
            }
            sb.append('\n');
            return StringUtils.bytesOf(sb);
        }

        private String escapeQuotesForCsv(String unescapedString) {
            if (!this._parms._escapeQuotes) {
                return unescapedString;
            }
            return this.escapingPattern.matcher(unescapedString).replaceAll(this.escapeReplacement);
        }

        @Override
        public int available() {
            if (this._position != this._line.length) {
                return this._line.length - this._position;
            }
            if (this._curChks == null) {
                return -1;
            }
            ++this._chkRow;
            Chunk anyChunk = this._curChks[0];
            if (anyChunk._start + (long)this._chkRow == anyChunk._vec.length()) {
                return -1;
            }
            if (this._chkRow == anyChunk.len()) {
                this._curChkIdx = anyChunk._vec.elem2ChunkIdx(anyChunk._start + (long)this._chkRow);
                if (this._curChkIdx > this._lastChkIdx) {
                    return -1;
                }
                Chunk[] newChks = new Chunk[this._curChks.length];
                for (int i = 0; i < this._curChks.length; ++i) {
                    newChks[i] = this._curChks[i]._vec.chunkForChunkIdx(this._curChkIdx);
                    Key oldKey = this._curChks[i]._vec.chunkKey(this._curChks[i]._cidx);
                    if (oldKey.home()) continue;
                    H2O.raw_remove(oldKey);
                }
                this._curChks = newChks;
                this._chkRow = 0;
            }
            this._line = this.getBytesForRow();
            this._position = 0;
            return this._line.length;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this._line = null;
        }

        @Override
        public int read() throws IOException {
            return this.available() == 0 ? -1 : this._line[this._position++];
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.available();
            if (n > 0) {
                n = Math.min(n, len);
                System.arraycopy(this._line, this._position, b, off, n);
                this._position += n;
            }
            return n;
        }
    }

    public static class CSVStreamParams
    extends Iced<CSVStreamParams> {
        public static final char DEFAULT_SEPARATOR = ',';
        public static final char DEFAULT_ESCAPE = '\"';
        boolean _headers = true;
        boolean _hexString = false;
        boolean _escapeQuotes = false;
        char _separator = (char)44;
        char _escapeCharacter = (char)34;

        public CSVStreamParams setHeaders(boolean headers) {
            this._headers = headers;
            return this;
        }

        public CSVStreamParams setHexString(boolean hex_string) {
            this._hexString = hex_string;
            return this;
        }

        public CSVStreamParams setSeparator(byte separator) {
            this._separator = (char)separator;
            return this;
        }

        public CSVStreamParams setEscapeQuotes(boolean backslash_escape) {
            this._escapeQuotes = backslash_escape;
            return this;
        }

        public CSVStreamParams setEscapeChar(char escapeChar) {
            this._escapeCharacter = escapeChar;
            return this;
        }
    }

    public static class DeepSelect
    extends MRTask<DeepSelect> {
        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            Chunk pred = chks[chks.length - 1];
            int[] ids = pred.getIntegers(new int[pred._len], 0, pred._len, 0);
            int zeros = 0;
            for (int i = 0; i < ids.length; ++i) {
                if (ids[i] == 1) {
                    ids[i - zeros] = i;
                    continue;
                }
                ++zeros;
            }
            ids = Arrays.copyOf(ids, ids.length - zeros);
            for (int c = 0; c < chks.length - 1; ++c) {
                chks[c].extractRows(nchks[c], ids);
            }
        }
    }

    private static class DeepSlice
    extends MRTask<DeepSlice> {
        final int[] _cols;
        final long[] _rows;
        final byte[] _isInt;

        DeepSlice(long[] rows, int[] cols, Vec[] vecs) {
            this._cols = cols;
            this._rows = rows;
            this._isInt = new byte[cols.length];
            for (int i = 0; i < cols.length; ++i) {
                this._isInt[i] = (byte)(vecs[cols[i]].isInt() ? 1 : 0);
            }
        }

        @Override
        public boolean logVerbose() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void map(Chunk[] chks, NewChunk[] nchks) {
            long rstart = chks[0]._start;
            int rlen = chks[0]._len;
            int rx = 0;
            int rlo = 0;
            int rhi = rlen;
            while (true) {
                if (this._rows != null) {
                    long r;
                    if (rx >= this._rows.length) return;
                    if ((r = this._rows[rx++]) < rstart) continue;
                    rlo = (int)(r - rstart);
                    for (rhi = rlo + 1; rx < this._rows.length && this._rows[rx] - rstart == (long)rhi && rhi < rlen; ++rx, ++rhi) {
                    }
                }
                BufferedString tmpStr = new BufferedString();
                for (int i = 0; i < this._cols.length; ++i) {
                    chks[this._cols[i]].extractRows(nchks[i], rlo, rhi);
                }
                rlo = rhi;
                if (this._rows == null) return;
            }
        }
    }

    private static class Slice
    extends MRTask<Slice> {
        final Frame _base;
        final int[] _cols;

        Slice(int[] cols, Frame base) {
            this._cols = cols;
            this._base = base;
        }

        @Override
        public void map(Chunk[] ix, NewChunk[] ncs) {
            Vec[] vecs = new Vec[this._cols.length];
            Vec anyv = this._base.anyVec();
            long nrow = anyv.length();
            long r = ix[0].at8(0);
            int last_ci = anyv.elem2ChunkIdx(r < nrow ? r : 0L);
            long last_c0 = anyv.espc()[last_ci];
            long last_c1 = anyv.espc()[last_ci + 1];
            Chunk[] last_cs = new Chunk[vecs.length];
            for (int c = 0; c < this._cols.length; ++c) {
                vecs[c] = this._base.vecs()[this._cols[c]];
                last_cs[c] = vecs[c].chunkForChunkIdx(last_ci);
            }
            for (int i = 0; i < ix[0]._len; ++i) {
                int c;
                r = ix[0].at8(i);
                if (r < 0L) continue;
                if (r >= nrow) {
                    for (c = 0; c < vecs.length; ++c) {
                        ncs[c].addNA();
                    }
                    continue;
                }
                if (r < last_c0 || r >= last_c1) {
                    last_ci = anyv.elem2ChunkIdx(r);
                    last_c0 = anyv.espc()[last_ci];
                    last_c1 = anyv.espc()[last_ci + 1];
                    for (c = 0; c < vecs.length; ++c) {
                        last_cs[c] = vecs[c].chunkForChunkIdx(last_ci);
                    }
                }
                int ir = (int)(r - last_cs[0].start());
                for (int c2 = 0; c2 < vecs.length; ++c2) {
                    last_cs[c2].extractRows(ncs[c2], ir);
                }
            }
        }
    }

    public static class VecSpecifier
    extends Iced
    implements Vec.Holder {
        public Key<Frame> _frame;
        public String _column_name;

        public VecSpecifier() {
        }

        public VecSpecifier(Key<Frame> frame, String column_name) {
            this._frame = frame;
            this._column_name = column_name;
        }

        @Override
        public Vec vec() {
            Value v = DKV.get(this._frame);
            if (null == v) {
                return null;
            }
            Frame f = (Frame)v.get();
            if (null == f) {
                return null;
            }
            return f.vec(this._column_name);
        }

        public static String[] vecNames(VecSpecifier[] vecSpecifiers) throws NullPointerException {
            Objects.requireNonNull(vecSpecifiers);
            String[] vecNames = new String[vecSpecifiers.length];
            for (int i = 0; i < vecSpecifiers.length; ++i) {
                vecNames[i] = vecSpecifiers[i]._column_name;
            }
            return vecNames;
        }
    }
}

