/*
 * Decompiled with CFR 0.152.
 */
package water.init;

import water.util.ArrayUtils;
import water.util.Log;
import water.util.Timer;

public class Linpack {
    double second_orig = -1.0;

    public static void main(String[] args) {
        int num_threads = Runtime.getRuntime().availableProcessors();
        double sumgflops = Linpack.run(num_threads);
        Log.info("CPU speed (" + num_threads + " cores) : " + sumgflops + " Gflops.");
    }

    public static double run(int num_threads) {
        int t;
        final double[] gflops = new double[num_threads];
        Thread[] threads = new Thread[num_threads];
        for (t = 0; t < num_threads; ++t) {
            final int thread_num = t;
            threads[t] = new Thread(){

                @Override
                public void run() {
                    Linpack l = new Linpack();
                    gflops[thread_num] = l.run_benchmark();
                }
            };
        }
        for (t = 0; t < num_threads; ++t) {
            threads[t].start();
        }
        for (t = 0; t < num_threads; ++t) {
            try {
                threads[t].join();
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        return ArrayUtils.sum(gflops);
    }

    final double abs(double d) {
        return d >= 0.0 ? d : -d;
    }

    double second() {
        if (this.second_orig == -1.0) {
            this.second_orig = System.currentTimeMillis();
        }
        return ((double)System.currentTimeMillis() - this.second_orig) / 1000.0;
    }

    public double run_benchmark() {
        int i;
        int info;
        double gflops_result = 0.0;
        double residn_result = 0.0;
        double time_result = 0.0;
        double eps_result = 0.0;
        double[][] a = new double[200][201];
        double[] b = new double[200];
        double[] x = new double[200];
        int[] ipvt = new int[200];
        int lda = 201;
        int ldaa = 200;
        double cray = 0.056;
        int n = 200;
        double ops = 2.0 * (double)(n * n * n) / 3.0 + 2.0 * (double)(n * n);
        double norma = this.matgen(a, lda, n, b);
        int repeats = 200;
        for (int r = 0; r < 10; ++r) {
            info = this.dgefa(a, lda, n, ipvt);
            this.dgesl(a, lda, n, ipvt, b, 0);
        }
        Timer timer = new Timer();
        for (int r = 0; r < repeats; ++r) {
            info = this.dgefa(a, lda, n, ipvt);
            this.dgesl(a, lda, n, ipvt, b, 0);
        }
        double total = (double)timer.time() / 1000.0;
        for (i = 0; i < n; ++i) {
            x[i] = b[i];
        }
        norma = this.matgen(a, lda, n, b);
        for (i = 0; i < n; ++i) {
            b[i] = -b[i];
        }
        this.dmxpy(n, b, n, lda, x, a);
        double resid = 0.0;
        double normx = 0.0;
        for (i = 0; i < n; ++i) {
            resid = resid > this.abs(b[i]) ? resid : this.abs(b[i]);
            normx = normx > this.abs(x[i]) ? normx : this.abs(x[i]);
        }
        eps_result = this.epslon(1.0);
        residn_result = resid / ((double)n * norma * normx * eps_result);
        residn_result += 0.005;
        residn_result = (int)(residn_result * 100.0);
        residn_result /= 100.0;
        time_result = total;
        time_result += 0.005;
        time_result = (int)(time_result * 100.0);
        time_result /= 100.0;
        gflops_result = ops / (1.0E9 * total) * (double)repeats;
        gflops_result += 5.0E-4;
        gflops_result = (int)(gflops_result * 1000.0);
        return gflops_result /= 1000.0;
    }

    final double matgen(double[][] a, int lda, int n, double[] b) {
        int j;
        int i;
        int init = 1325;
        double norma = 0.0;
        for (i = 0; i < n; ++i) {
            for (j = 0; j < n; ++j) {
                init = 3125 * init % 65536;
                a[j][i] = ((double)init - 32768.0) / 16384.0;
                norma = a[j][i] > norma ? a[j][i] : norma;
            }
        }
        for (i = 0; i < n; ++i) {
            b[i] = 0.0;
        }
        for (j = 0; j < n; ++j) {
            for (i = 0; i < n; ++i) {
                int n2 = i;
                b[n2] = b[n2] + a[j][i];
            }
        }
        return norma;
    }

    final int dgefa(double[][] a, int lda, int n, int[] ipvt) {
        int info = 0;
        int nm1 = n - 1;
        if (nm1 >= 0) {
            for (int k = 0; k < nm1; ++k) {
                int l;
                double[] col_k = a[k];
                int kp1 = k + 1;
                ipvt[k] = l = this.idamax(n - k, col_k, k, 1) + k;
                if (col_k[l] != 0.0) {
                    double t;
                    if (l != k) {
                        t = col_k[l];
                        col_k[l] = col_k[k];
                        col_k[k] = t;
                    }
                    t = -1.0 / col_k[k];
                    this.dscal(n - kp1, t, col_k, kp1, 1);
                    for (int j = kp1; j < n; ++j) {
                        double[] col_j = a[j];
                        t = col_j[l];
                        if (l != k) {
                            col_j[l] = col_j[k];
                            col_j[k] = t;
                        }
                        this.daxpy(n - kp1, t, col_k, kp1, 1, col_j, kp1, 1);
                    }
                    continue;
                }
                info = k;
            }
        }
        ipvt[n - 1] = n - 1;
        if (a[n - 1][n - 1] == 0.0) {
            info = n - 1;
        }
        return info;
    }

    final void dgesl(double[][] a, int lda, int n, int[] ipvt, double[] b, int job) {
        block7: {
            double t;
            int k;
            int nm1;
            block6: {
                double t2;
                int k2;
                nm1 = n - 1;
                if (job != 0) break block6;
                if (nm1 >= 1) {
                    for (k2 = 0; k2 < nm1; ++k2) {
                        int l = ipvt[k2];
                        t2 = b[l];
                        if (l != k2) {
                            b[l] = b[k2];
                            b[k2] = t2;
                        }
                        int kp1 = k2 + 1;
                        this.daxpy(n - kp1, t2, a[k2], kp1, 1, b, kp1, 1);
                    }
                }
                for (int kb = 0; kb < n; ++kb) {
                    int n2 = k2 = n - (kb + 1);
                    b[n2] = b[n2] / a[k2][k2];
                    t2 = -b[k2];
                    this.daxpy(k2, t2, a[k2], 0, 1, b, 0, 1);
                }
                break block7;
            }
            for (k = 0; k < n; ++k) {
                t = this.ddot(k, a[k], 0, 1, b, 0, 1);
                b[k] = (b[k] - t) / a[k][k];
            }
            if (nm1 < 1) break block7;
            for (int kb = 1; kb < nm1; ++kb) {
                k = n - (kb + 1);
                int kp1 = k + 1;
                int n3 = k;
                b[n3] = b[n3] + this.ddot(n - kp1, a[k], kp1, 1, b, kp1, 1);
                int l = ipvt[k];
                if (l == k) continue;
                t = b[l];
                b[l] = b[k];
                b[k] = t;
            }
        }
    }

    final void daxpy(int n, double da, double[] dx, int dx_off, int incx, double[] dy, int dy_off, int incy) {
        if (n > 0 && da != 0.0) {
            if (incx != 1 || incy != 1) {
                int ix = 0;
                int iy = 0;
                if (incx < 0) {
                    ix = (-n + 1) * incx;
                }
                if (incy < 0) {
                    iy = (-n + 1) * incy;
                }
                for (int i = 0; i < n; ++i) {
                    int n2 = iy + dy_off;
                    dy[n2] = dy[n2] + da * dx[ix + dx_off];
                    ix += incx;
                    iy += incy;
                }
                return;
            }
            for (int i = 0; i < n; ++i) {
                int n3 = i + dy_off;
                dy[n3] = dy[n3] + da * dx[i + dx_off];
            }
        }
    }

    final double ddot(int n, double[] dx, int dx_off, int incx, double[] dy, int dy_off, int incy) {
        double dtemp;
        block6: {
            dtemp = 0.0;
            if (n <= 0) break block6;
            if (incx != 1 || incy != 1) {
                int ix = 0;
                int iy = 0;
                if (incx < 0) {
                    ix = (-n + 1) * incx;
                }
                if (incy < 0) {
                    iy = (-n + 1) * incy;
                }
                for (int i = 0; i < n; ++i) {
                    dtemp += dx[ix + dx_off] * dy[iy + dy_off];
                    ix += incx;
                    iy += incy;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    dtemp += dx[i + dx_off] * dy[i + dy_off];
                }
            }
        }
        return dtemp;
    }

    final void dscal(int n, double da, double[] dx, int dx_off, int incx) {
        block4: {
            if (n <= 0) break block4;
            if (incx != 1) {
                int nincx = n * incx;
                for (int i = 0; i < nincx; i += incx) {
                    int n2 = i + dx_off;
                    dx[n2] = dx[n2] * da;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n3 = i + dx_off;
                    dx[n3] = dx[n3] * da;
                }
            }
        }
    }

    final int idamax(int n, double[] dx, int dx_off, int incx) {
        int itemp = 0;
        if (n < 1) {
            itemp = -1;
        } else if (n == 1) {
            itemp = 0;
        } else if (incx != 1) {
            double dmax = this.abs(dx[0 + dx_off]);
            int ix = 1 + incx;
            for (int i = 1; i < n; ++i) {
                double dtemp = this.abs(dx[ix + dx_off]);
                if (dtemp > dmax) {
                    itemp = i;
                    dmax = dtemp;
                }
                ix += incx;
            }
        } else {
            itemp = 0;
            double dmax = this.abs(dx[0 + dx_off]);
            for (int i = 1; i < n; ++i) {
                double dtemp = this.abs(dx[i + dx_off]);
                if (!(dtemp > dmax)) continue;
                itemp = i;
                dmax = dtemp;
            }
        }
        return itemp;
    }

    final double epslon(double x) {
        double a = 1.3333333333333333;
        double eps = 0.0;
        while (eps == 0.0) {
            double b = a - 1.0;
            double c = b + b + b;
            eps = this.abs(c - 1.0);
        }
        return eps * this.abs(x);
    }

    final void dmxpy(int n1, double[] y, int n2, int ldm, double[] x, double[][] m) {
        for (int j = 0; j < n2; ++j) {
            for (int i = 0; i < n1; ++i) {
                int n = i;
                y[n] = y[n] + x[j] * m[j][i];
            }
        }
    }
}

