/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import water.AutoBuffer;
import water.H2O;
import water.Key;
import water.Value;
import water.exceptions.H2ONotFoundArgumentException;
import water.fvec.NFSFileVec;
import water.persist.Persist;
import water.util.FileIntegrityChecker;
import water.util.FileUtils;
import water.util.Log;

public final class PersistNFS
extends Persist {
    static final String KEY_PREFIX = "nfs:" + File.separator;
    static final int KEY_PREFIX_LENGTH = KEY_PREFIX.length();

    public static Key decodeFile(File f) {
        return Key.make(KEY_PREFIX + f.toString());
    }

    private static File getFileForKey(Key k) {
        int off;
        int n = off = k._kb[0] == 5 ? 10 : 0;
        assert (new String(k._kb, off, KEY_PREFIX_LENGTH).equals(KEY_PREFIX)) : "Not an NFS key: " + k;
        String s = new String(k._kb, KEY_PREFIX_LENGTH + off, k._kb.length - (KEY_PREFIX_LENGTH + off));
        return new File(s);
    }

    @Override
    public void cleanUp() {
    }

    public static InputStream openStream(Key k) throws IOException {
        return new FileInputStream(PersistNFS.getFileForKey(k));
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] load(Value v) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void store(Value v) {
        if (!v._key.home()) {
            return;
        }
        if (v.isPersisted()) {
            return;
        }
        try {
            File f = PersistNFS.getFileForKey(v._key);
            if (!f.mkdirs()) {
                throw new IOException("Unable to create directory " + f);
            }
            try (FileOutputStream s = new FileOutputStream(f);){
                byte[] m = v.memOrLoad();
                assert (m == null || m.length == v._max);
                if (m != null) {
                    new AutoBuffer(s.getChannel(), false, 4).putA1(m, m.length).close();
                }
            }
        }
        catch (IOException e) {
            Log.err(e);
        }
    }

    @Override
    public void delete(Value v) {
        throw H2O.fail();
    }

    @Override
    public Key uriToKey(URI uri) {
        return NFSFileVec.make((File)(uri.getScheme() == null ? new File((String)uri.toString()) : new File((URI)uri)))._key;
    }

    public ArrayList<String> calcTypeaheadMatches(String filter, int limit) {
        File base = null;
        String filterPrefix = "";
        if (limit == 0) {
            --limit;
        }
        if (!filter.isEmpty()) {
            File file = new File(filter);
            if (file.isDirectory()) {
                base = file;
            } else {
                base = file.getParentFile();
                filterPrefix = file.getName().toLowerCase();
            }
        }
        if (base == null) {
            base = new File(".");
        }
        ArrayList<String> array = new ArrayList<String>();
        File[] files = base.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isHidden()) continue;
                if (file.getName().toLowerCase().startsWith(filterPrefix)) {
                    array.add(file.getPath());
                }
                if (array.size() == limit) break;
            }
        }
        return array;
    }

    @Override
    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        File f = new File(FileUtils.getURI(path));
        if (!f.exists()) {
            throw new H2ONotFoundArgumentException("File " + path + " does not exist");
        }
        FileIntegrityChecker.check(f).syncDirectory(files, keys, fails, dels);
    }
}

