/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.internal;

import java.lang.reflect.Method;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValStr;

public class AstRunTool
extends AstPrimitive<AstRunTool> {
    private static final String TOOLS_PACKAGE = "water.tools.";

    @Override
    public String[] args() {
        return new String[]{"tool_class", "tool_parameters"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "run_tool";
    }

    @Override
    public ValStr apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        String toolClassName = stk.track(asts[1].exec(env)).getStr();
        String[] args = stk.track(asts[2].exec(env)).getStrs();
        try {
            Class<?> clazz = Class.forName(TOOLS_PACKAGE + toolClassName);
            Method mainMethod = clazz.getDeclaredMethod("main", String[].class);
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new ValStr("OK");
    }
}

