/*
 * Decompiled with CFR 0.152.
 */
package water.udf;

import water.DKV;
import water.Key;
import water.fvec.Vec;
import water.udf.ChunkFactory;
import water.udf.ColumnBase;
import water.udf.TypedChunk;

public abstract class DataColumn<T>
extends ColumnBase<T> {
    protected transient Vec vec = null;
    private Key<Vec> vecKey;
    public final byte type;
    private ChunkFactory<T> chunkFactory;

    public DataColumn() {
        this.type = 0;
    }

    @Override
    public abstract T get(long var1);

    public abstract void set(long var1, T var3);

    @Override
    public T apply(Long idx) {
        return this.get(idx);
    }

    @Override
    public T apply(long idx) {
        return this.get(idx);
    }

    @Override
    public int rowLayout() {
        return this.vec()._rowLayout;
    }

    @Override
    public long size() {
        return this.vec().length();
    }

    @Override
    public TypedChunk<T> chunkAt(int i) {
        return (TypedChunk)this.chunkFactory.apply(this.vec().chunkForChunkIdx(i));
    }

    protected DataColumn(Vec vec, ChunkFactory<T> factory) {
        this.vec = vec;
        this.vecKey = vec._key;
        this.type = factory.typeCode();
        this.chunkFactory = factory;
    }

    @Override
    public boolean isNA(long idx) {
        return this.vec().isNA(idx);
    }

    @Override
    public Vec vec() {
        if (this.vec == null) {
            this.vec = (Vec)DKV.get(this.vecKey).get();
        }
        return this.vec;
    }

    public String toString() {
        return "DataColumn(type=" + this.type + ", factory=" + this.chunkFactory + ", vec=" + this.vec() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof DataColumn) {
            DataColumn that = (DataColumn)o;
            return this.type == that.type && this.vecKey.equals(that.vecKey);
        }
        return false;
    }

    public int hashCode() {
        return 61 * this.vecKey.hashCode() + this.type;
    }
}

