/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.log4j.H2OPropertyConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import water.H2O;
import water.util.StringUtils;

public abstract class Log {
    public static final byte FATAL = 0;
    public static final byte ERRR = 1;
    public static final byte WARN = 2;
    public static final byte INFO = 3;
    public static final byte DEBUG = 4;
    public static final byte TRACE = 5;
    public static final String[] LVLS = new String[]{"FATAL", "ERRR", "WARN", "INFO", "DEBUG", "TRACE"};
    public static final Level[] L4J_LVLS = new Level[]{Level.FATAL, Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE};
    private static int _level = 3;
    private static boolean _quiet = false;
    private static Logger _logger = null;
    private static boolean _bufferMessages = true;
    private static String _logDir = null;
    private static String _maxLogFileSize = "3MB";
    private static ArrayList<BufferedMsg> INIT_MSGS = new ArrayList();

    public static byte valueOf(String slvl) {
        if (slvl == null) {
            return -1;
        }
        if ((slvl = slvl.toLowerCase()).startsWith("fatal")) {
            return 0;
        }
        if (slvl.startsWith("err")) {
            return 1;
        }
        if (slvl.startsWith("warn")) {
            return 2;
        }
        if (slvl.startsWith("info")) {
            return 3;
        }
        if (slvl.startsWith("debug")) {
            return 4;
        }
        if (slvl.startsWith("trace")) {
            return 5;
        }
        return -1;
    }

    public static void init(String sLvl, boolean quiet, String maxLogFileSize) {
        byte lvl = Log.valueOf(sLvl);
        if (lvl != -1) {
            _level = lvl;
        }
        _quiet = quiet;
        _logger = null;
        if (maxLogFileSize != null) {
            _maxLogFileSize = maxLogFileSize;
        }
    }

    public static void notifyAboutNetworkingInitialized() {
        _bufferMessages = false;
        assert (H2O.SELF_ADDRESS != null && H2O.H2O_PORT != 0);
    }

    public static void notifyAboutProcessExiting() {
        Log.flushBufferedMessages();
        if (_quiet) {
            _quiet = false;
            _logger = null;
        }
        INIT_MSGS = null;
    }

    public static void setLogLevel(String level, boolean quiet) {
        Log.init(level, quiet, null);
    }

    public static void setLogLevel(String level) {
        Log.setLogLevel(level, true);
    }

    public static void trace(Object ... objs) {
        Log.log(5, objs);
    }

    public static void debug(Object ... objs) {
        Log.log(4, objs);
    }

    public static void info(Object ... objs) {
        Log.log(3, objs);
    }

    public static void warn(Object ... objs) {
        Log.log(2, objs);
    }

    public static void err(Object ... objs) {
        Log.log(1, objs);
    }

    public static void fatal(Object ... objs) {
        Log.log(0, objs);
    }

    public static void log(int level, Object ... objs) {
        Log.write(level, objs);
    }

    public static RuntimeException throwErr(Throwable e) {
        Log.err(e);
        throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static void write(int lvl, Object[] objs) {
        Log.write0(lvl, objs);
    }

    private static void write0(int lvl, Object[] objs) {
        StringBuilder msgBuff = new StringBuilder();
        Throwable t = null;
        for (int i = 0; i < objs.length - 1; ++i) {
            msgBuff.append(objs[i]);
        }
        if (objs.length > 0 && objs[objs.length - 1] instanceof Throwable) {
            t = (Throwable)objs[objs.length - 1];
        } else if (objs.length > 0) {
            msgBuff.append(objs[objs.length - 1]);
        }
        String msg = msgBuff.toString();
        if (_bufferMessages) {
            INIT_MSGS.add(new BufferedMsg(lvl, msg, t));
            return;
        }
        Log.flushBufferedMessages();
        Log.write0(lvl, msg, t);
    }

    private static void write0(int lvl, String s, Throwable t) {
        Logger log;
        Logger logger = log = _logger != null ? _logger : Log.createLog4j();
        if (s.contains("\n")) {
            for (String line : s.split("\n")) {
                log.log((Priority)L4J_LVLS[lvl], (Object)line);
            }
            if (t != null) {
                log.log((Priority)L4J_LVLS[lvl], (Object)t);
            }
        } else {
            log.log((Priority)L4J_LVLS[lvl], (Object)s, t);
        }
    }

    public static void flushBufferedMessages() {
        if (INIT_MSGS != null) {
            ArrayList<BufferedMsg> buff = INIT_MSGS;
            INIT_MSGS = null;
            if (buff != null) {
                for (BufferedMsg m : buff) {
                    Log.write0(m.lvl, m.msg, m.t);
                }
            }
        }
    }

    public static int getLogLevel() {
        return _level;
    }

    public static boolean isLoggingFor(int level) {
        if (level == -1) {
            return false;
        }
        return _level >= level;
    }

    public static boolean isLoggingFor(String strLevel) {
        byte level = Log.valueOf(strLevel);
        return Log.isLoggingFor(level);
    }

    public static String getLogDir() throws Exception {
        if (_logDir == null) {
            throw new Exception("LOG_DIR not yet defined");
        }
        return _logDir;
    }

    private static String getLogFileNamePrefix() throws Exception {
        if (H2O.SELF_ADDRESS == null) {
            throw new Exception("H2O.SELF_ADDRESS not yet defined");
        }
        if (H2O.H2O_PORT == 0) {
            throw new Exception("H2O.H2O_PORT is not yet determined");
        }
        String ip = H2O.SELF_ADDRESS.getHostAddress();
        int port = H2O.API_PORT;
        String portString = Integer.toString(port);
        return "h2o_" + ip + "_" + portString;
    }

    public static String getLogFileName(String level) throws Exception {
        return Log.getLogFileNamePrefix() + Log.getLogFileNameSuffix(level);
    }

    private static String getLogFileNameSuffix(String level) {
        switch (level) {
            case "trace": {
                return "-1-trace.log";
            }
            case "debug": {
                return "-2-debug.log";
            }
            case "info": {
                return "-3-info.log";
            }
            case "warn": {
                return "-4-warn.log";
            }
            case "error": {
                return "-5-error.log";
            }
            case "fatal": {
                return "-6-fatal.log";
            }
            case "httpd": {
                return "-httpd.log";
            }
        }
        throw new RuntimeException("Unknown level " + level);
    }

    public static String getLogFilePath(String level) throws Exception {
        return Log.getLogDir() + File.separator + Log.getLogFileName(level);
    }

    private static String getHostPortPid() {
        String host = H2O.SELF_ADDRESS.getHostAddress();
        return StringUtils.fixedLength(host + ":" + H2O.API_PORT + " ", 22) + StringUtils.fixedLength(H2O.PID + " ", 6);
    }

    private static void setLog4jProperties(String logDir, Properties p) throws Exception {
        _logDir = logDir;
        String patternTail = Log.getHostPortPid() + " %10.10t %5.5p %c: %m%n";
        String pattern = "%d{MM-dd HH:mm:ss.SSS} " + patternTail;
        p.setProperty("log4j.rootLogger", L4J_LVLS[_level] + ", console");
        String appenders = L4J_LVLS[_level] + ", R1, R2, R3, R4, R5, R6";
        for (String packageName : new String[]{"water", "ai.h2o", "hex"}) {
            p.setProperty("log4j.logger." + packageName, appenders);
            p.setProperty("log4j.logger.additivity." + packageName, "false");
        }
        p.setProperty("log4j.appender.console", "org.apache.log4j.ConsoleAppender");
        p.setProperty("log4j.appender.console.Threshold", L4J_LVLS[_level].toString());
        p.setProperty("log4j.appender.console.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.console.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R1", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R1.Threshold", "TRACE");
        p.setProperty("log4j.appender.R1.File", Log.getLogFilePath("trace"));
        p.setProperty("log4j.appender.R1.MaxFileSize", "1MB");
        p.setProperty("log4j.appender.R1.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R1.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R1.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R2", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R2.Threshold", "DEBUG");
        p.setProperty("log4j.appender.R2.File", Log.getLogFilePath("debug"));
        p.setProperty("log4j.appender.R2.MaxFileSize", _maxLogFileSize);
        p.setProperty("log4j.appender.R2.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R2.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R2.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R3", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R3.Threshold", "INFO");
        p.setProperty("log4j.appender.R3.File", Log.getLogFilePath("info"));
        p.setProperty("log4j.appender.R3.MaxFileSize", _maxLogFileSize);
        p.setProperty("log4j.appender.R3.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R3.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R3.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R4", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R4.Threshold", "WARN");
        p.setProperty("log4j.appender.R4.File", Log.getLogFilePath("warn"));
        p.setProperty("log4j.appender.R4.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R4.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R4.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R4.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R5", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R5.Threshold", "ERROR");
        p.setProperty("log4j.appender.R5.File", Log.getLogFilePath("error"));
        p.setProperty("log4j.appender.R5.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R5.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R5.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R5.layout.ConversionPattern", pattern);
        p.setProperty("log4j.appender.R6", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.R6.Threshold", "FATAL");
        p.setProperty("log4j.appender.R6.File", Log.getLogFilePath("fatal"));
        p.setProperty("log4j.appender.R6.MaxFileSize", "256KB");
        p.setProperty("log4j.appender.R6.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.R6.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.R6.layout.ConversionPattern", pattern);
        p.setProperty("log4j.logger.water.api.RequestServer", "TRACE, HTTPD");
        p.setProperty("log4j.additivity.water.api.RequestServer", "false");
        p.setProperty("log4j.appender.HTTPD", "org.apache.log4j.RollingFileAppender");
        p.setProperty("log4j.appender.HTTPD.Threshold", "TRACE");
        p.setProperty("log4j.appender.HTTPD.File", Log.getLogFilePath("httpd"));
        p.setProperty("log4j.appender.HTTPD.MaxFileSize", "1MB");
        p.setProperty("log4j.appender.HTTPD.MaxBackupIndex", "3");
        p.setProperty("log4j.appender.HTTPD.layout", "org.apache.log4j.PatternLayout");
        p.setProperty("log4j.appender.HTTPD.layout.ConversionPattern", "%d{ISO8601} " + patternTail);
        p.setProperty("log4j.logger.org.apache.http", "WARN");
        p.setProperty("log4j.logger.com.amazonaws", "WARN");
        p.setProperty("log4j.logger.org.apache.hadoop", "WARN");
        p.setProperty("log4j.logger.org.jets3t.service", "WARN");
        p.setProperty("log4j.logger.org.reflections.Reflections", "ERROR");
        p.setProperty("log4j.logger.com.brsanthu.googleanalytics", "ERROR");
        p.setProperty("log4j.logger.org.apache.hadoop.util.NativeCodeLoader", "ERROR");
    }

    private static synchronized Logger createLog4j() {
        if (_logger != null) {
            return _logger;
        }
        boolean launchedWithHadoopJar = H2O.ARGS.launchedWithHadoopJar();
        String h2oLog4jConfiguration = System.getProperty("h2o.log4j.configuration");
        if (h2oLog4jConfiguration != null) {
            if (new File(h2oLog4jConfiguration).exists()) {
                PropertyConfigurator.configure((String)h2oLog4jConfiguration);
            } else {
                URL confUrl = Log.class.getClassLoader().getResource(h2oLog4jConfiguration);
                if (confUrl != null) {
                    PropertyConfigurator.configure((URL)confUrl);
                }
            }
        } else {
            Properties p = new Properties();
            try {
                File dir;
                if (H2O.ARGS.log_dir != null) {
                    dir = new File(H2O.ARGS.log_dir);
                } else {
                    boolean windowsPath = H2O.ICE_ROOT.toString().matches("^[a-zA-Z]:.*");
                    dir = windowsPath ? new File(H2O.ICE_ROOT.toString()) : (H2O.ICE_ROOT.getScheme() == null || "file".equals(H2O.ICE_ROOT.getScheme()) ? new File(H2O.ICE_ROOT.getPath()) : new File(H2O.DEFAULT_ICE_ROOT()));
                    dir = new File(dir, "h2ologs");
                }
                Log.setLog4jProperties(dir.toString(), p);
            }
            catch (Exception e) {
                System.err.println("ERROR: failed in createLog4j, exiting now.");
                e.printStackTrace();
                H2O.exit(1);
            }
            if (!launchedWithHadoopJar && H2O.haveInheritedLog4jConfiguration()) {
                H2OPropertyConfigurator.configure((Properties)p);
            } else {
                PropertyConfigurator.configure((Properties)p);
            }
        }
        _logger = Logger.getLogger((String)"water.default");
        return _logger;
    }

    public static void ignore(Throwable e) {
        Log.ignore(e, "[h2o] Problem ignored: ");
    }

    public static void ignore(Throwable e, String msg) {
        Log.ignore(e, msg, true);
    }

    public static void ignore(Throwable e, String msg, boolean printException) {
        Log.debug(msg + (printException ? e.toString() : ""));
    }

    public static void POST(int n, String s) {
        System.out.println("POST " + n + ": " + s);
    }

    public static void POST(int n, Exception e) {
        if (e.getMessage() != null) {
            Log.POST(n, e.getMessage());
        }
        Log.POST(n, e.toString());
        StackTraceElement[] els = e.getStackTrace();
        for (int i = 0; i < els.length; ++i) {
            Log.POST(n, els[i].toString());
        }
    }

    private static class BufferedMsg {
        private final int lvl;
        private final String msg;
        private final Throwable t;

        BufferedMsg(int l, String m, Throwable t) {
            this.lvl = l;
            this.msg = m;
            this.t = t;
        }
    }
}

