/*
 * Decompiled with CFR 0.152.
 */
package water.server;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServlet;
import water.server.ServletMeta;
import water.server.ServletProvider;
import water.server.WebsocketMeta;
import water.webserver.iface.H2OWebsocketServlet;

public final class ServletService {
    public static final ServletService INSTANCE = new ServletService();
    private final ServiceLoader<ServletProvider> _loader = ServiceLoader.load(ServletProvider.class);

    private ServletService() {
    }

    public synchronized LinkedHashMap<String, Class<? extends HttpServlet>> getAlwaysEnabledServlets() {
        return StreamSupport.stream(this._loader.spliterator(), false).sorted(Comparator.comparing(ServletProvider::priority).reversed()).flatMap(provider -> provider.servlets().stream()).filter(servletMeta -> servletMeta.isAlwaysEnabled()).collect(Collectors.toMap(ServletMeta::getContextPath, ServletMeta::getServletClass, (val1, val2) -> val2, LinkedHashMap::new));
    }

    public synchronized LinkedHashMap<String, Class<? extends HttpServlet>> getAllServlets() {
        return StreamSupport.stream(this._loader.spliterator(), false).sorted(Comparator.comparing(ServletProvider::priority).reversed()).flatMap(provider -> provider.servlets().stream()).collect(Collectors.toMap(ServletMeta::getContextPath, ServletMeta::getServletClass, (val1, val2) -> val2, LinkedHashMap::new));
    }

    public synchronized LinkedHashMap<String, Class<? extends H2OWebsocketServlet>> getAllWebsockets() {
        return StreamSupport.stream(this._loader.spliterator(), false).sorted(Comparator.comparing(ServletProvider::priority).reversed()).flatMap(provider -> provider.websockets().stream()).collect(Collectors.toMap(WebsocketMeta::getContextPath, WebsocketMeta::getHandlerClass, (val1, val2) -> val2, LinkedHashMap::new));
    }
}

