/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Objects;
import water.Iced;
import water.api.Schema;
import water.util.JSONUtils;
import water.util.PojoUtils;

public class JSONValue<V>
extends Iced {
    protected String _json;
    protected Class<V> _clazz;

    public static <V> JSONValue<V> fromValue(V v) {
        return new JSONValue(JSONUtils.toJSON(v), v.getClass());
    }

    public JSONValue(String json) {
        this(json, null);
    }

    public JSONValue(String json, Class<V> clazz) {
        this._json = json;
        this._clazz = clazz;
    }

    public V value() {
        return this.valueAs(this._clazz);
    }

    public <T> T valueAs(Class<T> clazz) {
        if (clazz == null) {
            return (T)JSONUtils.parse(this._json);
        }
        return JSONUtils.parse(this._json, clazz);
    }

    public <T extends Iced, S extends Schema<T, S>> T valueAs(Class<T> clazz, Class<S> schema) {
        return ((Schema)this.valueAsSchema(schema)).createAndFillImpl();
    }

    public <T extends Iced, S extends Schema<T, S>> T[] valueAsArray(Class<T[]> clazz, Class<S[]> schema) {
        Schema[] ss = this.valueAsSchemas(schema);
        Class<?> tClazz = clazz.getComponentType();
        Iced[] ts = (Iced[])Array.newInstance(tClazz, ss.length);
        for (int i = 0; i < ss.length; ++i) {
            ts[i] = ss[i].createAndFillImpl();
        }
        return ts;
    }

    public <S extends Schema> S valueAsSchema(Class<S> schema) {
        Object s;
        if (Schema.AutoParseable.class.isAssignableFrom(schema)) {
            s = (Schema)this.valueAs(schema);
        } else {
            s = Schema.newInstance(schema);
            PojoUtils.fillFromJson(s, this._json);
        }
        return s;
    }

    public <S extends Schema> S[] valueAsSchemas(Class<S[]> schema) {
        Schema[] ss;
        Class<?> sClazz = schema.getComponentType();
        if (Schema.AutoParseable.class.isAssignableFrom(sClazz)) {
            ss = (Schema[])this.valueAs(schema);
        } else {
            Map[] maps = this.valueAs(Map[].class);
            ss = (Schema[])Array.newInstance(sClazz, maps.length);
            for (int i = 0; i < ss.length; ++i) {
                ss[i] = JSONValue.fromValue(maps[i]).valueAsSchema(sClazz);
            }
        }
        return ss;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONValue jsonValue = (JSONValue)o;
        return Objects.equals(this._json, jsonValue._json) && Objects.equals(this._clazz, jsonValue._clazz);
    }

    public int hashCode() {
        return Objects.hash(this._json, this._clazz);
    }
}

