/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas3;

import hex.Model;
import water.api.API;
import water.api.schemas3.KeyV3;
import water.api.schemas3.SchemaV3;

public class ModelSchemaBaseV3<M extends Model<M, ?, ?>, S extends ModelSchemaBaseV3<M, S>>
extends SchemaV3<M, S> {
    @API(help="Model key", required=true, direction=API.Direction.INOUT)
    public KeyV3.ModelKeyV3<M> model_id;
    @API(help="The algo name for this Model.", direction=API.Direction.OUTPUT)
    public String algo;
    @API(help="The pretty algo name for this Model (e.g., Generalized Linear Model, rather than GLM).", direction=API.Direction.OUTPUT)
    public String algo_full_name;
    @API(help="The response column name for this Model (if applicable). Is null otherwise.", direction=API.Direction.OUTPUT)
    public String response_column_name;
    @API(help="The Model's training frame key", direction=API.Direction.OUTPUT)
    public KeyV3.FrameKeyV3 data_frame;
    @API(help="Timestamp for when this model was completed", direction=API.Direction.OUTPUT)
    public long timestamp;
    @API(help="Indicator, whether export to POJO is available", direction=API.Direction.OUTPUT)
    public boolean have_pojo;
    @API(help="Indicator, whether export to MOJO is available", direction=API.Direction.OUTPUT)
    public boolean have_mojo;

    public ModelSchemaBaseV3() {
    }

    public ModelSchemaBaseV3(M m) {
        this.model_id = new KeyV3.ModelKeyV3(((Model)m)._key);
        this.algo = ((Model.Parameters)((Model)m)._parms).algoName().toLowerCase();
        this.algo_full_name = ((Model.Parameters)((Model)m)._parms).fullName();
        this.data_frame = new KeyV3.FrameKeyV3(((Model.Parameters)((Model)m)._parms)._train);
        this.response_column_name = ((Model.Parameters)((Model)m)._parms)._response_column;
        this.timestamp = ((Model.Output)((Model)m)._output)._job == null ? -1L : (((Model.Output)((Model)m)._output)._job.isRunning() ? 0L : ((Model.Output)((Model)m)._output)._job.end_time());
        this.have_pojo = ((Model)m).havePojo();
        this.have_mojo = ((Model)m).haveMojo();
    }
}

