/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.util.JavaVersionUtils;

public class JavaVersionSupport {
    public static final int MIN_SUPPORTED_JAVA_VERSION = 8;
    public static final int MAX_SUPPORTED_JAVA_VERSION = 15;

    public static boolean runningOnSupportedVersion() {
        return JavaVersionUtils.JAVA_VERSION.isKnown() && (JavaVersionSupport.isUserEnabledJavaVersion() || JavaVersionSupport.isSupportedVersion());
    }

    private static boolean isSupportedVersion() {
        return JavaVersionUtils.JAVA_VERSION.getMajor() >= 8 && JavaVersionUtils.JAVA_VERSION.getMajor() <= 15;
    }

    private static boolean isUserEnabledJavaVersion() {
        String[] splitVersions;
        String extraJavaVersionsStr = System.getProperty("sys.ai.h2o.debug.allowJavaVersions");
        if (extraJavaVersionsStr == null || extraJavaVersionsStr.isEmpty()) {
            return false;
        }
        for (String version : splitVersions = extraJavaVersionsStr.split(",")) {
            int majorVersion = Integer.valueOf(version);
            if (JavaVersionUtils.JAVA_VERSION.getMajor() != majorVersion) continue;
            return true;
        }
        return false;
    }

    public static String describeSupportedVersions() {
        return "8-15";
    }
}

