/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import hex.Interaction;
import hex.Model;
import hex.ToEigenVec;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import jsr166y.CountedCompleter;
import org.apache.commons.io.IOUtils;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.MrFun;
import water.fvec.AppendableVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NFSFileVec;
import water.fvec.NewChunk;
import water.fvec.UploadFileVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.parser.ParseDataset;
import water.parser.ParseSetup;
import water.persist.PersistManager;
import water.util.ArrayUtils;
import water.util.ChunkSummary;
import water.util.CompressionFactory;
import water.util.DecompressionFactory;
import water.util.IcedHashMap;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;
import water.util.VecUtils;

public class FrameUtils {
    public static final int MAX_VEC_NUM_ROWS_FOR_ARRAY_EXPORT = 100000;

    public static Frame parseFrame(Key okey, File ... files) throws IOException {
        if (files == null || files.length == 0) {
            throw new IllegalArgumentException("List of files is empty!");
        }
        for (File f : files) {
            if (f.exists()) continue;
            throw new FileNotFoundException("File not found " + f);
        }
        if (okey == null) {
            okey = Key.make(files[0].getName());
        }
        Key[] inKeys = new Key[files.length];
        for (int i = 0; i < files.length; ++i) {
            inKeys[i] = NFSFileVec.make((File)files[i])._key;
        }
        return ParseDataset.parse(okey, inKeys);
    }

    public static Frame parseFrame(Key okey, URI ... uris) throws IOException {
        return FrameUtils.parseFrame(okey, null, uris);
    }

    public static Key eagerLoadFromHTTP(String path) throws IOException {
        URL url = new URL(path);
        Key destination_key = Key.make(path);
        InputStream is = url.openStream();
        UploadFileVec.ReadPutStats stats = new UploadFileVec.ReadPutStats();
        UploadFileVec.readPut(destination_key, is, stats);
        return destination_key;
    }

    public static Frame parseFrame(Key okey, ParseSetup parseSetup, URI ... uris) throws IOException {
        if (uris == null || uris.length == 0) {
            throw new IllegalArgumentException("List of uris is empty!");
        }
        if (okey == null) {
            okey = Key.make(uris[0].toString());
        }
        Key[] inKeys = new Key[uris.length];
        for (int i = 0; i < uris.length; ++i) {
            inKeys[i] = "http".equals(uris[i].getScheme()) || "https".equals(uris[i].getScheme()) ? FrameUtils.eagerLoadFromHTTP(uris[i].toString()) : H2O.getPM().anyURIToKey(uris[i]);
        }
        return parseSetup != null ? ParseDataset.parse(okey, inKeys, true, ParseSetup.guessSetup(inKeys, parseSetup)) : ParseDataset.parse(okey, inKeys);
    }

    public static Frame categoricalEncoder(Frame dataset, String[] skipCols, Model.Parameters.CategoricalEncodingScheme scheme, ToEigenVec tev, int maxLevels) {
        switch (scheme) {
            case AUTO: 
            case Enum: 
            case SortByResponse: 
            case OneHotInternal: {
                return dataset;
            }
            case OneHotExplicit: {
                return new CategoricalOneHotEncoder(dataset, skipCols).exec().get();
            }
            case Binary: {
                return new CategoricalBinaryEncoder(dataset, skipCols).exec().get();
            }
            case EnumLimited: {
                return new CategoricalEnumLimitedEncoder(maxLevels, dataset, skipCols).exec().get();
            }
            case Eigen: {
                return new CategoricalEigenEncoder(tev, dataset, skipCols).exec().get();
            }
            case LabelEncoder: {
                return new CategoricalLabelEncoder(dataset, skipCols).exec().get();
            }
        }
        throw H2O.unimpl();
    }

    public static void printTopCategoricalLevels(Frame fr, boolean warn, int topK) {
        String[][] domains = fr.domains();
        String[] names = fr.names();
        int len = domains.length;
        int[] levels = new int[len];
        for (int i = 0; i < len; ++i) {
            levels[i] = domains[i] != null ? domains[i].length : 0;
        }
        Arrays.sort(levels);
        if (levels[len - 1] > 0) {
            int levelcutoff = levels[len - 1 - Math.min(topK, len - 1)];
            int count = 0;
            for (int i = 0; i < len && count < topK; ++count, ++i) {
                if (domains[i] == null || domains[i].length < levelcutoff) continue;
                if (warn) {
                    Log.warn("Categorical feature '" + names[i] + "' has cardinality " + domains[i].length + ".");
                    continue;
                }
                Log.info("Categorical feature '" + names[i] + "' has cardinality " + domains[i].length + ".");
            }
        }
    }

    public static double[] asDoubles(Vec v) {
        return ((Vec2ArryTsk)new Vec2ArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static double[][] asDoubles(Frame frame) {
        if (frame.numRows() > 100000L) {
            throw new IllegalArgumentException("Frame is too big to be extracted into array");
        }
        double[][] frameArray = new double[frame.numCols()][];
        for (int i = 0; i < frame.numCols(); ++i) {
            Vec v = frame.vec(i);
            frameArray[i] = ((Vec2ArryTsk)new Vec2ArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
        }
        return frameArray;
    }

    public static int[] asInts(Vec v) {
        if (v.length() > 100000L) {
            throw new IllegalArgumentException("Vec is too big to be extracted into array");
        }
        return ((Vec2IntArryTsk)new Vec2IntArryTsk((int)((int)v.length())).doAll((Vec[])new Vec[]{v})).res;
    }

    public static ChunkSummary chunkSummary(Frame fr) {
        return (ChunkSummary)new ChunkSummary().doAll(fr);
    }

    public static Key[] generateNumKeys(Key mk, int num) {
        return FrameUtils.generateNumKeys(mk, num, "_part");
    }

    public static Key[] generateNumKeys(Key mk, int num, String delim) {
        Key[] ks = new Key[num];
        String n = mk != null ? mk.toString() : "noname";
        String suffix = "";
        if (n.endsWith(".hex")) {
            n = n.substring(0, n.length() - 4);
            suffix = ".hex";
        }
        for (int i = 0; i < num; ++i) {
            ks[i] = Key.make(n + delim + i + suffix);
        }
        return ks;
    }

    public static double sparseRatio(Chunk[] chks) {
        double cnt = 0.0;
        double reg = 1.0 / (double)chks.length;
        for (Chunk c : chks) {
            if (c.isSparseNA()) {
                cnt += (double)c.sparseLenNA() / (double)c.len();
                continue;
            }
            if (c.isSparseZero()) {
                cnt += (double)c.sparseLenZero() / (double)c.len();
                continue;
            }
            cnt += 1.0;
        }
        return cnt * reg;
    }

    public static double sparseRatio(Frame fr) {
        double reg = 1.0 / (double)fr.numCols();
        double res = 0.0;
        for (Vec v : fr.vecs()) {
            res += v.sparseRatio();
        }
        return res * reg;
    }

    public static void cleanUp(IcedHashMap<Key, String> toDelete) {
        if (toDelete == null) {
            return;
        }
        Futures fs = new Futures();
        for (Key k : toDelete.keySet()) {
            Keyed.remove(k, fs, true);
        }
        fs.blockForPending();
        toDelete.clear();
    }

    public static void shrinkDomainsToObservedSubset(Frame frameToModifyInPlace) {
        for (Vec v : frameToModifyInPlace.vecs()) {
            if (!v.isCategorical()) continue;
            long[] uniques = v.min() >= 0.0 && v.max() < 2.147483643E9 ? ((VecUtils.CollectDomainFast)new VecUtils.CollectDomainFast((int)v.max()).doAll(v)).domain() : ((VecUtils.CollectIntegerDomain)new VecUtils.CollectIntegerDomain().doAll(v)).domain();
            String[] newDomain = new String[uniques.length];
            final int[] fromTo = new int[(int)ArrayUtils.maxValue(uniques) + 1];
            for (int i = 0; i < newDomain.length; ++i) {
                newDomain[i] = v.domain()[(int)uniques[i]];
                fromTo[(int)uniques[i]] = i;
            }
            new MRTask(){

                @Override
                public void map(Chunk c) {
                    for (int i = 0; i < c._len; ++i) {
                        if (c.isNA(i)) continue;
                        c.set(i, fromTo[(int)c.at8(i)]);
                    }
                }
            }.doAll(v);
            v.setDomain(newDomain);
        }
    }

    public static void delete(Lockable ... frs) {
        for (Lockable l : frs) {
            if (l == null) continue;
            l.delete();
        }
    }

    public static void labelRows(Frame frame, String labelColumnName) {
        Vec labelVec = Vec.makeSeq(1L, frame.numRows());
        frame.add(labelColumnName, labelVec);
    }

    private static String getCurrConstraintName(int id, Vec constraintsNames, BufferedString tmpStr) {
        String currConstraintName;
        if (constraintsNames.isString()) {
            currConstraintName = constraintsNames.atStr(tmpStr, id).toString();
        } else if (constraintsNames.isCategorical()) {
            currConstraintName = constraintsNames.domain()[id];
        } else {
            throw new IllegalArgumentException("Illegal beta constraints file, names column expected to contain column names (strings)");
        }
        return currConstraintName;
    }

    private static void writeNewRow(String name, Frame betaConstraints, NewChunk[] nc, int id) {
        nc[0].addStr(name);
        for (int k = 1; k < nc.length; ++k) {
            nc[k].addNum(betaConstraints.vec(k).at(id));
        }
    }

    public static Frame encodeBetaConstraints(Key key, String[] coefNames, String[] coefOriginalNames, Frame betaConstraints) {
        int ncols = betaConstraints.numCols();
        AppendableVec[] appendableVecs = new AppendableVec[ncols];
        NewChunk[] ncs = new NewChunk[ncols];
        Key<Vec>[] keys = Vec.VectorGroup.VG_LEN1.addVecs(ncols);
        for (int i = 0; i < appendableVecs.length; ++i) {
            appendableVecs[i] = new AppendableVec(keys[i], i == 0 ? (byte)2 : betaConstraints.vec(i).get_type());
        }
        Futures fs = new Futures();
        int chunknum = 0;
        if (ncs[0] == null) {
            for (int i = 0; i < ncols; ++i) {
                ncs[i] = new NewChunk(appendableVecs[i], chunknum);
            }
        }
        Vec constraintsNames = betaConstraints.vec(0);
        BufferedString tmpStr = new BufferedString();
        int i = 0;
        while ((long)i < constraintsNames.length()) {
            String currConstraintName = FrameUtils.getCurrConstraintName(i, constraintsNames, tmpStr);
            for (int j = 0; j < coefNames.length; ++j) {
                if (coefNames[j].equals(currConstraintName)) {
                    FrameUtils.writeNewRow(currConstraintName, betaConstraints, ncs, i);
                    continue;
                }
                if (Arrays.asList(coefNames).contains(currConstraintName) || !Arrays.asList(coefOriginalNames).contains(currConstraintName) || !coefNames[j].startsWith(currConstraintName)) continue;
                FrameUtils.writeNewRow(coefNames[j], betaConstraints, ncs, i);
            }
            ++i;
        }
        if (ncs[0] != null) {
            for (i = 0; i < ncols; ++i) {
                ncs[i].close(chunknum, fs);
            }
            ncs[0] = null;
        }
        Vec[] vecs = new Vec[ncols];
        int rowLayout = appendableVecs[0].compute_rowLayout();
        for (int i2 = 0; i2 < appendableVecs.length; ++i2) {
            vecs[i2] = appendableVecs[i2].close(rowLayout, fs);
        }
        fs.blockForPending();
        Frame fr = new Frame(key, betaConstraints.names(), vecs);
        if (key != null) {
            DKV.put(fr);
        }
        return fr;
    }

    public static Chunk[] extractChunks(Frame fr, int chunkId, boolean runLocal) {
        Vec v0 = fr.anyVec();
        Vec[] vecs = fr.vecs();
        Chunk[] chunks = new Chunk[vecs.length];
        for (int i = 0; i < vecs.length; ++i) {
            if (vecs[i] == null) continue;
            assert (runLocal || vecs[i].chunkKey(chunkId).home()) : "Chunk=" + chunkId + " v0=" + v0 + ", k=" + v0.chunkKey(chunkId) + "   v[" + i + "]=" + vecs[i] + ", k=" + vecs[i].chunkKey(chunkId);
            chunks[i] = vecs[i].chunkForChunkIdx(chunkId);
        }
        return chunks;
    }

    public static class CalculateWeightMeanSTD
    extends MRTask<CalculateWeightMeanSTD> {
        public double _weightedEleSum;
        public double _weightedEleSqSum;
        public double _weightedCount;
        public double _weightedMean;
        public double _weightedSigma;
        public long _nonZeroWeightsNum;

        @Override
        public void map(Chunk pcs, Chunk wcs) {
            this._weightedEleSum = 0.0;
            this._weightedEleSqSum = 0.0;
            this._weightedCount = 0.0;
            this._nonZeroWeightsNum = 0L;
            assert (pcs._len == wcs._len) : "Prediction and weight chunk should have the same length.";
            for (int rindex = 0; rindex < pcs._len; ++rindex) {
                double weight = wcs.atd(rindex);
                double pvalue = pcs.atd(rindex);
                if (Double.isNaN(pvalue) || !(Math.abs(weight) > 0.0) || Double.isNaN(pvalue)) continue;
                double v1 = pvalue * wcs.atd(rindex);
                this._weightedEleSum += v1;
                this._weightedEleSqSum += v1 * pvalue;
                this._weightedCount += wcs.atd(rindex);
                ++this._nonZeroWeightsNum;
            }
        }

        @Override
        public void reduce(CalculateWeightMeanSTD other) {
            this._weightedEleSum += other._weightedEleSum;
            this._weightedEleSqSum += other._weightedEleSqSum;
            this._weightedCount += other._weightedCount;
            this._nonZeroWeightsNum += other._nonZeroWeightsNum;
        }

        @Override
        public void postGlobal() {
            this._weightedMean = this._weightedCount == 0.0 ? Double.NaN : this._weightedEleSum / this._weightedCount;
            double scale = this._nonZeroWeightsNum == 1L ? (double)this._nonZeroWeightsNum * 1.0 : (double)this._nonZeroWeightsNum - 1.0;
            double scaling = (double)this._nonZeroWeightsNum * 1.0 / scale;
            this._weightedSigma = this._weightedCount == 0.0 ? Double.NaN : Math.sqrt((this._weightedEleSqSum / this._weightedCount - this._weightedMean * this._weightedMean) * scaling);
        }

        public double getWeightedMean() {
            return this._weightedMean;
        }

        public double getWeightedSigma() {
            return this._weightedSigma;
        }
    }

    public static class CategoricalEigenEncoder {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;
        final ToEigenVec _tev;

        public CategoricalEigenEncoder(ToEigenVec tev, Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
            this._tev = tev;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalEigenEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalEigenEncoderDriver(this._tev, this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalEigenEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;
            final ToEigenVec _tev;

            CategoricalEigenEncoderDriver(ToEigenVec tev, Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._tev = tev;
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
                assert (this._tev != null) : "Override toEigenVec for this Algo!";
            }

            @Override
            public void compute2() {
                int i;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] extraVecs = new Vec[this._skipCols == null ? 0 : this._skipCols.length];
                for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                    Vec v;
                    Vec vec = v = this._skipCols == null || this._skipCols.length <= i2 ? null : this._frame.vec(this._skipCols[i2]);
                    if (v == null) continue;
                    extraVecs[i2] = v;
                }
                Frame outputFrame = new Frame(this._destKey);
                for (i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    if (frameVecs[i].isCategorical()) {
                        outputFrame.add(this._frame.name(i) + ".Eigen", this._tev.toEigenVec(frameVecs[i]));
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                for (i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalEnumLimitedEncoder {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;
        final int _maxLevels;

        public CategoricalEnumLimitedEncoder(int maxLevels, Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
            this._maxLevels = maxLevels;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalEnumLimited");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalEnumLimitedDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalEnumLimitedDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalEnumLimitedDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                int i;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] extraVecs = new Vec[this._skipCols == null ? 0 : this._skipCols.length];
                for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                    Vec v;
                    Vec vec = v = this._skipCols == null || this._skipCols.length <= i2 ? null : this._frame.vec(this._skipCols[i2]);
                    if (v == null) continue;
                    extraVecs[i2] = v;
                }
                Frame outputFrame = new Frame(this._destKey);
                for (i = 0; i < frameVecs.length; ++i) {
                    Vec src = frameVecs[i];
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    if (src.cardinality() > CategoricalEnumLimitedEncoder.this._maxLevels && !src.isDomainTruncated(CategoricalEnumLimitedEncoder.this._maxLevels)) {
                        Key<Frame> source = Key.make();
                        Key<Frame> dest = Key.make();
                        Frame train = new Frame(source, new String[]{"enum"}, new Vec[]{src});
                        DKV.put(train);
                        Log.info("Reducing the cardinality of a categorical column with " + src.cardinality() + " levels to " + CategoricalEnumLimitedEncoder.this._maxLevels);
                        train = Interaction.getInteraction(train._key, train.names(), CategoricalEnumLimitedEncoder.this._maxLevels).execImpl(dest).get();
                        outputFrame.add(this._frame.name(i) + ".top_" + CategoricalEnumLimitedEncoder.this._maxLevels + "_levels", train.anyVec().makeCopy());
                        train.remove();
                        DKV.remove(source);
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                for (i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalBinaryEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalBinaryEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalBinaryEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalBinaryEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalBinaryEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalBinaryEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                Vec[] extraVecs;
                Vec[] frameVecs = this._frame.vecs();
                int numCategoricals = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (!frameVecs[i].isCategorical() || this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) != -1) continue;
                    ++numCategoricals;
                }
                Vec[] vecArray = extraVecs = this._skipCols == null ? null : new Vec[this._skipCols.length];
                if (extraVecs != null) {
                    for (int i = 0; i < extraVecs.length; ++i) {
                        Vec v = this._frame.vec(this._skipCols[i]);
                        if (v == null) continue;
                        extraVecs[i] = v;
                    }
                }
                Frame categoricalFrame = new Frame(new Vec[0]);
                Frame outputFrame = new Frame(this._destKey);
                int[] binaryCategorySizes = new int[numCategoricals];
                int numOutputColumns = 0;
                int j = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        categoricalFrame.add(this._frame.name(i), frameVecs[i]);
                        binaryCategorySizes[j] = 1 + MathUtils.log2(numCategories - 1 + 1);
                        numOutputColumns += binaryCategorySizes[j];
                        ++j;
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                BinaryConverter mrtask = new BinaryConverter(binaryCategorySizes);
                Frame binaryCols = ((BinaryConverter)mrtask.doAll(numOutputColumns, (byte)3, categoricalFrame)).outputFrame();
                int i = 0;
                int j2 = 0;
                while (i < binaryCategorySizes.length) {
                    for (int k = 0; k < binaryCategorySizes[i]; ++k) {
                        binaryCols._names[j2 + k] = categoricalFrame.name(i) + ":" + k;
                    }
                    j2 += binaryCategorySizes[i++];
                }
                outputFrame.add(binaryCols);
                if (this._skipCols != null) {
                    for (i = 0; i < extraVecs.length; ++i) {
                        if (extraVecs[i] == null) continue;
                        outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                    }
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }

            class BinaryConverter
            extends MRTask<BinaryConverter> {
                int[] _categorySizes;

                public BinaryConverter(int[] categorySizes) {
                    this._categorySizes = categorySizes;
                }

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int targetColOffset = 0;
                    for (int iCol = 0; iCol < cs.length; ++iCol) {
                        Chunk col = cs[iCol];
                        int numTargetColumns = this._categorySizes[iCol];
                        for (int iRow = 0; iRow < col._len; ++iRow) {
                            long val = col.isNA(iRow) ? 0L : 1L + col.at8(iRow);
                            for (int j = 0; j < numTargetColumns; ++j) {
                                ncs[targetColOffset + j].addNum(val & 1L, 0);
                                val >>>= 1;
                            }
                            assert (val == 0L) : "";
                        }
                        targetColOffset += numTargetColumns;
                    }
                }
            }
        }
    }

    public static class CategoricalLabelEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalLabelEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalLabelEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalLabelEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalLabelEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalLabelEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                int i;
                Vec[] extraVecs;
                Vec[] frameVecs = this._frame.vecs();
                Vec[] vecArray = extraVecs = this._skipCols == null ? null : new Vec[this._skipCols.length];
                if (extraVecs != null) {
                    for (int i2 = 0; i2 < extraVecs.length; ++i2) {
                        Vec v = this._frame.vec(this._skipCols[i2]);
                        if (v == null) continue;
                        extraVecs[i2] = v;
                    }
                }
                Frame outputFrame = new Frame(this._destKey);
                boolean j = false;
                for (i = 0; i < frameVecs.length; ++i) {
                    if (this._skipCols != null && ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        outputFrame.add(this._frame.name(i), frameVecs[i].toNumericVec());
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                if (this._skipCols != null) {
                    for (i = 0; i < extraVecs.length; ++i) {
                        if (extraVecs[i] == null) continue;
                        outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                    }
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }
        }
    }

    public static class CategoricalOneHotEncoder
    extends Iced {
        final Frame _frame;
        Job<Frame> _job;
        final String[] _skipCols;

        public CategoricalOneHotEncoder(Frame dataset, String[] skipCols) {
            this._frame = dataset;
            this._skipCols = skipCols;
        }

        public Job<Frame> exec() {
            if (this._frame == null) {
                throw new IllegalArgumentException("Frame doesn't exist.");
            }
            Key<Frame> destKey = Key.makeSystem(Key.make().toString());
            this._job = new Job(destKey, Frame.class.getName(), "CategoricalOneHotEncoder");
            int workAmount = this._frame.lastVec().nChunks();
            return this._job.start(new CategoricalOneHotEncoderDriver(this._frame, destKey, this._skipCols), workAmount);
        }

        class CategoricalOneHotEncoderDriver
        extends H2O.H2OCountedCompleter {
            final Frame _frame;
            final Key<Frame> _destKey;
            final String[] _skipCols;

            CategoricalOneHotEncoderDriver(Frame frame, Key<Frame> destKey, String[] skipCols) {
                this._frame = frame;
                this._destKey = destKey;
                this._skipCols = skipCols;
            }

            @Override
            public void compute2() {
                Vec[] frameVecs = this._frame.vecs();
                int numCategoricals = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (!frameVecs[i].isCategorical() || ArrayUtils.find(this._skipCols, this._frame._names[i]) != -1) continue;
                    ++numCategoricals;
                }
                Vec[] extraVecs = new Vec[this._skipCols.length];
                for (int i = 0; i < extraVecs.length; ++i) {
                    Vec v = this._frame.vec(this._skipCols[i]);
                    if (v == null) continue;
                    extraVecs[i] = v;
                }
                Frame categoricalFrame = new Frame(new Vec[0]);
                Frame outputFrame = new Frame(this._destKey);
                int[] categorySizes = new int[numCategoricals];
                int numOutputColumns = 0;
                ArrayList<String> catnames = new ArrayList<String>();
                int j = 0;
                for (int i = 0; i < frameVecs.length; ++i) {
                    if (ArrayUtils.find(this._skipCols, this._frame._names[i]) >= 0) continue;
                    int numCategories = frameVecs[i].cardinality();
                    if (numCategories > 0) {
                        categoricalFrame.add(this._frame.name(i), frameVecs[i]);
                        categorySizes[j] = numCategories + 1;
                        numOutputColumns += categorySizes[j];
                        for (int k = 0; k < categorySizes[j] - 1; ++k) {
                            catnames.add(this._frame.name(i) + "." + this._frame.vec(i).domain()[k]);
                        }
                        catnames.add(this._frame.name(i) + ".missing(NA)");
                        ++j;
                        continue;
                    }
                    outputFrame.add(this._frame.name(i), frameVecs[i].makeCopy());
                }
                OneHotConverter mrtask = new OneHotConverter(categorySizes);
                Frame binaryCols = ((OneHotConverter)mrtask.doAll(numOutputColumns, (byte)3, categoricalFrame)).outputFrame();
                binaryCols.setNames(catnames.toArray(new String[0]));
                outputFrame.add(binaryCols);
                for (int i = 0; i < extraVecs.length; ++i) {
                    if (extraVecs[i] == null) continue;
                    outputFrame.add(this._skipCols[i], extraVecs[i].makeCopy());
                }
                DKV.put(outputFrame);
                this.tryComplete();
            }

            class OneHotConverter
            extends MRTask<OneHotConverter> {
                int[] _categorySizes;

                public OneHotConverter(int[] categorySizes) {
                    this._categorySizes = categorySizes;
                }

                @Override
                public void map(Chunk[] cs, NewChunk[] ncs) {
                    int targetColOffset = 0;
                    for (int iCol = 0; iCol < cs.length; ++iCol) {
                        Chunk col = cs[iCol];
                        int numTargetColumns = this._categorySizes[iCol];
                        for (int iRow = 0; iRow < col._len; ++iRow) {
                            long val = col.isNA(iRow) ? (long)(numTargetColumns - 1) : col.at8(iRow);
                            for (int j = 0; j < numTargetColumns; ++j) {
                                ncs[targetColOffset + j].addNum(val == (long)j ? 1L : 0L, 0);
                            }
                        }
                        targetColOffset += numTargetColumns;
                    }
                }
            }
        }
    }

    public static class ExportTaskDriver
    extends H2O.H2OCountedCompleter<ExportTaskDriver> {
        private static int BUFFER_SIZE = 0x800000;
        private static long DEFAULT_TARGET_PART_SIZE = 0x8000000L;
        private static int AUTO_PARTS_MAX = 128;
        final Frame _frame;
        final String _path;
        final String _frameName;
        final boolean _overwrite;
        final Job _j;
        int _nParts;
        boolean _parallel;
        final CompressionFactory _compressor;
        final Frame.CSVStreamParams _csv_parms;

        public ExportTaskDriver(Frame frame, String path, String frameName, boolean overwrite, Job j, int nParts, boolean perChunk, CompressionFactory compressor, Frame.CSVStreamParams csvParms) {
            this._frame = frame;
            this._path = path;
            this._frameName = frameName;
            this._overwrite = overwrite;
            this._j = j;
            this._nParts = nParts;
            this._parallel = perChunk;
            this._compressor = compressor;
            this._csv_parms = csvParms;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compute2() {
            this._frame.read_lock(this._j._key);
            if (this._parallel && this._nParts == 1) {
                this._nParts = this._frame.anyVec().nChunks();
                int processed = 0;
                String compression = H2O.getSysProperty("export.csv.cache.compression", "none");
                CompressionFactory compressor = CompressionFactory.make(compression);
                DecompressionFactory decompressor = DecompressionFactory.make(compression);
                String cacheStorage = H2O.getSysProperty("export.csv.cache.storage", "memory");
                CsvChunkCache cache = "memory".equals(cacheStorage) ? new DkvCsvChunkCache() : new FileSystemCsvChunkCache();
                Log.info("Using compression=`" + compressor.getName() + "` and cache=`" + cache.getName() + "` for interim partial CSV export files.");
                ChunkExportTask chunkExportTask = cache.makeExportTask(this._frame, this._csv_parms, compressor);
                H2O.submitTask(new LocalMR((MrFun)chunkExportTask, H2O.NUMCPUS));
                try (FileOutputStream os = new FileOutputStream(this._path);){
                    byte[] buffer = new byte[BUFFER_SIZE];
                    boolean[] isChunkCompleted = new boolean[this._nParts + 1];
                    while (processed != this._nParts) {
                        int cid = (Integer)chunkExportTask._completed.take();
                        isChunkCompleted[cid] = true;
                        while (isChunkCompleted[processed]) {
                            try (InputStream rawInputStream = cache.getChunkCsvStream(chunkExportTask, processed);
                                 InputStream is = decompressor.wrapInputStream(rawInputStream);){
                                IOUtils.copyLarge((InputStream)is, (OutputStream)os, (byte[])buffer);
                            }
                            finally {
                                cache.releaseCache(chunkExportTask, processed);
                            }
                            ++processed;
                            this._j.update(1L);
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("File export failed", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("File export interrupted", e);
                }
                this.tryComplete();
            } else if (this._nParts == 1) {
                Frame.CSVStream is = new Frame.CSVStream(this._frame, this._csv_parms);
                this.exportCSVStream(is, this._path, 0);
                this.tryComplete();
            } else {
                if (this._nParts < 0) {
                    this._nParts = this.calculateNParts(this._csv_parms);
                    assert (this._nParts > 0);
                }
                int nChunksPerPart = (this._frame.anyVec().nChunks() - 1) / this._nParts + 1;
                new PartExportTask(this, this._frame._names, nChunksPerPart, this._csv_parms).dfork(this._frame);
            }
        }

        @Override
        public void onCompletion(CountedCompleter caller) {
            this._frame.unlock(this._j);
        }

        @Override
        public boolean onExceptionalCompletion(Throwable t, CountedCompleter caller) {
            this._frame.unlock(this._j);
            return super.onExceptionalCompletion(t, caller);
        }

        private int calculateNParts(Frame.CSVStreamParams parms) {
            EstimateSizeTask estSize = (EstimateSizeTask)((EstimateSizeTask)new EstimateSizeTask(parms).dfork(this._frame)).getResult();
            Log.debug("Estimator result: ", estSize);
            int nParts = Math.max((int)(estSize._size / DEFAULT_TARGET_PART_SIZE), H2O.CLOUD.size() + 1);
            if (nParts > AUTO_PARTS_MAX) {
                Log.debug("Recommended number of part files (" + nParts + ") exceeds maximum limit " + AUTO_PARTS_MAX + ". Number of part files is limited to avoid slow downs when importing back to H2O.");
                nParts = AUTO_PARTS_MAX;
            }
            Log.info("For file of estimated size " + estSize + "B determined number of parts: " + this._nParts);
            return nParts;
        }

        private long copyCSVStream(Frame.CSVStream is, OutputStream os, int firstChkIdx) throws IOException {
            int count;
            long len = 0L;
            byte[] bytes = new byte[BUFFER_SIZE];
            int curChkIdx = firstChkIdx;
            while ((count = is.read(bytes, 0, BUFFER_SIZE)) > 0) {
                len += (long)count;
                os.write(bytes, 0, count);
                int workDone = is._curChkIdx - curChkIdx;
                if (workDone <= 0) continue;
                if (this._j.stop_requested()) {
                    throw new Job.JobCancelledException();
                }
                this._j.update(workDone);
                curChkIdx = is._curChkIdx;
            }
            return len;
        }

        private void exportCSVStream(Frame.CSVStream is, String path, int firstChkIdx) {
            this.exportCSVStream(is, path, firstChkIdx, this._compressor);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void exportCSVStream(Frame.CSVStream is, String path, int firstChkIdx, CompressionFactory compressor) {
            block14: {
                OutputStream os = null;
                long written = -1L;
                try {
                    os = H2O.getPM().create(path, this._overwrite);
                    if (compressor != null) {
                        os = compressor.wrapOutputStream(os);
                    }
                    written = this.copyCSVStream(is, os, firstChkIdx);
                    if (os == null) break block14;
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (os != null) {
                            try {
                                os.flush();
                                os.close();
                                Log.info("Written " + written + " bytes of key '" + this._frameName + "' to " + this._path + ".");
                            }
                            catch (Exception e2) {
                                Log.err(e2);
                            }
                        }
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (Exception e3) {
                            Log.err(e3);
                        }
                        throw throwable;
                    }
                }
                try {
                    os.flush();
                    os.close();
                    Log.info("Written " + written + " bytes of key '" + this._frameName + "' to " + this._path + ".");
                }
                catch (Exception e) {
                    Log.err(e);
                }
            }
            try {
                is.close();
                return;
            }
            catch (Exception e) {
                Log.err(e);
                return;
            }
        }

        class InMemoryChunkExportTask
        extends ChunkExportTask {
            private final Key<?> _k;

            InMemoryChunkExportTask(Key<?> k, Frame fr, String[] colNames, Frame.CSVStreamParams csvParms, CompressionFactory compressor) {
                super(fr, colNames, csvParms, compressor);
                this._k = k;
            }

            @Override
            String getChunkPath(int cid) {
                return H2O.getPM().toHexPath(Vec.chunkKey(this._k, cid));
            }
        }

        class ChunkExportTask
        extends MrFun<ChunkExportTask> {
            private final transient AtomicInteger _chunkIndex = new AtomicInteger(-1);
            private final transient BlockingQueue<Integer> _completed = new LinkedBlockingQueue<Integer>();
            final Frame _fr;
            final String[] _colNames;
            final Frame.CSVStreamParams _csv_parms;
            final CompressionFactory _compressor;

            ChunkExportTask(Frame fr, String[] colNames, Frame.CSVStreamParams csvParms, CompressionFactory compressor) {
                this._fr = fr;
                this._colNames = colNames;
                this._csv_parms = csvParms;
                this._compressor = compressor;
            }

            @Override
            protected void map(int id) {
                int cid;
                int nChunks = this._fr.anyVec().nChunks();
                while ((cid = this._chunkIndex.incrementAndGet()) < nChunks) {
                    Chunk[] cs = new Chunk[this._fr.numCols()];
                    for (int i = 0; i < cs.length; ++i) {
                        Vec v = this._fr.vec(i);
                        cs[i] = v.chunkForChunkIdx(cid);
                    }
                    String chunkPath = this.getChunkPath(cid);
                    Frame.CSVStream is = new Frame.CSVStream(cs, cid == 0 ? this._colNames : null, 1, this._csv_parms);
                    ExportTaskDriver.this.exportCSVStream(is, chunkPath, cid, this._compressor);
                    this._completed.add(cid);
                }
            }

            String getChunkPath(int cid) {
                return ExportTaskDriver.this._path + ".chunk-" + String.valueOf(100000 + cid).substring(1);
            }
        }

        class PartExportTask
        extends MRTask<PartExportTask> {
            final String[] _colNames;
            final int _length;
            final Frame.CSVStreamParams _csv_parms;

            PartExportTask(H2O.H2OCountedCompleter<?> completer, String[] colNames, int length, Frame.CSVStreamParams csvParms) {
                super(completer);
                this._colNames = colNames;
                this._length = length;
                this._csv_parms = csvParms;
            }

            @Override
            public void map(Chunk[] cs) {
                Chunk anyChunk = cs[0];
                if (anyChunk.cidx() % this._length > 0) {
                    return;
                }
                int partIdx = anyChunk.cidx() / this._length;
                String partPath = ExportTaskDriver.this._path + "/part-m-" + String.valueOf(100000 + partIdx).substring(1);
                Frame.CSVStream is = new Frame.CSVStream(cs, this._colNames, this._length, this._csv_parms);
                ExportTaskDriver.this.exportCSVStream(is, partPath, anyChunk.cidx());
            }

            @Override
            protected void setupLocal() {
                boolean created = H2O.getPM().mkdirs(ExportTaskDriver.this._path);
                if (!created) {
                    Log.warn("Path ", ExportTaskDriver.this._path, " was not created.");
                }
            }
        }

        class EstimateSizeTask
        extends MRTask<EstimateSizeTask> {
            private final Frame.CSVStreamParams _parms;
            int _nNonEmpty;
            long _size;

            public EstimateSizeTask(Frame.CSVStreamParams parms) {
                this._parms = parms;
            }

            @Override
            public void map(Chunk[] cs) {
                if (cs[0]._len == 0) {
                    return;
                }
                try (Frame.CSVStream is = new Frame.CSVStream(cs, null, 1, this._parms);){
                    ++this._nNonEmpty;
                    this._size += (long)(is.getCurrentRowSize() * cs[0]._len);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public void reduce(EstimateSizeTask mrt) {
                this._nNonEmpty += mrt._nNonEmpty;
                this._size += mrt._size;
            }

            public String toString() {
                return "EstimateSizeTask{_nNonEmpty=" + this._nNonEmpty + ", _size=" + this._size + '}';
            }
        }

        private class DkvCsvChunkCache
        implements CsvChunkCache {
            private final Key<?> _vecKey = Vec.newKey();

            @Override
            public String getName() {
                return "DKV";
            }

            @Override
            public ChunkExportTask makeExportTask(Frame f, Frame.CSVStreamParams csvParams, CompressionFactory compressor) {
                return new InMemoryChunkExportTask(this._vecKey, f, f._names, csvParams, compressor);
            }

            @Override
            public InputStream getChunkCsvStream(ChunkExportTask task, int cid) {
                Key ck = Vec.chunkKey(this._vecKey, cid);
                PersistManager pm = H2O.getPM();
                return pm.open(pm.toHexPath(ck));
            }

            @Override
            public void releaseCache(ChunkExportTask task, int cid) {
                Key ck = Vec.chunkKey(this._vecKey, cid);
                DKV.remove(ck);
            }
        }

        private class FileSystemCsvChunkCache
        implements CsvChunkCache {
            private FileSystemCsvChunkCache() {
            }

            @Override
            public String getName() {
                return "FileSystem";
            }

            @Override
            public ChunkExportTask makeExportTask(Frame f, Frame.CSVStreamParams csvParams, CompressionFactory compressor) {
                return new ChunkExportTask(f, f._names, csvParams, compressor);
            }

            @Override
            public InputStream getChunkCsvStream(ChunkExportTask task, int cid) throws IOException {
                File chunkFile = new File(task.getChunkPath(cid));
                return new FileInputStream(chunkFile);
            }

            @Override
            public void releaseCache(ChunkExportTask task, int cid) {
                File chunkFile = new File(task.getChunkPath(cid));
                if (!chunkFile.delete()) {
                    Log.warn("Temporary file " + chunkFile.getAbsoluteFile() + " couldn't be deleted.");
                }
            }
        }

        private static interface CsvChunkCache {
            public String getName();

            public ChunkExportTask makeExportTask(Frame var1, Frame.CSVStreamParams var2, CompressionFactory var3);

            public InputStream getChunkCsvStream(ChunkExportTask var1, int var2) throws IOException;

            public void releaseCache(ChunkExportTask var1, int var2);
        }
    }

    public static class WeightedMean
    extends MRTask<WeightedMean> {
        private double _wresponse;
        private double _wsum;

        public double weightedMean() {
            return this._wsum == 0.0 ? 0.0 : this._wresponse / this._wsum;
        }

        @Override
        public void map(Chunk response, Chunk weight, Chunk offset) {
            for (int i = 0; i < response._len; ++i) {
                double w;
                if (response.isNA(i) || (w = weight.atd(i)) == 0.0) continue;
                this._wresponse += w * (response.atd(i) - offset.atd(i));
                this._wsum += w;
            }
        }

        @Override
        public void reduce(WeightedMean mrt) {
            this._wresponse += mrt._wresponse;
            this._wsum += mrt._wsum;
        }
    }

    public static class MissingInserter
    extends Iced {
        Job<Frame> _job;
        final Key<Frame> _dataset;
        final double _fraction;
        final long _seed;

        public MissingInserter(Key<Frame> frame, long seed, double frac) {
            this._dataset = frame;
            this._seed = seed;
            this._fraction = frac;
        }

        public Job<Frame> execImpl() {
            this._job = new Job<Frame>(this._dataset, Frame.class.getName(), "MissingValueInserter");
            if (DKV.get(this._dataset) == null) {
                throw new IllegalArgumentException("Invalid Frame key " + this._dataset + " (Frame doesn't exist).");
            }
            if (this._fraction < 0.0 || this._fraction > 1.0) {
                throw new IllegalArgumentException("fraction must be between 0 and 1.");
            }
            Frame frame = (Frame)DKV.getGet(this._dataset);
            MissingInserterDriver mid = new MissingInserterDriver(frame);
            int work = frame.vecs()[0].nChunks();
            return this._job.start(mid, work);
        }

        class MissingInserterDriver
        extends H2O.H2OCountedCompleter {
            final transient Frame _frame;

            MissingInserterDriver(Frame frame) {
                this._frame = frame;
            }

            @Override
            public void compute2() {
                new MRTask(){

                    @Override
                    public void map(Chunk[] cs) {
                        Random rng = RandomUtils.getRNG(0L);
                        for (int c = 0; c < cs.length; ++c) {
                            for (int r = 0; r < cs[c]._len; ++r) {
                                rng.setSeed(MissingInserter.this._seed + (long)(1234 * c) ^ 1723L * (cs[c].start() + (long)r));
                                if (!(rng.nextDouble() < MissingInserter.this._fraction)) continue;
                                cs[c].setNA(r);
                            }
                        }
                        MissingInserter.this._job.update(1L);
                    }
                }.doAll(this._frame);
                this.tryComplete();
            }
        }
    }

    private static class Vec2IntArryTsk
    extends MRTask<Vec2IntArryTsk> {
        final int N;
        public int[] res;

        public Vec2IntArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc4(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = (int)c.at8(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2IntArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0 || other.res[i] == 0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }

    public static class Vecs2ArryTsk
    extends MRTask<Vecs2ArryTsk> {
        final int dim1;
        final int dim2;
        public double[][] res;

        public Vecs2ArryTsk(int dim1, int dim2) {
            this.dim1 = dim1;
            this.dim2 = dim2;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc8d(this.dim1, this.dim2);
        }

        @Override
        public void map(Chunk[] c) {
            int off = (int)c[0].start();
            for (int colIndex = 0; colIndex < this.dim2; ++colIndex) {
                for (int rowIndex = 0; rowIndex < this.dim1; ++rowIndex) {
                    this.res[off + rowIndex][colIndex] = c[colIndex].atd(rowIndex);
                }
            }
        }

        @Override
        public void reduce(Vecs2ArryTsk other) {
            ArrayUtils.add(this.res, other.res);
        }
    }

    public static class Vec2ArryTsk
    extends MRTask<Vec2ArryTsk> {
        final int N;
        public double[] res;

        public Vec2ArryTsk(int N) {
            this.N = N;
        }

        @Override
        public void setupLocal() {
            this.res = MemoryManager.malloc8d(this.N);
        }

        @Override
        public void map(Chunk c) {
            int off = (int)c.start();
            int i = 0;
            while (i < c._len) {
                this.res[off + i] = c.atd(i);
                i = c.nextNZ(i);
            }
        }

        @Override
        public void reduce(Vec2ArryTsk other) {
            if (this.res != other.res) {
                for (int i = 0; i < this.res.length; ++i) {
                    assert (this.res[i] == 0.0 || other.res[i] == 0.0);
                    int n = i;
                    this.res[n] = this.res[n] + other.res[i];
                }
            }
        }
    }
}

