/*
 * Decompiled with CFR 0.152.
 */
package hex.grid;

import java.util.Map;
import java.util.TreeMap;
import water.AutoBuffer;
import water.H2O;
import water.Iced;

public class HyperParameters
extends Iced<HyperParameters> {
    private transient Map<String, Object[]> values;

    public HyperParameters(Map<String, Object[]> values) {
        this.values = values;
    }

    public Map<String, Object[]> getValues() {
        return this.values;
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        this.writeHyperParamsMap(ab, this.values);
        return ab;
    }

    private void writeHyperParamsMap(AutoBuffer ab, Map<String, Object[]> params) {
        ab.putInt(params.keySet().size());
        for (String key : params.keySet()) {
            ab.putStr(key);
            Object[] vals = params.get(key);
            if (vals.length > 0 && vals[0] instanceof Map) {
                ab.putInt(vals.length);
                for (int j = 0; j < vals.length; ++j) {
                    this.writeHyperParamsMap(ab, (Map)vals[j]);
                }
                continue;
            }
            ab.putInt(-1);
            ab.putASer(vals);
        }
    }

    public final HyperParameters read_impl(AutoBuffer ab) {
        return new HyperParameters(this.readHyperParamsMap(ab));
    }

    private Map<String, Object[]> readHyperParamsMap(AutoBuffer ab) {
        TreeMap<String, Object[]> map = new TreeMap<String, Object[]>();
        int len = ab.getInt();
        for (int i = 0; i < len; ++i) {
            Object[] vals;
            String key = ab.getStr();
            int subMapsCount = ab.getInt();
            if (subMapsCount >= 0) {
                vals = new Object[subMapsCount];
                for (int j = 0; j < subMapsCount; ++j) {
                    vals[j] = this.readHyperParamsMap(ab);
                }
            } else {
                vals = ab.getASer(Object.class);
            }
            map.put(key, vals);
        }
        return map;
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final HyperParameters readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }
}

