/*
 * Decompiled with CFR 0.152.
 */
package water;

import water.H2O;
import water.TimeLine;

public class H2ONodeTimestamp {
    static final short UNDEFINED = 0;

    public static boolean isDefined(short timestamp) {
        return timestamp != 0;
    }

    private static short truncateTimestamp(long jvmStartTime) {
        int bitMask = Short.MAX_VALUE;
        short timestamp = (short)(jvmStartTime & (long)bitMask);
        return timestamp == 0 ? (short)1 : timestamp;
    }

    static short calculateNodeTimestamp() {
        return H2ONodeTimestamp.calculateNodeTimestamp(TimeLine.JVM_BOOT_MSEC, H2O.ARGS.client);
    }

    static short calculateNodeTimestamp(long bootTimestamp, boolean amIClient) {
        short timestamp = H2ONodeTimestamp.truncateTimestamp(bootTimestamp);
        return amIClient ? (short)(-timestamp) : timestamp;
    }

    static boolean decodeIsClient(short timestamp) {
        return timestamp < 0;
    }

    static boolean hasNodeRespawned(short oldTimestamp, short newTimestamp) {
        return H2ONodeTimestamp.isDefined(oldTimestamp) && H2ONodeTimestamp.isDefined(newTimestamp) && oldTimestamp != newTimestamp;
    }
}

