/*
 * Decompiled with CFR 0.152.
 */
package water.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ServiceLoader;
import water.H2O;
import water.Key;
import water.api.Handler;
import water.api.RestApiHandler;
import water.api.schemas3.InitIDV3;
import water.api.schemas3.RapidsFrameV3;
import water.api.schemas3.RapidsFunctionV3;
import water.api.schemas3.RapidsHelpV3;
import water.api.schemas3.RapidsMapFrameV3;
import water.api.schemas3.RapidsNumberV3;
import water.api.schemas3.RapidsNumbersV3;
import water.api.schemas3.RapidsSchemaV3;
import water.api.schemas3.RapidsStringV3;
import water.api.schemas3.RapidsStringsV3;
import water.api.schemas3.SchemaV3;
import water.api.schemas3.SessionPropertyV3;
import water.api.schemas4.InputSchemaV4;
import water.api.schemas4.SessionIdV4;
import water.exceptions.H2OIllegalArgumentException;
import water.rapids.Rapids;
import water.rapids.Session;
import water.rapids.Val;
import water.rapids.ast.AstRoot;
import water.util.Log;
import water.util.StringUtils;

public class RapidsHandler
extends Handler {
    public static HashMap<String, Session> SESSIONS = new HashMap();

    public RapidsSchemaV3 exec(int version, RapidsSchemaV3 rapids) {
        Val val;
        if (rapids == null) {
            return null;
        }
        if (!StringUtils.isNullOrEmpty(rapids.id)) {
            throw new H2OIllegalArgumentException("Field RapidsSchemaV3.id is deprecated and should not be set " + rapids.id);
        }
        if (StringUtils.isNullOrEmpty(rapids.ast)) {
            return rapids;
        }
        if (StringUtils.isNullOrEmpty(rapids.session_id)) {
            rapids.session_id = "_specialSess";
        }
        Session ses = this.getOrCreateSession(rapids.session_id);
        try {
            val = Rapids.exec(rapids.ast, ses);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Throwable t) {
            throw Log.throwErr(t);
        }
        switch (val.type()) {
            case 1: {
                return new RapidsNumberV3(val.getNum());
            }
            case 2: {
                return new RapidsNumbersV3(val.getNums());
            }
            case 6: {
                return new RapidsNumbersV3(val.getRow());
            }
            case 3: {
                return new RapidsStringV3(val.getStr());
            }
            case 4: {
                return new RapidsStringsV3(val.getStrs());
            }
            case 5: {
                return new RapidsFrameV3(val.getFrame());
            }
            case 9: {
                return new RapidsMapFrameV3(val.getMapFrame());
            }
            case 7: {
                return new RapidsFunctionV3(val.getFun().toString());
            }
        }
        throw H2O.fail();
    }

    public static Session getSession(String sessionId) {
        return SESSIONS.get(sessionId);
    }

    Session getOrCreateSession(String sessionId) {
        Session ses = RapidsHandler.getSession(sessionId);
        if (ses == null) {
            ses = new Session(sessionId);
            SESSIONS.put(sessionId, ses);
        }
        return ses;
    }

    public RapidsHelpV3 genHelp(int version, SchemaV3 noschema) {
        Iterator<AstRoot> iterator = ServiceLoader.load(AstRoot.class).iterator();
        ArrayList<AstRoot> rapids = new ArrayList<AstRoot>();
        while (iterator.hasNext()) {
            rapids.add(iterator.next());
        }
        ArrayList<RapidsHelpV3.RapidsExpressionV3> expressions = new ArrayList<RapidsHelpV3.RapidsExpressionV3>();
        for (AstRoot expr : rapids) {
            expressions.add(this.processAstClass(expr));
        }
        RapidsHelpV3 res = new RapidsHelpV3();
        res.expressions = expressions.toArray(new RapidsHelpV3.RapidsExpressionV3[expressions.size()]);
        return res;
    }

    private RapidsHelpV3.RapidsExpressionV3 processAstClass(AstRoot expr) {
        RapidsHelpV3.RapidsExpressionV3 target = new RapidsHelpV3.RapidsExpressionV3();
        target.name = expr.getClass().getSimpleName();
        target.pattern = expr.example();
        target.description = expr.description();
        return target;
    }

    public InitIDV3 startSession(int version, InitIDV3 p) {
        p.session_key = "_sid" + Key.make().toString().substring(0, 5);
        p.session_properties_allowed = this.sessionPropertiesAllowed();
        return p;
    }

    public InitIDV3 endSession(int version, InitIDV3 p) {
        if (SESSIONS.get(p.session_key) != null) {
            try {
                SESSIONS.get(p.session_key).end(null);
                SESSIONS.remove(p.session_key);
            }
            catch (Throwable ex) {
                throw SESSIONS.get(p.session_key).endQuietly(ex);
            }
        }
        p.session_properties_allowed = this.sessionPropertiesAllowed();
        return p;
    }

    public SessionPropertyV3 setSessionProperty(int version, SessionPropertyV3 p) {
        if (!this.sessionPropertiesAllowed()) {
            throw new IllegalStateException("Using session properties is disabled by the admin.");
        }
        Session session = this.getOrCreateSession(p.session_key);
        session.setProperty(p.key, p.value);
        return p;
    }

    public SessionPropertyV3 getSessionProperty(int version, SessionPropertyV3 p) {
        p.value = null;
        if (!this.sessionPropertiesAllowed()) {
            return p;
        }
        Session session = RapidsHandler.getSession(p.session_key);
        if (session == null) {
            return p;
        }
        p.value = session.getProperty(p.key, null);
        return p;
    }

    boolean sessionPropertiesAllowed() {
        return H2O.getSysBoolProperty("session.allow_properties", true);
    }

    public static class StartSession4
    extends RestApiHandler<InputSchemaV4, SessionIdV4> {
        @Override
        public String name() {
            return "newSession4";
        }

        @Override
        public String help() {
            return "Start a new Rapids session, and return the session id.";
        }

        @Override
        public SessionIdV4 exec(int ignored, InputSchemaV4 input) {
            SessionIdV4 out = new SessionIdV4();
            out.session_key = "_sid" + Key.make().toString().substring(0, 5);
            return out;
        }
    }
}

