/*
 * Decompiled with CFR 0.152.
 */
package water.api.schemas4.output;

import java.io.PrintWriter;
import java.io.StringWriter;
import water.Job;
import water.TypeMap;
import water.api.API;
import water.api.schemas4.OutputSchemaV4;

public class JobV4
extends OutputSchemaV4<Job<?>, JobV4> {
    @API(help="Job id")
    public String job_id;
    @API(help="Job status", values={"RUNNING", "DONE", "STOPPING", "CANCELLED", "FAILED"})
    public Status status;
    @API(help="Current progress, a number going from 0 to 1")
    public float progress;
    @API(help="Current progress status description")
    public String progress_msg;
    @API(help="Start time")
    public long start_time;
    @API(help="Runtime in milliseconds")
    public long duration;
    @API(help="Id of the target object (being created by this Job)")
    public String target_id;
    @API(help="Type of the target: Frame, Model, etc.")
    public String target_type;
    @API(help="Exception message, if an exception occurred")
    public String exception;
    @API(help="Stacktrace")
    public String stacktrace;

    @Override
    public JobV4 fillFromImpl(Job<?> job) {
        if (job == null) {
            return this;
        }
        this.job_id = job._key.toString();
        this.progress = job.progress();
        this.progress_msg = job.progress_msg();
        this.duration = job.msec();
        this.status = job.isRunning() ? (job.stop_requested() ? Status.STOPPING : Status.RUNNING) : (job.stop_requested() ? Status.CANCELLED : Status.DONE);
        Throwable ex = job.ex();
        if (ex != null) {
            this.status = Status.FAILED;
            this.exception = ex.toString();
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            this.stacktrace = sw.toString();
        }
        this.target_id = job._result == null || !job.readyForView() ? null : job._result.toString();
        this.target_type = TypeMap.theFreezable(job._typeid).getClass().getSimpleName();
        return this;
    }

    public static enum Status {
        RUNNING,
        DONE,
        STOPPING,
        CANCELLED,
        FAILED;

    }
}

