/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import water.AutoBuffer;
import water.Freezable;
import water.H2O;
import water.Iced;
import water.nbhm.NonBlockingHashMap;

public class IcedHashSet<V extends Freezable<V>>
extends Iced<IcedHashSet<V>>
implements Set<V>,
Cloneable,
Serializable {
    private volatile transient boolean _write_lock;
    private transient NonBlockingHashMap<V, V> _map;

    public IcedHashSet() {
        this.init();
    }

    private Map<V, V> init() {
        this._map = this.makeBackingMap();
        return this._map;
    }

    private NonBlockingHashMap<V, V> makeBackingMap() {
        return new NonBlockingHashMap();
    }

    public V addIfAbsent(V value) {
        assert (!this._write_lock);
        return (V)((Freezable)this._map.putIfAbsent(value, value));
    }

    public V get(V value) {
        assert (!this._write_lock);
        return (V)((Freezable)this._map.getk(value));
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object value) {
        return this._map.containsKey(value);
    }

    @Override
    public Iterator<V> iterator() {
        return this._map.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this._map.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        Objects.requireNonNull(a);
        return this._map.values().toArray(a);
    }

    @Override
    public boolean add(V v) {
        assert (!this._write_lock);
        return this._map.putIfAbsent(v, v) == null;
    }

    @Override
    public boolean remove(Object o) {
        assert (!this._write_lock);
        return this._map.remove(o, o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._map.keySet().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        assert (!this._write_lock);
        boolean added = false;
        for (Freezable item : c) {
            added |= this._map.putIfAbsent((V)item, (V)item) == null;
        }
        return added;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Operation retainAll is not yet supported on IcedHashSet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Operation removeAll is not yet supported on IcedHashSet");
    }

    @Override
    public void clear() {
        assert (!this._write_lock);
        this._map.clear();
    }

    private void writeMap(AutoBuffer ab) {
        Object[] kvs = this._map.raw_array();
        for (int i = 2; i < kvs.length; i += 2) {
            if (!(kvs[i + 1] instanceof Iced)) continue;
            ab.put((Freezable)kvs[i + 1]);
        }
    }

    public final AutoBuffer write_impl(AutoBuffer ab) {
        this._write_lock = true;
        try {
            if (this._map.size() == 0) {
                AutoBuffer autoBuffer = ab.put1(0);
                return autoBuffer;
            }
            ab.put1(1);
            this.writeMap(ab);
            AutoBuffer autoBuffer = ab.put(null);
            return autoBuffer;
        }
        catch (Exception e) {
            throw new RuntimeException("IcedHashSet serialization failed!", e);
        }
        finally {
            this._write_lock = false;
        }
    }

    public final IcedHashSet read_impl(AutoBuffer ab) {
        try {
            Object val;
            assert (this._map == null || this._map.isEmpty());
            Map map = this.init();
            if (ab.get1() == 0) {
                return this;
            }
            while ((val = ab.get()) != null) {
                map.put(val, val);
            }
            return this;
        }
        catch (Exception e) {
            throw new RuntimeException("IcedHashSet deserialization failed!", e);
        }
    }

    public final IcedHashSet readJSON_impl(AutoBuffer ab) {
        throw H2O.unimpl();
    }

    public final AutoBuffer writeJSON_impl(AutoBuffer ab) {
        boolean first = true;
        for (Freezable value : this._map.values()) {
            if (!first) {
                ab.put1(44).put1(32);
            } else {
                first = false;
            }
            if (value == null) continue;
            ab.putJSON(value);
        }
        return ab;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcedHashSet that = (IcedHashSet)o;
        return this._map != null ? this._map.equals(that._map) : that._map == null;
    }

    @Override
    public int hashCode() {
        return this._map != null ? this._map.hashCode() : 0;
    }
}

