/*
 * Decompiled with CFR 0.152.
 */
package water.persist;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import water.Futures;
import water.H2O;
import water.Key;
import water.Keyed;
import water.LocalMR;
import water.MRTask;
import water.MrFun;
import water.Value;
import water.api.FSIOException;
import water.api.HDFSIOException;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.FileVec;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.persist.Persist;
import water.persist.PersistEagerHTTP;
import water.persist.PersistFS;
import water.persist.PersistH2O;
import water.persist.PersistHex;
import water.persist.PersistNFS;
import water.util.FileUtils;
import water.util.Log;
import water.util.fp.Function2;

public class PersistManager {
    public static final int MAX_BACKENDS = 8;
    private static final String PROP_ENABLE_HDFS_FALLBACK = "sys.ai.h2o.persist.enable.hdfs.fallback";
    private static final String PROP_FORCE_HDFS_FOR_S3 = "sys.ai.h2o.persist.enable.hdfs.for.s3";
    private Persist[] I;
    private PersistHex HEX = new PersistHex();
    private PersistH2O persistH2O = new PersistH2O();
    private PersistStatsEntry[] stats;

    public PersistStatsEntry[] getStats() {
        return this.stats;
    }

    boolean isS3Path(String path) {
        String s = path.toLowerCase();
        return s.startsWith("s3:");
    }

    public boolean isHdfsPath(String path) {
        if (this.isS3Path(path) && !PersistManager.forceHdfsForS3()) {
            return false;
        }
        String s = path.toLowerCase();
        return s.startsWith("hdfs:") || s.startsWith("s3:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:") || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(path);
    }

    private void validateHdfsConfigured() {
        if (this.hdfsNotConfigured()) {
            throw new H2OIllegalArgumentException("HDFS and S3A support is not configured");
        }
    }

    private boolean hdfsNotConfigured() {
        return this.I[2] == null;
    }

    public boolean isGcsPath(String path) {
        return path.toLowerCase().startsWith("gs://");
    }

    public boolean isHexPath(String path) {
        return path.toLowerCase().startsWith("hex://");
    }

    public String toHexPath(Key<?> key) {
        if (!key.isChunkKey()) {
            throw new IllegalArgumentException("Only Chunk keys are supported for HEX schema");
        }
        return "hex://" + key;
    }

    public PersistManager(URI iceRoot) {
        Constructor<?> constructor;
        Class<?> klass;
        this.I = new Persist[8];
        this.stats = new PersistStatsEntry[8];
        for (int i = 0; i < this.stats.length; ++i) {
            this.stats[i] = new PersistStatsEntry();
        }
        if (iceRoot == null) {
            Log.err("ice_root must be specified.  Exiting.");
            H2O.exit(1);
        }
        PersistFS ice = null;
        boolean windowsPath = iceRoot.toString().matches("^[a-zA-Z]:.*");
        if (windowsPath) {
            ice = new PersistFS(new File(iceRoot.toString()));
        } else if (iceRoot.getScheme() == null || "file".equals(iceRoot.getScheme())) {
            ice = new PersistFS(new File(iceRoot.getPath()));
        } else if ("hdfs".equals(iceRoot.getScheme())) {
            Log.err("HDFS ice_root not yet supported.  Exiting.");
            H2O.exit(1);
        }
        this.I[1] = ice;
        this.I[4] = new PersistNFS();
        try {
            klass = Class.forName("water.persist.PersistHTTP");
            constructor = klass.getConstructor(new Class[0]);
            this.I[6] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("Subsystem for distributed import from HTTP/HTTPS successfully initialized");
        }
        catch (Throwable ignore) {
            this.I[6] = new PersistEagerHTTP();
            Log.info("Distributed HTTP import not available (import from HTTP/HTTPS will be eager)");
        }
        try {
            klass = Class.forName("water.persist.PersistHdfs");
            constructor = klass.getConstructor(new Class[0]);
            this.I[2] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("HDFS subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("HDFS subsystem not available");
        }
        try {
            klass = Class.forName("water.persist.PersistS3");
            constructor = klass.getConstructor(new Class[0]);
            this.I[3] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("S3 subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("S3 subsystem not available");
        }
        try {
            klass = Class.forName("water.persist.PersistGcs");
            constructor = klass.getConstructor(new Class[0]);
            this.I[5] = (Persist)constructor.newInstance(new Object[0]);
            Log.info("GCS subsystem successfully initialized");
        }
        catch (Throwable ignore) {
            Log.info("GCS subsystem not available");
        }
    }

    public void store(int backend, Value v) throws IOException {
        this.stats[backend].store_count.incrementAndGet();
        this.I[backend].store(v);
    }

    public void delete(int backend, Value v) {
        this.stats[backend].delete_count.incrementAndGet();
        this.I[backend].delete(v);
    }

    public byte[] load(int backend, Value v) throws IOException {
        this.stats[backend].load_count.incrementAndGet();
        byte[] arr = this.I[backend].load(v);
        this.stats[backend].load_bytes.addAndGet(arr.length);
        return arr;
    }

    public byte[] load(int backend, Key k, long skip, int max) throws IOException {
        this.stats[backend].load_count.incrementAndGet();
        byte[] arr = this.I[backend].load(k, skip, max);
        this.stats[backend].load_bytes.addAndGet(arr.length);
        return arr;
    }

    public Persist getIce() {
        return this.I[1];
    }

    public final Key anyURIToKey(URI uri) throws IOException {
        Key ikey;
        String scheme = uri.getScheme();
        if ("s3".equals(scheme)) {
            ikey = this.I[3].uriToKey(uri);
        } else if ("hdfs".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("s3n".equals(scheme) || "s3a".equals(scheme)) {
            ikey = this.I[2].uriToKey(uri);
        } else if ("gs".equals(scheme)) {
            ikey = this.I[5].uriToKey(uri);
        } else if ("file".equals(scheme) || scheme == null) {
            ikey = this.I[4].uriToKey(uri);
        } else if (PersistManager.useHdfsAsFallback() && this.I[2].canHandle(uri.toString())) {
            ikey = this.I[2].uriToKey(uri);
        } else {
            throw new H2OIllegalArgumentException("Unsupported schema '" + scheme + "' for given uri " + uri);
        }
        return ikey;
    }

    private static boolean httpUrlExists(String URLName) {
        try {
            HttpURLConnection con = (HttpURLConnection)new URL(URLName).openConnection();
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("HEAD");
            return con.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public List<String> calcTypeaheadMatches(String filter, int limit) {
        if ((filter = filter.trim()).isEmpty()) {
            return Collections.emptyList();
        }
        String s = filter.toLowerCase();
        if (s.startsWith("http:") || s.startsWith("https:")) {
            if (PersistManager.httpUrlExists(filter)) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(filter);
                return arrayList;
            }
            return new ArrayList<String>();
        }
        if (s.startsWith("h2o://")) {
            return this.persistH2O.calcTypeaheadMatches(filter, limit);
        }
        if (s.startsWith("s3://")) {
            return this.I[3].calcTypeaheadMatches(filter, limit);
        }
        if (s.startsWith("gs://")) {
            return this.I[5].calcTypeaheadMatches(filter, limit);
        }
        if (s.startsWith("hdfs:") || s.startsWith("s3n:") || s.startsWith("s3a:") || s.startsWith("maprfs:") || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(s)) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3, S3N, and S3A support is not configured");
            }
            return this.I[2].calcTypeaheadMatches(filter, limit);
        }
        return this.I[4].calcTypeaheadMatches(filter, limit);
    }

    public void importFiles(String[] paths, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        if (paths.length == 1) {
            this.importFiles(paths[0], pattern, files, keys, fails, dels);
            return;
        }
        ImportFilesTask importFilesTask = new ImportFilesTask(paths, pattern);
        H2O.submitTask(new LocalMR((MrFun)importFilesTask, paths.length)).join();
        ImportFilesTask.addAllTo(importFilesTask._pFiles, files);
        ImportFilesTask.addAllTo(importFilesTask._pKeys, keys);
        ImportFilesTask.addAllTo(importFilesTask._pFails, fails);
        ImportFilesTask.addAllTo(importFilesTask._pDels, dels);
    }

    public void importFiles(String path, String pattern, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails, ArrayList<String> dels) {
        URI uri = FileUtils.getURI(path);
        String scheme = uri.getScheme();
        if (scheme == null || "file".equals(scheme)) {
            this.I[4].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("http".equals(scheme) || "https".equals(scheme)) {
            this.I[6].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("h2o".equals(scheme)) {
            this.persistH2O.importFiles(path, pattern, files, keys, fails, dels);
        } else if ("s3".equals(scheme)) {
            if (this.I[3] == null) {
                throw new H2OIllegalArgumentException("S3 support is not configured");
            }
            this.I[3].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("gs".equals(scheme)) {
            if (this.I[5] == null) {
                throw new H2OIllegalArgumentException("GCS support is not configured");
            }
            this.I[5].importFiles(path, pattern, files, keys, fails, dels);
        } else if ("hdfs".equals(scheme) || "s3n:".equals(scheme) || "s3a:".equals(scheme) || "maprfs:".equals(scheme) || PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(path)) {
            if (this.I[2] == null) {
                throw new H2OIllegalArgumentException("HDFS, S3N, and S3A support is not configured");
            }
            this.I[2].importFiles(path, pattern, files, keys, fails, dels);
        }
        if (pattern != null && !pattern.isEmpty()) {
            this.filterFiles((prefix, elements) -> this.matchPattern((String)prefix, (ArrayList<String>)elements, pattern), path, files, keys, fails);
        }
        this.filterMetadataFiles(path, files, keys, fails);
    }

    private void filterMetadataFiles(String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails) {
        this.filterFiles(new DeltaLakeMetadataFilter(), path, files, keys, fails);
    }

    private void filterFiles(Function2<String, ArrayList<String>, ArrayList<String>> matcher, String path, ArrayList<String> files, ArrayList<String> keys, ArrayList<String> fails) {
        files.retainAll((Collection)matcher.apply(path, files));
        List retainKeys = matcher.apply(path, keys);
        if (retainKeys.size() != keys.size()) {
            Futures fs = new Futures();
            List removed = (List)keys.clone();
            removed.removeAll(retainKeys);
            for (String r : removed) {
                Keyed.remove(Key.make(r), fs, true);
            }
            fs.blockForPending();
            keys.retainAll(retainKeys);
        }
        if (!fails.isEmpty()) {
            fails.retainAll((Collection)matcher.apply(path, fails));
        }
    }

    public String getHdfsHomeDirectory() {
        if (this.I[2] == null) {
            return null;
        }
        return this.I[2].getHomeDirectory();
    }

    public Persist.PersistEntry[] list(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            Persist.PersistEntry[] arr = this.I[2].list(path);
            return arr;
        }
        if (this.isGcsPath(path)) {
            return this.I[5].list(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].list(path);
        }
        File dir = new File(path);
        File[] files = dir.listFiles();
        if (files == null) {
            return new Persist.PersistEntry[0];
        }
        ArrayList<Persist.PersistEntry> arr = new ArrayList<Persist.PersistEntry>();
        for (File f : files) {
            Persist.PersistEntry entry = new Persist.PersistEntry(f.getName(), f.length(), f.lastModified());
            arr.add(entry);
        }
        return arr.toArray(new Persist.PersistEntry[arr.size()]);
    }

    public boolean exists(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].exists(path);
            return b;
        }
        if (this.isGcsPath(path)) {
            return this.I[5].exists(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].exists(path);
        }
        File f = new File(path);
        return f.exists();
    }

    public boolean isEmptyDirectoryAllNodes(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            if (!this.I[2].exists(path)) {
                return true;
            }
            if (!this.I[2].isDirectory(path)) {
                return false;
            }
            Persist.PersistEntry[] content = this.I[2].list(path);
            return content == null || content.length == 0;
        }
        if (this.isS3Path(path)) {
            Persist.PersistEntry[] content = this.I[3].list(path);
            return content.length == 0;
        }
        return ((CheckLocalDirTask)new CheckLocalDirTask((String)path).doAllNodes())._result;
    }

    public boolean isWritableDirectory(String path) {
        String pathUriStr;
        URI pathAsUri = FileUtils.getURI(path);
        Persist persist = this.getPersistForURI(pathAsUri);
        if (persist.isDirectory(pathUriStr = pathAsUri.toString())) {
            return this.isDirectoryWritable(persist, path);
        }
        if (persist.exists(pathUriStr)) {
            return false;
        }
        String existingParent = this.getExistingParent(persist, pathUriStr);
        if (existingParent != null) {
            return this.isDirectoryWritable(persist, existingParent);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirectoryWritable(Persist persist, String path) {
        boolean bl;
        OutputStream os = null;
        try {
            String testFileUriStr = FileUtils.getURI(path + "/.h2oWriteCheck").toString();
            os = persist.create(testFileUriStr, true);
            os.close();
            persist.delete(testFileUriStr);
            bl = true;
        }
        catch (IOException | FSIOException | HDFSIOException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                FileUtils.close(os);
                throw throwable;
            }
            FileUtils.close(os);
            return bl2;
        }
        FileUtils.close(os);
        return bl;
    }

    private String getExistingParent(Persist persist, String path) {
        String parent = persist.getParent(path);
        if (parent == null) {
            return null;
        }
        if (persist.exists(parent)) {
            return parent;
        }
        return this.getExistingParent(persist, parent);
    }

    public long length(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            return this.I[2].length(path);
        }
        if (this.isGcsPath(path)) {
            return this.I[5].length(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].length(path);
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        return f.length();
    }

    public InputStream open(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            return this.I[2].open(path);
        }
        if (this.isGcsPath(path)) {
            return this.I[5].open(path);
        }
        if (this.isHexPath(path)) {
            return this.HEX.open(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].open(path);
        }
        try {
            File f = new File(path);
            return new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found (" + path + ")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream openSeekable(Vec vec) throws IOException {
        if (vec instanceof FileVec) {
            FileVec fileVec = (FileVec)vec;
            String path = fileVec.getPath();
            Persist p = this.I[fileVec.getBackend()];
            if (p != null) {
                if (p.isSeekableOpenSupported()) {
                    return p.openSeekable(path);
                }
            } else if (this.isHdfsPath(path)) {
                this.validateHdfsConfigured();
                return this.I[2].openSeekable(path);
            }
        }
        if (this.hdfsNotConfigured()) {
            throw new IllegalArgumentException(String.format("Failed to open Vec '%s' for reading. Persistence backend doesn't provide implementation of a Seekable InputStream and HDFS fallback is not available.", vec._key));
        }
        Log.debug("Persist doesn't provide openSeekable. Falling back to HDFS wrapper (VecDataInputStream).");
        return this.I[2].wrapSeekable(vec);
    }

    public boolean mkdirs(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].mkdirs(path);
            return b;
        }
        if (this.isGcsPath(path)) {
            return this.I[5].mkdirs(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].mkdirs(path);
        }
        File f = new File(path);
        boolean b = f.mkdirs();
        return b;
    }

    public boolean rename(String fromPath, String toPath) {
        if (this.isHdfsPath(fromPath) || this.isHdfsPath(toPath)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].rename(fromPath, toPath);
            return b;
        }
        if (this.isGcsPath(fromPath) || this.isGcsPath(toPath)) {
            return this.I[5].rename(fromPath, toPath);
        }
        if (this.isS3Path(fromPath) || this.isS3Path(toPath)) {
            return this.I[3].rename(fromPath, toPath);
        }
        File f = new File(fromPath);
        File t = new File(toPath);
        boolean b = f.renameTo(t);
        return b;
    }

    public OutputStream create(String path, boolean overwrite) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            return this.I[2].create(path, overwrite);
        }
        if (this.isGcsPath(path)) {
            return this.I[5].create(path, overwrite);
        }
        if (this.isHexPath(path)) {
            return this.HEX.create(path, overwrite);
        }
        if (this.isS3Path(path)) {
            return this.I[3].create(path, overwrite);
        }
        try {
            File f;
            if (!overwrite && (f = new File(path)).exists()) {
                throw new IllegalArgumentException("File already exists (" + path + ")");
            }
            return new BufferedOutputStream(new FileOutputStream(path));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean delete(String path) {
        if (this.isHdfsPath(path)) {
            this.validateHdfsConfigured();
            boolean b = this.I[2].delete(path);
            return b;
        }
        if (this.isGcsPath(path)) {
            return this.I[5].delete(path);
        }
        if (this.isS3Path(path)) {
            return this.I[3].delete(path);
        }
        File f = new File(path);
        boolean b = f.delete();
        return b;
    }

    public Persist getPersistForURI(URI uri) {
        String scheme = uri.getScheme();
        boolean windowsPath = scheme.matches("^[a-zA-Z]$");
        if (windowsPath) {
            return this.I[1];
        }
        if (scheme != null) {
            switch (scheme) {
                case "file": {
                    return this.I[1];
                }
                case "hdfs": 
                case "s3n": 
                case "s3a": {
                    return this.I[2];
                }
                case "s3": {
                    return this.I[3];
                }
                case "gs": {
                    return this.I[5];
                }
            }
            if (PersistManager.useHdfsAsFallback() && this.I[2] != null && this.I[2].canHandle(uri.toString())) {
                return this.I[2];
            }
            throw new IllegalArgumentException("Cannot find persist manager for scheme " + scheme);
        }
        return this.I[1];
    }

    private ArrayList<String> matchPattern(String prefix, ArrayList<String> fileList, String matchStr) {
        ArrayList<String> result = new ArrayList<String>();
        Pattern pattern = Pattern.compile(matchStr);
        for (String s : fileList) {
            Matcher matcher = pattern.matcher(PersistManager.afterPrefix(s, prefix));
            if (!matcher.find()) continue;
            result.add(s);
        }
        return result;
    }

    private static String afterPrefix(String wholeString, String substring) {
        int posSubstring = wholeString.lastIndexOf(substring);
        if (posSubstring == -1) {
            return "";
        }
        int adjustedPosSubstring = posSubstring + substring.length();
        if (adjustedPosSubstring >= wholeString.length()) {
            return "";
        }
        return wholeString.substring(adjustedPosSubstring);
    }

    static boolean useHdfsAsFallback() {
        return System.getProperty(PROP_ENABLE_HDFS_FALLBACK, "true").equals("true");
    }

    static boolean forceHdfsForS3() {
        return Boolean.parseBoolean(System.getProperty(PROP_FORCE_HDFS_FOR_S3, "false"));
    }

    private static class CheckLocalDirTask
    extends MRTask<CheckLocalDirTask> {
        String _path;
        boolean _result;

        CheckLocalDirTask(String _path) {
            this._path = _path;
        }

        @Override
        public void reduce(CheckLocalDirTask mrt) {
            this._result = this._result && mrt._result;
        }

        @Override
        protected void setupLocal() {
            File[] content;
            File f = new File(this._path);
            this._result = !f.exists() ? true : (f.isDirectory() ? (content = f.listFiles()) != null && content.length == 0 : false);
        }
    }

    static class DeltaLakeMetadataFilter
    implements Function2<String, ArrayList<String>, ArrayList<String>> {
        private static final String DELTA_LOG_DIRNAME = "_delta_log";

        DeltaLakeMetadataFilter() {
        }

        @Override
        public ArrayList<String> apply(String unused, ArrayList<String> ids) {
            ArrayList<String> filteredIds = new ArrayList<String>(ids.size());
            Exception firstFailure = null;
            int failureCount = 0;
            for (String id : ids) {
                try {
                    String[] segments;
                    URI uri = URI.create(id);
                    String path = uri.getPath();
                    if (path != null && (segments = path.split("/")).length > 1 && DELTA_LOG_DIRNAME.equalsIgnoreCase(segments[segments.length - 2])) {
                        continue;
                    }
                }
                catch (Exception e) {
                    ++failureCount;
                    firstFailure = firstFailure == null ? e : firstFailure;
                    Log.trace("Cannot create uri", e);
                }
                filteredIds.add(id);
            }
            if (firstFailure != null) {
                Log.warn("There were " + failureCount + " failures during file filtering (only the first one logged)", firstFailure);
            }
            return filteredIds;
        }
    }

    private static class ImportFilesTask
    extends MrFun<ImportFilesTask> {
        private final String[] _paths;
        private final String _pattern;
        BufferedString[][] _pFiles;
        BufferedString[][] _pKeys;
        BufferedString[][] _pFails;
        BufferedString[][] _pDels;

        public ImportFilesTask(String[] paths, String pattern) {
            this._paths = paths;
            this._pattern = pattern;
            this._pFiles = new BufferedString[paths.length][];
            this._pKeys = new BufferedString[paths.length][];
            this._pFails = new BufferedString[paths.length][];
            this._pDels = new BufferedString[paths.length][];
        }

        @Override
        protected void map(int t) {
            ArrayList<String> pFiles = new ArrayList<String>();
            ArrayList<String> pKeys = new ArrayList<String>();
            ArrayList<String> pFails = new ArrayList<String>();
            ArrayList<String> pDels = new ArrayList<String>();
            H2O.getPM().importFiles(this._paths[t], this._pattern, pFiles, pKeys, pFails, pDels);
            this._pFiles[t] = ImportFilesTask.toArray(pFiles);
            this._pKeys[t] = ImportFilesTask.toArray(pKeys);
            this._pFails[t] = ImportFilesTask.toArray(pFails);
            this._pDels[t] = ImportFilesTask.toArray(pDels);
        }

        private static BufferedString[] toArray(List<String> ls) {
            BufferedString[] bss = new BufferedString[ls.size()];
            int i = 0;
            for (String s : ls) {
                bss[i++] = new BufferedString(s);
            }
            return bss;
        }

        private static void addAllTo(BufferedString[][] bssAry, ArrayList<String> target) {
            BufferedString[][] bufferedStringArray = bssAry;
            int n = bufferedStringArray.length;
            for (int i = 0; i < n; ++i) {
                BufferedString[] bss;
                for (BufferedString bs : bss = bufferedStringArray[i]) {
                    target.add(bs.toString());
                }
            }
        }
    }

    public static class PersistStatsEntry {
        public AtomicLong store_count = new AtomicLong();
        public AtomicLong store_bytes = new AtomicLong();
        public AtomicLong delete_count = new AtomicLong();
        public AtomicLong load_count = new AtomicLong();
        public AtomicLong load_bytes = new AtomicLong();
    }

    public static interface Schemes {
        public static final String FILE = "file";
        public static final String HDFS = "hdfs";
        public static final String S3 = "s3";
        public static final String S3N = "s3n";
        public static final String S3A = "s3a";
        public static final String GCS = "gs";
        public static final String NFS = "nfs";
        public static final String HEX = "hex";
    }
}

