/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.models;

import hex.Model;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.vals.ValFrame;

public class AstModelResetThreshold
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"model", "threshold"};
    }

    @Override
    public int nargs() {
        return 3;
    }

    @Override
    public String str() {
        return "model.reset.threshold";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        Model model = stk.track(asts[1].exec(env)).getModel();
        double oldThreshold = ((Model.Output)model._output).defaultThreshold();
        double newThreshold = stk.track(asts[2].exec(env)).getNum();
        model.resetThreshold(newThreshold);
        return ValFrame.fromRow(oldThreshold);
    }
}

