/*
 * Decompiled with CFR 0.152.
 */
package water.util;

import java.util.Arrays;
import water.AutoBuffer;
import water.Iced;
import water.IcedWrapper;
import water.Key;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.StringUtils;

public class TwoDimTable
extends Iced {
    private String tableHeader;
    private final String tableDescription;
    private final String[] rowHeaders;
    private final String[] colHeaders;
    private final String[] colTypes;
    private final String[] colFormats;
    private final IcedWrapper[][] cellValues;
    private final String colHeaderForRowHeaders;
    public static final double emptyDouble = 9.9E-324;
    private static final int PRINTOUT_ROW_LIMIT = 20;

    public static boolean isEmpty(double d) {
        return Double.doubleToRawLongBits(d) == Double.doubleToRawLongBits(9.9E-324);
    }

    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders) {
        if (tableHeader == null) {
            tableHeader = "";
        }
        if (tableDescription == null) {
            tableDescription = "";
        }
        this.colHeaderForRowHeaders = colHeaderForRowHeaders;
        if (rowHeaders == null) {
            throw new IllegalArgumentException("rowHeaders is null");
        }
        for (int r = 0; r < rowHeaders.length; ++r) {
            if (rowHeaders[r] != null) continue;
            rowHeaders[r] = "";
        }
        if (colHeaders == null) {
            throw new IllegalArgumentException("colHeaders is null");
        }
        for (int c = 0; c < colHeaders.length; ++c) {
            if (colHeaders[c] != null) continue;
            colHeaders[c] = "";
        }
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        if (colTypes == null) {
            colTypes = new String[colDim];
            Arrays.fill(colTypes, "string");
        } else {
            if (colTypes.length != colDim) {
                throw new IllegalArgumentException("colTypes must have the same length as colHeaders");
            }
            for (int c = 0; c < colDim; ++c) {
                colTypes[c] = colTypes[c].toLowerCase();
                if (colTypes[c].equals("double") || colTypes[c].equals("float") || colTypes[c].equals("int") || colTypes[c].equals("long") || colTypes[c].equals("string")) continue;
                throw new IllegalArgumentException(String.format("colTypes values must be one of \"double\", \"float\", \"int\", \"long\", or \"string\". Received \"%s\" as ColType %d", colTypes[c], c));
            }
        }
        if (colFormats == null) {
            colFormats = new String[colDim];
            Arrays.fill(colFormats, "%s");
        } else if (colFormats.length != colDim) {
            throw new IllegalArgumentException("colFormats must have the same length as colHeaders");
        }
        this.tableHeader = tableHeader;
        this.tableDescription = tableDescription;
        this.rowHeaders = rowHeaders;
        this.colHeaders = colHeaders;
        this.colTypes = colTypes;
        this.colFormats = colFormats;
        this.cellValues = new IcedWrapper[rowDim][colDim];
    }

    public TwoDimTable(String tableHeader, String tableDescription, String[] rowHeaders, String[] colHeaders, String[] colTypes, String[] colFormats, String colHeaderForRowHeaders, String[][] strCellValues, double[][] dblCellValues) {
        this(tableHeader, tableDescription, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
        int c;
        assert (TwoDimTable.isEmpty(9.9E-324));
        assert (!Arrays.equals(new AutoBuffer().put8d(9.9E-324).buf(), new AutoBuffer().put8d(Double.NaN).buf()));
        int rowDim = rowHeaders.length;
        int colDim = colHeaders.length;
        for (c = 0; c < colDim; ++c) {
            if (!colTypes[c].equalsIgnoreCase("string")) continue;
            for (Object vec : strCellValues) {
                if (vec == null) {
                    throw new IllegalArgumentException("Null string in strCellValues");
                }
                if (((String[])vec).length == colDim) continue;
                throw new IllegalArgumentException("Each row in strCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (c = 0; c < colDim; ++c) {
            if (colTypes[c].equalsIgnoreCase("string")) continue;
            for (Object vec : (String)dblCellValues) {
                if (((String[])vec).length == colDim) continue;
                throw new IllegalArgumentException("Each row in dblCellValues must have the same length as colHeaders");
            }
            break;
        }
        for (int r = 0; r < rowDim; ++r) {
            for (int c2 = 0; c2 < colDim; ++c2) {
                if (strCellValues[r] == null || strCellValues[r][c2] == null || dblCellValues[r] == null || TwoDimTable.isEmpty(dblCellValues[r][c2])) continue;
                throw new IllegalArgumentException("Cannot provide both a String and a Double at row " + r + " and column " + c2 + ".");
            }
        }
        block18: for (c = 0; c < colDim; ++c) {
            switch (colTypes[c]) {
                case "double": 
                case "float": {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, dblCellValues[r][c]);
                    }
                    continue block18;
                }
                case "int": 
                case "long": {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        double val = dblCellValues[r][c];
                        if (TwoDimTable.isEmpty(val)) {
                            this.set(r, c, Double.NaN);
                            continue;
                        }
                        if ((double)((long)val) == val) {
                            this.set(r, c, (long)val);
                            continue;
                        }
                        this.set(r, c, val);
                    }
                    continue block18;
                }
                case "string": {
                    int r;
                    for (r = 0; r < rowDim; ++r) {
                        this.set(r, c, strCellValues[r][c]);
                    }
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("Column type " + colTypes[c] + " is not supported.");
                }
            }
        }
    }

    public Object get(int row, int col) {
        return this.cellValues[row][col] == null ? null : this.cellValues[row][col].get();
    }

    public String getTableHeader() {
        return this.tableHeader;
    }

    public String getTableDescription() {
        return this.tableDescription;
    }

    public String[] getRowHeaders() {
        return this.rowHeaders;
    }

    public String[] getColHeaders() {
        return this.colHeaders;
    }

    public String getColHeaderForRowHeaders() {
        return this.colHeaderForRowHeaders;
    }

    public String[] getColTypes() {
        return this.colTypes;
    }

    public String[] getColFormats() {
        return this.colFormats;
    }

    public IcedWrapper[][] getCellValues() {
        return this.cellValues;
    }

    public int getRowDim() {
        return this.rowHeaders.length;
    }

    public int getColDim() {
        return this.colHeaders.length;
    }

    public void setTableHeader(String newHeader) {
        if (!StringUtils.isNullOrEmpty(newHeader)) {
            this.tableHeader = newHeader;
        }
    }

    public void set(int row, int col, Object o) {
        this.cellValues[row][col] = o == null ? new IcedWrapper(null) : (o instanceof Double && Double.isNaN((Double)o) ? new IcedWrapper(Double.NaN) : (o instanceof int[] ? new IcedWrapper(Arrays.toString((int[])o)) : (o instanceof long[] ? new IcedWrapper(Arrays.toString((long[])o)) : (o instanceof float[] ? new IcedWrapper(Arrays.toString((float[])o)) : (o instanceof double[] ? new IcedWrapper(Arrays.toString((double[])o)) : (this.colTypes[col] == "string" ? new IcedWrapper(o.toString()) : new IcedWrapper(o)))))));
    }

    public String toString() {
        return this.toString(2, true);
    }

    public String toString(int pad) {
        return this.toString(pad, true);
    }

    private boolean skip(int row) {
        if (this.getRowDim() <= 20) {
            return false;
        }
        if (row <= 10) {
            return false;
        }
        return row < this.getRowDim() - 10;
    }

    /*
     * WARNING - void declaration
     */
    public String toString(int pad, boolean full) {
        void var10_18;
        int c;
        String[][] cellStrings;
        if (pad < 0) {
            throw new IllegalArgumentException("pad must be a non-negative integer");
        }
        int rowDim = this.getRowDim();
        int colDim = this.getColDim();
        int actualRowDim = full ? rowDim : Math.min(21, rowDim);
        for (Object[] objectArray : cellStrings = new String[actualRowDim + 1][colDim + 1]) {
            Arrays.fill(objectArray, "");
        }
        cellStrings[0][0] = this.colHeaderForRowHeaders != null ? this.colHeaderForRowHeaders : "";
        int row = 0;
        for (int r = 0; r < rowDim; ++r) {
            if (!full && this.skip(r)) continue;
            cellStrings[row + 1][0] = this.rowHeaders[r];
            ++row;
        }
        for (c = 0; c < colDim; ++c) {
            cellStrings[0][c + 1] = this.colHeaders[c];
        }
        for (c = 0; c < colDim; ++c) {
            String formatString = this.colFormats[c];
            row = 0;
            for (int i = 0; i < rowDim; ++i) {
                if (!full && this.skip(i)) continue;
                Object o = this.get(i, c);
                if (o == null || o instanceof Double && TwoDimTable.isEmpty((Double)o)) {
                    cellStrings[row + 1][c + 1] = "";
                    ++row;
                    continue;
                }
                if (o instanceof Double && Double.isNaN((Double)o)) {
                    cellStrings[row + 1][c + 1] = "NaN";
                    ++row;
                    continue;
                }
                try {
                    cellStrings[row + 1][c + 1] = o instanceof Double ? String.format(formatString, o) : (o instanceof Float ? String.format(formatString, o) : (o instanceof Integer ? String.format(formatString, o) : (o instanceof Long ? String.format(formatString, o) : (o instanceof String ? (String)o : String.format(formatString, this.cellValues[i][c])))));
                }
                catch (Throwable t) {
                    cellStrings[row + 1][c + 1] = o.toString();
                }
                ++row;
            }
        }
        int[] colLen = new int[colDim + 1];
        for (int c2 = 0; c2 <= colDim; ++c2) {
            for (int i = 0; i <= actualRowDim; ++i) {
                colLen[c2] = Math.max(colLen[c2], cellStrings[i][c2].length());
            }
        }
        StringBuilder sb = new StringBuilder();
        if (this.tableHeader.length() > 0) {
            sb.append(this.tableHeader);
        }
        if (this.tableDescription.length() > 0) {
            sb.append(" (").append(this.tableDescription).append(")");
        }
        sb.append(":\n");
        boolean bl = false;
        while (var10_18 <= actualRowDim) {
            int len = colLen[0];
            if (actualRowDim != rowDim && var10_18 - true == 10) {
                assert (!full);
                sb.append("---");
            } else {
                if (len > 0) {
                    sb.append(String.format("%" + colLen[0] + "s", cellStrings[var10_18][0]));
                }
                for (int c3 = 1; c3 <= colDim; ++c3) {
                    len = colLen[c3];
                    if (len <= 0) continue;
                    sb.append(String.format("%" + (len + pad) + "s", cellStrings[var10_18][c3].equals("null") ? "" : cellStrings[var10_18][c3]));
                }
            }
            sb.append("\n");
            ++var10_18;
        }
        return sb.toString();
    }

    public Frame asFrame(Key frameKey) {
        String[] colNames = new String[this.getColDim()];
        System.arraycopy(this.getColHeaders(), 0, colNames, 0, this.getColDim());
        Vec[] vecs = new Vec[colNames.length];
        vecs[0] = Vec.makeVec(this.getRowHeaders(), Vec.newKey());
        block12: for (int j = 0; j < this.getColDim(); ++j) {
            switch (this.getColTypes()[j]) {
                case "string": {
                    String[] strRow = new String[this.getRowDim()];
                    for (int i = 0; i < this.getRowDim(); ++i) {
                        strRow[i] = (String)this.get(i, j);
                    }
                    vecs[j] = Vec.makeVec(strRow, Vec.newKey());
                    continue block12;
                }
                case "int": 
                case "long": {
                    double[] longRow = new double[this.getRowDim()];
                    for (int i = 0; i < this.getRowDim(); ++i) {
                        longRow[i] = ((Long)this.get(i, j)).longValue();
                    }
                    vecs[j] = Vec.makeVec(longRow, Vec.newKey());
                    continue block12;
                }
                case "float": 
                case "double": {
                    double[] dblRow = new double[this.getRowDim()];
                    for (int i = 0; i < this.getRowDim(); ++i) {
                        dblRow[i] = (Double)this.get(i, j);
                    }
                    vecs[j] = Vec.makeVec(dblRow, Vec.newKey());
                }
            }
        }
        Frame fr = new Frame(frameKey, colNames, vecs);
        return fr;
    }
}

