/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.CustomDistributionWrapper;
import hex.Distribution;
import hex.LinkFunctionFactory;
import hex.Model;
import water.H2O;
import water.udf.CDistributionFunc;
import water.udf.CFuncRef;

class CustomDistribution
extends Distribution {
    private CustomDistributionWrapper _wrapper;
    private static CustomDistribution _instance;
    private String _distributionDef;

    private CustomDistribution(Model.Parameters params) {
        super(params);
        this._distributionDef = params._custom_distribution_func;
        this._wrapper = new CustomDistributionWrapper(CFuncRef.from(params._custom_distribution_func));
        assert (this._wrapper != null);
        assert (this._wrapper.getFunc() != null);
        this._linkFunction = LinkFunctionFactory.getLinkFunction(((CDistributionFunc)this._wrapper.getFunc()).link());
    }

    public static CustomDistribution getCustomDistribution(Model.Parameters params) {
        if (_instance == null || !params._custom_distribution_func.equals(CustomDistribution._instance._distributionDef)) {
            _instance = new CustomDistribution(params);
        }
        return _instance;
    }

    @Override
    public double deviance(double w, double y, double f) {
        throw H2O.unimpl("Deviance is not supported in Custom Distribution.");
    }

    @Override
    public double negHalfGradient(double y, double f) {
        return ((CDistributionFunc)this._wrapper.getFunc()).gradient(y, f);
    }

    @Override
    public double negHalfGradient(double y, double f, int l) {
        return ((CDistributionFunc)this._wrapper.getFunc()).gradient(y, f, l);
    }

    @Override
    public double initFNum(double w, double o, double y) {
        double[] init = ((CDistributionFunc)this._wrapper.getFunc()).init(w, o, y);
        assert (init.length == 2);
        return init[0];
    }

    @Override
    public double initFDenom(double w, double o, double y) {
        double[] init = ((CDistributionFunc)this._wrapper.getFunc()).init(w, o, y);
        assert (init.length == 2);
        return init[1];
    }

    @Override
    public double gammaNum(double w, double y, double z, double f) {
        double[] gamma = ((CDistributionFunc)this._wrapper.getFunc()).gamma(w, y, z, f);
        assert (gamma.length == 2);
        return gamma[0];
    }

    @Override
    public double gammaDenom(double w, double y, double z, double f) {
        double[] gamma = ((CDistributionFunc)this._wrapper.getFunc()).gamma(w, y, z, f);
        assert (gamma.length == 2);
        return gamma[1];
    }

    @Override
    public void reset() {
        this._wrapper.setupLocal();
    }
}

