/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUUC;
import hex.CMetricScoringTask;
import hex.DefaultPojoWriter;
import hex.DelegatingPojoWriter;
import hex.Distribution;
import hex.DistributionFactory;
import hex.GainsLift;
import hex.ModelBuilder;
import hex.ModelCategory;
import hex.ModelExportOption;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialUplift;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsRegression;
import hex.ModelMojoWriter;
import hex.ModelPreprocessor;
import hex.MultinomialAucType;
import hex.PojoWriter;
import hex.ScoreKeeper;
import hex.ScoringInfo;
import hex.StringPair;
import hex.ToEigenVec;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.GenModel;
import hex.genmodel.ModelMojoReader;
import hex.genmodel.MojoModel;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.MojoReaderBackendFactory;
import hex.genmodel.algos.glrm.GlrmMojoModel;
import hex.genmodel.algos.tree.ContributionComposer;
import hex.genmodel.algos.tree.SharedTreeGraph;
import hex.genmodel.algos.tree.SharedTreeMojoModel;
import hex.genmodel.descriptor.ModelDescriptor;
import hex.genmodel.easy.EasyPredictModelWrapper;
import hex.genmodel.easy.RowData;
import hex.genmodel.easy.exception.PredictException;
import hex.genmodel.easy.prediction.AnomalyDetectionPrediction;
import hex.genmodel.easy.prediction.AutoEncoderModelPrediction;
import hex.genmodel.easy.prediction.BinomialModelPrediction;
import hex.genmodel.easy.prediction.ClusteringModelPrediction;
import hex.genmodel.easy.prediction.CoxPHModelPrediction;
import hex.genmodel.easy.prediction.DimReductionModelPrediction;
import hex.genmodel.easy.prediction.MultinomialModelPrediction;
import hex.genmodel.easy.prediction.OrdinalModelPrediction;
import hex.genmodel.easy.prediction.RegressionModelPrediction;
import hex.genmodel.utils.ArrayUtils;
import hex.genmodel.utils.DistributionFamily;
import hex.quantile.QuantileModel;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import water.AutoBuffer;
import water.DKV;
import water.Futures;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Job;
import water.Key;
import water.KeySnapshot;
import water.Keyed;
import water.Lockable;
import water.MRTask;
import water.MemoryManager;
import water.Value;
import water.Weaver;
import water.api.ModelsHandler;
import water.api.StreamWriteOption;
import water.api.StreamWriter;
import water.api.StreamingSchema;
import water.api.schemas3.KeyV3;
import water.codegen.CodeGenerator;
import water.codegen.CodeGeneratorPipeline;
import water.exceptions.JCodeSB;
import water.fvec.ByteVec;
import water.fvec.C0DChunk;
import water.fvec.CategoricalWrappedVec;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.parser.BufferedString;
import water.persist.Persist;
import water.udf.CFuncRef;
import water.util.FileUtils;
import water.util.FrameUtils;
import water.util.IcedHashMap;
import water.util.JCodeGen;
import water.util.LineLimitOutputStreamWrapper;
import water.util.Log;
import water.util.MathUtils;
import water.util.RandomUtils;
import water.util.ReproducibilityInformationUtils;
import water.util.SB;
import water.util.SBPrintStream;
import water.util.TwoDimTable;
import water.util.VecUtils;

public abstract class Model<M extends Model<M, P, O>, P extends Parameters, O extends Output>
extends DefaultPojoWriter<M>
implements StreamWriter {
    public static final String EVAL_AUTO_PARAMS_ENABLED = "sys.ai.h2o.algos.evaluate_auto_model_parameters";
    public P _parms;
    public P _input_parms;
    public O _output;
    public String[] _warnings = new String[0];
    public transient String[] _warningsP;
    public Distribution _dist;
    protected ScoringInfo[] scoringInfo;
    public IcedHashMap<Key, String> _toDelete = new IcedHashMap();
    public boolean evalAutoParamsEnabled;

    public static Model[] fetchAll() {
        Key[] modelKeys = KeySnapshot.globalSnapshot().filter(new KeySnapshot.KVFilter(){

            @Override
            public boolean filter(KeySnapshot.KeyInfo k) {
                return Value.isSubclassOf(k._type, Model.class) && !Value.isSubclassOf(k._type, QuantileModel.class);
            }
        }).keys();
        Model[] models = new Model[modelKeys.length];
        for (int i = 0; i < modelKeys.length; ++i) {
            Model model;
            models[i] = model = ModelsHandler.getFromDKV("(none)", modelKeys[i]);
        }
        return models;
    }

    public static boolean evaluateAutoModelParameters() {
        return Boolean.parseBoolean(System.getProperty(EVAL_AUTO_PARAMS_ENABLED, "true"));
    }

    public void setInputParms(P _input_parms) {
        this._input_parms = _input_parms;
    }

    public double defaultThreshold() {
        return ((Output)this._output).defaultThreshold();
    }

    public void resetThreshold(double value) {
        ((Output)this._output).resetThreshold(value);
    }

    @Deprecated
    public static <O extends Output> double defaultThreshold(O output) {
        return output.defaultThreshold();
    }

    public final boolean isSupervised() {
        return ((Output)this._output).isSupervised();
    }

    public boolean havePojo() {
        if (((Parameters)this._parms)._preprocessors != null) {
            return false;
        }
        String algoName = ((Parameters)this._parms).algoName();
        return ModelBuilder.getRegisteredBuilder(algoName).map(ModelBuilder::havePojo).orElseGet(() -> {
            Log.warn("Model Builder for algo = " + algoName + " is not registered. Unable to determine if Model has a POJO. Please override method havePojo().");
            return false;
        });
    }

    public boolean haveMojo() {
        if (((Parameters)this._parms)._preprocessors != null) {
            return false;
        }
        String algoName = ((Parameters)this._parms).algoName();
        return ModelBuilder.getRegisteredBuilder(algoName).map(ModelBuilder::haveMojo).orElseGet(() -> {
            Log.warn("Model Builder for algo = " + algoName + " is not registered. Unable to determine if Model has a MOJO. Please override method haveMojo().");
            return false;
        });
    }

    public GridSortBy getDefaultGridSortBy() {
        if (!this.isSupervised()) {
            return null;
        }
        if (((Output)this._output).nclasses() > 1) {
            return GridSortBy.LOGLOSS;
        }
        return GridSortBy.RESDEV;
    }

    public ToEigenVec getToEigenVec() {
        return null;
    }

    public ModelMetrics addModelMetrics(ModelMetrics mm) {
        DKV.put(mm);
        Model.incrementModelMetrics(this._output, mm._key);
        return mm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementModelMetrics(Output out, Key k) {
        Output output = out;
        synchronized (output) {
            for (Key<ModelMetrics> key : out._model_metrics) {
                if (!k.equals(key)) continue;
                return;
            }
            out._model_metrics = Arrays.copyOf(out._model_metrics, out._model_metrics.length + 1);
            out._model_metrics[out._model_metrics.length - 1] = k;
        }
    }

    public void addWarning(String s) {
        this._warnings = Arrays.copyOf(this._warnings, this._warnings.length + 1);
        this._warnings[this._warnings.length - 1] = s;
    }

    protected String[][] scoringDomains() {
        return ((Output)this._output)._domains;
    }

    public ModelMetrics addMetrics(ModelMetrics mm) {
        return this.addModelMetrics(mm);
    }

    public abstract ModelMetrics.MetricBuilder makeMetricBuilder(String[] var1);

    public Model(Key<M> selfKey, P parms, O output) {
        super(selfKey);
        assert (parms != null);
        this._parms = parms;
        this.evalAutoParamsEnabled = Model.evaluateAutoModelParameters();
        if (this.evalAutoParamsEnabled) {
            this.initActualParamValues();
        }
        this._output = output;
        if (this._output != null) {
            ((Output)this._output).startClock();
        }
        this._dist = this.isSupervised() && ((Output)this._output).nclasses() == 1 ? DistributionFactory.getDistribution(this._parms) : null;
        Log.info("Starting model " + selfKey);
    }

    public void initActualParamValues() {
    }

    public double deviance(double w, double y, double f) {
        return this._dist.deviance(w, y, f);
    }

    public double likelihood(double w, double y, double f) {
        return 0.0;
    }

    public ScoringInfo[] scoring_history() {
        return this.scoringInfo;
    }

    public void fillScoringInfo(ScoringInfo scoringInfo) {
        scoringInfo.is_classification = ((Output)this._output).isClassifier();
        scoringInfo.is_autoencoder = ((Output)this._output).isAutoencoder();
        scoringInfo.scored_train = new ScoreKeeper(((Output)this._output)._training_metrics);
        scoringInfo.scored_valid = new ScoreKeeper(((Output)this._output)._validation_metrics);
        scoringInfo.scored_xval = new ScoreKeeper(((Output)this._output)._cross_validation_metrics);
        scoringInfo.validation = ((Output)this._output)._validation_metrics != null;
        scoringInfo.cross_validation = ((Output)this._output)._cross_validation_metrics != null;
    }

    public ScoringInfo last_scored() {
        return this.scoringInfo == null ? null : this.scoringInfo[this.scoringInfo.length - 1];
    }

    public float loss() {
        switch (Optional.ofNullable(((Parameters)this._parms)._stopping_metric).orElse(ScoreKeeper.StoppingMetric.AUTO)) {
            case MSE: {
                return (float)this.mse();
            }
            case MAE: {
                return (float)this.mae();
            }
            case RMSLE: {
                return (float)this.rmsle();
            }
            case logloss: {
                return (float)this.logloss();
            }
            case deviance: {
                return (float)this.deviance();
            }
            case misclassification: {
                return (float)this.classification_error();
            }
            case AUC: {
                return (float)(1.0 - this.auc());
            }
            case AUCPR: {
                return (float)(1.0 - this.AUCPR());
            }
            case mean_per_class_error: {
                return (float)this.mean_per_class_error();
            }
            case lift_top_group: {
                return (float)this.lift_top_group();
            }
        }
        return (float)(((Output)this._output).isClassifier() ? this.logloss() : (((Output)this._output).isAutoencoder() ? this.mse() : this.deviance()));
    }

    public int compareTo(M o) {
        if (((Output)((Model)o)._output).isClassifier() != ((Output)this._output).isClassifier()) {
            throw new UnsupportedOperationException("Cannot compare classifier against regressor.");
        }
        if (((Output)((Model)o)._output).isClassifier() && ((Output)((Model)o)._output).nclasses() != ((Output)this._output).nclasses()) {
            throw new UnsupportedOperationException("Cannot compare models with different number of classes.");
        }
        return this.loss() < ((Model)o).loss() ? -1 : (this.loss() > ((Model)o).loss() ? 1 : 0);
    }

    public double classification_error() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._classError : (this.last_scored().validation ? this.last_scored().scored_valid._classError : this.last_scored().scored_train._classError);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial) {
            return ((ModelMetricsBinomial)mm)._auc.defaultErr();
        }
        if (mm instanceof ModelMetricsMultinomial) {
            return ((ModelMetricsMultinomial)mm)._cm.err();
        }
        return Double.NaN;
    }

    public double mse() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._mse : (this.last_scored().validation ? this.last_scored().scored_valid._mse : this.last_scored().scored_train._mse);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        return mm.mse();
    }

    public double r2() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._r2 : (this.last_scored().validation ? this.last_scored().scored_valid._r2 : this.last_scored().scored_train._r2);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        return mm.mse();
    }

    public double mae() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._mae : (this.last_scored().validation ? this.last_scored().scored_valid._mae : this.last_scored().scored_train._mae);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        return ((ModelMetricsRegression)mm).mae();
    }

    public double rmsle() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._rmsle : (this.last_scored().validation ? this.last_scored().scored_valid._rmsle : this.last_scored().scored_train._rmsle);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        return ((ModelMetricsRegression)mm).rmsle();
    }

    public double auc() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._AUC : (this.last_scored().validation ? this.last_scored().scored_valid._AUC : this.last_scored().scored_train._AUC);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial) {
            return ((ModelMetricsBinomial)mm)._auc._auc;
        }
        if (mm instanceof ModelMetricsMultinomial) {
            return ((ModelMetricsMultinomial)mm).auc();
        }
        return Double.NaN;
    }

    public double AUCPR() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._pr_auc : (this.last_scored().validation ? this.last_scored().scored_valid._pr_auc : this.last_scored().scored_train._pr_auc);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial) {
            return ((ModelMetricsBinomial)mm)._auc._pr_auc;
        }
        if (mm instanceof ModelMetricsMultinomial) {
            return ((ModelMetricsMultinomial)mm).pr_auc();
        }
        return Double.NaN;
    }

    public double deviance() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._mean_residual_deviance : (this.last_scored().validation ? this.last_scored().scored_valid._mean_residual_deviance : this.last_scored().scored_train._mean_residual_deviance);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        return ((ModelMetricsRegression)mm)._mean_residual_deviance;
    }

    public double logloss() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._logloss : (this.last_scored().validation ? this.last_scored().scored_valid._logloss : this.last_scored().scored_train._logloss);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial) {
            return ((ModelMetricsBinomial)mm).logloss();
        }
        if (mm instanceof ModelMetricsMultinomial) {
            return ((ModelMetricsMultinomial)mm).logloss();
        }
        return Double.NaN;
    }

    public double mean_per_class_error() {
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._mean_per_class_error : (this.last_scored().validation ? this.last_scored().scored_valid._mean_per_class_error : this.last_scored().scored_train._mean_per_class_error);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial) {
            return ((ModelMetricsBinomial)mm).mean_per_class_error();
        }
        if (mm instanceof ModelMetricsMultinomial) {
            return ((ModelMetricsMultinomial)mm).mean_per_class_error();
        }
        return Double.NaN;
    }

    public double lift_top_group() {
        GainsLift gl;
        ModelMetrics mm;
        if (this.scoringInfo != null) {
            return this.last_scored().cross_validation ? this.last_scored().scored_xval._lift : (this.last_scored().validation ? this.last_scored().scored_valid._lift : this.last_scored().scored_train._lift);
        }
        ModelMetrics modelMetrics = ((Output)this._output)._cross_validation_metrics != null ? ((Output)this._output)._cross_validation_metrics : (mm = ((Output)this._output)._validation_metrics != null ? ((Output)this._output)._validation_metrics : ((Output)this._output)._training_metrics);
        if (mm == null) {
            return Double.NaN;
        }
        if (mm instanceof ModelMetricsBinomial && (gl = ((ModelMetricsBinomial)mm)._gainsLift) != null && gl.response_rates != null && gl.response_rates.length > 0) {
            return gl.response_rates[0] / gl.avg_response_rate;
        }
        return Double.NaN;
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics) {
        return this.adaptTestForTrain(test, expensive, computeMetrics, false);
    }

    public String[] adaptTestForTrain(Frame test, boolean expensive, boolean computeMetrics, boolean catEncoded) {
        return Model.adaptTestForTrain(test, ((Output)this._output)._origNames, ((Output)this._output)._origDomains, ((Output)this._output)._names, ((Output)this._output)._domains, this.makeAdaptFrameParameters(), expensive, computeMetrics, ((Output)this._output).interactionBuilder(), this.getToEigenVec(), this._toDelete, catEncoded);
    }

    protected AdaptFrameParameters makeAdaptFrameParameters() {
        return this._parms;
    }

    public static String[] adaptTestForTrain(Frame test, String[] origNames, String[][] origDomains, String[] names, String[][] domains, AdaptFrameParameters parms, boolean expensive, boolean computeMetrics, InteractionBuilder interactionBldr, ToEigenVec tev, IcedHashMap<Key, String> toDelete, boolean catEncoded) throws IllegalArgumentException {
        boolean hasCategoricalPredictors;
        boolean checkCategoricals;
        String[] msg = new String[]{};
        if (test == null) {
            return msg;
        }
        if (catEncoded && origNames == null) {
            return msg;
        }
        String[][] tdomains = test.domains();
        if (names == test._names && domains == tdomains || Arrays.equals(names, test._names) && Arrays.deepEquals((Object[])domains, (Object[])tdomains)) {
            return msg;
        }
        String[] backupNames = names;
        String[][] backupDomains = domains;
        String weights = parms.getWeightsColumn();
        String offset = parms.getOffsetColumn();
        String fold = parms.getFoldColumn();
        String response = parms.getResponseColumn();
        String treatment = parms.getTreatmentColumn();
        boolean bl = checkCategoricals = !catEncoded && Arrays.asList(Parameters.CategoricalEncodingScheme.Binary, Parameters.CategoricalEncodingScheme.LabelEncoder, Parameters.CategoricalEncodingScheme.Eigen, Parameters.CategoricalEncodingScheme.EnumLimited, Parameters.CategoricalEncodingScheme.OneHotExplicit).indexOf((Object)parms.getCategoricalEncoding()) >= 0;
        if (checkCategoricals && origNames != null) {
            boolean match = Arrays.equals(origNames, test.names());
            if (!match) {
                HashSet<String> required = new HashSet<String>(Arrays.asList(origNames));
                required.removeAll(Arrays.asList(response, weights, fold, treatment));
                for (String name : test.names()) {
                    if (!required.contains(name)) continue;
                    match = true;
                    break;
                }
            }
            if (match) {
                names = origNames;
                domains = origDomains;
            }
        }
        if (null != interactionBldr) {
            interactionBldr.makeInteractions(test);
        }
        ArrayList<String> msgs = new ArrayList<String>();
        Vec[] vvecs = new Vec[names.length];
        int good = 0;
        int convNaN = 0;
        Frame.FrameVecRegistry frameVecRegistry = test.frameVecRegistry();
        for (int i = 0; i < names.length; ++i) {
            boolean isTreatment;
            Vec vec = frameVecRegistry.findByColName(names[i]);
            boolean isResponse = response != null && names[i].equals(response);
            boolean isWeights = weights != null && names[i].equals(weights);
            boolean isOffset = offset != null && names[i].equals(offset);
            boolean isFold = fold != null && names[i].equals(fold);
            boolean bl2 = isTreatment = treatment != null && names[i].equals(treatment);
            if (vec == null) {
                if (isResponse && computeMetrics) {
                    throw new IllegalArgumentException("Test/Validation dataset is missing response column '" + response + "'");
                }
                if (isOffset) {
                    throw new IllegalArgumentException(H2O.technote(12, "Test/Validation dataset is missing offset column '" + offset + "'. If your intention is to disable the effect of the offset add a zero offset column."));
                }
                if (isWeights && computeMetrics) {
                    if (expensive) {
                        vec = test.anyVec().makeCon(1.0);
                        toDelete.put(vec._key, "adapted missing vectors");
                        msgs.add(H2O.technote(1, "Test/Validation dataset is missing weights column '" + names[i] + "' (needed because a response was found and metrics are to be computed): substituting in a column of 1s"));
                    } else if (isTreatment && computeMetrics) {
                        throw new IllegalArgumentException("Test/Validation dataset is missing treatment column '" + treatment + "'");
                    }
                } else if (expensive) {
                    double defval;
                    if (isWeights) {
                        defval = 1.0;
                    } else if (isFold && domains[i] == null) {
                        defval = 0.0;
                    } else {
                        defval = parms.missingColumnsType();
                        ++convNaN;
                    }
                    vec = test.anyVec().makeCon(defval);
                    toDelete.put(vec._key, "adapted missing vectors");
                    String str = "Test/Validation dataset is missing column '" + names[i] + "': substituting in a column of " + defval;
                    if (water.util.ArrayUtils.contains(parms.getNonPredictors(), names[i])) {
                        Log.info(str);
                    } else {
                        msgs.add(str);
                    }
                }
            }
            if (vec != null) {
                if (domains[i] != null) {
                    if (vec.isString()) {
                        vec = VecUtils.stringToCategorical(vec);
                    }
                    if (expensive && !Arrays.equals(vec.domain(), domains[i])) {
                        Vec evec;
                        try {
                            evec = vec.adaptTo(domains[i]);
                            toDelete.put(evec._key, "categorically adapted vec");
                        }
                        catch (NumberFormatException nfe) {
                            throw new IllegalArgumentException("Test/Validation dataset has a non-categorical column '" + names[i] + "' which is categorical in the training data");
                        }
                        String[] ds = evec.domain();
                        assert (ds != null && ds.length >= domains[i].length);
                        if (isResponse && vec.domain() != null && ds.length == domains[i].length + vec.domain().length) {
                            throw new IllegalArgumentException("Test/Validation dataset has a categorical response column '" + names[i] + "' with no levels in common with the model");
                        }
                        if (isTreatment && vec.domain() != null && ds.length == domains[i].length + vec.domain().length) {
                            throw new IllegalArgumentException("Test/Validation dataset has a categorical treatment column '" + names[i] + "' with no levels in common with the model");
                        }
                        if (ds.length > domains[i].length) {
                            msgs.add("Test/Validation dataset column '" + names[i] + "' has levels not trained on: " + water.util.ArrayUtils.toStringQuotedElements(Arrays.copyOfRange(ds, domains[i].length, ds.length), 20));
                        }
                        vec = evec;
                    }
                } else if (vec.isCategorical()) {
                    throw new IllegalArgumentException("Test/Validation dataset has categorical column '" + names[i] + "' which is real-valued in the training data");
                }
                ++good;
            }
            vvecs[i] = vec;
        }
        if (good == convNaN) {
            throw new IllegalArgumentException("Test/Validation dataset has no columns in common with the training set");
        }
        if (good == names.length || response != null && test.find(response) == -1 && good == names.length - 1) {
            test.restructure(names, vvecs, good);
        }
        if (expensive && checkCategoricals && (hasCategoricalPredictors = Model.hasCategoricalPredictors(test, response, weights, offset, fold, treatment, names, domains))) {
            Frame updated = FrameUtils.categoricalEncoder(test, parms.getNonPredictors(), parms.getCategoricalEncoding(), tev, parms.getMaxCategoricalLevels());
            toDelete.put(updated._key, "categorically encoded frame");
            test.restructure(updated.names(), updated.vecs());
            String[] msg2 = Model.adaptTestForTrain(test, origNames, origDomains, backupNames, backupDomains, parms, expensive, computeMetrics, interactionBldr, tev, toDelete, true);
            msgs.addAll(Arrays.asList(msg2));
            return msgs.toArray(new String[msgs.size()]);
        }
        return msgs.toArray(new String[msgs.size()]);
    }

    private static boolean hasCategoricalPredictors(Frame frame, String responseName, String wieghtsName, String offsetName, String foldName, String treatmentName, String[] names, String[][] domains) {
        int i;
        boolean haveCategoricalPredictors = false;
        HashMap<String, Integer> namesIndicesMap = new HashMap<String, Integer>(names.length);
        for (i = 0; i < names.length; ++i) {
            namesIndicesMap.put(names[i], i);
        }
        for (i = 0; i < frame.numCols(); ++i) {
            if (frame.names()[i].equals(responseName) || frame.names()[i].equals(wieghtsName) || frame.names()[i].equals(offsetName) || frame.names()[i].equals(foldName) || frame.names()[i].equals(treatmentName)) continue;
            if (frame.vec(i).get_type() == 4) {
                haveCategoricalPredictors = true;
                break;
            }
            int whichCol = (Integer)namesIndicesMap.get(frame.name(i));
            if (whichCol < 0 || domains[whichCol] == null) continue;
            haveCategoricalPredictors = true;
            break;
        }
        return haveCategoricalPredictors;
    }

    public Frame score(Frame fr) throws IllegalArgumentException {
        return this.score(fr, null, null, true);
    }

    public Frame result() {
        throw new UnsupportedOperationException("this model doesn't support constant frame results");
    }

    public Frame transform(Frame fr) {
        throw new UnsupportedOperationException("this model doesn't support constant frame results");
    }

    public Frame score(Frame fr, String destination_key, CFuncRef customMetricFunc) throws IllegalArgumentException {
        return this.score(fr, destination_key, null, true, customMetricFunc);
    }

    public Frame score(Frame fr, String destination_key) throws IllegalArgumentException {
        return this.score(fr, destination_key, null, true);
    }

    public Frame score(Frame fr, String destination_key, Job j) throws IllegalArgumentException {
        return this.score(fr, destination_key, j, true);
    }

    private void addWarningP(String s) {
        String[] warningsP = this._warningsP;
        warningsP = warningsP != null ? Arrays.copyOf(warningsP, warningsP.length + 1) : new String[1];
        warningsP[warningsP.length - 1] = s;
        this._warningsP = warningsP;
    }

    public boolean containsResponse(String s, String responseName) {
        Pattern pat = Pattern.compile("'(.*?)'");
        Matcher match = pat.matcher(s);
        return match.find() && responseName.equals(match.group(1));
    }

    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics) throws IllegalArgumentException {
        return this.score(fr, destination_key, j, computeMetrics, CFuncRef.NOP);
    }

    protected Frame adaptFrameForScore(Frame fr, boolean computeMetrics, List<Frame> tmpFrames) {
        Frame adaptFr = new Frame(fr);
        this.applyPreprocessors(adaptFr, tmpFrames);
        String[] msg = this.adaptTestForTrain(adaptFr, true, computeMetrics);
        tmpFrames.add(adaptFr);
        if (msg.length > 0) {
            for (String s : msg) {
                if (((Output)this._output).responseName() != null && this.containsResponse(s, ((Output)this._output).responseName())) continue;
                this.addWarningP(s);
                Log.warn(s);
            }
        }
        return adaptFr;
    }

    public Frame score(Frame fr, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) throws IllegalArgumentException {
        Object[] sdomain;
        Vec actual;
        this._warningsP = new String[0];
        computeMetrics = computeMetrics && (!((Output)this._output).hasResponse() || fr.vec(((Output)this._output).responseName()) != null && !fr.vec(((Output)this._output).responseName()).isBad());
        ArrayList<Frame> tmpFrames = new ArrayList<Frame>();
        Frame adaptFr = this.adaptFrameForScore(fr, computeMetrics, tmpFrames);
        PredictScoreResult result = this.predictScoreImpl(fr, adaptFr, destination_key, j, computeMetrics, customMetricFunc);
        Frame output = result.getPredictions();
        result.makeModelMetrics(fr, adaptFr);
        Vec predicted = output.vecs()[0];
        Object[] mdomain = predicted.domain();
        if (((Output)this._output).isClassifier() && computeMetrics && !((Output)this._output).hasTreatment() && (actual = fr.vec(((Output)this._output).responseName())) != null && (sdomain = actual.domain()) != null && mdomain != sdomain && !Arrays.equals(mdomain, sdomain)) {
            CategoricalWrappedVec.updateDomain(output.vec(0), (String[])sdomain);
        }
        for (Frame tmp : tmpFrames) {
            Frame.deleteTempFrameAndItsNonSharedVecs(tmp, fr);
        }
        return output;
    }

    private void applyPreprocessors(Frame fr, List<Frame> tmpFrames) {
        if (((Parameters)this._parms)._preprocessors == null) {
            return;
        }
        for (Key<ModelPreprocessor> key : ((Parameters)this._parms)._preprocessors) {
            DKV.prefetch(key);
        }
        Frame result = fr;
        for (Key<ModelPreprocessor> key : ((Parameters)this._parms)._preprocessors) {
            ModelPreprocessor preprocessor = key.get();
            result = preprocessor.processScoring(result, this);
            tmpFrames.add(result);
        }
        fr.restructure(result.names(), result.vecs());
    }

    public Frame computeDeviances(Frame valid, Frame predictions, String outputName) {
        Distribution myDist;
        assert (((Parameters)this._parms)._response_column != null) : "response column can't be null";
        assert (valid.find(((Parameters)this._parms)._response_column) >= 0) : "validation frame must contain a response column";
        predictions.add(((Parameters)this._parms)._response_column, valid.vec(((Parameters)this._parms)._response_column));
        if (valid.find(((Parameters)this._parms)._weights_column) >= 0) {
            predictions.add(((Parameters)this._parms)._weights_column, valid.vec(((Parameters)this._parms)._weights_column));
        }
        final int respIdx = predictions.find(((Parameters)this._parms)._response_column);
        final int weightIdx = predictions.find(((Parameters)this._parms)._weights_column);
        Distribution distribution = myDist = this._dist == null ? null : IcedUtils.deepCopy(this._dist);
        if (myDist != null && myDist._family == DistributionFamily.huber) {
            myDist.setHuberDelta(ModelMetricsRegression.computeHuberDelta(valid.vec(((Parameters)this._parms)._response_column), predictions.vec(0), valid.vec(((Parameters)this._parms)._weights_column), ((Parameters)this._parms)._huber_alpha));
        }
        return ((MRTask)new MRTask(){

            @Override
            public void map(Chunk[] cs, NewChunk[] nc) {
                Chunk weight = weightIdx >= 0 ? cs[weightIdx] : new C0DChunk(1.0, cs[0]._len);
                Chunk response = cs[respIdx];
                for (int i = 0; i < cs[0]._len; ++i) {
                    double w = weight.atd(i);
                    double y = response.atd(i);
                    if (((Output)Model.this._output).nclasses() == 1) {
                        double f = cs[0].atd(i);
                        if (myDist != null && myDist._family == DistributionFamily.huber) {
                            nc[0].addNum(myDist.deviance(w, y, f));
                            continue;
                        }
                        nc[0].addNum(Model.this.deviance(w, y, f));
                        continue;
                    }
                    int iact = (int)y;
                    double err = iact < ((Output)Model.this._output).nclasses() ? 1.0 - cs[1 + iact].atd(i) : 1.0;
                    nc[0].addNum(w * MathUtils.logloss(err));
                }
            }
        }.doAll((byte)3, predictions)).outputFrame(Key.make(outputName), new String[]{"deviance"}, null);
    }

    protected String[] makeScoringNames() {
        return Model.makeScoringNames(this._output);
    }

    protected String[][] makeScoringDomains(Frame adaptFrm, boolean computeMetrics, String[] names) {
        String[][] domains = new String[names.length][];
        Vec response = adaptFrm.lastVec();
        String[] stringArray = names.length == 1 || ((Output)this._output).hasTreatment() ? null : (domains[0] = !computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : response.domain());
        if (((Parameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            domains[0] = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(null, 2).doAll(response)).stringDomain(response.isInt());
        }
        return domains;
    }

    public static <O extends Output> String[] makeScoringNames(O output) {
        int nc = output.nclasses();
        int ncols = nc == 1 ? 1 : nc + 1;
        String[] names = new String[ncols];
        if (output.hasTreatment()) {
            names[0] = "uplift_predict";
            names[1] = "p_y1_ct1";
            names[2] = "p_y1_ct0";
        } else {
            names[0] = "predict";
            for (int i = 1; i < names.length; ++i) {
                names[i] = output.classNames()[i - 1];
                try {
                    Integer.valueOf(names[i]);
                    names[i] = "p" + names[i];
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return names;
    }

    protected BigScore makeBigScoreTask(String[][] domains, String[] names, Frame adaptFrm, boolean computeMetrics, boolean makePrediction, Job j, CFuncRef customMetricFunc) {
        return new BigScore(domains[0], names != null ? names.length : 0, adaptFrm.means(), ((Output)this._output).hasWeights() && adaptFrm.find(((Output)this._output).weightsName()) >= 0, computeMetrics, makePrediction, j, customMetricFunc);
    }

    protected PredictScoreResult predictScoreImpl(Frame fr, Frame adaptFrm, String destination_key, Job j, boolean computeMetrics, CFuncRef customMetricFunc) {
        String[] names = this.makeScoringNames();
        String[][] domains = this.makeScoringDomains(adaptFrm, computeMetrics, names);
        BigScore bs = (BigScore)this.makeBigScoreTask(domains, names, adaptFrm, computeMetrics, true, j, customMetricFunc).doAll(names.length, (byte)3, adaptFrm);
        ModelMetrics.MetricBuilder mb = null;
        Frame rawPreds = null;
        if (computeMetrics && bs._mb != null) {
            rawPreds = bs.outputFrame();
            mb = bs._mb;
        }
        Frame predictFr = bs.outputFrame(Key.make(destination_key), names, domains);
        Frame outputPreds = this.postProcessPredictions(adaptFrm, predictFr, j);
        return new PredictScoreResult(mb, rawPreds, outputPreds);
    }

    protected Frame postProcessPredictions(Frame adaptFrm, Frame predictFr, Job j) {
        return predictFr;
    }

    protected ModelMetrics.MetricBuilder scoreMetrics(Frame adaptFrm) {
        boolean computeMetrics = !this.isSupervised() || adaptFrm.vec(((Output)this._output).responseName()) != null && !adaptFrm.vec(((Output)this._output).responseName()).isBad();
        String[][] domains = new String[1][];
        Vec response = adaptFrm.lastVec();
        String[] stringArray = ((Output)this._output).nclasses() == 1 ? null : (domains[0] = !computeMetrics ? ((Output)this._output)._domains[((Output)this._output)._domains.length - 1] : response.domain());
        if (((Parameters)this._parms)._distribution == DistributionFamily.quasibinomial) {
            domains[0] = ((VecUtils.CollectDoubleDomain)new VecUtils.CollectDoubleDomain(null, 2).doAll(response)).stringDomain(response.isInt());
        }
        BigScore bs = (BigScore)this.makeBigScoreTask(domains, null, adaptFrm, computeMetrics, false, null, CFuncRef.from(((Parameters)this._parms)._custom_metric_func)).doAll(adaptFrm);
        return bs._mb;
    }

    protected BigScorePredict setupBigScorePredict(BigScore bs) {
        return bs;
    }

    protected double data(Chunk[] chks, int row, int col) {
        return chks[col].atd(row);
    }

    public double[] score0(Chunk[] chks, int row_in_chunk, double[] tmp, double[] preds) {
        return this.score0(chks, 0.0, row_in_chunk, tmp, preds);
    }

    public double[] score0(Chunk[] chks, double offset, int row_in_chunk, double[] tmp, double[] preds) {
        assert (((Output)this._output).nfeatures() == tmp.length);
        for (int i = 0; i < tmp.length; ++i) {
            tmp[i] = chks[i].atd(row_in_chunk);
        }
        double[] scored = this.score0(tmp, preds, offset);
        if (this.needsPostProcess() && this.isSupervised()) {
            this.score0PostProcessSupervised(scored, tmp);
        }
        return scored;
    }

    protected boolean needsPostProcess() {
        return true;
    }

    protected final void score0PostProcessSupervised(double[] scored, double[] tmp) {
        if (((Output)this._output).isClassifier()) {
            if (((Parameters)this._parms)._balance_classes) {
                GenModel.correctProbabilities((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])((Output)this._output)._modelClassDist);
            }
            if (!((Output)this._output).hasTreatment()) {
                scored[0] = GenModel.getPrediction((double[])scored, (double[])((Output)this._output)._priorClassDist, (double[])tmp, (double)this.defaultThreshold());
            }
        }
    }

    protected abstract double[] score0(double[] var1, double[] var2);

    protected double[] score0(double[] data, double[] preds, double offset) {
        assert (offset == 0.0) : "Override this method for non-trivial offset!";
        return this.score0(data, preds);
    }

    public double score(double[] data) {
        double[] pred = this.score0(data, new double[((Output)this._output).nclasses()]);
        return ((Output)this._output).nclasses() == 1 ? pred[0] : (double)water.util.ArrayUtils.maxIndex(pred);
    }

    @Override
    protected Futures remove_impl(Futures fs, boolean cascade) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key<ModelMetrics> k : ((Output)this._output)._model_metrics) {
                Keyed.remove(k, fs, true);
            }
        }
        if (cascade) {
            this.deleteCrossValidationFoldAssignment();
            this.deleteCrossValidationPreds();
            this.deleteCrossValidationModels();
        }
        FrameUtils.cleanUp(this._toDelete);
        return super.remove_impl(fs, cascade);
    }

    @Override
    protected AutoBuffer writeAll_impl(AutoBuffer ab) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key<ModelMetrics> k : ((Output)this._output)._model_metrics) {
                ab.putKey(k);
            }
        }
        return super.writeAll_impl(ab);
    }

    @Override
    protected Keyed readAll_impl(AutoBuffer ab, Futures fs) {
        if (((Output)this._output)._model_metrics != null) {
            for (Key<ModelMetrics> k : ((Output)this._output)._model_metrics) {
                ab.getKey(k, fs);
            }
        }
        return super.readAll_impl(ab, fs);
    }

    @Override
    protected long checksum_impl() {
        return ((Parameters)this._parms).checksum(null) * ((Output)this._output).checksum_impl();
    }

    public ModelMojoWriter getMojo() {
        throw H2O.unimpl("MOJO format is not available for " + ((Parameters)this._parms).fullName() + " models.");
    }

    protected CategoricalEncoding getGenModelEncoding() {
        return CategoricalEncoding.AUTO;
    }

    public final String toJava(boolean preview, boolean verboseCode) {
        ByteArrayOutputStream os = new ByteArrayOutputStream(Short.MAX_VALUE);
        this.toJava(os, preview, verboseCode);
        return os.toString();
    }

    public final SBPrintStream toJava(OutputStream os, boolean preview, boolean verboseCode) {
        if (preview) {
            os = new LineLimitOutputStreamWrapper(os, 1000);
        }
        return this.toJava(new SBPrintStream(os), preview, verboseCode);
    }

    protected SBPrintStream toJava(SBPrintStream sb, boolean isGeneratingPreview, boolean verboseCode) {
        boolean writeOrigs;
        PojoWriter writer = this.makePojoWriter();
        CodeGeneratorPipeline fileCtx = new CodeGeneratorPipeline();
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.p("/*").nl();
        sb.p("  Licensed under the Apache License, Version 2.0").nl();
        sb.p("    http://www.apache.org/licenses/LICENSE-2.0.html").nl();
        sb.nl();
        sb.p("  AUTOGENERATED BY H2O at ").p(new DateTime().toString()).nl();
        sb.p("  ").p(H2O.ABV.projectVersion()).nl();
        sb.p("  ").nl();
        sb.p("  Standalone prediction code with sample test data for ").p(this.toJavaModelClassName()).p(" named ").p(modelName).nl();
        sb.nl();
        sb.p("  How to download, compile and execute:").nl();
        sb.p("      mkdir tmpdir").nl();
        sb.p("      cd tmpdir").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/h2o-genmodel.jar > h2o-genmodel.jar").nl();
        sb.p("      curl http:/").p(H2O.SELF.toString()).p("/3/Models.java/").pobj(this._key).p(" > ").p(modelName).p(".java").nl();
        sb.p("      javac -cp h2o-genmodel.jar -J-Xmx2g -J-XX:MaxPermSize=128m ").p(modelName).p(".java").nl();
        sb.nl();
        sb.p("     (Note:  Try java argument -XX:+PrintCompilation to show runtime JIT compiler behavior.)").nl();
        if (((Parameters)this._parms)._offset_column != null) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model export does not support offset_column.").nl();
            sb.nl();
            Log.warn("Java model export does not support offset_column.");
        }
        if (isGeneratingPreview && writer.toJavaCheckTooBig()) {
            sb.nl();
            sb.nl();
            sb.nl();
            sb.p("  NOTE:  Java model is too large to preview, please download as shown above.").nl();
            sb.nl();
            return sb;
        }
        sb.p("*/").nl();
        sb.p("import java.util.Map;").nl();
        sb.p("import hex.genmodel.GenModel;").nl();
        sb.p("import hex.genmodel.annotations.ModelPojo;").nl();
        for (Class<?> clz : this.getPojoInterfaces()) {
            sb.p("import ").p(clz.getName()).p(";").nl();
        }
        sb.nl();
        sb.p("@ModelPojo(name=\"").p(modelName).p("\", algorithm=\"").p(this.toJavaAlgo()).p("\")").nl();
        sb.p("public class ").p(modelName).p(" extends GenModel ").p(this.makeImplementsClause()).p("{").nl().ii(1);
        sb.ip("public hex.ModelCategory getModelCategory() { return hex.ModelCategory." + ((Output)this._output).getModelCategory() + "; }").nl();
        writer.toJavaInit(sb, fileCtx).nl();
        this.toJavaNAMES(sb, fileCtx);
        CategoricalEncoding encoding = this.getGenModelEncoding();
        assert (encoding != null);
        boolean bl = writeOrigs = encoding != CategoricalEncoding.AUTO;
        if (writeOrigs && ((Output)this._output)._origNames != null) {
            this.toJavaOrigNAMES(sb, fileCtx);
        }
        this.toJavaNCLASSES(sb);
        this.toJavaDOMAINS(sb, fileCtx);
        if (writeOrigs && ((Output)this._output)._origDomains != null) {
            this.toJavaOrigDOMAINS(sb, fileCtx);
        }
        this.toJavaPROB(sb);
        this.toJavaSuper(modelName, sb);
        sb.p("  public String getUUID() { return Long.toString(" + this.toJavaUUID() + "L); }").nl();
        this.toJavaPredict(writer, sb, fileCtx, verboseCode);
        writer.toJavaTransform(sb, fileCtx, verboseCode);
        sb.p("}").nl().di(1);
        fileCtx.generate(sb);
        sb.nl();
        return sb;
    }

    protected PojoWriter makePojoWriter() {
        return new DelegatingPojoWriter(this);
    }

    protected String toJavaModelClassName() {
        return this.getClass().getSimpleName();
    }

    protected String toJavaAlgo() {
        return this.getClass().getSimpleName().toLowerCase().replace("model", "");
    }

    protected String toJavaUUID() {
        return String.valueOf(this.checksum());
    }

    protected Class<?>[] getPojoInterfaces() {
        return new Class[0];
    }

    private SB makeImplementsClause() {
        SB sb = new SB();
        Class<?>[] interfaces = this.getPojoInterfaces();
        if (interfaces.length == 0) {
            return sb;
        }
        sb.p("implements ");
        for (int i = 0; i < interfaces.length - 1; ++i) {
            sb.p(interfaces[i].getSimpleName()).p(", ");
        }
        sb.p(interfaces[interfaces.length - 1].getSimpleName()).p(' ');
        return sb;
    }

    private SBPrintStream toJavaSuper(String modelName, SBPrintStream sb) {
        String responseName = this.isSupervised() ? '\"' + ((Output)this._output).responseName() + '\"' : null;
        return sb.nl().ip("public " + modelName + "() { super(NAMES,DOMAINS," + responseName + "); }").nl();
    }

    private SBPrintStream toJavaNAMES(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        final String namesHolderClassName = "NamesHolder_" + modelName;
        sb.i().p("// ").p("Names of columns used by model.").nl();
        sb.i().p("public static final String[] NAMES = " + namesHolderClassName + ".VALUES;").nl();
        fileCtx.add(new CodeGenerator(){

            @Override
            public void generate(JCodeSB out) {
                out.i().p("// The class representing training column names").nl();
                JCodeGen.toClassWithArray(out, null, namesHolderClassName, Arrays.copyOf(((Output)Model.this._output)._names, ((Output)Model.this._output).nfeatures()));
            }
        });
        return sb;
    }

    private SBPrintStream toJavaOrigNAMES(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        final String namesHolderClassName = "OrigNamesHolder_" + modelName;
        sb.i().p("// ").p("Original names of columns used by model.").nl();
        sb.i().p("public static final String[] ORIG_NAMES = " + namesHolderClassName + ".VALUES;").nl();
        fileCtx.add(new CodeGenerator(){

            @Override
            public void generate(JCodeSB out) {
                out.i().p("// The class representing original training column names").nl();
                int nResponse = ((Output)Model.this._output)._names.length - ((Output)Model.this._output).nfeatures();
                JCodeGen.toClassWithArray(out, null, namesHolderClassName, Arrays.copyOf(((Output)Model.this._output)._origNames, ((Output)Model.this._output)._origNames.length - nResponse));
            }
        });
        sb.nl();
        sb.ip("@Override").nl();
        sb.ip("public String[] getOrigNames() {").nl();
        sb.ii(1).ip("return ORIG_NAMES;").nl();
        sb.di(1).ip("}").nl();
        return sb;
    }

    private SBPrintStream toJavaNCLASSES(SBPrintStream sb) {
        return ((Output)this._output).isClassifier() ? JCodeGen.toStaticVar(sb, "NCLASSES", ((Output)this._output).nclasses(), "Number of output classes included in training data response column.") : sb;
    }

    private SBPrintStream toJavaDOMAINS(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.nl();
        sb.ip("// Column domains. The last array contains domain of response column.").nl();
        sb.ip("public static final String[][] DOMAINS = new String[][] {").nl();
        String[][] domains = this.scoringDomains();
        for (int i = 0; i < domains.length; ++i) {
            final int idx = i;
            final String[] dom = domains[i];
            final String colInfoClazz = modelName + "_ColInfo_" + i;
            sb.i(1).p("/* ").p(((Output)this._output)._names[i]).p(" */ ");
            if (dom != null) {
                sb.p(colInfoClazz).p(".VALUES");
            } else {
                sb.p("null");
            }
            if (i != domains.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (dom == null) continue;
            fileCtx.add(new CodeGenerator(){

                @Override
                public void generate(JCodeSB out) {
                    out.ip("// The class representing column ").p(((Output)Model.this._output)._names[idx]).nl();
                    JCodeGen.toClassWithArray(out, null, colInfoClazz, dom);
                }
            });
        }
        return sb.ip("};").nl();
    }

    private SBPrintStream toJavaOrigDOMAINS(SBPrintStream sb, CodeGeneratorPipeline fileCtx) {
        String modelName = JCodeGen.toJavaId(this._key.toString());
        sb.nl();
        sb.ip("// Original column domains. The last array contains domain of response column.").nl();
        sb.ip("public static final String[][] ORIG_DOMAINS = new String[][] {").nl();
        String[][] domains = ((Output)this._output)._origDomains;
        for (int i = 0; i < domains.length; ++i) {
            final int idx = i;
            final String[] dom = domains[i];
            final String colInfoClazz = modelName + "_OrigColInfo_" + i;
            sb.i(1).p("/* ").p(((Output)this._output)._origNames[i]).p(" */ ");
            if (dom != null) {
                sb.p(colInfoClazz).p(".VALUES");
            } else {
                sb.p("null");
            }
            if (i != domains.length - 1) {
                sb.p(',');
            }
            sb.nl();
            if (dom == null) continue;
            fileCtx.add(new CodeGenerator(){

                @Override
                public void generate(JCodeSB out) {
                    out.ip("// The class representing the original column ").p(((Output)Model.this._output)._names[idx]).nl();
                    JCodeGen.toClassWithArray(out, null, colInfoClazz, dom);
                }
            });
        }
        sb.ip("};").nl();
        sb.nl();
        sb.ip("@Override").nl();
        sb.ip("public String[][] getOrigDomainValues() {").nl();
        sb.ii(1).ip("return ORIG_DOMAINS;").nl();
        sb.di(1).ip("}").nl();
        return sb;
    }

    private SBPrintStream toJavaPROB(SBPrintStream sb) {
        if (this.isSupervised()) {
            JCodeGen.toStaticVar((JCodeSB)sb, "PRIOR_CLASS_DISTRIB", ((Output)this._output)._priorClassDist, "Prior class distribution");
            JCodeGen.toStaticVar((JCodeSB)sb, "MODEL_CLASS_DISTRIB", ((Output)this._output)._modelClassDist, "Class distribution used for model building");
        }
        return sb;
    }

    @Override
    protected boolean toJavaCheckTooBig() {
        Log.warn("toJavaCheckTooBig must be overridden for this model type to render it in the browser");
        return true;
    }

    @Override
    protected SBPrintStream toJavaInit(SBPrintStream sb, CodeGeneratorPipeline fileContext) {
        return sb;
    }

    @Override
    protected void toJavaPredictBody(SBPrintStream body, CodeGeneratorPipeline classCtx, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        throw new UnsupportedOperationException("This model type does not support conversion to Java");
    }

    @Override
    protected SBPrintStream toJavaTransform(SBPrintStream ccsb, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        return ccsb;
    }

    private SBPrintStream toJavaPredict(PojoWriter builder, SBPrintStream ccsb, CodeGeneratorPipeline fileCtx, boolean verboseCode) {
        ccsb.nl();
        ccsb.ip("// Pass in data in a double[], pre-aligned to the Model's requirements.").nl();
        ccsb.ip("// Jam predictions into the preds[] array; preds[0] is reserved for the").nl();
        ccsb.ip("// main prediction (class for classifiers or value for regression),").nl();
        ccsb.ip("// and remaining columns hold a probability distribution for classifiers.").nl();
        ccsb.ip("public final double[] score0( double[] data, double[] preds ) {").nl();
        CodeGeneratorPipeline classCtx = new CodeGeneratorPipeline();
        builder.toJavaPredictBody(ccsb.ii(1), classCtx, fileCtx, verboseCode);
        ccsb.ip("return preds;").nl();
        ccsb.di(1).ip("}").nl();
        classCtx.generate(ccsb.ii(1));
        ccsb.di(1);
        return ccsb;
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon) {
        return this.testJavaScoring(data, model_predictions, rel_epsilon, JavaScoringOptions.DEFAULT._abs_epsilon, JavaScoringOptions.DEFAULT._fraction);
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon, double abs_epsilon) {
        return this.testJavaScoring(data, model_predictions, rel_epsilon, abs_epsilon, JavaScoringOptions.DEFAULT._fraction);
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon, double abs_epsilon, double fraction) {
        return this.testJavaScoring(data, model_predictions, new EasyPredictModelWrapper.Config(), rel_epsilon, abs_epsilon, fraction);
    }

    public boolean testJavaScoring(Frame data, Frame model_predictions, EasyPredictModelWrapper.Config config, double rel_epsilon, double abs_epsilon, double fraction) {
        JavaScoringOptions options = new JavaScoringOptions();
        options._abs_epsilon = abs_epsilon;
        options._fraction = fraction;
        options._config = config;
        return this.testJavaScoring(data, model_predictions, rel_epsilon, options);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean testJavaScoring(Frame data, Frame model_predictions, double rel_epsilon, JavaScoringOptions options) {
        mb = ModelBuilder.make(this._parms.algoName().toLowerCase(), null, null);
        mb._parms = this._parms;
        havePojo = mb.havePojo() != false && options._disable_pojo == false;
        haveMojo = mb.haveMojo() != false && options._disable_mojo == false;
        rnd = RandomUtils.getRNG(new long[]{data.byteSize()});
        if (!Model.$assertionsDisabled && data.numRows() != model_predictions.numRows()) {
            throw new AssertionError();
        }
        fr = new Frame(data);
        computeMetrics = data.vec(this._output.responseName()) != null && data.vec(this._output.responseName()).isBad() == false;
        try {
            warns = this.adaptTestForJavaScoring(fr, computeMetrics);
            if (warns.length > 0) {
                System.err.println(Arrays.toString(warns));
            }
            omap = null;
            if (this._output.isClassifier() && model_predictions.vec(0).domain() != null) {
                actual = fr.vec(this._output.responseName());
                sdomain = actual == null ? null : actual.domain();
                mdomain = model_predictions.vec(0).domain();
                if (sdomain != null && !Arrays.equals(mdomain, sdomain)) {
                    omap = CategoricalWrappedVec.computeMap((String[])mdomain, (String[])sdomain);
                }
            }
            modelName = JCodeGen.toJavaId(this._key.toString());
            preview = false;
            genmodel = null;
            dvecs = fr.vecs();
            pvecs = model_predictions.vecs();
            features = null;
            num_errors = 0;
            num_total = 0;
            if (havePojo) {
                try {
                    java_text = this.toJava(preview, true);
                    clz = JCodeGen.compile(modelName, java_text);
                    genmodel = (GenModel)clz.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IllegalStateException("Internal POJO compilation failed", e);
                }
                for (Class<?> clz : this.getPojoInterfaces()) {
                    if (clz.isInstance(genmodel)) continue;
                    throw new IllegalStateException("POJO is expected to implement interface " + clz.getName());
                }
                if (!Model.$assertionsDisabled && this._output.responseName() != null && !this._output.responseName().equals(genmodel.getResponseName())) {
                    throw new AssertionError();
                }
                features = MemoryManager.malloc8d(genmodel.nfeatures());
                predictions = MemoryManager.malloc8d(genmodel.nclasses() + 1);
                compVecLen = this._output.isBinomialClassifier() != false ? 3 : pvecs.length;
                row = 0;
                while ((long)row < fr.numRows()) {
                    if (!(rnd.nextDouble() >= options._fraction)) {
                        ++num_total;
                        for (col = 0; col < features.length; ++col) {
                            features[col] = dvecs[col].at(row);
                        }
                        genmodel.score0(features, predictions);
                        v0 = col = this._output.isClassifier() != false ? 1 : 0;
                        while (col < compVecLen) {
                            d = pvecs[col].at(row);
                            if (col == 0 && omap != null) {
                                d = omap[(int)d];
                            }
                            if (!MathUtils.compare(predictions[col], d, options._abs_epsilon, rel_epsilon)) {
                                if (num_errors++ >= 10) break;
                                System.err.println("Predictions mismatch, row " + row + ", col " + model_predictions._names[col] + ", internal prediction=" + d + ", POJO prediction=" + predictions[col]);
                                break;
                            }
                            ++col;
                        }
                    }
                    ++row;
                }
            }
            for (i = 0; i < 2; ++i) {
                if (i == 0 && !havePojo || i == 1 && !haveMojo) continue;
                if (i == 1) {
                    filename = modelName + ".zip";
                    ss = new StreamingSchema(this.getMojo(), filename);
                    try {
                        os = new FileOutputStream(ss.getFilename());
                        ss.getStreamWriter().writeTo(os, new StreamWriteOption[0]);
                        os.close();
                        genmodel = MojoModel.load((String)filename, (boolean)true);
                        Model.checkSerializable((MojoModel)genmodel);
                        features = MemoryManager.malloc8d(genmodel._names.length);
                        deleted = new File(filename).delete();
                        ** if (deleted) goto lbl-1000
                    }
                    catch (IOException e1) {
                        try {
                            e1.printStackTrace();
                            throw new IllegalStateException("Internal MOJO loading failed", e1);
                        }
                        catch (Throwable var28_48) {
                            deleted = new File(filename).delete();
                            if (!deleted) {
                                Log.warn(new Object[]{"Failed to delete the file"});
                            }
                            throw var28_48;
                        }
                    }
lbl-1000:
                    // 1 sources

                    {
                        Log.warn(new Object[]{"Failed to delete the file"});
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    if (!Arrays.equals(model_predictions.names(), genmodel.getOutputNames())) {
                        if (this._parms._distribution == DistributionFamily.quasibinomial) {
                            Log.warn(new Object[]{"Quasibinomial doesn't correctly return output names in MOJO"});
                        } else if (genmodel.getModelCategory() == ModelCategory.Clustering && Arrays.equals(genmodel.getOutputNames(), new String[]{"cluster"})) {
                            Log.warn(new Object[]{"Known inconsistency between MOJO output naming and H2O predict - cluster vs predict"});
                        } else if (genmodel instanceof GlrmMojoModel) {
                            Log.trace(new Object[]{"GLRM is being tested for 'reconstruct', not the default score0 - dim reduction, unable to compare output names"});
                        }
                    }
                }
                if (genmodel instanceof GlrmMojoModel) {
                    try {
                        options._config.setModel(genmodel).setEnableGLRMReconstrut(true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                trees = null;
                if (genmodel instanceof SharedTreeMojoModel) {
                    treemodel = (SharedTreeMojoModel)genmodel;
                    ntrees = treemodel.getNTreeGroups();
                    trees = new SharedTreeGraph[ntrees];
                    for (t = 0; t < ntrees; ++t) {
                        trees[t] = treemodel.computeGraph(t);
                    }
                }
                try {
                    options._config.setModel(genmodel).setConvertUnknownCategoricalLevelsToNa(true).setEnableLeafAssignment(genmodel instanceof SharedTreeMojoModel).setEnableStagedProbabilities(genmodel instanceof SharedTreeMojoModel).setUseExternalEncoding(true);
                    epmw = new EasyPredictModelWrapper(options._config);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                rowData = new RowData();
                bStr = new BufferedString();
                compVecLen = i == 0 && this._output.isBinomialClassifier() != false ? 3 : pvecs.length;
                row = 0;
                while ((long)row < fr.numRows()) {
                    block75: {
                        if (!(rnd.nextDouble() >= options._fraction)) {
                            if (genmodel instanceof GlrmMojoModel) {
                                ((GlrmMojoModel)genmodel)._rcnt = row;
                            }
                            for (col = 0; col < features.length; ++col) {
                                if (dvecs[col].isString()) {
                                    rowData.put((Object)genmodel._names[col], (Object)dvecs[col].atStr(bStr, row).toString());
                                    continue;
                                }
                                val = dvecs[col].at(row);
                                rowData.put((Object)genmodel._names[col], genmodel._domains[col] == null ? Double.valueOf(val) : (Double.isNaN(val) != false ? Double.valueOf(val) : ((int)val < genmodel._domains[col].length ? genmodel._domains[col][(int)val] : "UnknownLevel")));
                            }
                            try {
                                if (genmodel instanceof GlrmMojoModel) {
                                    ((GlrmMojoModel)genmodel)._rcnt = row;
                                }
                                if (genmodel._offsetColumn != null) {
                                    offset = fr.vec(genmodel._offsetColumn).at(row);
                                    switch (7.$SwitchMap$hex$ModelCategory[genmodel.getModelCategory().ordinal()]) {
                                        case 1: {
                                            p = epmw.predictRegression(rowData, offset);
                                            break;
                                        }
                                        case 2: {
                                            p = epmw.predictBinomial(rowData, offset);
                                            break;
                                        }
                                        case 3: {
                                            p = epmw.predictMultinomial(rowData, offset);
                                            break;
                                        }
                                        case 4: {
                                            p = epmw.predictOrdinal(rowData, offset);
                                            break;
                                        }
                                        case 5: {
                                            p = epmw.predictKLime(rowData);
                                            break;
                                        }
                                        case 6: {
                                            p = epmw.predictCoxPH(rowData, offset);
                                            break;
                                        }
                                        default: {
                                            throw new UnsupportedOperationException("Predicting with offset current not supported for " + genmodel.getModelCategory());
                                        }
                                    }
                                } else {
                                    p = epmw.predict(rowData);
                                }
                            }
                            catch (PredictException e) {
                                if (++num_errors >= 20) break block75;
                                System.err.println("EasyPredict threw an exception when predicting row " + rowData);
                                e.printStackTrace();
                                break block75;
                            }
                            expected_preds = new double[pvecs.length];
                            actual_preds = new double[pvecs.length];
                            decisionPath = null;
                            nodeIds = null;
                            for (col = 0; col < compVecLen; ++col) {
                                d = pvecs[col].at(row);
                                if (col == 0 && omap != null) {
                                    d = omap[(int)d];
                                }
                                d2 = NaN;
                                switch (7.$SwitchMap$hex$ModelCategory[genmodel.getModelCategory().ordinal()]) {
                                    case 7: {
                                        d2 = ((AutoEncoderModelPrediction)p).reconstructed[col];
                                        break;
                                    }
                                    case 8: {
                                        d2 = ((ClusteringModelPrediction)p).cluster;
                                        break;
                                    }
                                    case 1: {
                                        rmp = (RegressionModelPrediction)p;
                                        d2 = rmp.value;
                                        decisionPath = rmp.leafNodeAssignments;
                                        nodeIds = rmp.leafNodeAssignmentIds;
                                        break;
                                    }
                                    case 2: {
                                        bmp = (BinomialModelPrediction)p;
                                        d2 = col == 0 ? (double)bmp.labelIndex : (col > bmp.classProbabilities.length && bmp.calibratedClassProbabilities != null ? bmp.calibratedClassProbabilities[col - bmp.classProbabilities.length - 1] : bmp.classProbabilities[col - 1]);
                                        decisionPath = bmp.leafNodeAssignments;
                                        nodeIds = bmp.leafNodeAssignmentIds;
                                        break;
                                    }
                                    case 4: {
                                        orp = (OrdinalModelPrediction)p;
                                        d2 = col == 0 ? (double)orp.labelIndex : orp.classProbabilities[col - 1];
                                        break;
                                    }
                                    case 3: {
                                        mmp = (MultinomialModelPrediction)p;
                                        d2 = col == 0 ? (double)mmp.labelIndex : mmp.classProbabilities[col - 1];
                                        decisionPath = mmp.leafNodeAssignments;
                                        nodeIds = mmp.leafNodeAssignmentIds;
                                        break;
                                    }
                                    case 9: {
                                        adp = (AnomalyDetectionPrediction)p;
                                        d2 = adp.toPreds()[col];
                                        decisionPath = adp.leafNodeAssignments;
                                        nodeIds = adp.leafNodeAssignmentIds;
                                        break;
                                    }
                                    case 10: {
                                        d2 = genmodel instanceof GlrmMojoModel != false ? ((DimReductionModelPrediction)p).reconstructed[col] : ((DimReductionModelPrediction)p).dimensions[col];
                                        break;
                                    }
                                    case 6: {
                                        d2 = ((CoxPHModelPrediction)p).value;
                                    }
                                }
                                expected_preds[col] = d;
                                actual_preds[col] = d2;
                            }
                            if (trees != null) {
                                for (t = 0; t < trees.length; ++t) {
                                    tree = trees[t];
                                    node = tree.walkNodes(0, (String)decisionPath[t]);
                                    if (node != null && node.getNodeNumber() == nodeIds[t]) continue;
                                    throw new IllegalStateException("Path to leaf node is inconsistent with predicted node id: path=" + decisionPath[t] + ", nodeId=" + nodeIds[t]);
                                }
                            }
                            ++num_total;
                            v1 = col = genmodel.isClassifier() != false ? 1 : 0;
                            while (col < compVecLen) {
                                if (!MathUtils.compare(actual_preds[col], expected_preds[col], options._abs_epsilon, rel_epsilon)) {
                                    if (++num_errors >= 20) break;
                                    System.err.println((i == 0 ? "POJO" : "MOJO") + " EasyPredict Predictions mismatch for row " + row + ":" + rowData);
                                    System.err.println("  Expected predictions: " + Arrays.toString(expected_preds));
                                    System.err.println("  Actual predictions:   " + Arrays.toString(actual_preds));
                                    System.err.println("Difference: " + Math.abs(expected_preds[expected_preds.length - 1] - actual_preds[actual_preds.length - 1]));
                                    break;
                                }
                                ++col;
                            }
                        }
                    }
                    ++row;
                }
            }
            if (num_errors != 0) {
                System.err.println("Number of errors: " + num_errors + (num_errors > 20 ? " (only first 20 are shown)" : "") + " out of " + num_total + " rows tested.");
            }
            var22_24 = num_errors == 0;
            return var22_24;
        }
        finally {
            Frame.deleteTempFrameAndItsNonSharedVecs(fr, data);
        }
    }

    protected String[] adaptTestForJavaScoring(Frame test, boolean computeMetrics) {
        return this.adaptTestForTrain(test, true, computeMetrics);
    }

    private static void checkSerializable(MojoModel mojoModel) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(mojoModel);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException("MOJO cannot be serialized", e);
        }
    }

    static <T extends Lockable<T>> int deleteAll(Key<T>[] keys) {
        int c = 0;
        for (Key<T> k : keys) {
            Lockable t = (Lockable)DKV.getGet(k);
            if (t == null) continue;
            t.delete();
            ++c;
        }
        return c;
    }

    public void deleteCrossValidationModels() {
        if (((Output)this._output)._cross_validation_models != null) {
            Log.info("Cleaning up CV Models for " + this._key);
            int count = Model.deleteAll(((Output)this._output)._cross_validation_models);
            Log.info(count + " CV models were removed");
        }
    }

    public void deleteCrossValidationPreds() {
        if (((Output)this._output)._cross_validation_predictions != null) {
            Log.info("Cleaning up CV Predictions for " + this._key);
            int count = Model.deleteAll(((Output)this._output)._cross_validation_predictions);
            Log.info(count + " CV predictions were removed");
        }
        Keyed.remove(((Output)this._output)._cross_validation_holdout_predictions_frame_id);
    }

    public void deleteCrossValidationFoldAssignment() {
        Keyed.remove(((Output)this._output)._cross_validation_fold_assignment_frame_id);
    }

    public String toString() {
        return ((Output)this._output).toString();
    }

    @Override
    public Class<KeyV3.ModelKeyV3> makeSchema() {
        return KeyV3.ModelKeyV3.class;
    }

    public static Frame makeInteractions(Frame fr, boolean valid, InteractionPair[] interactions, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyTrainVec = fr.anyVec();
        Vec[] interactionVecs = new Vec[interactions.length];
        String[] interactionNames = new String[interactions.length];
        int idx = 0;
        for (InteractionPair ip : interactions) {
            interactionNames[idx] = fr.name(ip._v1) + "_" + fr.name(ip._v2);
            boolean allFactLevels = useAllFactorLevels || ip.needsAllFactorLevels();
            InteractionWrappedVec iwv = new InteractionWrappedVec(anyTrainVec.group().addVec(), anyTrainVec._rowLayout, ip._v1Enums, ip._v2Enums, allFactLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
            interactionVecs[idx++] = iwv;
        }
        return new Frame(interactionNames, interactionVecs);
    }

    public static InteractionWrappedVec[] makeInteractions(Frame fr, InteractionPair[] interactions, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyTrainVec = fr.anyVec();
        InteractionWrappedVec[] interactionVecs = new InteractionWrappedVec[interactions.length];
        int idx = 0;
        for (InteractionPair ip : interactions) {
            interactionVecs[idx++] = new InteractionWrappedVec(anyTrainVec.group().addVec(), anyTrainVec._rowLayout, ip._v1Enums, ip._v2Enums, useAllFactorLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
        }
        return interactionVecs;
    }

    public static InteractionWrappedVec makeInteraction(Frame fr, InteractionPair ip, boolean useAllFactorLevels, boolean skipMissing, boolean standardize) {
        Vec anyVec = fr.anyVec();
        return new InteractionWrappedVec(anyVec.group().addVec(), anyVec._rowLayout, ip._v1Enums, ip._v2Enums, useAllFactorLevels, skipMissing, standardize, fr.vec((int)((InteractionPair)ip)._v1)._key, fr.vec((int)((InteractionPair)ip)._v2)._key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <M extends Model<?, ?, ?>> M importBinaryModel(String location) throws IOException {
        Model model;
        InputStream is = null;
        try {
            URI targetUri = FileUtils.getURI(location);
            Persist p = H2O.getPM().getPersistForURI(targetUri);
            is = p.open(targetUri.toString());
            AutoBuffer ab = new AutoBuffer(is);
            ab.sourceName = targetUri.toString();
            Model model2 = (Model)Keyed.readAll(ab);
            Keyed.readAll(ab);
            ab.close();
            is.close();
            model = model2;
        }
        catch (Throwable throwable) {
            FileUtils.closeSilently(is);
            throw throwable;
        }
        FileUtils.closeSilently(is);
        return (M)model;
    }

    public static <M extends Model<?, ?, ?>> M uploadBinaryModel(String destinationFrame) throws IOException {
        Frame fr = (Frame)DKV.getGet(destinationFrame);
        ByteVec vec = (ByteVec)fr.vec(0);
        try (InputStream inputStream = vec.openStream(null);){
            AutoBuffer ab = new AutoBuffer(inputStream);
            Model model = (Model)Keyed.readAll(ab);
            Keyed.readAll(ab);
            ab.close();
            Model model2 = model;
            return (M)model2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final URI exportBinaryModel(String location, boolean force, ModelExportOption ... options) throws IOException {
        URI uRI;
        OutputStream os = null;
        try {
            URI targetUri = FileUtils.getURI(location);
            Persist p = H2O.getPM().getPersistForURI(targetUri);
            os = p.create(targetUri.toString(), force);
            this.writeTo(os, options);
            os.close();
            uRI = targetUri;
        }
        catch (Throwable throwable) {
            FileUtils.closeSilently(os);
            throw throwable;
        }
        FileUtils.closeSilently(os);
        return uRI;
    }

    @Override
    public final void writeTo(OutputStream os, StreamWriteOption ... options) {
        try (AutoBuffer ab = new AutoBuffer(os, true);){
            this.writeAll(ab);
            Keyed holdoutFrame = null;
            if (water.util.ArrayUtils.contains(options, ModelExportOption.INCLUDE_CV_PREDICTIONS) && ((Output)this._output)._cross_validation_holdout_predictions_frame_id != null && (holdoutFrame = (Frame)DKV.getGet(((Output)this._output)._cross_validation_holdout_predictions_frame_id)) == null) {
                Log.warn("CV holdout predictions frame is no longer available and won't be exported in the binary model file.");
            }
            if (holdoutFrame != null) {
                holdoutFrame.writeAll(ab);
            } else {
                ab.put(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI exportMojo(String location, boolean force) throws IOException {
        URI uRI;
        if (!this.haveMojo()) {
            throw new IllegalStateException("Model doesn't support MOJOs.");
        }
        OutputStream os = null;
        try {
            URI targetUri = FileUtils.getURI(location);
            Persist p = H2O.getPM().getPersistForURI(targetUri);
            os = p.create(targetUri.toString(), force);
            ModelMojoWriter mojo = this.getMojo();
            mojo.writeTo(os, new StreamWriteOption[0]);
            os.close();
            uRI = targetUri;
        }
        catch (Throwable throwable) {
            FileUtils.closeSilently(os);
            throw throwable;
        }
        FileUtils.closeSilently(os);
        return uRI;
    }

    public MojoModel toMojo() throws IOException {
        MojoReaderBackend mojoReaderBackend = this.convertToInMemoryMojoReader();
        return MojoModel.load((MojoReaderBackend)mojoReaderBackend);
    }

    public MojoModel toMojo(boolean readMetadata) throws IOException {
        MojoReaderBackend mojoReaderBackend = this.convertToInMemoryMojoReader();
        return ModelMojoReader.readFrom((MojoReaderBackend)mojoReaderBackend, (boolean)readMetadata);
    }

    MojoReaderBackend convertToInMemoryMojoReader() throws IOException {
        if (!this.haveMojo()) {
            throw new IllegalStateException("Model doesn't support MOJOs.");
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.getMojo().writeTo(os, new StreamWriteOption[0]);
            MojoReaderBackend mojoReaderBackend = MojoReaderBackendFactory.createReaderBackend((InputStream)new ByteArrayInputStream(os.toByteArray()), (MojoReaderBackendFactory.CachingStrategy)MojoReaderBackendFactory.CachingStrategy.MEMORY);
            return mojoReaderBackend;
        }
    }

    public ModelDescriptor modelDescriptor() {
        return new H2OModelDescriptor();
    }

    public boolean isFeatureUsedInPredict(String featureName) {
        if (featureName.equals(((Parameters)this._parms)._response_column)) {
            return false;
        }
        int featureIdx = water.util.ArrayUtils.find(((Output)this._output)._names, featureName);
        if (featureIdx == -1) {
            return false;
        }
        return this.isFeatureUsedInPredict(featureIdx);
    }

    protected boolean isFeatureUsedInPredict(int featureIdx) {
        return true;
    }

    public boolean isDistributionHuber() {
        return ((Parameters)this._parms)._distribution == DistributionFamily.huber;
    }

    protected class H2OModelDescriptor
    implements ModelDescriptor {
        protected H2OModelDescriptor() {
        }

        public String[][] scoringDomains() {
            return Model.this.scoringDomains();
        }

        public String projectVersion() {
            return H2O.ABV.projectVersion();
        }

        public String algoName() {
            return ((Parameters)Model.this._parms).algoName();
        }

        public String algoFullName() {
            return ((Parameters)Model.this._parms).fullName();
        }

        public String offsetColumn() {
            return ((Output)Model.this._output).offsetName();
        }

        public String weightsColumn() {
            return ((Output)Model.this._output).weightsName();
        }

        public String foldColumn() {
            return ((Output)Model.this._output).foldName();
        }

        public ModelCategory getModelCategory() {
            return ((Output)Model.this._output).getModelCategory();
        }

        public boolean isSupervised() {
            return ((Output)Model.this._output).isSupervised();
        }

        public int nfeatures() {
            return ((Output)Model.this._output).nfeatures();
        }

        public String[] features() {
            return ((Output)Model.this._output).features();
        }

        public int nclasses() {
            return ((Output)Model.this._output).nclasses();
        }

        public String[] columnNames() {
            return ((Output)Model.this._output)._names;
        }

        public boolean balanceClasses() {
            return ((Parameters)Model.this._parms)._balance_classes;
        }

        public double defaultThreshold() {
            return Model.this.defaultThreshold();
        }

        public double[] priorClassDist() {
            return ((Output)Model.this._output)._priorClassDist;
        }

        public double[] modelClassDist() {
            return ((Output)Model.this._output)._modelClassDist;
        }

        public String uuid() {
            return String.valueOf(Model.this.checksum());
        }

        public String timestamp() {
            return new DateTime().toString();
        }

        public String[] getOrigNames() {
            return ((Output)Model.this._output)._origNames;
        }

        public String[][] getOrigDomains() {
            return ((Output)Model.this._output)._origDomains;
        }
    }

    public static class InteractionPair
    extends Iced<InteractionPair> {
        public final String _name1;
        public final String _name2;
        private int _v1;
        private int _v2;
        private String[] _v1Enums;
        private String[] _v2Enums;
        private int _hash;
        private boolean _needsAllFactorLevels;

        private InteractionPair(Frame f, int v1, int v2, String[] v1Enums, String[] v2Enums) {
            this._name1 = f.name(v1);
            this._name2 = f.name(v2);
            this._v1 = v1;
            this._v2 = v2;
            this._v1Enums = v1Enums;
            this._v2Enums = v2Enums;
            this._hash = 17;
            this._hash = 31 * this._hash + this._v1;
            this._hash = 31 * this._hash + this._v2;
            if (this._v1Enums == null) {
                this._hash = 31 * this._hash;
            } else {
                for (String s : this._v1Enums) {
                    this._hash = 31 * this._hash + s.hashCode();
                }
            }
            if (this._v2Enums == null) {
                this._hash = 31 * this._hash;
            } else {
                for (String s : this._v2Enums) {
                    this._hash = 31 * this._hash + s.hashCode();
                }
            }
        }

        public boolean needsAllFactorLevels() {
            return this._needsAllFactorLevels;
        }

        public void setNeedsAllFactorLevels(boolean needsAllFactorLevels) {
            this._needsAllFactorLevels = needsAllFactorLevels;
        }

        public static InteractionPair[] generatePairwiseInteractionsFromList(Frame f, int ... indexes) {
            if (null == indexes) {
                return null;
            }
            if (indexes.length < 2) {
                if (indexes.length == 1 && indexes[0] == -1) {
                    return null;
                }
                throw new IllegalArgumentException("Must supply 2 or more columns.");
            }
            InteractionPair[] res = new InteractionPair[(indexes.length - 1) * indexes.length >> 1];
            int idx = 0;
            for (int i = 0; i < indexes.length; ++i) {
                for (int j = i + 1; j < indexes.length; ++j) {
                    res[idx++] = new InteractionPair(f, indexes[i], indexes[j], f.vec(indexes[i]).domain(), f.vec(indexes[j]).domain());
                }
            }
            return res;
        }

        public int hashCode() {
            return this._hash;
        }

        public String toString() {
            return this._v1 + (this._v1Enums == null ? "" : Arrays.toString(this._v1Enums)) + ":" + this._v2 + (this._v2Enums == null ? "" : Arrays.toString(this._v2Enums));
        }

        public boolean equals(Object o) {
            boolean res = o instanceof InteractionPair;
            if (res) {
                InteractionPair ip = (InteractionPair)o;
                return this._v1 == ip._v1 && this._v2 == ip._v2 && Arrays.equals(this._v1Enums, ip._v1Enums) && Arrays.equals(this._v2Enums, ip._v2Enums);
            }
            return false;
        }

        public int getV1() {
            return this._v1;
        }

        public int getV2() {
            return this._v2;
        }

        public boolean isNumeric() {
            return this._v1Enums == null && this._v2Enums == null;
        }
    }

    public class JavaModelStreamWriter
    implements StreamWriter {
        private final boolean preview;

        public JavaModelStreamWriter(boolean preview) {
            this.preview = preview;
        }

        @Override
        public void writeTo(OutputStream os, StreamWriteOption ... options) {
            Model.this.toJava(os, this.preview, true);
        }
    }

    public static class JavaScoringOptions {
        private static final JavaScoringOptions DEFAULT = new JavaScoringOptions();
        public double _abs_epsilon = 1.0E-15;
        public double _fraction = 1.0;
        public boolean _disable_pojo = false;
        public boolean _disable_mojo = false;
        EasyPredictModelWrapper.Config _config = new EasyPredictModelWrapper.Config();
    }

    public static interface BigScoreChunkPredict
    extends AutoCloseable {
        public double[] score0(Chunk[] var1, double var2, int var4, double[] var5, double[] var6);

        @Override
        public void close();
    }

    public static interface BigScorePredict {
        public BigScoreChunkPredict initMap(Frame var1, Chunk[] var2);
    }

    protected class BigScore
    extends CMetricScoringTask<BigScore>
    implements BigScorePredict,
    BigScoreChunkPredict {
        protected final String[] _domain;
        protected final int _npredcols;
        final double[] _mean;
        public final boolean _computeMetrics;
        public final boolean _hasWeights;
        public final boolean _makePreds;
        public final Job _j;
        private transient BigScorePredict _localPredict;
        public ModelMetrics.MetricBuilder _mb;

        public BigScore(String[] domain, int ncols, double[] mean, boolean testHasWeights, boolean computeMetrics, boolean makePreds, Job j, CFuncRef customMetricFunc) {
            super(customMetricFunc);
            this._j = j;
            this._domain = domain;
            this._npredcols = ncols;
            this._mean = mean;
            this._computeMetrics = computeMetrics;
            this._makePreds = makePreds;
            if (((Output)Model.this._output)._hasWeights && this._computeMetrics && !testHasWeights) {
                throw new IllegalArgumentException("Missing weights when computing validation metrics.");
            }
            this._hasWeights = testHasWeights;
        }

        @Override
        protected void setupLocal() {
            super.setupLocal();
            this._localPredict = Model.this.setupBigScorePredict(this);
            assert (this._localPredict != null);
        }

        @Override
        public void map(Chunk[] chks, NewChunk[] cpreds) {
            if (this.isCancelled() || this._j != null && this._j.stop_requested()) {
                return;
            }
            Chunk weightsChunk = this._hasWeights && this._computeMetrics ? chks[((Output)Model.this._output).weightsIdx()] : null;
            Chunk offsetChunk = ((Output)Model.this._output).hasOffset() ? chks[((Output)Model.this._output).offsetIdx()] : null;
            Chunk responseChunk = null;
            float[] actual = null;
            this._mb = Model.this.makeMetricBuilder(this._domain);
            if (this._computeMetrics) {
                if (((Output)Model.this._output).hasResponse()) {
                    actual = new float[1];
                    responseChunk = chks[((Output)Model.this._output).responseIdx()];
                } else {
                    actual = new float[chks.length];
                }
            }
            int len = chks[0]._len;
            try (BigScoreChunkPredict predict = this._localPredict.initMap(this._fr, chks);){
                double[] tmp = new double[((Output)Model.this._output).nfeatures()];
                for (int row = 0; row < len; ++row) {
                    double weight;
                    double d = weight = weightsChunk != null ? weightsChunk.atd(row) : 1.0;
                    if (weight == 0.0) {
                        if (!this._makePreds) continue;
                        for (int c = 0; c < this._npredcols; ++c) {
                            cpreds[c].addNum(0.0);
                        }
                        continue;
                    }
                    double offset = offsetChunk != null ? offsetChunk.atd(row) : 0.0;
                    double[] preds = predict.score0(chks, offset, row, tmp, this._mb._work);
                    if (this._computeMetrics) {
                        if (responseChunk != null) {
                            actual[0] = (float)responseChunk.atd(row);
                        } else {
                            for (int i = 0; i < actual.length; ++i) {
                                actual[i] = (float)Model.this.data(chks, row, i);
                            }
                        }
                        this._mb.perRow(preds, actual, weight, offset, Model.this);
                        this.customMetricPerRow(preds, actual, weight, offset, Model.this);
                    }
                    if (!this._makePreds) continue;
                    for (int c = 0; c < this._npredcols; ++c) {
                        cpreds[c].addNum(preds[c]);
                    }
                }
            }
        }

        @Override
        public double[] score0(Chunk[] chks, double offset, int row_in_chunk, double[] tmp, double[] preds) {
            return Model.this.score0(chks, offset, row_in_chunk, tmp, preds);
        }

        @Override
        public BigScoreChunkPredict initMap(Frame fr, Chunk[] chks) {
            return this;
        }

        @Override
        public void close() {
        }

        @Override
        public void reduce(BigScore bs) {
            super.reduce(bs);
            if (this._mb != null) {
                this._mb.reduce(bs._mb);
            }
        }

        @Override
        protected void postGlobal() {
            super.postGlobal();
            if (this._mb != null) {
                this._mb.postGlobal(this.getComputedCustomMetric());
            }
        }
    }

    protected class PredictScoreResult {
        private final ModelMetrics.MetricBuilder<?> _mb;
        private final Frame _rawPreds;
        private final Frame _outputPreds;

        public PredictScoreResult(ModelMetrics.MetricBuilder<?> mb, Frame rawPreds, Frame outputPreds) {
            this._mb = mb;
            this._rawPreds = rawPreds;
            this._outputPreds = outputPreds;
        }

        public final Frame getPredictions() {
            return this._outputPreds;
        }

        public ModelMetrics.MetricBuilder<?> getMetricBuilder() {
            return this._mb;
        }

        public ModelMetrics makeModelMetrics(Frame fr, Frame adaptFrm) {
            if (this._mb == null) {
                return null;
            }
            return this._mb.makeModelMetrics(Model.this, fr, adaptFrm, this._rawPreds);
        }
    }

    public static interface AdaptFrameParameters {
        public Parameters.CategoricalEncodingScheme getCategoricalEncoding();

        public String getWeightsColumn();

        public String getOffsetColumn();

        public String getFoldColumn();

        public String getResponseColumn();

        public String getTreatmentColumn();

        public double missingColumnsType();

        public int getMaxCategoricalLevels();

        default public String[] getNonPredictors() {
            return (String[])Arrays.stream(new String[]{this.getWeightsColumn(), this.getOffsetColumn(), this.getFoldColumn(), this.getResponseColumn(), this.getTreatmentColumn()}).filter(Objects::nonNull).toArray(String[]::new);
        }
    }

    public static abstract class Output
    extends Iced {
        public String[] _names;
        public String[] _column_types;
        public String[] _origNames;
        public String[][] _domains;
        public String[][] _origDomains;
        public double[] _orig_projection_array;
        public Key[] _cross_validation_models;
        public Key[] _cross_validation_predictions;
        public Key<Frame> _cross_validation_holdout_predictions_frame_id;
        public Key<Frame> _cross_validation_fold_assignment_frame_id;
        public long _start_time;
        public long _end_time;
        public long _run_time;
        public long _total_run_time;
        Key<ModelMetrics>[] _model_metrics = new Key[0];
        public Job _job;
        public ModelMetrics _training_metrics;
        public ModelMetrics _validation_metrics;
        public ModelMetrics _cross_validation_metrics;
        public TwoDimTable _cross_validation_metrics_summary;
        public TwoDimTable _model_summary;
        public TwoDimTable[] _reproducibility_information_table;
        public TwoDimTable _scoring_history;
        public TwoDimTable[] _cv_scoring_history;
        public double[] _distribution;
        public double[] _modelClassDist;
        public double[] _priorClassDist;
        protected boolean _isSupervised;
        public double _defaultThreshold;
        protected boolean _hasOffset;
        protected boolean _hasWeights;
        protected boolean _hasFold;
        protected boolean _hasTreatment;

        @Deprecated
        public void setNames(String[] names) {
            this._names = names;
            this._column_types = new String[names.length];
            Arrays.fill(this._column_types, "NA");
        }

        public void setNames(String[] names, String[] columntypes) {
            this._names = names;
            this._column_types = columntypes;
        }

        protected void startClock() {
            this._start_time = System.currentTimeMillis();
        }

        protected void stopClock() {
            this._end_time = System.currentTimeMillis();
            this._total_run_time = this._run_time = this._end_time - this._start_time;
        }

        public Output() {
            this(false, false, false);
        }

        public Output(boolean hasWeights, boolean hasOffset, boolean hasFold) {
            this._hasWeights = hasWeights;
            this._hasOffset = hasOffset;
            this._hasFold = hasFold;
        }

        public Output(ModelBuilder b) {
            this(b, b._train);
        }

        protected Output(ModelBuilder b, Frame train) {
            if (b.error_count() > 0) {
                throw new IllegalArgumentException(b.validationErrors());
            }
            this.setNames(train != null ? train.names() : new String[]{}, train != null ? train.typesStr() : new String[]{});
            this._domains = train != null ? train.domains() : new String[][]{};
            this._origNames = b._origNames;
            this._origDomains = b._origDomains;
            this._orig_projection_array = b._orig_projection_array;
            this._isSupervised = b.isSupervised();
            this._hasOffset = b.hasOffsetCol();
            this._hasWeights = b.hasWeightCol();
            this._hasFold = b.hasFoldCol();
            this._hasTreatment = b.hasTreatmentCol();
            this._distribution = b._distribution;
            this._priorClassDist = b._priorClassDist;
            this._reproducibility_information_table = this.createReproducibilityInformationTable(b);
            assert (this._job == null);
            this._defaultThreshold = -1.0;
        }

        public int nfeatures() {
            return this._names.length - (this._hasOffset ? 1 : 0) - (this._hasWeights ? 1 : 0) - (this._hasFold ? 1 : 0) - (this._hasTreatment ? 1 : 0) - (this.isSupervised() ? 1 : 0);
        }

        public String[] features() {
            return Arrays.copyOf(this._names, this.nfeatures());
        }

        public boolean isSupervised() {
            return this._isSupervised;
        }

        public boolean hasOffset() {
            return this._hasOffset;
        }

        public boolean hasWeights() {
            return this._hasWeights;
        }

        public boolean hasFold() {
            return this._hasFold;
        }

        public boolean hasTreatment() {
            return this._hasTreatment;
        }

        public boolean hasResponse() {
            return this.isSupervised();
        }

        public String responseName() {
            return this.isSupervised() ? this._names[this.responseIdx()] : null;
        }

        public String weightsName() {
            return this._hasWeights ? this._names[this.weightsIdx()] : null;
        }

        public String offsetName() {
            return this._hasOffset ? this._names[this.offsetIdx()] : null;
        }

        public String foldName() {
            return this._hasFold ? this._names[this.foldIdx()] : null;
        }

        public InteractionBuilder interactionBuilder() {
            return null;
        }

        protected int lastSpecialColumnIdx() {
            return this._names.length - 1 - (this.isSupervised() ? 1 : 0);
        }

        public int weightsIdx() {
            if (!this._hasWeights) {
                return -1;
            }
            return this.lastSpecialColumnIdx() - (this.hasOffset() ? 1 : 0) - (this.hasFold() ? 1 : 0) - (this.hasTreatment() ? 1 : 0);
        }

        public int offsetIdx() {
            if (!this._hasOffset) {
                return -1;
            }
            return this.lastSpecialColumnIdx() - (this.hasFold() ? 1 : 0) - (this.hasTreatment() ? 1 : 0);
        }

        public int foldIdx() {
            if (!this._hasFold) {
                return -1;
            }
            return this.lastSpecialColumnIdx() - (this.hasTreatment() ? 1 : 0);
        }

        public int responseIdx() {
            if (!this.isSupervised()) {
                return -1;
            }
            return this._names.length - 1;
        }

        public int treatmentIdx() {
            if (!this._hasTreatment) {
                return -1;
            }
            return this._names.length - (this.isSupervised() ? 1 : 0) - 1;
        }

        public String[] classNames() {
            if (this._domains == null || this._domains.length == 0 || !this.isSupervised()) {
                return null;
            }
            return this._domains[this._domains.length - 1];
        }

        public boolean isClassifier() {
            return this.isSupervised() && this.nclasses() > 1;
        }

        public boolean isBinomialClassifier() {
            return this.isSupervised() && this.nclasses() == 2;
        }

        public boolean isMultinomialClassifier() {
            return this.isSupervised() && this.nclasses() > 2;
        }

        public int nclasses() {
            String[] cns = this.classNames();
            return cns == null ? 1 : cns.length;
        }

        public ModelCategory getModelCategory() {
            if (this.isSupervised()) {
                return this.isClassifier() ? (this.nclasses() > 2 ? ModelCategory.Multinomial : ModelCategory.Binomial) : ModelCategory.Regression;
            }
            return ModelCategory.Unknown;
        }

        public boolean isAutoencoder() {
            return false;
        }

        public TwoDimTable getVariableImportances() {
            return null;
        }

        public synchronized Key<ModelMetrics>[] clearModelMetrics(boolean keepModelTrainingMetrics) {
            Key<ModelMetrics>[] removed;
            if (keepModelTrainingMetrics) {
                Key[] kept = new Key[]{};
                if (this._training_metrics != null) {
                    kept = water.util.ArrayUtils.append(kept, this._training_metrics._key);
                }
                if (this._validation_metrics != null) {
                    kept = water.util.ArrayUtils.append(kept, this._validation_metrics._key);
                }
                if (this._cross_validation_metrics != null) {
                    kept = water.util.ArrayUtils.append(kept, this._cross_validation_metrics._key);
                }
                removed = new Key[]{};
                for (Key<ModelMetrics> k : this._model_metrics) {
                    if (water.util.ArrayUtils.contains(kept, k)) continue;
                    removed = water.util.ArrayUtils.append(removed, k);
                }
                this._model_metrics = kept;
            } else {
                removed = Arrays.copyOf(this._model_metrics, this._model_metrics.length);
                this._model_metrics = new Key[0];
            }
            return removed;
        }

        public synchronized Key<ModelMetrics>[] getModelMetrics() {
            return Arrays.copyOf(this._model_metrics, this._model_metrics.length);
        }

        public synchronized void changeModelMetricsKey(Key modelkey) {
            for (Key<ModelMetrics> modelMetrics : this._model_metrics) {
                modelMetrics.get().setModelKey(modelkey);
            }
        }

        protected long checksum_impl() {
            return (null == this._names ? 13 : Arrays.hashCode(this._names)) * (null == this._domains ? 17 : Arrays.deepHashCode((Object[])this._domains)) * this.getModelCategory().ordinal();
        }

        public double defaultThreshold() {
            if (this.nclasses() != 2 || this._training_metrics == null || this._training_metrics instanceof ModelMetricsBinomialUplift) {
                return 0.5;
            }
            if (this._defaultThreshold == -1.0) {
                if (this._validation_metrics != null && ((ModelMetricsBinomial)this._validation_metrics)._auc != null) {
                    return ((ModelMetricsBinomial)this._validation_metrics)._auc.defaultThreshold();
                }
                if (((ModelMetricsBinomial)this._training_metrics)._auc != null) {
                    return ((ModelMetricsBinomial)this._training_metrics)._auc.defaultThreshold();
                }
            } else {
                return this._defaultThreshold;
            }
            return 0.5;
        }

        public void resetThreshold(double value) {
            assert (value > 0.0 && value <= 1.0) : "Reset threshold should be value from 0 to 1 (included). Got " + value + ".";
            this._defaultThreshold = value;
        }

        public void printTwoDimTables(StringBuilder sb, Object o) {
            for (Field f : Weaver.getWovenFields(o.getClass())) {
                Class<TwoDimTable> c = f.getType();
                if (!c.isAssignableFrom(TwoDimTable.class)) continue;
                try {
                    TwoDimTable t = (TwoDimTable)f.get(this);
                    f.setAccessible(true);
                    if (t == null) continue;
                    sb.append(t.toString(1, false));
                }
                catch (IllegalAccessException e) {
                    Log.err(e);
                    sb.append("Failed to print table ").append(f.getName()).append("\n");
                }
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._training_metrics != null) {
                sb.append(this._training_metrics.toString());
            }
            if (this._validation_metrics != null) {
                sb.append(this._validation_metrics.toString());
            }
            if (this._cross_validation_metrics != null) {
                sb.append(this._cross_validation_metrics.toString());
            }
            this.printTwoDimTables(sb, this);
            return sb.toString();
        }

        private TwoDimTable[] createReproducibilityInformationTable(ModelBuilder modelBuilder) {
            TwoDimTable nodeInformation = ReproducibilityInformationUtils.createNodeInformationTable();
            TwoDimTable clusterConfiguration = ReproducibilityInformationUtils.createClusterConfigurationTable();
            TwoDimTable inputFramesInformation = this.createInputFramesInformationTable(modelBuilder);
            return new TwoDimTable[]{nodeInformation, clusterConfiguration, inputFramesInformation};
        }

        public TwoDimTable createInputFramesInformationTable(ModelBuilder modelBuilder) {
            String[] colHeaders = new String[]{"Input Frame", "Checksum", "ESPC"};
            String[] colTypes = new String[]{"string", "long", "string"};
            String[] colFormat = new String[]{"%s", "%d", "%d"};
            int rows = this.getInformationTableNumRows();
            TwoDimTable table = new TwoDimTable("Input Frames Information", null, new String[rows], colHeaders, colTypes, colFormat, "");
            table.set(0, 0, "training_frame");
            table.set(1, 0, "validation_frame");
            table.set(0, 1, modelBuilder.train() != null ? modelBuilder.train().checksum() : -1L);
            table.set(1, 1, modelBuilder._valid != null ? modelBuilder.valid().checksum() : -1L);
            table.set(0, 2, modelBuilder.train() != null ? Arrays.toString(modelBuilder.train().anyVec().espc()) : Integer.valueOf(-1));
            table.set(1, 2, modelBuilder._valid != null ? Arrays.toString(modelBuilder.valid().anyVec().espc()) : Integer.valueOf(-1));
            return table;
        }

        public int getInformationTableNumRows() {
            return 2;
        }
    }

    public static class InteractionSpec
    extends Iced {
        private final String[] _columns;
        private final StringPair[] _pairs;
        private final String[] _interactionsOnly;
        private String[] _ignored;

        private InteractionSpec(String[] columns, StringPair[] pairs, String[] interactionsOnly, String[] ignored) {
            this._columns = columns;
            this._pairs = pairs;
            this._interactionsOnly = interactionsOnly;
            if (ignored != null) {
                this._ignored = (String[])ignored.clone();
                Arrays.sort(this._ignored);
            }
        }

        public String[] getInteractionsOnly() {
            return this._interactionsOnly;
        }

        public static InteractionSpec allPairwise(String[] columns) {
            return columns != null ? new InteractionSpec(columns, null, null, null) : null;
        }

        public static InteractionSpec create(String[] columns, StringPair[] pairs, String[] interactionsOnly, String[] ignored) {
            return columns == null && pairs == null ? null : new InteractionSpec(columns, pairs, interactionsOnly, ignored);
        }

        public static InteractionSpec create(String[] columns, StringPair[] pairs, String[] interactionsOnly) {
            return columns == null && pairs == null ? null : new InteractionSpec(columns, pairs, interactionsOnly, null);
        }

        public static InteractionSpec create(String[] columns, StringPair[] pairs) {
            return columns == null && pairs == null ? null : new InteractionSpec(columns, pairs, null, null);
        }

        public boolean isEmpty() {
            return this._columns == null && this._pairs == null;
        }

        private boolean isUsed(String col) {
            if (this._columns != null) {
                for (String usedCol : this._columns) {
                    if (!usedCol.equals(col)) continue;
                    return true;
                }
            }
            if (this._pairs != null) {
                for (StringPair colPair : this._pairs) {
                    if (!col.equals(colPair._a) && !col.equals(colPair._b)) continue;
                    return true;
                }
            }
            return false;
        }

        public Frame reorderColumns(Frame f) {
            if (this._interactionsOnly == null || f == null) {
                return f;
            }
            Vec[] interOnlyVecs = f.vecs(this._interactionsOnly);
            f.remove(this._interactionsOnly);
            for (int i = 0; i < this._interactionsOnly.length; ++i) {
                if (this.isUsed(this._interactionsOnly[i])) {
                    f.add(this._interactionsOnly[i], interOnlyVecs[i]);
                    continue;
                }
                if (this.isIgnored(this._interactionsOnly[i])) continue;
                Log.warn("Column '" + this._interactionsOnly[i] + "' was marked to be used for interactions only but it is not actually required in any interaction.");
            }
            return f;
        }

        private boolean isIgnored(String column) {
            return this._ignored != null && Arrays.binarySearch(this._ignored, column) >= 0;
        }

        public Frame removeInteractionOnlyColumns(Frame f) {
            if (this._interactionsOnly == null || f == null) {
                return f;
            }
            return f.remove(this._interactionsOnly);
        }

        public InteractionPair[] makeInteractionPairs(Frame f) {
            InteractionPair[] pairs;
            if (this.isEmpty()) {
                return null;
            }
            InteractionPair[] allPairwise = null;
            InteractionPair[] allExplicit = null;
            int[] interactionIDs = new int[]{};
            if (this._columns != null) {
                interactionIDs = new int[this._columns.length];
                for (int i = 0; i < this._columns.length; ++i) {
                    interactionIDs[i] = f.find(this._columns[i]);
                    if (interactionIDs[i] != -1) continue;
                    throw new IllegalArgumentException("missing column from the dataset, could not make interaction: " + interactionIDs[i]);
                }
                allPairwise = InteractionPair.generatePairwiseInteractionsFromList(f, interactionIDs);
            }
            if (this._pairs != null) {
                Arrays.sort(interactionIDs);
                allExplicit = new InteractionPair[this._pairs.length];
                int n = 0;
                for (StringPair p : this._pairs) {
                    int aIdx = f.find(p._a);
                    if (aIdx == -1) {
                        throw new IllegalArgumentException("Invalid interactions specified (first column is missing): " + p.toJsonString() + " in " + Arrays.toString(f.names()));
                    }
                    int bIdx = f.find(p._b);
                    if (bIdx == -1) {
                        throw new IllegalArgumentException("Invalid interactions specified (second column is missing): " + p.toJsonString() + " in " + Arrays.toString(f.names()));
                    }
                    if (Arrays.binarySearch(interactionIDs, aIdx) >= 0 && Arrays.binarySearch(interactionIDs, bIdx) >= 0) continue;
                    allExplicit[n++] = new InteractionPair(f, aIdx, bIdx, f.vec(aIdx).domain(), f.vec(bIdx).domain());
                }
                if (n != allExplicit.length) {
                    InteractionPair[] resized = new InteractionPair[n];
                    System.arraycopy(allExplicit, 0, resized, 0, resized.length);
                    allExplicit = resized;
                }
            }
            InteractionPair[] interactionPairArray = pairs = allExplicit == null ? allPairwise : (InteractionPair[])water.util.ArrayUtils.append(allPairwise, allExplicit);
            if (pairs != null) {
                pairs = this.flagAllFactorInteractionPairs(f, pairs);
            }
            return pairs;
        }

        private InteractionPair[] flagAllFactorInteractionPairs(Frame f, InteractionPair[] pairs) {
            if (this._interactionsOnly == null || this._interactionsOnly.length == 0) {
                return pairs;
            }
            Object[] interOnly = (String[])this._interactionsOnly.clone();
            Arrays.sort(interOnly);
            for (InteractionPair p : pairs) {
                boolean v2num;
                boolean v1num = f.vec(p._v1).isNumeric();
                if (v1num == (v2num = f.vec(p._v2).isNumeric())) continue;
                String numVecName = v1num ? f.name(p._v1) : f.name(p._v2);
                boolean needsAllFactorColumns = Arrays.binarySearch(interOnly, numVecName) >= 0;
                p.setNeedsAllFactorLevels(needsAllFactorColumns);
            }
            return pairs;
        }
    }

    public static interface InteractionBuilder {
        public Frame makeInteractions(Frame var1);
    }

    public static abstract class Parameters
    extends Iced<Parameters>
    implements AdaptFrameParameters {
        public static final int MAX_SUPPORTED_LEVELS = 0x100000;
        public Key<Frame> _train;
        public Key<Frame> _valid;
        public int _nfolds = 0;
        public boolean _keep_cross_validation_models = true;
        public boolean _keep_cross_validation_predictions = false;
        public int _keep_cross_validation_predictions_precision = -1;
        public boolean _keep_cross_validation_fold_assignment = false;
        public boolean _parallelize_cross_validation = true;
        public boolean _auto_rebalance = true;
        public Key<ModelPreprocessor>[] _preprocessors;
        public long _seed = -1L;
        public FoldAssignmentScheme _fold_assignment = FoldAssignmentScheme.AUTO;
        public CategoricalEncodingScheme _categorical_encoding = CategoricalEncodingScheme.AUTO;
        public int _max_categorical_levels = 10;
        public DistributionFamily _distribution = DistributionFamily.AUTO;
        public double _tweedie_power = 1.5;
        public double _quantile_alpha = 0.5;
        public double _huber_alpha = 0.9;
        public String[] _ignored_columns;
        public boolean _ignore_const_cols;
        public String _weights_column;
        public String _offset_column;
        public String _fold_column;
        public String _treatment_column;
        public boolean _check_constant_response = true;
        public boolean _is_cv_model;
        public int _cv_fold = -1;
        public boolean _score_each_iteration;
        public double _max_runtime_secs = 0.0;
        public double _main_model_time_budget_factor = 0.0;
        public int _stopping_rounds = 0;
        public ScoreKeeper.StoppingMetric _stopping_metric = ScoreKeeper.StoppingMetric.AUTO;
        public double _stopping_tolerance = this.defaultStoppingTolerance();
        public String _response_column;
        public boolean _balance_classes = false;
        public float _max_after_balance_size = 5.0f;
        public float[] _class_sampling_factors;
        public int _max_confusion_matrix_size = 20;
        public Key<? extends Model> _checkpoint;
        public Key<? extends Model> _pretrained_autoencoder;
        public String _custom_metric_func = null;
        public String _custom_distribution_func = null;
        public String _export_checkpoints_dir;
        public int _gainslift_bins = -1;
        public MultinomialAucType _auc_type = MultinomialAucType.AUTO;
        public AUUC.AUUCType _auuc_type = AUUC.AUUCType.AUTO;
        public int _auuc_nbins = -1;

        public abstract String algoName();

        public abstract String fullName();

        public abstract String javaName();

        protected double defaultStoppingTolerance() {
            return 0.001;
        }

        public abstract long progressUnits();

        public void setTrain(Key<Frame> train) {
            this._train = train;
        }

        public long getOrMakeRealSeed() {
            while (this._seed == -1L) {
                this._seed = RandomUtils.getRNG(System.nanoTime()).nextLong();
                Log.debug("Auto-generated time-based seed for pseudo-random number generator (because it was set to -1): " + this._seed);
            }
            return this._seed;
        }

        public Parameters() {
            this._ignore_const_cols = this.defaultDropConsCols();
        }

        public final Frame train() {
            return this._train == null ? null : this._train.get();
        }

        public final Frame valid() {
            return this._valid == null ? null : this._valid.get();
        }

        @Override
        public String[] getNonPredictors() {
            return (String[])Arrays.stream(new String[]{this._weights_column, this._offset_column, this._fold_column, this._response_column, this._treatment_column}).filter(Objects::nonNull).toArray(String[]::new);
        }

        public void read_lock_frames(Job job) {
            Key jobKey = job._key;
            Frame tr = this.train();
            if (tr != null) {
                this.read_lock_frame(tr, jobKey);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this.read_lock_frame(this._valid.get(), jobKey);
            }
        }

        private void read_lock_frame(Frame fr, Key<Job> jobKey) {
            if (this._is_cv_model) {
                fr.write_lock_to_read_lock(jobKey);
            } else {
                fr.read_lock(jobKey);
            }
        }

        public void read_unlock_frames(Job job) {
            Frame tr = this.train();
            if (tr != null) {
                tr.unlock(job._key, false);
            }
            if (this._valid != null && !this._train.equals(this._valid)) {
                this.valid().unlock(job._key, false);
            }
        }

        protected boolean defaultDropConsCols() {
            return true;
        }

        @Override
        public double missingColumnsType() {
            return Double.NaN;
        }

        public boolean hasCheckpoint() {
            return this._checkpoint != null;
        }

        public long checksum() {
            return this.checksum(null);
        }

        public long checksum(Set<String> ignoredFields) {
            long xs = 24589L;
            int count = 0;
            Field[] fields = Weaver.getWovenFields(this.getClass());
            Arrays.sort(fields, Comparator.comparing(Field::getName));
            for (Field f : fields) {
                if (ignoredFields != null && ignoredFields.contains(f.getName())) continue;
                long P = MathUtils.PRIMES[count % MathUtils.PRIMES.length];
                Class<?> c = f.getType();
                if (c.isArray()) {
                    try {
                        f.setAccessible(true);
                        if (f.get(this) != null) {
                            Object[] arr;
                            if (c.getComponentType() == Integer.TYPE) {
                                arr = (int[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode(arr);
                            }
                            if (c.getComponentType() == Float.TYPE) {
                                arr = (float[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((float[])arr);
                            }
                            if (c.getComponentType() == Double.TYPE) {
                                arr = (double[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((double[])arr);
                            }
                            if (c.getComponentType() == Long.TYPE) {
                                arr = (long[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((long[])arr);
                            }
                            if (c.getComponentType() == Boolean.TYPE) {
                                arr = (boolean[])f.get(this);
                                xs = xs * P + (long)Arrays.hashCode((boolean[])arr);
                            }
                            arr = (Object[])f.get(this);
                            xs = xs * P + (long)Arrays.deepHashCode(arr);
                        }
                        xs *= P;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                    catch (ClassCastException t) {
                        throw H2O.fail("Failed to calculate checksum for the parameter object", t);
                    }
                } else {
                    try {
                        f.setAccessible(true);
                        Object value = f.get(this);
                        xs = value instanceof Enum ? xs * P + (long)value.toString().hashCode() : (value != null ? xs * P + (long)value.hashCode() : xs * P + P);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                ++count;
            }
            return xs ^= (this.train() == null ? 43L : this.train().checksum()) * (this.valid() == null ? 17L : this.valid().checksum());
        }

        private void addToUsedIfColumn(Set<String> usedColumns, Set<String> allColumns, String value) {
            if (value == null) {
                return;
            }
            if (allColumns.contains(value)) {
                usedColumns.add(value);
            }
        }

        public Set<String> getUsedColumns(String[] trainNames) {
            Field[] fields;
            HashSet<String> trainColumns = new HashSet<String>(Arrays.asList(trainNames));
            HashSet<String> usedColumns = new HashSet<String>();
            for (Field f : fields = Weaver.getWovenFields(this.getClass())) {
                if (f.getName().equals("_ignored_columns") || !f.getName().toLowerCase().contains("column")) continue;
                Class<?> c = f.getType();
                if (c.isArray()) {
                    try {
                        String[] values;
                        f.setAccessible(true);
                        if (f.get(this) == null || c.getComponentType() != String.class) continue;
                        for (String v : values = (String[])f.get(this)) {
                            this.addToUsedIfColumn(usedColumns, trainColumns, v);
                        }
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    f.setAccessible(true);
                    Object value = f.get(this);
                    if (!(value instanceof String)) continue;
                    this.addToUsedIfColumn(usedColumns, trainColumns, (String)value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return usedColumns;
        }

        public Set<Key<?>> getDependentKeys() {
            Field[] fields = Weaver.getWovenFields(this.getClass());
            HashSet values = new HashSet();
            for (Field f : fields) {
                f.setAccessible(true);
                Class<?> c = f.getType();
                try {
                    Key[] arr;
                    Object value = f.get(this);
                    if (value instanceof Key) {
                        values.add((Key)value);
                        continue;
                    }
                    if (value == null || !c.isArray() || c.getComponentType() != Key.class) continue;
                    for (Key k : arr = (Key[])value) {
                        if (k == null) continue;
                        values.add(k);
                    }
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            return values;
        }

        @Override
        public final CategoricalEncodingScheme getCategoricalEncoding() {
            return this._categorical_encoding;
        }

        @Override
        public final String getWeightsColumn() {
            return this._weights_column;
        }

        @Override
        public final String getOffsetColumn() {
            return this._offset_column;
        }

        @Override
        public final String getFoldColumn() {
            return this._fold_column;
        }

        @Override
        public final String getResponseColumn() {
            return this._response_column;
        }

        @Override
        public final String getTreatmentColumn() {
            return this._treatment_column;
        }

        @Override
        public final int getMaxCategoricalLevels() {
            return this._max_categorical_levels;
        }

        public void setDistributionFamily(DistributionFamily distributionFamily) {
            this._distribution = distributionFamily;
        }

        public DistributionFamily getDistributionFamily() {
            return this._distribution;
        }

        public static enum CategoricalEncodingScheme {
            AUTO(false),
            OneHotInternal(false),
            OneHotExplicit(false),
            Enum(false),
            Binary(false),
            Eigen(false),
            LabelEncoder(false),
            SortByResponse(true),
            EnumLimited(false);

            final boolean _needResponse;

            private CategoricalEncodingScheme(boolean needResponse) {
                this._needResponse = needResponse;
            }

            boolean needsResponse() {
                return this._needResponse;
            }

            public static CategoricalEncodingScheme fromGenModel(CategoricalEncoding encoding) {
                if (encoding == null) {
                    return null;
                }
                try {
                    return CategoricalEncodingScheme.valueOf(CategoricalEncodingScheme.class, encoding.name());
                }
                catch (IllegalArgumentException iae) {
                    throw new UnsupportedOperationException("Unknown encoding " + encoding);
                }
            }
        }

        public static enum FoldAssignmentScheme {
            AUTO,
            Random,
            Modulo,
            Stratified;

        }
    }

    public static class GridSortBy {
        public static final GridSortBy LOGLOSS = new GridSortBy("logloss", false);
        public static final GridSortBy RESDEV = new GridSortBy("residual_deviance", false);
        public static final GridSortBy R2 = new GridSortBy("r2", true);
        public final String _name;
        public final boolean _decreasing;

        GridSortBy(String name, boolean decreasing) {
            this._name = name;
            this._decreasing = decreasing;
        }
    }

    public static interface GetNTrees {
        public int getNTrees();
    }

    public static interface GetMostImportantFeatures {
        public String[] getMostImportantFeatures(int var1);
    }

    public static interface ExemplarMembers {
        public Frame scoreExemplarMembers(Key<Frame> var1, int var2);
    }

    public static interface RowToTreeAssignment {
        public Frame rowToTreeAssignment(Frame var1, Key<Frame> var2, Job<Frame> var3);
    }

    public static interface Contributions {
        public Frame scoreContributions(Frame var1, Key<Frame> var2);

        default public Frame scoreContributions(Frame frame, Key<Frame> destination_key, Job<Frame> j) {
            return this.scoreContributions(frame, destination_key, j, new ContributionsOptions());
        }

        default public Frame scoreContributions(Frame frame, Key<Frame> destination_key, Job<Frame> j, ContributionsOptions options) {
            return this.scoreContributions(frame, destination_key);
        }

        default public void composeScoreContributionTaskMetadata(String[] names, byte[] types, String[][] domains, String[] originalFrameNames, ContributionsOptions options) {
            String[] contribNames = ArrayUtils.append((String[])originalFrameNames, (String[])new String[]{"BiasTerm"});
            ContributionComposer contributionComposer = new ContributionComposer();
            int topNAdjusted = contributionComposer.checkAndAdjustInput(options._topN, originalFrameNames.length);
            int bottomNAdjusted = contributionComposer.checkAndAdjustInput(options._bottomN, originalFrameNames.length);
            int outputSize = Math.min((topNAdjusted + bottomNAdjusted) * 2, originalFrameNames.length * 2);
            for (int i = 0; i < outputSize; i += 2) {
                types[i] = 4;
                domains[i] = Arrays.copyOf(contribNames, contribNames.length);
                domains[i + 1] = null;
                types[i + 1] = 3;
            }
            int topFeatureIterator = 1;
            for (int i = 0; i < topNAdjusted * 2; i += 2) {
                names[i] = "top_feature_" + topFeatureIterator;
                names[i + 1] = "top_value_" + topFeatureIterator;
                ++topFeatureIterator;
            }
            int bottomFeatureIterator = 1;
            for (int i = topNAdjusted * 2; i < outputSize; i += 2) {
                names[i] = "bottom_feature_" + bottomFeatureIterator;
                names[i + 1] = "bottom_value_" + bottomFeatureIterator;
                ++bottomFeatureIterator;
            }
            names[outputSize] = "BiasTerm";
            types[outputSize] = 3;
            domains[outputSize] = null;
        }

        public static class ContributionsOptions {
            public ContributionsOutputFormat _outputFormat = ContributionsOutputFormat.Original;
            public int _topN;
            public int _bottomN;
            public boolean _compareAbs;

            public ContributionsOptions setOutputFormat(ContributionsOutputFormat outputFormat) {
                this._outputFormat = outputFormat;
                return this;
            }

            public ContributionsOptions setTopN(int topN) {
                this._topN = topN;
                return this;
            }

            public ContributionsOptions setBottomN(int bottomN) {
                this._bottomN = bottomN;
                return this;
            }

            public ContributionsOptions setCompareAbs(boolean compareAbs) {
                this._compareAbs = compareAbs;
                return this;
            }

            public boolean isSortingRequired() {
                return this._topN != 0 || this._bottomN != 0;
            }
        }

        public static enum ContributionsOutputFormat {
            Original,
            Compact;

        }
    }

    public static interface UpdateAuxTreeWeights {
        public UpdateAuxTreeWeightsReport updateAuxTreeWeights(Frame var1, String var2);

        public static class UpdateAuxTreeWeightsReport {
            public int[] _warn_trees;
            public int[] _warn_classes;

            public boolean hasWarnings() {
                return this._warn_trees != null && this._warn_trees.length > 0;
            }
        }
    }

    public static interface StagedPredictions {
        public Frame scoreStagedPredictions(Frame var1, Key<Frame> var2);
    }

    public static interface FeatureFrequencies {
        public Frame scoreFeatureFrequencies(Frame var1, Key<Frame> var2);
    }

    public static interface LeafNodeAssignment {
        public Frame scoreLeafNodeAssignment(Frame var1, LeafNodeAssignmentType var2, Key<Frame> var3);

        public static enum LeafNodeAssignmentType {
            Path,
            Node_ID;

        }
    }

    public static interface GLRMArchetypes {
        public Frame scoreReconstruction(Frame var1, Key<Frame> var2, boolean var3);

        public Frame scoreArchetypes(Frame var1, Key<Frame> var2, boolean var3);
    }

    public static interface DeepFeatures {
        public Frame scoreAutoEncoder(Frame var1, Key var2, boolean var3);

        public Frame scoreDeepFeatures(Frame var1, int var2);

        public Frame scoreDeepFeatures(Frame var1, int var2, Job var3);

        public Frame scoreDeepFeatures(Frame var1, String var2, Job var3);
    }
}

