/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ModelBuilder;
import org.apache.log4j.Logger;
import water.H2O;
import water.Job;
import water.ParallelizationTask;

public class SubModelBuilder {
    private static final Logger LOG = Logger.getLogger(SubModelBuilder.class);
    private final Job<?> job;
    private final ModelBuilder<?, ?, ?>[] modelBuilders;
    private final int parallelization;

    public SubModelBuilder(Job<?> job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization) {
        this.job = job;
        this.modelBuilders = modelBuilders;
        this.parallelization = parallelization;
    }

    public void bulkBuildModels() {
        H2O.H2OCountedCompleter[] tasks = new TrainModelTask[this.modelBuilders.length];
        for (int i = 0; i < this.modelBuilders.length; ++i) {
            tasks[i] = new TrainModelTask(this.modelBuilders[i]);
        }
        H2O.submitTask(new ParallelizationTask(tasks, this.parallelization, this.job)).join();
    }

    private static class TrainModelTask
    extends H2O.H2OCountedCompleter<TrainModelTask> {
        private final ModelBuilder<?, ?, ?> _mb;

        TrainModelTask(ModelBuilder<?, ?, ?> mb) {
            this._mb = mb;
        }

        @Override
        public void compute2() {
            LOG.info((Object)("Building " + this._mb._desc + "."));
            boolean success = false;
            try {
                this._mb.startClock();
                this._mb.submitTrainModelTask().join();
                success = true;
            }
            catch (Throwable throwable) {
                LOG.info((Object)(this._mb._desc + (success ? " completed successfully." : " failed.")));
                throw throwable;
            }
            LOG.info((Object)(this._mb._desc + (success ? " completed successfully." : " failed.")));
            this.tryComplete();
        }
    }
}

