/*
 * Decompiled with CFR 0.152.
 */
package water.rapids;

import java.math.BigInteger;
import water.DKV;
import water.H2O;
import water.H2ONode;
import water.Iced;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.util.MathUtils;

class RadixCount
extends MRTask<RadixCount> {
    private Long2DArray _counts;
    private final int _shift;
    private final int _col;
    private final BigInteger _base;
    private final boolean _isLeft;
    private final int[][] _id_maps;
    private final int _ascending;
    final long _mergeId;

    RadixCount(boolean isLeft, BigInteger base, int shift, int col, int[][] id_maps, int ascending, long mergeId) {
        this._isLeft = isLeft;
        this._base = base;
        this._col = col;
        this._shift = shift;
        this._id_maps = id_maps;
        this._ascending = ascending;
        this._mergeId = mergeId;
    }

    static Key getKey(boolean isLeft, int col, long mergeId, H2ONode node) {
        return Key.make("__radix_order__MSBNodeCounts_col" + col + "_node" + node.index() + "_" + mergeId + (isLeft ? "_LEFT" : "_RIGHT"));
    }

    @Override
    protected void setupLocal() {
        this._counts = new Long2DArray(this._fr.anyVec().nChunks());
    }

    @Override
    public void map(Chunk chk) {
        block13: {
            boolean isIntVal;
            long[] tmp;
            block12: {
                long[] lArray = new long[256];
                this._counts._val[chk.cidx()] = lArray;
                tmp = lArray;
                boolean bl = isIntVal = chk.vec().isCategorical() || chk.vec().isInt();
                if (!chk.vec().isCategorical()) break block12;
                assert (this._id_maps[0].length > 0);
                assert (this._base.compareTo(BigInteger.ZERO) == 0);
                if (chk.vec().naCnt() == 0L) {
                    for (int r = 0; r < chk._len; ++r) {
                        int ctrVal;
                        int n = ctrVal = this._isLeft ? BigInteger.valueOf(this._id_maps[0][(int)chk.at8(r)] + 1).shiftRight(this._shift).intValue() : BigInteger.valueOf((int)chk.at8(r) + 1).shiftRight(this._shift).intValue();
                        tmp[n] = tmp[n] + 1L;
                    }
                } else {
                    for (int r = 0; r < chk._len; ++r) {
                        int ctrVal;
                        if (chk.isNA(r)) {
                            tmp[0] = tmp[0] + 1L;
                            continue;
                        }
                        int n = ctrVal = this._isLeft ? BigInteger.valueOf(this._id_maps[0][(int)chk.at8(r)] + 1).shiftRight(this._shift).intValue() : BigInteger.valueOf((int)chk.at8(r) + 1).shiftRight(this._shift).intValue();
                        tmp[n] = tmp[n] + 1L;
                    }
                }
                break block13;
            }
            if (this._isLeft && chk.vec().isCategorical()) break block13;
            if (chk.vec().naCnt() == 0L) {
                for (int r = 0; r < chk._len; ++r) {
                    long ctrVal = isIntVal ? BigInteger.valueOf(chk.at8(r) * (long)this._ascending).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue() : MathUtils.convertDouble2BigInteger((double)this._ascending * chk.atd(r)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue();
                    int n = (int)ctrVal;
                    tmp[n] = tmp[n] + 1L;
                }
            } else {
                for (int r = 0; r < chk._len; ++r) {
                    if (chk.isNA(r)) {
                        tmp[0] = tmp[0] + 1L;
                        continue;
                    }
                    long ctrVal = isIntVal ? BigInteger.valueOf((long)this._ascending * chk.at8(r)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue() : MathUtils.convertDouble2BigInteger((double)this._ascending * chk.atd(r)).subtract(this._base).add(BigInteger.ONE).shiftRight(this._shift).longValue();
                    int n = (int)ctrVal;
                    tmp[n] = tmp[n] + 1L;
                }
            }
        }
    }

    @Override
    protected void closeLocal() {
        DKV.put(RadixCount.getKey(this._isLeft, this._col, this._mergeId, H2O.SELF), this._counts, this._fs, true);
    }

    static class Long2DArray
    extends Iced {
        long[][] _val;

        Long2DArray(int len) {
            this._val = new long[len][];
        }
    }
}

