/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import hex.ModelBuilder;
import hex.ModelBuilderListener;
import java.util.Collection;
import java.util.Objects;
import jsr166y.ForkJoinTask;
import org.apache.log4j.Logger;
import water.Iced;
import water.util.IcedAtomicInt;

public class ParallelModelBuilder
extends ForkJoinTask<ParallelModelBuilder> {
    private static final Logger LOG = Logger.getLogger(ParallelModelBuilder.class);
    private final transient ParallelModelBuilderCallback _callback;
    private final transient IcedAtomicInt _modelInProgressCounter = new IcedAtomicInt();
    private final transient ParallelModelBuiltListener _parallelModelBuiltListener;

    public ParallelModelBuilder(ParallelModelBuilderCallback callback) {
        Objects.requireNonNull(callback);
        this._callback = callback;
        this._parallelModelBuiltListener = new ParallelModelBuiltListener();
    }

    public void run(Collection<ModelBuilder> modelBuilders) {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("run with " + modelBuilders.size() + " models"));
        }
        for (ModelBuilder modelBuilder : modelBuilders) {
            this._modelInProgressCounter.incrementAndGet();
            modelBuilder.trainModel(this._parallelModelBuiltListener);
        }
    }

    private void attemptComplete() {
        int modelsInProgress = this._modelInProgressCounter.decrementAndGet();
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Completed a model, left in progress: " + modelsInProgress));
        }
        if (modelsInProgress == 0) {
            this.complete(this);
        }
    }

    @Override
    public ParallelModelBuilder getRawResult() {
        return this;
    }

    @Override
    protected void setRawResult(ParallelModelBuilder value) {
    }

    @Override
    protected boolean exec() {
        return false;
    }

    public static class ModelBuildFailure {
        private final Throwable _throwable;
        private final Model.Parameters _parameters;

        public ModelBuildFailure(Throwable throwable, Model.Parameters parameters) {
            this._throwable = throwable;
            this._parameters = parameters;
        }

        public Throwable getThrowable() {
            return this._throwable;
        }

        public Model.Parameters getParameters() {
            return this._parameters;
        }
    }

    private class ParallelModelBuiltListener
    extends ModelBuilderListener<ParallelModelBuiltListener> {
        private ParallelModelBuiltListener() {
        }

        @Override
        public void onModelSuccess(Model model) {
            try {
                ParallelModelBuilder.this._callback.onBuildSuccess(model, ParallelModelBuilder.this);
            }
            finally {
                ParallelModelBuilder.this.attemptComplete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onModelFailure(Throwable cause, Model.Parameters parameters) {
            try {
                ModelBuildFailure modelBuildFailure = new ModelBuildFailure(cause, parameters);
                ParallelModelBuilder.this._callback.onBuildFailure(modelBuildFailure, ParallelModelBuilder.this);
            }
            finally {
                ParallelModelBuilder.this.attemptComplete();
            }
        }
    }

    public static abstract class ParallelModelBuilderCallback<D extends ParallelModelBuilderCallback>
    extends Iced<D> {
        public abstract void onBuildSuccess(Model var1, ParallelModelBuilder var2);

        public abstract void onBuildFailure(ModelBuildFailure var1, ParallelModelBuilder var2);
    }
}

