/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.ast.prims.advmath;

import hex.quantile.Quantile;
import hex.quantile.QuantileModel;
import water.DKV;
import water.Job;
import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Env;
import water.rapids.ast.AstPrimitive;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstNumList;
import water.rapids.vals.ValFrame;

public class AstQtile
extends AstPrimitive {
    @Override
    public String[] args() {
        return new String[]{"ary", "probs", "interpolationMethod", "weights_column"};
    }

    @Override
    public int nargs() {
        return 5;
    }

    @Override
    public String str() {
        return "quantile";
    }

    @Override
    public ValFrame apply(Env env, Env.StackHelp stk, AstRoot[] asts) {
        QuantileModel.QuantileParameters parms = new QuantileModel.QuantileParameters();
        Frame fr = stk.track(asts[1].exec(env)).getFrame();
        Frame fr_wkey = new Frame(fr);
        DKV.put(fr_wkey);
        parms._train = fr_wkey._key;
        for (double d : parms._probs = ((AstNumList)asts[2]).expand()) {
            if (!(d < 0.0) && !(d > 1.0)) continue;
            throw new IllegalArgumentException("Probability must be between 0 and 1: " + d);
        }
        String inter = asts[3].exec(env).getStr();
        parms._combine_method = QuantileModel.CombineMethod.valueOf(inter.toUpperCase());
        parms._weights_column = asts[4].str().equals("_") ? null : asts[4].str();
        Job j = new Quantile(parms).trainModel();
        QuantileModel q = (QuantileModel)j.get();
        DKV.remove(j._key);
        DKV.remove(fr_wkey._key);
        int ncols = fr.numCols();
        if (parms._weights_column != null) {
            --ncols;
        }
        Vec[] vecs = new Vec[1 + ncols];
        String[] names = new String[vecs.length];
        vecs[0] = Vec.makeCon(null, parms._probs);
        names[0] = "Probs";
        int w = 0;
        for (int i = 0; i < vecs.length - 1; ++i) {
            if (fr._names[i].equals(parms._weights_column)) {
                w = 1;
            }
            vecs[i + 1] = Vec.makeCon(null, ((QuantileModel.QuantileOutput)q._output)._quantiles[i]);
            names[i + 1] = fr._names[w + i] + "Quantiles";
        }
        q.delete();
        return new ValFrame(new Frame(names, vecs));
    }
}

