/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Random;
import water.H2O;
import water.Iced;
import water.Job;
import water.Key;
import water.fvec.Frame;
import water.fvec.FrameCreator;
import water.util.Log;
import water.util.PrettyPrint;

public class CreateFrame
extends Iced {
    public final Job<Frame> _job;
    public long rows = 10000L;
    public int cols = 10;
    public long seed = -1L;
    public long seed_for_column_types = -1L;
    public boolean randomize = true;
    public long value = 0L;
    public long real_range = 100L;
    public double categorical_fraction = 0.2;
    public int factors = 100;
    public double integer_fraction = 0.2;
    public double time_fraction = 0.0;
    public double string_fraction = 0.0;
    public long integer_range = 100L;
    public double binary_fraction = 0.1;
    public double binary_ones_fraction = 0.02;
    public double missing_fraction = 0.01;
    public int response_factors = 2;
    public boolean positive_response;
    public boolean has_response = false;

    public CreateFrame(Key<Frame> key) {
        this._job = new Job<Frame>(key, Frame.class.getName(), "CreateFrame");
    }

    public CreateFrame() {
        this(Key.make());
    }

    public Job<Frame> execImpl() {
        long cluster_free_mem;
        if (this.seed == -1L) {
            this.seed = new Random().nextLong();
        }
        if (this.seed_for_column_types == -1L) {
            this.seed_for_column_types = this.seed;
        }
        if (this.integer_fraction + this.binary_fraction + this.categorical_fraction + this.time_fraction + this.string_fraction > 1.00000001) {
            throw new IllegalArgumentException("Integer, binary, categorical, time and string fractions must add up to <= 1.");
        }
        if (this.missing_fraction < 0.0 || this.missing_fraction > 1.0) {
            throw new IllegalArgumentException("Missing fraction must be between 0 and 1.");
        }
        if (this.integer_fraction < 0.0 || this.integer_fraction > 1.0) {
            throw new IllegalArgumentException("Integer fraction must be between 0 and 1.");
        }
        if (this.binary_fraction < 0.0 || this.binary_fraction > 1.0) {
            throw new IllegalArgumentException("Binary fraction must be between 0 and 1.");
        }
        if (this.time_fraction < 0.0 || this.time_fraction > 1.0) {
            throw new IllegalArgumentException("Time fraction must be between 0 and 1.");
        }
        if (this.string_fraction < 0.0 || this.string_fraction > 1.0) {
            throw new IllegalArgumentException("String fraction must be between 0 and 1.");
        }
        if (this.binary_ones_fraction < 0.0 || this.binary_ones_fraction > 1.0) {
            throw new IllegalArgumentException("Binary ones fraction must be between 0 and 1.");
        }
        if (this.categorical_fraction < 0.0 || this.categorical_fraction > 1.0) {
            throw new IllegalArgumentException("Categorical fraction must be between 0 and 1.");
        }
        if (this.categorical_fraction > 0.0 && this.factors <= 1) {
            throw new IllegalArgumentException("Factors must be larger than 2 for categorical data.");
        }
        if (this.response_factors < 1) {
            throw new IllegalArgumentException("Response factors must be either 1 (real-valued response), or >=2 (factor levels).");
        }
        if (this.response_factors > 0x100000) {
            throw new IllegalArgumentException("Response factors must be <= 1048576.");
        }
        if (this.factors > 10000000) {
            throw new IllegalArgumentException("Number of factors must be <= 10,000,000).");
        }
        if (this.cols <= 0 || this.rows <= 0L) {
            throw new IllegalArgumentException("Must have number of rows > 0 and columns > 0.");
        }
        double byte_estimate = this.randomize ? (double)(this.rows * (long)this.cols) * (this.binary_fraction * 1.0 / 8.0 + this.categorical_fraction * (double)(this.factors < 128 ? 1 : (this.factors < 32768 ? 2 : 4)) + this.integer_fraction * (double)(this.integer_range < 128L ? 1 : (this.integer_range < 32768L ? 2 : (this.integer_range < Integer.MIN_VALUE ? 4 : 8))) + this.time_fraction * 8.0 + (1.0 - this.integer_fraction - this.binary_fraction - this.categorical_fraction - this.time_fraction - this.string_fraction) * 8.0) + (double)this.rows : 0.0;
        if (byte_estimate > (double)(cluster_free_mem = H2O.CLOUD.free_mem())) {
            throw new IllegalArgumentException("Frame is expected to require " + PrettyPrint.bytes((long)byte_estimate) + ", won't fit into H2O's free memory of " + cluster_free_mem);
        }
        if (!this.randomize) {
            if (this.integer_fraction != 0.0 || this.categorical_fraction != 0.0 || this.time_fraction != 0.0 || this.string_fraction != 0.0) {
                throw new IllegalArgumentException("Cannot have integer, categorical or time fractions > 0 unless randomize=true.");
            }
        } else if (this.value != 0L) {
            throw new IllegalArgumentException("Cannot set data to a constant value if randomize=true.");
        }
        Log.info("Generated seed: " + this.seed);
        FrameCreator fc = new FrameCreator(this);
        return this._job.start(fc, fc.nChunks() * 7);
    }
}

