/*
 * Decompiled with CFR 0.152.
 */
package hex.leaderboard;

import hex.Model;
import hex.leaderboard.LeaderboardCell;
import hex.leaderboard.LeaderboardColumn;
import java.util.HashMap;
import java.util.Map;
import water.Iced;
import water.Key;

public class MetricScore
extends Iced<MetricScore>
implements LeaderboardCell<Double, MetricScore> {
    private static final Map<String, LeaderboardColumn> COLUMNS = new HashMap<String, LeaderboardColumn>();
    private final Key<Model> _modelId;
    private final String _metric;
    private Double _score;

    public static LeaderboardColumn getColumn(String metric) {
        if (!COLUMNS.containsKey(metric)) {
            COLUMNS.put(metric, new LeaderboardColumn(metric, "double", "%.6f"));
        }
        return COLUMNS.get(metric);
    }

    public MetricScore(Key<Model> modelId, String metric, Double score) {
        this._modelId = modelId;
        this._metric = metric;
        this._score = score;
    }

    @Override
    public LeaderboardColumn getColumn() {
        return MetricScore.getColumn(this._metric);
    }

    @Override
    public Key<Model> getModelId() {
        return this._modelId;
    }

    @Override
    public Double getValue() {
        return this._score;
    }

    @Override
    public void setValue(Double value) {
        this._score = value;
    }
}

