/*
 * Decompiled with CFR 0.152.
 */
package hex.schemas;

import hex.ScoreKeeper;
import hex.grid.HyperSpaceSearchCriteria;
import water.api.API;
import water.api.EnumValuesProvider;
import water.api.schemas3.SchemaV3;
import water.exceptions.H2OIllegalArgumentException;
import water.util.PojoUtils;

public class HyperSpaceSearchCriteriaV99<I extends HyperSpaceSearchCriteria, S extends HyperSpaceSearchCriteriaV99<I, S>>
extends SchemaV3<I, S> {
    @API(help="Hyperparameter space search strategy.", required=true, valuesProvider=StrategyValuesProvider.class, direction=API.Direction.INOUT)
    public HyperSpaceSearchCriteria.Strategy strategy;

    public static HyperSpaceSearchCriteriaV99 make(HyperSpaceSearchCriteria.Strategy strategy) {
        switch (strategy) {
            case Cartesian: {
                return new CartesianSearchCriteriaV99();
            }
            case RandomDiscrete: {
                return new RandomDiscreteValueSearchCriteriaV99();
            }
            case Sequential: {
                return new SequentialSearchCriteriaV99();
            }
        }
        throw new H2OIllegalArgumentException("search_criteria.strategy", strategy.toString());
    }

    public S fillWithDefaults() {
        HyperSpaceSearchCriteria defaults = HyperSpaceSearchCriteria.make(this.strategy);
        this.fillFromImpl(defaults);
        return (S)this;
    }

    public static class StrategyValuesProvider
    extends EnumValuesProvider<HyperSpaceSearchCriteria.Strategy> {
        public StrategyValuesProvider() {
            super(HyperSpaceSearchCriteria.Strategy.class);
        }
    }

    public static class SequentialSearchCriteriaV99
    extends HyperSpaceSearchCriteriaV99<HyperSpaceSearchCriteria.SequentialSearchCriteria, SequentialSearchCriteriaV99> {
        @API(help="Maximum number of models to build (optional).", direction=API.Direction.INOUT)
        public int max_models;
        @API(help="Maximum time to spend building models (optional).", direction=API.Direction.INOUT)
        public double max_runtime_secs;
        @API(help="Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public int stopping_rounds;
        @API(help="Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)", valuesProvider=RandomSearchStoppingMetricValuesProvider.class, level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public ScoreKeeper.StoppingMetric stopping_metric;
        @API(help="Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public double stopping_tolerance;
        @API(help="Use early stopping", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public boolean early_stopping;

        public SequentialSearchCriteriaV99() {
            this.strategy = HyperSpaceSearchCriteria.Strategy.Sequential;
        }

        @Override
        public HyperSpaceSearchCriteria.SequentialSearchCriteria fillImpl(HyperSpaceSearchCriteria.SequentialSearchCriteria impl) {
            HyperSpaceSearchCriteria.SequentialSearchCriteria filledImpl = super.fillImpl(impl);
            PojoUtils.copyProperties(filledImpl.stoppingCriteria(), this, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            return filledImpl;
        }

        @Override
        public SequentialSearchCriteriaV99 fillFromImpl(HyperSpaceSearchCriteria.SequentialSearchCriteria impl) {
            SequentialSearchCriteriaV99 schema = (SequentialSearchCriteriaV99)super.fillFromImpl(impl);
            PojoUtils.copyProperties(this, impl.stoppingCriteria(), PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
            return schema;
        }
    }

    public static class RandomSearchStoppingMetricValuesProvider
    extends EnumValuesProvider<ScoreKeeper.StoppingMetric> {
        public RandomSearchStoppingMetricValuesProvider() {
            super(ScoreKeeper.StoppingMetric.class, (Enum[])new ScoreKeeper.StoppingMetric[]{ScoreKeeper.StoppingMetric.custom, ScoreKeeper.StoppingMetric.custom_increasing});
        }
    }

    public static class RandomDiscreteValueSearchCriteriaV99
    extends HyperSpaceSearchCriteriaV99<HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria, RandomDiscreteValueSearchCriteriaV99> {
        @API(help="Seed for random number generator; set to a value other than -1 for reproducibility.", direction=API.Direction.INOUT)
        public long seed;
        @API(help="Maximum number of models to build (optional).", direction=API.Direction.INOUT)
        public int max_models;
        @API(help="Maximum time to spend building models (optional).", direction=API.Direction.INOUT)
        public double max_runtime_secs;
        @API(help="Early stopping based on convergence of stopping_metric. Stop if simple moving average of length k of the stopping_metric does not improve for k:=stopping_rounds scoring events (0 to disable)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public int stopping_rounds;
        @API(help="Metric to use for early stopping (AUTO: logloss for classification, deviance for regression)", valuesProvider=RandomSearchStoppingMetricValuesProvider.class, level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public ScoreKeeper.StoppingMetric stopping_metric;
        @API(help="Relative tolerance for metric-based stopping criterion (stop if relative improvement is not at least this much)", level=API.Level.secondary, direction=API.Direction.INOUT, gridable=true)
        public double stopping_tolerance;

        public RandomDiscreteValueSearchCriteriaV99() {
            this.strategy = HyperSpaceSearchCriteria.Strategy.RandomDiscrete;
        }

        public RandomDiscreteValueSearchCriteriaV99(long seed, int max_models, int max_runtime_secs) {
            this.strategy = HyperSpaceSearchCriteria.Strategy.RandomDiscrete;
            this.seed = seed;
            this.max_models = max_models;
            this.max_runtime_secs = max_runtime_secs;
        }

        @Override
        public HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria fillImpl(HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria impl) {
            HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria filledImpl = super.fillImpl(impl);
            PojoUtils.copyProperties(filledImpl.stoppingCriteria(), this, PojoUtils.FieldNaming.DEST_HAS_UNDERSCORES);
            return filledImpl;
        }

        @Override
        public RandomDiscreteValueSearchCriteriaV99 fillFromImpl(HyperSpaceSearchCriteria.RandomDiscreteValueSearchCriteria impl) {
            RandomDiscreteValueSearchCriteriaV99 schema = (RandomDiscreteValueSearchCriteriaV99)super.fillFromImpl(impl);
            PojoUtils.copyProperties(this, impl.stoppingCriteria(), PojoUtils.FieldNaming.ORIGIN_HAS_UNDERSCORES);
            return schema;
        }
    }

    public static class CartesianSearchCriteriaV99
    extends HyperSpaceSearchCriteriaV99<HyperSpaceSearchCriteria.CartesianSearchCriteria, CartesianSearchCriteriaV99> {
        public CartesianSearchCriteriaV99() {
            this.strategy = HyperSpaceSearchCriteria.Strategy.Cartesian;
        }
    }
}

