/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.transforms;

import java.util.Arrays;
import java.util.LinkedList;
import org.apache.commons.lang.ArrayUtils;
import water.DKV;
import water.H2O;
import water.fvec.Frame;
import water.rapids.Session;
import water.rapids.ast.AstExec;
import water.rapids.ast.AstParameter;
import water.rapids.ast.AstRoot;
import water.rapids.ast.params.AstId;
import water.rapids.ast.prims.mungers.AstColPySlice;
import water.rapids.transforms.Transform;

public class H2OColOp
extends Transform<H2OColOp> {
    private static final String FRAME_ID_PLACEHOLDER = "dummy";
    protected final String _fun;
    protected String _oldCol;
    private String[] _newCol;
    private String _newJavaColTypes;
    private String _newColTypes;
    boolean _multiColReturn;

    @Override
    public String[] getNewNames() {
        return this._newCol;
    }

    @Override
    public String[] getNewTypes() {
        Object[] result = new String[this._newCol.length == 0 ? 1 : this._newCol.length];
        Arrays.fill(result, this._newColTypes);
        return result;
    }

    public String[] getOldNames() {
        return new String[]{this._oldCol};
    }

    public H2OColOp(String name, String ast, boolean inplace, String[] newNames) {
        super(name, ast, inplace, newNames);
        this._fun = this._ast._asts[0].str();
        this._oldCol = null;
        for (int i = 1; i < this._ast._asts.length; ++i) {
            if (!(this._ast._asts[i] instanceof AstExec)) continue;
            this._oldCol = H2OColOp.findOldName((AstExec)this._ast._asts[i]);
            break;
        }
        this.setupParams();
    }

    private void setupParams() {
        String[] args = this._ast.getArgs();
        if (args != null && args.length > 1) {
            for (int i = 0; i < args.length; ++i) {
                this.setupParamsImpl(i, args);
            }
        }
    }

    protected void setupParamsImpl(int i, String[] args) {
        if (this._ast._asts[i + 1] instanceof AstParameter) {
            this._params.put(args[i], (AstParameter)this._ast._asts[i + 1]);
        }
    }

    @Override
    public Transform<H2OColOp> fit(Frame f) {
        return this;
    }

    @Override
    protected Frame transformImpl(Frame f) {
        this.substitutePlaceholders(this._ast, f);
        Session ses = new Session();
        Frame fr = ses.exec(this._ast, null).getFrame();
        this._newCol = this._newNames == null ? new String[fr.numCols()] : this._newNames;
        this._newColTypes = fr.anyVec().get_type_str();
        this._newJavaColTypes = H2OColOp.toJavaPrimitive(this._newColTypes);
        this._multiColReturn = fr.numCols() > 1;
        if (this._multiColReturn) {
            for (int i = 0; i < this._newCol.length; ++i) {
                if (this._newNames == null) {
                    this._newCol[i] = f.uniquify(i > 0 ? this._newCol[i - 1] : this._oldCol);
                }
                f.add(this._newCol[i], fr.vec(i));
            }
            if (this._inplace) {
                f.remove(f.find(this._oldCol)).remove();
            }
        } else {
            String[] stringArray;
            if (this._newNames == null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this._inplace ? this._oldCol : f.uniquify(this._oldCol);
            } else {
                stringArray = this._newCol = this._newCol;
            }
            if (this._inplace) {
                f.replace(f.find(this._oldCol), fr.anyVec()).remove();
            } else {
                f.add(this._newNames == null ? this._newCol[0] : this._newNames[0], fr.anyVec());
            }
        }
        DKV.put(f);
        return f;
    }

    private void substitutePlaceholders(AstExec root, Frame f) {
        LinkedList<AstExec> execs = new LinkedList<AstExec>();
        execs.add(root);
        while (!execs.isEmpty()) {
            AstExec exec = (AstExec)execs.poll();
            for (int i = 1; i < exec._asts.length; ++i) {
                AstId id;
                AstRoot ast = exec._asts[i];
                if (ast instanceof AstExec) {
                    execs.add((AstExec)ast);
                    continue;
                }
                if (!(ast instanceof AstId) || !FRAME_ID_PLACEHOLDER.equals((id = (AstId)ast).str())) continue;
                exec._asts[i] = new AstId(f);
            }
        }
    }

    private static String findOldName(AstExec root) {
        AstColPySlice py = new AstColPySlice();
        LinkedList<AstExec> execs = new LinkedList<AstExec>();
        execs.add(root);
        String oldName = null;
        while (!execs.isEmpty()) {
            AstExec exec = (AstExec)execs.poll();
            if (exec._asts.length == 3 && py.str().equals(exec._asts[0].str()) && FRAME_ID_PLACEHOLDER.equals(exec._asts[1].str())) {
                oldName = exec._asts[2].str();
                break;
            }
            for (int i = 1; i < exec._asts.length; ++i) {
                AstRoot ast = exec._asts[i];
                if (!(ast instanceof AstExec)) continue;
                execs.add((AstExec)ast);
            }
        }
        return oldName;
    }

    @Override
    Frame inverseTransform(Frame f) {
        throw H2O.unimpl();
    }

    @Override
    public String genClassImpl() {
        String typeCast;
        int typeId = ArrayUtils.indexOf((Object[])this._inNames, (Object)this._oldCol);
        if (typeId < 0) {
            throw new IllegalStateException("Unknown column " + this._oldCol + " (known: " + Arrays.toString(this._inNames));
        }
        String string = typeCast = this._inTypes[typeId].equals("Numeric") ? "Double" : "String";
        if (this._multiColReturn) {
            StringBuilder sb = new StringBuilder("    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "     " + this._newJavaColTypes + "[] res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n");
            for (int i = 0; i < this._newCol.length; ++i) {
                sb.append("      row.put(\"" + this._newCol[i] + "\",(" + i + ">=res.length)?\"\":res[" + i + "]);\n");
            }
            sb.append("      return row;\n    }\n");
            return sb.toString();
        }
        return "    @Override public RowData transform(RowData row) {\n" + (this.paramIsRow() ? this.addRowParam() : "") + "      " + this._newJavaColTypes + " res = GenMunger." + this.lookup(this._fun) + "((" + typeCast + ")row.get(\"" + this._oldCol + "\"), _params);\n      row.put(\"" + this._newCol[0] + "\", res);\n      return row;\n    }\n";
    }

    protected boolean paramIsRow() {
        return false;
    }

    protected String addRowParam() {
        return "";
    }

    protected String lookup(String op) {
        return op.replaceAll("\\.", "");
    }
}

