/*
 * Decompiled with CFR 0.152.
 */
package water.rapids.vals;

import water.fvec.Frame;
import water.fvec.Vec;
import water.rapids.Val;

public class ValFrame
extends Val {
    private final Frame _fr;

    public ValFrame(Frame fr) {
        assert (fr != null) : "Cannot construct a Frame from null";
        this._fr = fr;
    }

    @Override
    public int type() {
        return 5;
    }

    @Override
    public boolean isFrame() {
        return true;
    }

    @Override
    public Frame getFrame() {
        return this._fr;
    }

    public String toString() {
        return this._fr.toString();
    }

    @Override
    public double[] getRow() {
        if (this._fr.numRows() != 1L) {
            throw new IllegalArgumentException("Trying to get a single row from a multirow frame: " + this._fr.numRows() + "!=1");
        }
        double[] res = new double[this._fr.numCols()];
        for (int i = 0; i < this._fr.numCols(); ++i) {
            res[i] = this._fr.vec(i).at(0L);
        }
        return res;
    }

    public static ValFrame fromRow(double ... values) {
        Vec[] vecs = new Vec[values.length];
        for (int i = 0; i < values.length; ++i) {
            vecs[i] = Vec.makeCon(values[i], 1L);
        }
        Frame fr = new Frame(vecs);
        return new ValFrame(fr);
    }
}

