/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.ChunkSplitter;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class FrameSplitter
extends H2O.H2OCountedCompleter<FrameSplitter> {
    final Frame dataset;
    final double[] ratios;
    final Key<Frame>[] destKeys;
    final Key<Job> jobKey;
    private Frame[] splits;
    private Throwable[] workersExceptions;

    public FrameSplitter(Frame dataset, double[] ratios, Key<Frame>[] destKeys, Key<Job> jobKey) {
        this(null, dataset, ratios, destKeys, jobKey);
    }

    public FrameSplitter(H2O.H2OCountedCompleter cc, Frame dataset, double[] ratios, Key<Frame>[] destKeys, Key<Job> jobKey) {
        super(cc);
        assert (ratios.length > 0) : "No ratio specified!";
        assert (ratios.length < 100) : "Too many frame splits demanded!";
        assert (destKeys != null) : "Destination keys are not specified!";
        assert (destKeys.length == ratios.length + 1) : "Unexpected number of destination keys.";
        this.dataset = dataset;
        this.ratios = ratios;
        this.jobKey = jobKey;
        this.destKeys = destKeys;
    }

    @Override
    public void compute2() {
        this.dataset.read_lock(this.jobKey);
        Vec[][] templates = this.makeTemplates(this.dataset, this.ratios);
        final int nsplits = templates.length;
        assert (nsplits == this.ratios.length + 1) : "Unexpected number of split templates!";
        final Vec[] datasetVecs = this.dataset.vecs();
        this.splits = new Frame[nsplits];
        for (int s = 0; s < nsplits; ++s) {
            Frame split = new Frame(this.destKeys[s], this.dataset.names(), templates[s]);
            split.delete_and_lock(this.jobKey);
            this.splits[s] = split;
        }
        this.setPendingCount(1);
        H2O.submitTask(new H2O.H2OCountedCompleter(this){

            @Override
            public void compute2() {
                this.setPendingCount(nsplits);
                for (int s = 0; s < nsplits; ++s) {
                    new FrameSplitTask(new H2O.H2OCountedCompleter(this){

                        @Override
                        public void compute2() {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
                            FrameSplitter frameSplitter = FrameSplitter.this;
                            synchronized (frameSplitter) {
                                FrameSplitter.access$102(FrameSplitter.this, FrameSplitter.this.workersExceptions != null ? Arrays.copyOf(FrameSplitter.this.workersExceptions, FrameSplitter.this.workersExceptions.length + 1) : new Throwable[1]);
                                ((FrameSplitter)FrameSplitter.this).workersExceptions[((FrameSplitter)FrameSplitter.this).workersExceptions.length - 1] = ex;
                            }
                            this.tryComplete();
                            return false;
                        }
                    }, datasetVecs, FrameSplitter.this.ratios, s).asyncExec(FrameSplitter.this.splits[s]);
                }
                this.tryComplete();
            }
        });
        this.tryComplete();
    }

    public Frame[] getResult() {
        this.join();
        if (this.workersExceptions != null) {
            throw new RuntimeException(this.workersExceptions[0]);
        }
        return this.splits;
    }

    public Throwable[] getErrors() {
        return this.workersExceptions;
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        boolean exceptional = this.workersExceptions != null;
        this.dataset.unlock(this.jobKey);
        if (this.splits != null) {
            for (Frame s : this.splits) {
                if (s == null) continue;
                if (!exceptional) {
                    s.update(this.jobKey);
                    s.unlock(this.jobKey);
                    continue;
                }
                s.unlock(this.jobKey);
                s.delete(this.jobKey, new Futures()).blockForPending();
            }
        }
    }

    private Vec[][] makeTemplates(Frame dataset, double[] ratios) {
        Vec anyVec = dataset.anyVec();
        long[][] espcPerSplit = FrameSplitter.computeEspcPerSplit(anyVec.espc(), anyVec.length(), ratios);
        int num = dataset.numCols();
        int nsplits = espcPerSplit.length;
        String[][] domains = dataset.domains();
        byte[] types = new byte[num];
        int j = 0;
        for (Vec v : dataset.vecs()) {
            types[j++] = v.get_type();
        }
        Vec[][] t = new Vec[nsplits][];
        for (int i = 0; i < nsplits; ++i) {
            Key<Vec> vkey = Vec.newKey();
            int rowLayout = Vec.ESPC.rowLayout(vkey, espcPerSplit[i]);
            t[i] = new Vec(vkey, rowLayout).makeCons(num, 0L, domains, types);
        }
        return t;
    }

    static long[][] computeEspcPerSplit(long[] espc, long len, double[] ratios) {
        assert (espc.length > 0 && espc[0] == 0L);
        assert (espc[espc.length - 1] == len);
        long[] partSizes = FrameSplitter.partitione(len, ratios);
        int nparts = ratios.length + 1;
        long[][] r = new long[nparts][espc.length];
        long nrows = 0L;
        long start = 0L;
        int c = 0;
        for (int p = 0; p < nparts; ++p) {
            int nc = 0;
            while (c < espc.length - 1 && espc[c + 1] - start <= partSizes[p]) {
                r[p][++nc] = espc[c + 1] - start;
                ++c;
            }
            if (r[p][nc] < partSizes[p]) {
                r[p][++nc] = partSizes[p];
            }
            r[p] = Arrays.copyOf(r[p], nc + 1);
            nrows -= partSizes[p];
            start += partSizes[p];
        }
        return r;
    }

    static final long[] partitione(long len, double[] ratio) {
        long[] r = new long[ratio.length + 1];
        long sum = 0L;
        int i = 0;
        float sr = 0.0f;
        for (i = 0; i < ratio.length; ++i) {
            r[i] = (int)(ratio[i] * (double)len);
            sum += r[i];
            sr = (float)((double)sr + ratio[i]);
        }
        if (sr < 1.0f) {
            r[i] = len - sum;
        } else {
            int n = i - 1;
            r[n] = r[n] + (len - sum);
        }
        return r;
    }

    static /* synthetic */ Throwable[] access$102(FrameSplitter x0, Throwable[] x1) {
        x0.workersExceptions = x1;
        return x1;
    }

    private static class FrameSplitTask
    extends MRTask<FrameSplitTask> {
        final Vec[] _srcVecs;
        final double[] _ratios;
        final int _partIdx;
        transient int _pcidx;
        transient int _psrow;

        public FrameSplitTask(H2O.H2OCountedCompleter completer, Vec[] srcVecs, double[] ratios, int partIdx) {
            super(completer);
            this._srcVecs = srcVecs;
            this._ratios = ratios;
            this._partIdx = partIdx;
        }

        @Override
        protected void setupLocal() {
            Vec anyInVec = this._srcVecs[0];
            long[] partSizes = FrameSplitter.partitione(anyInVec.length(), this._ratios);
            long pnrows = 0L;
            for (int p = 0; p < this._partIdx; ++p) {
                pnrows += partSizes[p];
            }
            long[] espc = anyInVec.espc();
            while (this._pcidx < espc.length - 1 && (pnrows -= espc[this._pcidx + 1] - espc[this._pcidx]) >= 0L) {
                ++this._pcidx;
            }
            assert (pnrows <= 0L);
            this._psrow = (int)(pnrows + espc[this._pcidx + 1] - espc[this._pcidx]);
        }

        @Override
        public void map(Chunk[] cs) {
            int coutidx = cs[0].cidx();
            int cinidx = this._pcidx + coutidx;
            int startRow = coutidx > 0 ? 0 : this._psrow;
            int nrows = cs[0]._len;
            for (int i = 0; i < cs.length; ++i) {
                ChunkSplitter.extractChunkPart(this._srcVecs[i].chunkForChunkIdx(cinidx), cs[i], startRow, nrows, this._fs);
            }
        }
    }
}

